/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskFreeSpace
extends Task {
    List<TaskContainerFreeSpace.Location> m_locations;
    String m_nodeFreeSpc;
    TaskContainerFreeSpace.MountPoint m_mountPoint;
    StorageSize m_reqdMntSize;
    StorageSize m_reqdMntSizeForRim;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);

    protected TaskFreeSpace(String node, TaskContainerFreeSpace.MountPoint mountPoint) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.m_locations = mountPoint.getLocations();
        this.m_nodeFreeSpc = node;
        this.m_mountPoint = mountPoint;
        this.m_reqdMntSize = new StorageSize(0.0, StorageUnit.BYTE);
        this.m_reqdMntSizeForRim = new StorageSize(0.0, StorageUnit.BYTE);
        boolean isLocaSeverityCritical = false;
        for (TaskContainerFreeSpace.Location loc : this.m_locations) {
            this.m_reqdMntSize.add(loc.getReqdFreeSpace());
            this.m_reqdMntSizeForRim.add(loc.getReqdRimFreeSpace());
            if (loc.getSeverity() != SeverityType.CRITICAL) continue;
            isLocaSeverityCritical = true;
        }
        this.setSeverity(isLocaSeverityCritical ? SeverityType.CRITICAL : SeverityType.IGNORABLE);
        Trace.out((String)("\nOn Node (" + this.m_nodeFreeSpc + ") Mount Point is (" + mountPoint.getMountPoint() + ") with available free space (" + mountPoint.getAvailableSpace().toString() + ") and following locations."));
        for (TaskContainerFreeSpace.Location loc : this.m_locations) {
            Trace.out((String)loc.toString());
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    @Override
    public String[] getNodeList() {
        String[] nodeList = new String[]{this.m_nodeFreeSpc};
        return nodeList;
    }

    public void adjustFreeSpace(double multiplier) {
        Trace.out((int)1, (String)("m_reqdMntSize before: '" + this.m_reqdMntSize.toString() + "'"));
        this.m_reqdMntSize.modify(multiplier);
        Trace.out((int)1, (String)("m_reqdMntSize after: '" + this.m_reqdMntSize.toString() + "'"));
    }

    public void setFreeSpace(StorageSize newsize) {
        Trace.out((int)1, (String)("m_reqdMntSize before: '" + this.m_reqdMntSize.toString() + "'"));
        this.m_reqdMntSize = newsize;
        Trace.out((int)1, (String)("m_reqdMntSize after: '" + this.m_reqdMntSize.toString() + "'"));
    }

    @Override
    public boolean performTask() {
        ErrorDescription errDesc;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (this.hasRunBefore() && !this.m_mountPoint.getMountPoint().contentEquals("UNKNOWN")) {
            this.refreshAvailableSize(this.m_mountPoint.getMountPoint());
        }
        Trace.out((String)("\n\n Performing Task for: " + this.toString()));
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
        NodeManager nm = null;
        boolean bigCluster = false;
        List<Object> rimNodeList = null;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager();
            bigCluster = nm.isBigCluster();
            if (bigCluster) {
                rimNodeList = Arrays.asList(nm.getNodes(NodeRoleCapability.RIM));
            }
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return false;
        }
        catch (NoSuchNodesException e) {
            rimNodeList = new ArrayList();
        }
        catch (NodeManagerException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return false;
        }
        ReportUtil.writeColHeaders(ReportUtil.PATH, ReportUtil.NODENAME, ReportUtil.MNTPNT, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, this.m_reqdMntSize, null, this.getDefaultDescription(), 5);
        this.m_resultSet.addCollectionElement(this.m_nodeFreeSpc, collectionElement);
        StorageSize reqFreeSpaceAtMountPoint = this.m_reqdMntSize;
        StorageSize availableFreeSpaceAtMntPoint = null;
        if (bigCluster && rimNodeList.contains(this.m_nodeFreeSpc)) {
            reqFreeSpaceAtMountPoint = this.m_reqdMntSizeForRim;
        }
        for (TaskContainerFreeSpace.Location location : this.m_locations) {
            String nstatus;
            StorageSize reqFreeSpaceAtLoc = location.getReqdFreeSpace();
            if (bigCluster && rimNodeList.contains(this.m_nodeFreeSpc)) {
                reqFreeSpaceAtLoc = location.getReqdRimFreeSpace();
            }
            if (this.m_mountPoint.getMountPoint().contentEquals("UNKNOWN")) {
                errDesc = new ErrorDescription(s_gMsgBundle.getMessage("13336", true, (Object[])new String[]{location.getPath()}), s_msgBundle, "13336");
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 2);
                this.m_resultSet.addErrorDescription(errDesc);
                nstatus = ReportUtil.FAILED;
                collectionElement.setStatus(2);
            } else {
                availableFreeSpaceAtMntPoint = location.getAvailableFreeSpace();
                if (location.getAvailableFreeSpace().compareTo(reqFreeSpaceAtLoc) >= 0) {
                    this.m_resultSet.addResult(this.m_nodeFreeSpc, 1);
                    nstatus = ReportUtil.PASSED;
                    collectionElement.setStatus(1);
                    this.m_resultSet.getResult(this.m_nodeFreeSpc).setActualValue(ReportUtil.unitizeSize(location.getAvailableFreeSpace(), 1));
                } else {
                    nstatus = ReportUtil.FAILED;
                    this.m_resultSet.addResult(this.m_nodeFreeSpc, 3);
                    this.m_resultSet.getResult(this.m_nodeFreeSpc).setActualValue(ReportUtil.unitizeSize(location.getAvailableFreeSpace(), 1));
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", true, (Object[])new String[]{location.getOriginalPath(), this.m_nodeFreeSpc, ReportUtil.unitizeSize(reqFreeSpaceAtLoc, 1), ReportUtil.unitizeSize(location.getAvailableFreeSpace(), 1)}), s_msgBundle, "7501");
                    this.m_resultSet.addErrorDescription(errDesc);
                    collectionElement.setStatus(3);
                }
                this.m_resultSet.getResult(this.m_nodeFreeSpc).setHasResultValues(true);
                this.m_resultSet.getResult(this.m_nodeFreeSpc).setExpectedValue(ReportUtil.unitizeSize(reqFreeSpaceAtLoc, 1));
                collectionElement.setValue(ReportUtil.unitizeSize(location.getAvailableFreeSpace()));
                collectionElement.setExpectedValue(ReportUtil.unitizeSize(reqFreeSpaceAtLoc));
            }
            String availSize = null;
            availSize = this.m_mountPoint.getMountPoint().contentEquals("UNKNOWN") && location.getAvailableFreeSpace().sizeIn(StorageUnit.KBYTE) == 0.0 ? "NOTAVAIL" : ReportUtil.unitizeSize(location.getAvailableFreeSpace(), 1);
            ReportUtil.writeRecord(location.getOriginalPath(), this.m_nodeFreeSpc, this.m_mountPoint.getMountPoint(), availSize, ReportUtil.unitizeSize(reqFreeSpaceAtLoc, 1), nstatus);
            Trace.out((String)("\n\n    Node:      " + this.m_nodeFreeSpc + "\n    Location:  " + location.getOriginalPath() + "\n    Available: " + availSize + "\n    Required:  " + ReportUtil.unitizeSize(reqFreeSpaceAtLoc, 1) + "\n\n"));
        }
        if (availableFreeSpaceAtMntPoint != null && reqFreeSpaceAtMountPoint.compareTo(availableFreeSpaceAtMntPoint) >= 0 && this.m_locations.size() > 1) {
            ArrayList<String> requiredSpaceList = new ArrayList<String>();
            for (TaskContainerFreeSpace.Location loc : this.m_locations) {
                requiredSpaceList.add(ReportUtil.unitizeSize(loc.getReqdFreeSpace(), 1) + "(" + loc.getOriginalPath() + ") ");
            }
            String string = "[" + VerificationUtil.strList2List(requiredSpaceList, "+ ") + "= " + ReportUtil.unitizeSize(reqFreeSpaceAtMountPoint, 1) + "]";
            VerificationUtil.traceAndLogError("Available free space at mount point (" + ReportUtil.unitizeSize(availableFreeSpaceAtMntPoint, 1) + ") is less than Required space at mount point (" + string + ")");
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", true, (Object[])new String[]{this.m_mountPoint.getMountPoint(), this.m_nodeFreeSpc, string, ReportUtil.unitizeSize(availableFreeSpaceAtMntPoint, 1)}), s_msgBundle, "7501");
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setHasResultValues(true);
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setExpectedValue(string);
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setActualValue(ReportUtil.unitizeSize(availableFreeSpaceAtMntPoint, 1));
            collectionElement.setValue(ReportUtil.unitizeSize(availableFreeSpaceAtMntPoint, 1));
            collectionElement.setExpectedValue(string);
            collectionElement.setStatus(3);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"Exit");
            }
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return false;
    }

    private void refreshAvailableSize(String loc) {
        NativeSystem nativeSystem;
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace(this);
        String cmd = sTask.getCommand(loc);
        ResultSet rsltSet = new ResultSet();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n\n    Executing command: " + cmd + "\n    on node:      " + this.m_nodeFreeSpc));
        }
        if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            globalExec.runGenericCmd(new String[]{this.m_nodeFreeSpc}, cmd, rsltSet);
        } else {
            globalExec.getSpaceCmd(new String[]{this.m_nodeFreeSpc}, loc, rsltSet);
        }
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        Result result = (Result)t.get(this.m_nodeFreeSpc);
        if (result != null && result.getStatus() == 1) {
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), VerificationConstants.LINE_SEPARATOR);
            String sizeTxt = sTask.getData(cmdOut, 4);
            this.m_mountPoint.setAvailableSpace(new StorageSize((double)new Double(sizeTxt), StorageUnit.MBYTE));
        }
        if (ParamManager.isRuncluvfy() || m_isAPImode) {
            this.bootStrapSizeAdjustment();
        }
    }

    private void bootStrapSizeAdjustment() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry bootStrapSizeAdjustment()..");
        }
        Trace.out((String)"In bootStrapSizeAdjustment..");
        if (m_localNode.equals(this.m_nodeFreeSpc)) {
            String bootStrapPath = CVUAutoUpdateManager.getDerivedCVUHome();
            String mntPnt = TaskContainerFreeSpace.getMntPnt(bootStrapPath);
            Trace.out((String)("\nMount Point " + mntPnt + "\n" + "Location   " + bootStrapPath));
            if (this.m_mountPoint.equals(mntPnt)) {
                Trace.out((String)("    Before adding bootstrap size \n    Mount Point: " + this.m_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(this.m_mountPoint.getAvailableSpace(), 1)));
                this.addBootStrapSpace(bootStrapPath);
                Trace.out((String)("    After adding bootstrap size \n    Mount Point: " + this.m_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(this.m_mountPoint.getAvailableSpace(), 1)));
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)" Exit ");
        }
    }

    public boolean addBootStrapSpace(String bsLoc) {
        VerificationCommand cmdOP;
        Result result;
        Trace.out((String)"Inside addBootStrapSpace().....");
        ResultSet rsltSet = new ResultSet();
        String[] arg = new String[]{"-getdirsize", bsLoc};
        String[] env = null;
        VerificationCommand[] cmd = new VerificationCommand[]{new VerificationCommand(m_localNode, arg, env)};
        boolean cmdResult = new GlobalHandler().submit((Command[])cmd, 0, rsltSet);
        if (cmdResult && (result = (Result)rsltSet.getResultTable().get(m_localNode)).getStatus() == 1 && (cmdOP = cmd[0]).getVfyCode() == 0) {
            String cmdOut = cmdOP.getOutput();
            if (cmdOut == null) {
                return false;
            }
            String[] op = (cmdOut = cmdOut.trim()).split("\n");
            if (op.length > 0) {
                cmdOut = op[0];
            }
            StorageSize sizeAvail = new StorageSize((double)new Double(cmdOut), StorageUnit.BYTE);
            this.m_mountPoint.getAvailableSpace().add(sizeAvail);
            return true;
        }
        return false;
    }

    public String getLocations() {
        return this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations);
    }

    private String getDisplayLocations(String node, List<TaskContainerFreeSpace.Location> locations) {
        StringBuffer strBuf = new StringBuffer("");
        if (locations != null) {
            boolean first = true;
            for (TaskContainerFreeSpace.Location loc : locations) {
                if (loc == null) continue;
                if (first) {
                    first = false;
                } else {
                    strBuf.append(",");
                }
                strBuf.append(node + ":" + loc.getOriginalPath());
            }
        }
        return strBuf.toString();
    }

    @Override
    public String getTaskID() {
        return "CHECK_FREE_SPACE_" + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4408", false) + ": " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4458", false);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        ArrayList<String> avlSpaces = new ArrayList<String>();
        ArrayList<String> reqSpaces = new ArrayList<String>();
        for (TaskContainerFreeSpace.Location loc : this.m_locations) {
            reqSpaces.add(ReportUtil.unitizeSize(loc.getReqdFreeSpace(), 1) + "(RIM:" + ReportUtil.unitizeSize(loc.getReqdRimFreeSpace(), 1) + ")");
            avlSpaces.add(ReportUtil.unitizeSize(loc.getAvailableFreeSpace(), 1));
        }
        strBuf.append("\n\n    Location: " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations) + "\n    Node: " + this.m_nodeFreeSpc + "\n    Required Spaces: " + VerificationUtil.strList2List(reqSpaces) + "\n    Available Spaces: " + VerificationUtil.strList2List(avlSpaces) + "\n    Mount Point: " + this.m_mountPoint.getMountPoint() + "\n    Required Total Size: " + ReportUtil.unitizeSize(this.m_reqdMntSize, 1) + "\n    Avail Size at mount point: " + ReportUtil.unitizeSize(this.m_mountPoint.getAvailableSpace(), 1) + "\n\n");
        return strBuf.toString();
    }
}

