/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.database.DatabaseConnectInfoException;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.VerificationType;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskEZConnect
extends Task
implements ContainerTaskInterface {
    private Version m_crsVer = null;
    private List<Task> m_subTaskList = new ArrayList<Task>();
    private static boolean m_isInitialized = false;
    private String m_dbUniqueName;

    public TaskEZConnect(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskEZConnect(Version crsVer, String dbUniqueName) {
        this.m_crsVer = crsVer;
        this.m_dbUniqueName = dbUniqueName;
    }

    private TaskEZConnect(VerificationTaskContext ctx, Version crsVer, String dbUniqueName) {
        super(ctx);
        this.m_crsVer = crsVer;
        this.m_dbUniqueName = dbUniqueName;
    }

    @Override
    protected void init() {
        if (!m_isInitialized) {
            VerificationType vType = this.m_globalContext.getVerificationType();
            switch (vType) {
                case BESTPRACTICE_POSTREQ_DB_CONFIG: 
                case POSTREQ_DB_CONFIG: {
                    VerificationUtil.traceAndLog("Initializing for Post DB Config scenario");
                    try {
                        Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
                        Collection<DatabaseConnectInfo> dbConInfos = DatabaseConnectInfo.getDatabaseConnectInfos();
                        Trace.out((String)("Total DB connectInfo objects are " + dbConInfos.size()));
                        for (DatabaseConnectInfo dbConInfo : dbConInfos) {
                            TaskEZConnect task = new TaskEZConnect(this.m_ctx, crsVersion, dbConInfo.dbUniqueName());
                            this.addTaskToContainer(task);
                            Trace.out((String)("Successfully added EZ connect check for (" + dbConInfo.dbUniqueName() + ") to the container"));
                        }
                        break;
                    }
                    catch (DatabaseConnectInfoException exDC) {
                        VerificationUtil.traceAndLogError("DatabaseConnectInfoException occured while getting databases conect info. message " + exDC.getMessage());
                        return;
                    }
                }
            }
            m_isInitialized = true;
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!this.m_subTaskList.isEmpty()) {
            ArrayList<Task> applicableList = new ArrayList<Task>();
            for (Task t : this.m_subTaskList) {
                if (t.isApplicable()) {
                    Trace.out((String)(t.getTaskName() + " is applicable from this container."));
                    applicableList.add(t);
                    continue;
                }
                Trace.out((String)(t.getTaskName() + " is NOT applicable from this container."));
            }
            this.m_subTaskList.clear();
            this.m_subTaskList.addAll(applicableList);
            return !this.m_subTaskList.isEmpty();
        }
        if (VerificationUtil.isStringGood(this.m_dbUniqueName)) {
            if (this.m_crsVer != null) {
                VerificationUtil.traceAndLog("Adding the EZ connect check for DB unique name (" + this.m_dbUniqueName + ") and CRS version (" + this.m_crsVer + ")");
                return true;
            }
            VerificationUtil.traceAndLog("Not applicable as the CRS version is null");
            return false;
        }
        VerificationUtil.traceAndLog("Not applicable as the db unique name is null");
        return false;
    }

    @Override
    public boolean performTask() {
        Object npp = null;
        ErrorDescription errDesc = null;
        ReportUtil.blankln();
        ReportUtil.println(s_gMsgBundle.getMessage("1152", false, (Object[])new String[0]));
        String tnsAdminEnv = null;
        String oracleHome = null;
        DBUtils dbUtils = new DBUtils(this.m_crsVer);
        try {
            DatabaseInfo dbInfo = dbUtils.getDatabaseInfo(this.m_dbUniqueName);
            oracleHome = dbInfo.getHome();
        }
        catch (DBUtilsException e) {
            String msg = s_gMsgBundle.getMessage("1155", false, (Object[])new String[0]);
            errDesc = new ErrorDescription(msg + e.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.setStatus(2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + e.getMessage());
            return false;
        }
        try {
            tnsAdminEnv = dbUtils.getDatabaseEnv(oracleHome, this.m_dbUniqueName, "TNS_ADMIN");
        }
        catch (DBUtilsException e) {
            Trace.out((String)e.getMessage());
        }
        ArrayList<String> unknownNodes = new ArrayList<String>();
        unknownNodes.addAll(Arrays.asList(this.m_nodeList));
        boolean status = true;
        if (VerificationUtil.isStringGood(tnsAdminEnv)) {
            status = this.verifyNameDirectoryPath(tnsAdminEnv, unknownNodes);
        }
        if (status && unknownNodes.size() > 0) {
            String networkAdminDir = oracleHome + VerificationUtil.FILE_SEPARATOR + "network" + VerificationUtil.FILE_SEPARATOR + "admin" + VerificationUtil.FILE_SEPARATOR;
            this.verifyNameDirectoryPath(networkAdminDir, unknownNodes);
        }
        if (status) {
            VerificationUtil.traceAndLog("The nodes where sqlnet.ora is absent are " + VerificationUtil.strList2List(unknownNodes));
            this.m_resultSet.addResult(unknownNodes, 1);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("1156", false, (Object[])new String[0]));
            return true;
        }
        ReportUtil.printResult(s_gMsgBundle.getMessage("1157", false, (Object[])new String[0]));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private boolean verifyNameDirectoryPath(String sqlnetORALoc, List<String> unknownNodes) {
        ArrayList<String> succNodes = new ArrayList<String>();
        ArrayList<String> failNodes = new ArrayList<String>();
        ArrayList<String> processedNodes = new ArrayList<String>();
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5642", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        String sqlnetORA = sqlnetORALoc + VerificationUtil.FILE_SEPARATOR + "sqlnet.ora";
        String sqlnetORATmp = null;
        for (String node : unknownNodes) {
            boolean copyStatus = false;
            Trace.out((String)("copying file from node:" + node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, sqlnetORA);
                if (!currentNodeStatus) {
                    Trace.out((String)("sqlnet.ora does not exists on node " + node + " in " + sqlnetORALoc));
                    continue;
                }
                sqlnetORATmp = scratchPath + "/sqlnet.ora_" + node;
                copyStatus = clusterCmd.copyFileFromNode(node, sqlnetORA, sqlnetORATmp);
                Trace.out((String)("copy status = " + copyStatus));
                if (!copyStatus) {
                    processedNodes.add(node);
                    failNodes.add(node);
                    String msg = s_gMsgBundle.getMessage("1155", false, (Object[])new String[0]);
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 2);
                    continue;
                }
                NLParamParser npp = new NLParamParser(sqlnetORATmp);
                for (String np : npp.getNLPAllNames()) {
                    if (!np.toLowerCase().equals("names.directory_path")) continue;
                    processedNodes.add(node);
                    String npValue = npp.getNLPListElement(np).valueToString();
                    if (Pattern.compile(".*ezconnect.*", 2).matcher(npValue).matches()) {
                        succNodes.add(node);
                        this.m_resultSet.addResult(node, 1);
                        continue;
                    }
                    Trace.out((String)("node=" + node + " entry " + np + " = " + npValue));
                    failNodes.add(node);
                    String failMsg = s_gMsgBundle.getMessage("1154", false, (Object[])new String[]{sqlnetORALoc, node});
                    ErrorDescription errDesc = new ErrorDescription(failMsg);
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
            }
            catch (ClusterException e) {
                Trace.out((String)"ClusterException while looking for resolv.conf");
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                ReportUtil.sureprintln(e.getMessage());
                processedNodes.add(node);
                failNodes.add(node);
            }
            catch (IOException e) {
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                ReportUtil.sureprintln(e.getMessage());
                processedNodes.add(node);
                failNodes.add(node);
            }
            catch (NLException e) {
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                ReportUtil.sureprintln(e.getMessage());
                processedNodes.add(node);
                failNodes.add(node);
            }
        }
        unknownNodes.removeAll(processedNodes);
        if (failNodes.size() > 0) {
            String cliMsg = s_gMsgBundle.getMessage("1153", false, (Object[])new String[]{sqlnetORALoc});
            ReportUtil.blankln();
            ReportUtil.println(cliMsg);
            ReportUtil.printNodelist(failNodes);
        }
        return true;
    }

    @Override
    public String getDefaultElementName() {
        if (VerificationUtil.isStringGood(this.m_dbUniqueName)) {
            return s_gMsgBundle.getMessage("1150", false) + ":" + this.m_dbUniqueName;
        }
        return s_gMsgBundle.getMessage("1150", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1151", false, (Object[])new String[0]);
    }

    public String getDBUniqueName() {
        return this.m_dbUniqueName;
    }

    @Override
    public boolean hasSubtasks() {
        return this.isContainerTask();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        if (this.m_subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : this.m_subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public String getTaskID() {
        return this.getDefaultTaskID() + (VerificationUtil.isStringGood(this.m_dbUniqueName) ? " " + this.m_dbUniqueName : "");
    }

    @Override
    public Task addTaskToContainer(Task t) {
        for (Task taskEZCon : this.m_subTaskList) {
            if (!((TaskEZConnect)taskEZCon).getDBUniqueName().equalsIgnoreCase(((TaskEZConnect)t).getDBUniqueName())) continue;
            Trace.out((String)("Already added the EZ connect check for database (" + ((TaskEZConnect)t).getDBUniqueName() + ")"));
            return taskEZCon;
        }
        Trace.out((String)("Adding the EZ connect check for database (" + ((TaskEZConnect)t).getDBUniqueName() + ")"));
        this.m_subTaskList.add(t);
        return t;
    }

    @Override
    public boolean isContainerTask() {
        this.init();
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public Task getContainerObject() {
        m_isInitialized = false;
        return this;
    }

    @Override
    public Task finalizeContainer() {
        Trace.out((String)"Finalizing the container.");
        return this;
    }
}

