/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckKernelRunningMode
extends Task {
    public TaskCheckKernelRunningMode(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskCheckKernelRunningMode(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        ResultSet aixResultSet = new ResultSet();
        boolean checkStatus = true;
        aixResultSet.clear();
        checkStatus = this.performKernelBitTask(aixResultSet);
        this.m_resultSet.addResultSetData(aixResultSet);
        return checkStatus;
    }

    private boolean performKernelBitTask(ResultSet KernBitResultSet) {
        int nodeIndex;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing Kernel Bitness checks");
        }
        VerificationCommand[] cmdArray = new VerificationCommand[this.m_nodeList.length];
        for (nodeIndex = 0; nodeIndex < this.m_nodeList.length; ++nodeIndex) {
            String[] arg = new String[]{"-rungencmd", "/usr/sbin/prtconf -k"};
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + VerificationUtil.strArr2String(arg)));
            }
            cmdArray[nodeIndex] = new VerificationCommand(this.m_nodeList[nodeIndex], arg, null);
        }
        new GlobalHandler().submit((Command[])cmdArray, 0, KernBitResultSet);
        if (!KernBitResultSet.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Global failure executing Kernel Bitness check command");
            }
            String message = s_gMsgBundle.getMessage("1164", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            KernBitResultSet.addErrorDescription(errorDesc);
            return false;
        }
        for (nodeIndex = 0; nodeIndex < this.m_nodeList.length; ++nodeIndex) {
            String node;
            boolean kernel64bit;
            block13: {
                String output;
                Result result = cmdArray[nodeIndex].getResult();
                kernel64bit = false;
                node = cmdArray[nodeIndex].getNode();
                if (result.getStatus() == 1 && (output = cmdArray[nodeIndex].getOutput().trim()) != null) {
                    result.addResultInfo(output);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Output from Kernel Bitness query command on node " + node + " is " + output));
                    }
                    try {
                        if (output.compareTo("Kernel Type: 64-bit") == 0) {
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)"Kernel 64-bit mode check successful");
                            }
                            KernBitResultSet.addResult(node, 1);
                            kernel64bit = true;
                        }
                    }
                    catch (NumberFormatException n) {
                        if (!Trace.isLevelEnabled((int)5)) break block13;
                        Trace.out((String)("Kernel 64-bit mode check failed : " + n.getMessage()));
                    }
                }
            }
            if (kernel64bit) continue;
            KernBitResultSet.addResult(node, 3);
            String message = s_gMsgBundle.getMessage("1162", true, (Object[])new String[]{node});
            ErrorDescription errorDesc = new ErrorDescription(message);
            KernBitResultSet.addErrorDescription(node, errorDesc);
        }
        if (KernBitResultSet.allSuccess()) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("1165", false));
            ReportUtil.sureblankln();
            return true;
        }
        ReportUtil.printResult(s_gMsgBundle.getMessage("1166", false));
        ReportUtil.sureblankln();
        return false;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1161", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1160", false);
    }
}

