/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.OracleDirectoryType;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckHome
extends Task {
    private String m_location;
    private OracleDirectoryType m_type;

    public TaskCheckHome(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("PATH".equals(argName)) {
                this.m_location = argVal;
                continue;
            }
            if ("TYPE".equals(argName)) {
                this.m_type = OracleDirectoryType.valueOf(argVal);
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!VerificationUtil.isStringGood(this.m_location)) {
            Trace.out((String)"The task is not applicable because the home location is unavailable");
            return false;
        }
        return true;
    }

    public TaskCheckHome(String[] nodeList, String path, OracleDirectoryType type) {
        super(nodeList, null, 1);
        this.m_location = path;
        this.m_type = type;
    }

    @Override
    public boolean performTask() {
        boolean ret = true;
        try {
            Assert.assertPath(this.m_location);
        }
        catch (InvalidPathException ipe) {
            Trace.out((String)("InvalidPathException: " + ipe.getMessage()));
            ErrorDescription errorDesc = new ErrorDescription(ipe.getMessage());
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(ipe.getMessage() + LSEP);
            return false;
        }
        switch (this.m_type) {
            case CRS_HOME: 
            case GI_HOME: {
                ret = this.performCRSHomeChecks();
                break;
            }
            case ORACLE_HOME: 
            case RAC_HOME: {
                ret = this.performRACHomeChecks();
                break;
            }
            case ORACLE_BASE: {
                if (!VerificationUtil.isPlatformWindows() && this.m_globalContext.isUpgrade()) {
                    Trace.out((String)"Unix platform during upgrade. setting severity to FATAL");
                    this.setSeverity(SeverityType.FATAL);
                }
                ret = this.performOracleBaseChecks();
            }
        }
        return ret;
    }

    public boolean performCRSHomeChecks() {
        Trace.out((String)"Performing destination CRS home verification task... ");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11981", false, (Object[])new String[]{this.m_location}));
        Trace.out((String)("Destination CRS home path[" + this.m_location + "]"));
        ResultSet pathExCrRset = new ResultSet();
        VerificationUtil.checkPathWriteableCreateable(this.m_nodeList, this.m_location, pathExCrRset, false);
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", this.m_nodeList, this, pathExCrRset);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(pathExCrRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11982", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11983", false));
        return false;
    }

    private boolean performRACHomeChecks() {
        Trace.out((String)"Performing Oracle home verification task... ");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11954", false, (Object[])new String[]{this.m_location}));
        Trace.out((String)("Oracle home path[" + this.m_location + "]"));
        ResultSet pathExCrRset = new ResultSet();
        VerificationUtil.checkPathWriteableCreateable(this.m_nodeList, this.m_location, pathExCrRset, false);
        if (!VerificationUtil.isPlatformWindows()) {
            pathExCrRset.addResultSetData(this.checkRACHomePermissions());
        }
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", this.m_nodeList, this, pathExCrRset);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(pathExCrRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11955", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11956", false));
        return false;
    }

    private ResultSet checkRACHomePermissions() {
        ResultSet permsCheckRes = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        VerificationUtil.pathExists(this.m_nodeList, this.m_location, 1, succNodes, failNodes);
        if (!succNodes.isEmpty()) {
            Hashtable<String, FileInfo> nodeHomePathAttrTable = VerificationUtil.getFileAttributes(this.m_location, succNodes.toArray(new String[0]), permsCheckRes);
            String expectedPermissions = new FileInfo.Permissions("050").toStringGroup();
            for (String node : nodeHomePathAttrTable.keySet()) {
                FileInfo.Permissions nodeHomePerms = nodeHomePathAttrTable.get(node).getFilePermissionsObj();
                Trace.out((String)("RAC home (" + this.m_location + ") has permissions (" + nodeHomePerms.toString() + ") on node (" + node + ")"));
                if (!nodeHomePerms.isGroupReadable() || !nodeHomePerms.isGroupExecutable()) {
                    permsCheckRes.addResult(node, 3);
                    String errorMsg = "";
                    if (!nodeHomePerms.isGroupReadable()) {
                        errorMsg = s_gMsgBundle.getMessage("11946", true, (Object[])new String[]{this.m_location, node});
                    }
                    if (!nodeHomePerms.isGroupExecutable()) {
                        errorMsg = errorMsg + (VerificationUtil.isStringGood(errorMsg) ? LSEP : "") + s_gMsgBundle.getMessage("11947", true, (Object[])new String[]{this.m_location, node});
                    }
                    permsCheckRes.addErrorDescription(new ErrorDescription(errorMsg));
                    VerificationUtil.traceAndLogError("Incorret group permissions detected on RAC home path (" + this.m_location + ") on node (" + node + ") Expected atleast (" + expectedPermissions + ") current (" + nodeHomePerms.toStringGroup() + ")");
                    continue;
                }
                permsCheckRes.addResult(node, 1);
            }
        } else {
            permsCheckRes.addResult(this.m_nodeList, 1);
            Trace.out((String)("The home location (" + this.m_location + ") does not exist on any of" + " the nodes. permissions check is being skipped. "));
        }
        return permsCheckRes;
    }

    private boolean performOracleBaseChecks() {
        Trace.out((String)"Performing Oracle base verification task... ");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11964", false, (Object[])new String[]{this.m_location}));
        Trace.out((String)("Oracle base path[" + this.m_location + "]"));
        ResultSet pathExCrRset = new ResultSet();
        VerificationUtil.checkPathWriteableCreateable(this.m_nodeList, this.m_location, pathExCrRset, false);
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", this.m_nodeList, this, pathExCrRset);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(pathExCrRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11965", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11966", false));
        return false;
    }

    @Override
    public String getDefaultElementName() {
        String elem = null;
        switch (this.m_type) {
            case CRS_HOME: 
            case GI_HOME: {
                elem = s_gMsgBundle.getMessage("11979", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_HOME: 
            case RAC_HOME: {
                elem = s_gMsgBundle.getMessage("11952", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_BASE: {
                elem = s_gMsgBundle.getMessage("11962", false, (Object[])new String[]{this.m_location});
            }
        }
        return elem;
    }

    @Override
    public String getDefaultDescription() {
        String description = null;
        switch (this.m_type) {
            case CRS_HOME: 
            case GI_HOME: {
                description = s_gMsgBundle.getMessage("11980", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_HOME: 
            case RAC_HOME: {
                description = s_gMsgBundle.getMessage("11953", false, (Object[])new String[]{this.m_location});
                break;
            }
            case ORACLE_BASE: {
                description = s_gMsgBundle.getMessage("11963", false, (Object[])new String[]{this.m_location});
            }
        }
        return description;
    }
}

