/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.sql.SQLException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.InstanceType;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMInitParamCollection
extends Task {
    private static String m_initParamQuery = "select i.instance_name, p.name, p.value from gv$parameter p,gv$instance I where p.inst_id = i.inst_id order by i.inst_id ";

    public TaskASMInitParamCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskASMInitParamCollection(String[] nodeList) {
        super(nodeList);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource();
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing ASMInit Param Collection");
        this.executeSQL();
        return retVal;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.ASM_INIT_PARAMETER_COLLECTION;
    }

    private void executeSQL() {
        InstanceType insType = InstanceType.ASM;
        String roleASM = "sysdba";
        String asmName = insType.toString();
        try {
            Result asmRes = new Result(asmName, 1, ResultKeyType.ASMPARAMETERS);
            Trace.out((String)("executing query: " + m_initParamQuery));
            OracleCachedRowSet rs = CVUHelperUtil.runASMQuery(m_initParamQuery, roleASM, asmRes);
            this.m_resultSet.addResult(asmName, asmRes);
            while (rs.next()) {
                String instanceName = rs.getString(1);
                String paramName = rs.getString(2);
                String paramValue = rs.getString(3);
                asmRes = new Result(instanceName, 1, ResultKeyType.ASMINSTANCE);
                this.m_resultSet.addResult(instanceName, asmRes);
                CollectionElement CE = new CollectionElement(paramName, paramValue, null, null, paramName, 1);
                this.m_resultSet.addCollectionElement(instanceName, CE);
            }
            rs.close();
        }
        catch (SQLException e) {
            Result asmRes = new Result(asmName, 2, ResultKeyType.ASMINSTANCE);
            this.m_resultSet.addResult(asmName, asmRes);
            this.m_resultSet.addErrorDescription(asmName, new ErrorDescription(e.getMessage()));
            Trace.out((String)("SQLException occured. message:" + e.getMessage()));
            Trace.out((Exception)e);
        }
    }

    @Override
    public String getTaskID() {
        return "ASM_INIT_PARAMETER_COLLECTION";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11204", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11205", false);
    }
}

