/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskUserEquivalence;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Stage
implements VerificationConstants,
MultiTaskHandler {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    protected boolean m_excludeUserEquiv;
    protected String[] m_nodeList;
    protected String[] m_validNodeList;
    protected int m_verificationMode;
    private Vector m_currentTaskSet = new Vector();
    protected ParamManager m_paramMgr;
    protected ResultSet m_resultSet = new ResultSet();
    protected boolean bNodeAddOper = false;
    private Set<String> m_alreadyAddedGlobalErrors = new HashSet<String>();
    protected List<Task> m_taskReportList = new ArrayList<Task>();
    protected ReportUtilConstants.BasicClusterWareDetails m_clusterwareDetails = new ReportUtilConstants.BasicClusterWareDetails();
    private static XmlReportTool s_xmlReportTool = null;

    Stage(int verificationMode) throws StageInitException {
        Trace.out((String)"Inside constructor of Stage(mode)...");
        this.m_verificationMode = verificationMode;
    }

    public void init() throws StageInitException {
        ArrayList newNodeList = new ArrayList();
        Trace.out((String)"Inside init of Stage...");
        try {
            this.m_paramMgr = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((String)("UNINITIALZEDPARMMGREXCEPTION: \n" + e.getMessage()));
            throw new StageInitException(e.getMessage());
        }
        this.bNodeAddOper = this.m_paramMgr.isNodeAdd();
        String autoNodeListStr = CVUVariables.getValue(CVUVariableConstants.AUTO_LIST);
        String hubNodeListStr = CVUVariables.getValue(CVUVariableConstants.HUB_LIST);
        String rimNodeListStr = CVUVariables.getValue(CVUVariableConstants.RIM_LIST);
        String targetHubSizeStr = CVUVariables.getValue(CVUVariableConstants.TARGET_HUB_SIZE);
        if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
            ArrayList<String> allNodeList = new ArrayList<String>();
            if (autoNodeListStr != null) {
                allNodeList.addAll(Arrays.asList(autoNodeListStr.split(",")));
            }
            if (hubNodeListStr != null) {
                allNodeList.addAll(Arrays.asList(hubNodeListStr.split(",")));
            }
            if (rimNodeListStr != null) {
                allNodeList.addAll(Arrays.asList(rimNodeListStr.split(",")));
            }
            VerificationUtil.setLocalNodeFirst(allNodeList);
            this.m_nodeList = allNodeList.toArray(new String[0]);
        } else {
            try {
                this.m_nodeList = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException e) {
                throw new StageInitException(e.getMessage());
            }
        }
        this.initRemoteExec();
        this.initNodeManager();
        VerificationUtil.adjustTraceSize(this.m_nodeList.length);
    }

    protected void initRemoteExec() throws StageInitException {
        try {
            VerificationUtil.startRemoteExecServer();
        }
        catch (VerificationException e) {
            throw new StageInitException(e.getMessage());
        }
    }

    protected void initNodeManager() throws StageInitException {
        NodeManager nm;
        block26: {
            nm = null;
            if (this.m_nodeList == null) {
                Trace.out((String)"m_nodeList is not initialized");
                throw new StageInitException(s_msgBundle.getMessage("7508", true));
            }
            try {
                NodeManagerFactory nmf;
                String autoNodeListStr = CVUVariables.getValue(CVUVariableConstants.AUTO_LIST);
                String hubNodeListStr = CVUVariables.getValue(CVUVariableConstants.HUB_LIST);
                String rimNodeListStr = CVUVariables.getValue(CVUVariableConstants.RIM_LIST);
                String targetHubSizeStr = CVUVariables.getValue(CVUVariableConstants.TARGET_HUB_SIZE);
                if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
                    Trace.out((String)"Creating NodeMamanger with autoNodes=%s, hubNodes=%s, rimNodes=%s, targetHubSize=%s", (Object[])new Object[]{autoNodeListStr, hubNodeListStr, rimNodeListStr, targetHubSizeStr});
                    int targetHubSize = 0;
                    String[] autoNodeList = null;
                    String[] hubNodeList = null;
                    String[] rimNodeList = null;
                    if (autoNodeListStr != null) {
                        autoNodeList = autoNodeListStr.split(",");
                    }
                    if (hubNodeListStr != null) {
                        hubNodeList = hubNodeListStr.split(",");
                    }
                    if (rimNodeListStr != null) {
                        rimNodeList = rimNodeListStr.split(",");
                    }
                    if (targetHubSizeStr != null) {
                        targetHubSize = Integer.parseInt(targetHubSizeStr);
                    } else {
                        if (autoNodeList != null) {
                            targetHubSize = autoNodeList.length;
                        }
                        if (hubNodeList != null) {
                            targetHubSize += hubNodeList.length;
                        }
                    }
                    NodeManagerFactory nmf2 = NodeManagerFactory.getInstance();
                    if (this.bNodeAddOper) {
                        nm = nmf2.getNodeManager();
                        try {
                            nm.addNodes(hubNodeList, rimNodeList, autoNodeList, targetHubSize);
                            break block26;
                        }
                        catch (NodeManagerException nme) {
                            Trace.out((String)("NodeManagerException :" + nme.getMessage()));
                            Trace.stackTrace();
                            throw new StageInitException(nme.getMessage());
                        }
                    }
                    nm = nmf2.getNodeManager(hubNodeList, rimNodeList, autoNodeList, targetHubSize);
                    break block26;
                }
                String crsHome = null;
                String haHome = null;
                boolean crsRunning = false;
                boolean haRunning = false;
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                try {
                    if (VerificationUtil.isCRSConfigured()) {
                        crsHome = VerificationUtil.getCRSHome();
                        Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj(true);
                        if (crsActiveVersion != null && VerificationUtil.isStringGood(crsHome)) {
                            crsRunning = clusterwareInfo.isCRSRunning(crsHome, crsActiveVersion);
                        }
                    } else if (VerificationUtil.isHAConfigured()) {
                        haHome = VerificationUtil.getHAHome();
                        haRunning = clusterwareInfo.isHARunning(haHome);
                    }
                }
                catch (InstallException e) {
                    Trace.out((String)("InstallException :" + e.getMessage()));
                    crsRunning = false;
                    haRunning = false;
                }
                if (crsRunning || haRunning) {
                    Trace.out((String)"CRS is configured. Creating node manager without any arguments");
                    nmf = NodeManagerFactory.getInstance();
                    nm = nmf.getNodeManager();
                    if (!this.bNodeAddOper) break block26;
                    try {
                        nm.addNodes(this.m_nodeList);
                        break block26;
                    }
                    catch (NodeManagerException nme) {
                        Trace.out((String)("NodeManagerException :" + nme.getMessage()));
                        Trace.stackTrace();
                        throw new StageInitException(nme.getMessage());
                    }
                }
                if (this.bNodeAddOper) {
                    String errorMsg = LSEP + s_gMsgBundle.getMessage("11901", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    throw new StageInitException(errorMsg);
                }
                Trace.out((String)("both CRS/HA not running. Creating nodeManager with node list: " + VerificationUtil.strArr2List(this.m_nodeList)));
                nmf = NodeManagerFactory.getInstance();
                nm = nmf.getNodeManager(this.m_nodeList);
            }
            catch (NodeManagerFactoryException nmfEx) {
                Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
                throw new StageInitException(nmfEx.getMessage());
            }
        }
        if (nm != null) {
            Trace.out((int)1, (String)("NodeManager Info: \n" + nm.toString()));
        } else {
            Trace.out((int)1, (String)"NodeManager is NULL!!");
        }
    }

    protected void setExcludeUserEquiv(boolean value) {
        this.m_excludeUserEquiv = value;
    }

    protected String[] getNodeList() {
        return this.m_nodeList;
    }

    protected String[] getValidNodeList() {
        return this.m_validNodeList;
    }

    protected void setValidNodeList(String[] validNodeList) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n Setting Valid Node list to: " + VerificationUtil.strArr2List(validNodeList)));
        }
        this.m_validNodeList = validNodeList;
    }

    public ResultSet getResultSet() {
        if (VerificationLogData.hasGlobalErrors() && !this.getNewGlobalErrorsToAdd().isEmpty()) {
            for (ErrorDescription errorDesc : this.getNewGlobalErrorsToAdd()) {
                this.m_resultSet.addErrorDescription(errorDesc);
                Trace.out((String)("Adding Global error to resultset: " + LSEP + errorDesc.getErrorMessage()));
            }
        }
        return this.m_resultSet;
    }

    private List<ErrorDescription> getNewGlobalErrorsToAdd() {
        ArrayList<ErrorDescription> newErrorList = new ArrayList<ErrorDescription>();
        for (ErrorDescription errDesc : VerificationLogData.getGlobalErrors()) {
            if (this.m_alreadyAddedGlobalErrors.contains(errDesc.getErrorMessage())) continue;
            newErrorList.add(errDesc);
            this.m_alreadyAddedGlobalErrors.add(errDesc.getErrorMessage());
        }
        return newErrorList;
    }

    public abstract void generateReport();

    protected abstract void setTaskList() throws TaskFactoryException, PreReqNotSupportedException;

    protected boolean checkSetup() {
        return this.checkSetup(this.getNodeList());
    }

    protected boolean checkSetup(String[] nodeList) {
        TaskAnonymousProxy taskAnonProxy;
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        String[] succNodeArr = nodeList;
        String[] failNodeArr = null;
        Object previousTaskReference = null;
        Trace.out((String)(" Performing checkSetup for stage... nodeList: '" + VerificationUtil.strArr2List(nodeList, ", ")));
        if (this.m_excludeUserEquiv) {
            Trace.out((String)"Skipping user equivalence check not required in this context");
        }
        if (!this.m_excludeUserEquiv) {
            TaskNodeConnectivity taskNodeReach = new TaskNodeConnectivity(nodeList);
            taskNodeReach.setTaskType(1);
            ReportUtil.setQuietModeLocal(true);
            boolean nodeReachSucc = taskNodeReach.performTask();
            ReportUtil.setQuietModeLocal(false);
            Trace.out((String)"Node Reachability checked.");
            if (!nodeReachSucc) {
                taskAnonProxy = new TaskAnonymousProxy(taskNodeReach.getElementName(), this.getNodeList(), null, taskNodeReach.getResultSet());
                taskAnonProxy.perform();
                this.m_taskReportList.add(taskNodeReach);
                taskNodeReach.getResultSet().getSuccNodes(succNodes, failNodes);
                Trace.out((String)"Node Reachability had some failures, add results to task list so they will be output to user.");
                this.m_resultSet.uploadResultSet(taskNodeReach.getResultSet());
                if (succNodes.size() == 0) {
                    String stopMessage = s_msgBundle.getMessage("4095", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    this.setValidNodeList(null);
                    return false;
                }
                String limitedVerMsg = s_msgBundle.getMessage("0008", false);
                String notReachableMsg = s_msgBundle.getMessage("4096", true);
                ReportUtil.sureprintln(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP);
                succNodeArr = succNodes.toArray(new String[succNodes.size()]);
                failNodeArr = failNodes.toArray(new String[failNodes.size()]);
                ReportUtil.processAlert(notReachableMsg + " " + VerificationUtil.strArr2List(failNodeArr, ", "));
                ReportUtil.processAlert(limitedVerMsg + " " + VerificationUtil.strArr2List(succNodeArr, ", ") + LSEP);
                this.setValidNodeList(succNodeArr);
            } else {
                this.setValidNodeList(nodeList);
            }
            TaskUserEquivalence taskUserEquiv = new TaskUserEquivalence(this.getValidNodeList());
            ReportUtil.setQuietModeLocal(true);
            boolean userEquivSucc = taskUserEquiv.performTask();
            ReportUtil.setQuietModeLocal(false);
            Trace.out((String)"Performed User Equivalence check");
            if (!userEquivSucc) {
                taskAnonProxy = new TaskAnonymousProxy(taskUserEquiv.getElementName(), this.getValidNodeList(), null, taskUserEquiv.getResultSet());
                taskAnonProxy.perform();
                this.m_taskReportList.add(taskUserEquiv);
                succNodes.clear();
                failNodes.clear();
                taskUserEquiv.getResultSet().getSuccNodes(succNodes, failNodes);
                Trace.out((String)"User Equivalence had some failures, add results to task list so they will be output to user.");
                this.m_resultSet.uploadResultSet(taskUserEquiv.getResultSet());
                if (succNodes.size() == 0) {
                    String stopMessage = s_msgBundle.getMessage("4008", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    this.setValidNodeList(null);
                    return false;
                }
                String noEquivMsg = s_msgBundle.getMessage("4009", true);
                String limitedVerMsg = s_msgBundle.getMessage("0008", false);
                failNodeArr = failNodes.toArray(new String[failNodes.size()]);
                succNodeArr = succNodes.toArray(new String[succNodes.size()]);
                ReportUtil.printWarning(noEquivMsg);
                ReportUtil.sureprintNodelist(failNodes);
                ReportUtil.sureprintln(limitedVerMsg);
                ReportUtil.sureprintNodelist(succNodes);
                ReportUtil.reportFormatPrintln(noEquivMsg + VerificationUtil.strArr2List(failNodeArr, ", "));
                ReportUtil.reportFormatPrintln(limitedVerMsg + VerificationUtil.strArr2List(succNodeArr, ", ") + LSEP);
                this.setValidNodeList(succNodeArr);
            }
        } else {
            this.setValidNodeList(nodeList);
        }
        succNodes.clear();
        failNodes.clear();
        ResultSet destlocRS = new ResultSet();
        boolean destLocSucc = VerificationUtil.checkDestLoc(this.getValidNodeList(), destlocRS, succNodes, failNodes, true);
        if (failNodes.size() > 0) {
            String taskNameStr = "'" + VerificationUtil.getDestLoc() + "'";
            taskAnonProxy = new TaskAnonymousProxy(taskNameStr, failNodes.toArray(new String[failNodes.size()]), null, destlocRS);
            taskAnonProxy.perform();
            this.m_taskReportList.add(taskAnonProxy);
            this.m_resultSet.uploadResultSet(destlocRS);
        }
        if (succNodes.size() > 0) {
            succNodeArr = succNodes.toArray(new String[succNodes.size()]);
            this.setValidNodeList(succNodeArr);
            this.m_resultSet.addResult(succNodeArr, 1);
        } else {
            this.setValidNodeList(null);
        }
        boolean succ = null == succNodeArr ? false : succNodeArr.length == nodeList.length;
        return succ;
    }

    protected boolean validateEnvironment() {
        VerificationUtil.setNoReportException(true);
        MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
        ErrorDescription errDesc = null;
        boolean check1 = false;
        boolean check2 = false;
        try {
            check1 = VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured();
            check2 = VerificationUtil.isCRSConfigured();
        }
        catch (Exception e) {
            Trace.out((String)("Caught Exception" + e.getMessage()));
            return false;
        }
        if (check1) {
            String msg = theMB.getMessage("5740", true);
            Trace.out((String)msg);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            String stopMessage = errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(stopMessage);
            ReportUtil.reportPrint(stopMessage);
            return false;
        }
        if (!check2) {
            String msg = theMB.getMessage("5745", true);
            Trace.out((String)msg);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            String stopMessage = errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(stopMessage);
            ReportUtil.reportPrint(stopMessage);
            return false;
        }
        VerificationUtil.setNoReportException(false);
        return true;
    }

    public final boolean verify() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Inside Stage.verify()...");
        }
        this.checkSetup();
        this.m_resultSet.traceResultSet("After return from  checkSetup");
        if (null == this.m_validNodeList || 0 == this.m_validNodeList.length) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n ==== NO VALID NODES ====");
            }
            return false;
        }
        if (RootAutomationUtility.isRootExecutionConfigured()) {
            try {
                if (!RootAutomationUtility.validateRootPrivileges(this.m_validNodeList)) {
                    this.m_resultSet.addResult(this.m_validNodeList, 3);
                    return false;
                }
            }
            catch (RootAutomationNotConfiguredException rance) {
                Trace.out((String)"Contradictory status of root automation configuration");
                this.m_resultSet.addResult(this.m_validNodeList, 2);
                return false;
            }
        }
        try {
            this.setTaskList();
        }
        catch (TaskFactoryException e) {
            this.m_resultSet.addResult(this.m_validNodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeList, new ErrorDescription(e.getMessage()));
            String stopMessage = e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(stopMessage);
            ReportUtil.reportPrint(stopMessage);
            return false;
        }
        catch (PreReqNotSupportedException e) {
            this.m_resultSet.addResult(this.m_validNodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeList, new ErrorDescription(e.getMessage()));
            String stopMessage = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(stopMessage);
            ReportUtil.reportPrint(stopMessage);
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            try {
                NodeManagerFactory nmf = NodeManagerFactory.getInstance();
                NodeManager nm = nmf.getNodeManager();
                Trace.out((String)("NodeManager configuration: " + nm.toString()));
            }
            catch (NodeManagerFactoryException nmfEx) {
                Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
                Trace.stackTrace();
                String stopMessage = s_msgBundle.getMessage("7508", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                ReportUtil.printError(stopMessage);
                ReportUtil.reportPrint(stopMessage);
                return false;
            }
            Trace.out((String)"\n Tasks in Task Set List: ");
            for (int dbgi = 0; dbgi < this.m_currentTaskSet.size(); ++dbgi) {
                Task trcTask = (Task)this.m_currentTaskSet.get(dbgi);
                Trace.out((String)("TaskSet task: \n" + trcTask.getClass().getName()));
                if (!trcTask.hasSubtasks()) continue;
                try {
                    List<VerificationTask> subTaskList = trcTask.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        Trace.out((String)("         sub-task: \n" + subTask.getClass().getName()));
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeList, new ErrorDescription(e.getMessage()));
                    String stopMessage = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    return false;
                }
            }
        }
        while (this.m_currentTaskSet.size() != 0) {
            boolean taskResult;
            Task task;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("m_currentTaskSet.size=" + this.m_currentTaskSet.size()));
            }
            if ((task = (Task)this.m_currentTaskSet.firstElement()).hasSubtasks()) {
                this.m_currentTaskSet.remove(0);
                try {
                    this.m_currentTaskSet.addAll(0, task.getSubtasks());
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeList, new ErrorDescription(e.getMessage()));
                    String stopMessage = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    return false;
                }
            }
            this.m_resultSet.traceResultSet("Before performing task:" + task.getClass().getName());
            try {
                taskResult = task.perform();
            }
            catch (Exception ex) {
                Trace.out((String)("Fatal error occured while executing the task " + task.getClass()));
                Trace.out((String)("Task Element" + task.getDefaultElementName()));
                Trace.out((String)("Exception :" + ex.getMessage()));
                Trace.out((Exception)ex);
                this.removeFromCurrentTaskSet(task);
                taskResult = false;
            }
            this.m_taskReportList.add(task);
            Trace.out((String)("Upload after performing task:" + task.getClass().getName()));
            this.m_resultSet.uploadResultSet(task.getResultSet());
            switch (task.getActionOnCompletion()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (taskResult) break;
                    return false;
                }
                case 3: {
                    if (taskResult || this.actionOnTaskError(task)) break;
                    return false;
                }
                case 4: {
                    if (this.actionOnTaskCompletion(task)) break;
                    return false;
                }
            }
        }
        this.generateReport();
        this.postVerify();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Stage.verify(): setting status and exiting...");
        }
        return this.m_resultSet.getStatus() == 1 || this.m_resultSet.getStatus() == 4;
    }

    protected void postVerify() {
    }

    @Override
    public synchronized Vector getCurrentTaskSet() {
        return this.m_currentTaskSet;
    }

    @Override
    public synchronized void addToCurrentTaskSet(Task task) {
        this.m_currentTaskSet.addElement(task);
    }

    @Override
    public synchronized void addToCurrentTaskSet(Task[] taskArr) {
        for (int i = 0; i < taskArr.length; ++i) {
            this.m_currentTaskSet.addElement(taskArr[i]);
        }
    }

    @Override
    public synchronized void removeFromCurrentTaskSet(Task task) {
        this.m_currentTaskSet.removeElement(task);
    }

    @Override
    public boolean actionOnTaskError(Task task) {
        Trace.out((String)"Inside stage:actionOnTaskError()...");
        return true;
    }

    @Override
    public boolean actionOnTaskCompletion(Task task) {
        Trace.out((String)"Inside stage:actionOnTaskCompletion()...");
        return true;
    }

    public void generateResults() {
        Object errorMsg = null;
        this.m_clusterwareDetails.setCVUOperation(this.getStageDisplayName());
        this.m_clusterwareDetails.setCVUHome(VerificationUtil.getCVHome());
        this.m_clusterwareDetails.setCrsUserName(VerificationUtil.getDefaultOracleUser());
        this.m_clusterwareDetails.setnodeListStr(VerificationUtil.strArr2List(this.m_validNodeList));
        if (!ReportUtil.getOldFormat()) {
            ReportUtil.reportOperationalSummary(this.m_clusterwareDetails, this.m_taskReportList);
        }
    }

    private String getStageDisplayName() {
        String stageID = this.m_paramMgr.getStageID();
        String KEY_SEP = " ";
        String mode = CLSyntax.STR_PRE;
        boolean isPre = this.m_paramMgr.checkArgPre();
        if (!isPre) {
            mode = CLSyntax.STR_POST;
        }
        return CLSyntax.STR_STAGE + KEY_SEP + mode + KEY_SEP + stageID;
    }
}

