/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.context;

import java.util.ArrayList;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqAppCluster;
import oracle.cluster.verification.ParamPreReqCFSSetup;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.ParamPreReqDBProv;
import oracle.cluster.verification.ParamPreReqHAConfig;
import oracle.cluster.verification.ParamPreReqHWOSSetup;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.GroupPrivilege;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GlobalVerificationContext
implements VerificationAPIConstants {
    private MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private ParamPreReq m_param = null;
    private ParamManager m_pm = null;
    private boolean m_isUnixSystem = false;
    private String[] m_ASMDGList;
    private String[] m_asmDevices = null;
    private VerificationType m_currentVerificationType = VerificationType.NONE;
    private boolean m_isCVUQDISKPackageCheckAdded = false;
    private boolean m_isCrsConfigured = false;
    private boolean m_isCrsConfiguredChecked = false;
    private boolean m_isHaConfigured = false;
    private boolean m_isHaConfiguredChecked = false;
    private String m_haHome = null;
    private String m_oracleHome = null;
    private String m_oracleBase = null;
    private String m_asmQuorumGroupDisks = "";
    private boolean m_asmQuorumGroupDisksChecked = false;
    private static GlobalVerificationContext m_gCtx = null;

    public static synchronized GlobalVerificationContext getInstance() {
        if (m_gCtx == null) {
            m_gCtx = new GlobalVerificationContext();
        }
        return m_gCtx;
    }

    private GlobalVerificationContext() {
        try {
            this.m_pm = ParamManager.getInstance();
            this.m_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
        }
        catch (UninitializedParamManagerException e) {
            VerificationUtil.traceAndLogError(e.getMessage());
        }
    }

    public void destroy() {
        m_gCtx = null;
    }

    public void setParamPrereq(ParamPreReq param, VerificationType vfyType) throws VerificationException {
        switch (vfyType) {
            case POSTREQ_HWOS_SETUP: {
                if (param == null || param instanceof ParamPreReqHWOSSetup) break;
                throw new VerificationException(this.s_msgBundle.getMessage("7606", false));
            }
            case POSTREQ_CFS_SETUP: 
            case PREREQ_CFS_SETUP: {
                if (param == null || param instanceof ParamPreReqCFSSetup) break;
                throw new VerificationException(this.s_msgBundle.getMessage("7605", false));
            }
            case PREREQ_USM_CONFIG: {
                if (param == null || param instanceof ParamPreReqUSMConfig) break;
                throw new VerificationException(this.s_msgBundle.getMessage("7607", false));
            }
            case PREREQ_CRS_INST: {
                if (param != null) {
                    if (param instanceof ParamPreReqCRSInst) break;
                    throw new VerificationException(this.s_msgBundle.getMessage("7511", false));
                }
                param = new ParamPreReqCRSInst();
                break;
            }
            case PREREQ_DB_INST: {
                if (param != null) {
                    if (param instanceof ParamPreReqDBInst) break;
                    throw new VerificationException(this.s_msgBundle.getMessage("7512", false));
                }
                param = new ParamPreReqDBInst();
                break;
            }
            case PREREQ_DB_PROV: {
                if (param != null) {
                    if (param instanceof ParamPreReqDBProv) break;
                    throw new VerificationException(this.s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"ParamPreReqDBProv-expected"}));
                }
                param = new ParamPreReqDBProv();
                break;
            }
            case PREREQ_SI_DB_CONFIG: 
            case PREREQ_DB_CONFIG: {
                if (param == null || param instanceof ParamPreReqDBConfig) break;
                throw new VerificationException(this.s_msgBundle.getMessage("7603", false));
            }
            case PREREQ_SI_HA_CONFIG: {
                if (param == null || param instanceof ParamPreReqHAConfig) break;
                throw new VerificationException(this.s_msgBundle.getMessage("7604", false));
            }
            case POSTREQ_NODE_ADD: 
            case POSTREQ_NODE_DEL: 
            case PREREQ_RACNODE_ADD: 
            case PREREQ_NODE_ADD: {
                if (param == null || param instanceof ParamPreReqNodeAddDel) break;
                throw new VerificationException(this.s_msgBundle.getMessage("7609", false));
            }
            case PREREQ_APPLICATION_CLUSTER_INST: 
            case POSTREQ_APPLICATION_CLUSTER_INST: {
                if (param == null || param instanceof ParamPreReqAppCluster) break;
                throw new VerificationException(this.s_gMsgBundle.getMessage("13201", true, (Object[])new String[]{"cvu-param-appcluster"}));
            }
            default: {
                if (this.m_param == null) {
                    this.m_param = param;
                }
                return;
            }
        }
        if (param == null) {
            throw new VerificationException(this.s_msgBundle.getMessage("7516", false));
        }
        this.m_param = param;
        this.setGroupVariablesValueForVfyType(vfyType);
    }

    private void setGroupVariablesValueForVfyType(VerificationType vfyType) {
        Trace.out((String)("Method Entry: vfyType " + vfyType.toString()));
        CVUVariableConstants[] groupVarNames = new CVUVariableConstants[]{CVUVariableConstants.ASM_GROUP, CVUVariableConstants.OPER_GROUP, CVUVariableConstants.DBA_GROUP, CVUVariableConstants.DBA_ASM_GROUP, CVUVariableConstants.BACKUPDBA_GROUP, CVUVariableConstants.DGDBA_GROUP, CVUVariableConstants.KMDBA_GROUP, CVUVariableConstants.RACDBA_GROUP};
        if (VerificationUtil.isHealthCheckMode()) {
            Trace.out((String)"Health check mode, cleaning group variable values");
            for (CVUVariableConstants groupVarName : groupVarNames) {
                CVUVariables.setValue(groupVarName, null);
            }
        }
        for (CVUVariableConstants groupVarName : groupVarNames) {
            String groupValue = VerificationUtil.getGroupValueForVfyType(vfyType, groupVarName);
            String privilege = GroupPrivilege.valueOf(groupVarName.toString()).getID();
            CVUVariables.setValue(groupVarName, groupValue);
            if (!VerificationUtil.isStringGood(groupValue) || !VerificationUtil.isStringGood(privilege)) continue;
            VerificationUtil.addGroupPrivilege(groupValue, privilege);
        }
    }

    public ParamPreReq getParamPrereq() {
        return this.m_param;
    }

    public String getRequestedRelease() {
        String release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
        if (!VerificationUtil.isStringGood(release) && !VerificationUtil.isStringGood(release = VerificationUtil.getConfiguredValue("CV_ORACLE_RELEASE", false))) {
            release = "12.2";
        }
        Trace.out((String)("The release being returned is " + release));
        return release;
    }

    public boolean isCVUQdiskPackageCheckAdded() {
        return this.m_isCVUQDISKPackageCheckAdded;
    }

    public void setCVUQdiskPackageCheckAdded(boolean flag) {
        this.m_isCVUQDISKPackageCheckAdded = flag;
    }

    public boolean isPreCRS() {
        return this.getVerificationType() == VerificationType.PREREQ_CRS_INST || this.getVerificationType() == VerificationType.BESTPRACTICE_PRE_CRS_INST || this.getVerificationType() == VerificationType.PREREQ_NODE_ADD || this.getVerificationType() == VerificationType.PREREQ_RACNODE_ADD || this.getVerificationType() == VerificationType.PREREQ_FARM_HEALTH || this.getVerificationType() == VerificationType.POSTREQ_HWOS_SETUP;
    }

    public boolean isNodeAdd() {
        return this.getVerificationType() == VerificationType.PREREQ_NODE_ADD || this.getVerificationType() == VerificationType.PREREQ_RACNODE_ADD || this.getVerificationType() == VerificationType.POSTREQ_NODE_ADD;
    }

    public VerificationType getVerificationType() {
        return this.m_currentVerificationType;
    }

    public void setVerificationType(VerificationType type) {
        this.m_currentVerificationType = type;
    }

    public boolean isCRSSoftwareOnlyInstall() {
        return VerificationAPIConstants.VAR_VAL_CRS_SOFT_ONLY.equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.INSTALL_OPTION));
    }

    public boolean isServicePwdSpecifiedOnCLI() {
        return this.m_pm != null && this.m_pm.isServicePwdSpecified();
    }

    public boolean isServiceUserSpecifiedOnCLI() {
        return this.m_pm != null && this.m_pm.isServiceUserSpecified();
    }

    public String getServiceUserPassword() {
        if (this.m_pm != null) {
            return this.m_pm.getServiceUserPassword();
        }
        return null;
    }

    public boolean isBigCluster() {
        try {
            return NodeManagerFactory.getInstance().getNodeManager().isBigCluster();
        }
        catch (NodeManagerException nmEx) {
            VerificationUtil.traceAndLogError("NodeManagerException occured. msg: " + nmEx.getMessage());
            return false;
        }
    }

    public boolean isApplicationCluster() {
        try {
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            return clustInfo.isApplicationCluster();
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
            return false;
        }
    }

    public static boolean isMemberCluster() {
        boolean isMemberCluster = false;
        try {
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            ClusterClassification clusterClass = clustInfo.getClusterClassification();
            Trace.out((String)("clusterClass[" + clusterClass.toString() + "]"));
            isMemberCluster = clusterClass == ClusterClassification.MEMBER_CLUSTER;
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
        }
        return isMemberCluster;
    }

    public ParamManager getParamManager() {
        return this.m_pm;
    }

    public boolean isCRSConfigured() {
        if (this.m_isCrsConfiguredChecked) {
            Trace.out((String)"Returning based on the earlier retrieval of the status");
            return this.m_isCrsConfigured;
        }
        this.m_isCrsConfigured = Boolean.valueOf(CVUVariables.getValue(CVUVariableConstants.CRS_CONFIG));
        Trace.out((String)("crsConfigured=" + this.m_isCrsConfigured));
        this.m_isCrsConfiguredChecked = true;
        return this.m_isCrsConfigured;
    }

    public boolean isHAConfigured() {
        if (this.m_isHaConfiguredChecked) {
            Trace.out((String)"Returning based on the earlier retrieval of the status");
            return this.m_isHaConfigured;
        }
        this.m_isHaConfigured = Boolean.valueOf(CVUVariables.getValue(CVUVariableConstants.HA_CONFIG));
        Trace.out((String)("haConfigured=" + this.m_isHaConfigured));
        this.m_isHaConfiguredChecked = true;
        return this.m_isHaConfigured;
    }

    public boolean isLocalNodeCRSRunning() {
        boolean localNodeCRSRunning = false;
        boolean isHA = this.isHAConfigured();
        String installedCRSorHAhome = CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome);
        if (!VerificationUtil.isStringGood(installedCRSorHAhome)) {
            installedCRSorHAhome = isHA ? VerificationUtil.getHAHome() : VerificationUtil.getCRSHome();
            Trace.out((String)("installedCRSorHAhome=" + installedCRSorHAhome));
        }
        if (!VerificationUtil.isStringGood(installedCRSorHAhome)) {
            installedCRSorHAhome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
            Trace.out((String)("installedCRSorHAhome=" + installedCRSorHAhome));
        }
        try {
            String localNode = VerificationUtil.getLocalHostName();
            if (VerificationUtil.isStringGood(installedCRSorHAhome)) {
                Version installedVersion = isHA ? VerificationUtil.getSIHAReleaseVersionObj() : VerificationUtil.getCRSActiveVersionObj();
                Trace.out((String)("installedVersion=" + installedVersion));
                localNodeCRSRunning = isHA ? new ClusterwareInfo().isHARunning(installedCRSorHAhome) : new ClusterwareInfo().isCRSRunning(installedCRSorHAhome, localNode, installedVersion);
                Trace.out((String)("localNodeCRSRunning=" + localNodeCRSRunning));
            } else {
                localNodeCRSRunning = false;
            }
        }
        catch (InstallException ie) {
            VerificationUtil.traceAndLogError("INSTALLEXCEPTION: \n" + ie.getMessage());
        }
        Trace.out((String)("Returning localNodeCRSRunning=" + localNodeCRSRunning));
        return localNodeCRSRunning;
    }

    public boolean isUnixSystem() {
        return this.m_isUnixSystem;
    }

    public boolean isUpgrade() {
        String installOption = CVUVariables.getValue(CVUVariableConstants.INSTALL_OPTION);
        if (VerificationUtil.isStringGood(installOption)) {
            return VAR_VAL_UPGRADE.equalsIgnoreCase(installOption);
        }
        return false;
    }

    public boolean isRollingUpgrade() {
        return this.isUpgrade() && this.isRolling();
    }

    public boolean isRolling() {
        String isRollingStr = CVUVariables.getValue(CVUVariableConstants.ISROLLING);
        return VerificationUtil.isStringGood(isRollingStr) && isRollingStr.equalsIgnoreCase("true");
    }

    public void setASMDiskGroups(String[] asmDiskGrpList) {
        this.m_ASMDGList = asmDiskGrpList;
    }

    public String[] getASMDiskGroups() {
        return this.m_ASMDGList;
    }

    public void setASMDevices(String[] asmDevices) {
        this.m_asmDevices = asmDevices;
    }

    public String[] getASMdevices() {
        return this.m_asmDevices;
    }

    public boolean isASMCheck() {
        String asmDeviceChecks = CVUVariables.getValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG);
        String dgReuseOptionStr = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_REUSE_OPTION);
        if (VerificationUtil.isStringGood(asmDeviceChecks) && asmDeviceChecks.equalsIgnoreCase("true")) {
            Trace.out((String)"ASM device check flag is set to true");
            return true;
        }
        if (VerificationUtil.isStringGood(dgReuseOptionStr) && dgReuseOptionStr.equalsIgnoreCase("true")) {
            Trace.out((String)"ASM diskgroup reuse option specified");
            return true;
        }
        return this.isOCROrVdiskOnASM() && !this.isASMFar();
    }

    public boolean isASMFar() {
        return this.isCRSConfigured() && CVUHelperUtil.isASMFar();
    }

    public String getCRSHome() {
        return CVUVariables.getValue(CVUVariableConstants.CONFIGURED_CRS_HOME);
    }

    public String getHAHome() {
        if (VerificationUtil.isStringGood(this.m_haHome)) {
            Trace.out((String)("Returning based on the earlier retrieval of HA home (" + this.m_haHome + ")"));
        } else {
            this.m_haHome = CVUVariables.getValue(CVUVariableConstants.HA_HOME);
        }
        return this.m_haHome;
    }

    public boolean isDHCPConfigured() {
        String dhcpConfig = CVUVariables.getValue(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP);
        return dhcpConfig != null && dhcpConfig.equalsIgnoreCase("true");
    }

    public boolean isGNSConfigured() {
        String gnsConfig = CVUVariables.getValue(CVUVariableConstants.CONFIGURE_GNS);
        return gnsConfig != null && gnsConfig.equalsIgnoreCase("true");
    }

    public boolean isIPMIConfigured() {
        String ipmiConfig = CVUVariables.getValue(CVUVariableConstants.USE_IPMI);
        return VerificationUtil.isStringGood(ipmiConfig) && ipmiConfig.equalsIgnoreCase("true");
    }

    public String getOSDBAgroup() {
        String osDbaGroup = CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
        if (!VerificationUtil.isStringGood(osDbaGroup)) {
            Trace.out((String)"Using default osdba group value");
            osDbaGroup = VerificationUtil.getDefaultDbaGroup();
        }
        Trace.out((String)("Returning m_OSDBAgroup as : " + osDbaGroup));
        return osDbaGroup;
    }

    public String getOSBACKUPgroup() {
        String osBkupGroup = CVUVariables.getValue(CVUVariableConstants.BACKUPDBA_GROUP);
        if (!VerificationUtil.isStringGood(osBkupGroup)) {
            Trace.out((String)"Using default OS backup group value");
            osBkupGroup = VerificationUtil.getDefaultDbaGroup();
        }
        Trace.out((String)("Returning OS backup DBA group  as : " + osBkupGroup));
        return osBkupGroup;
    }

    public String getOraInv() {
        Result result = new Result(VerificationUtil.getLocalNode());
        String oraInvGroup = CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
        if (!VerificationUtil.isStringGood(oraInvGroup)) {
            Trace.out((String)"Using default ora inventory group value");
            oraInvGroup = VerificationUtil.getDefaultOraInvGroup(result);
            if (oraInvGroup == null) {
                Trace.out((Object)"getOraInv: %s", (String)result.traceResultInfo());
            }
        }
        Trace.out((String)("Returning ora inventory group as : " + oraInvGroup));
        return oraInvGroup;
    }

    public String getASMAdminGroup() {
        String asmAdminGroup = CVUVariables.getValue(CVUVariableConstants.ASM_GROUP);
        if (!VerificationUtil.isStringGood(asmAdminGroup)) {
            Trace.out((String)"Using default ASM Admin group value");
            asmAdminGroup = VerificationUtil.getDefaultAsmAdminGroup();
        }
        Trace.out((String)("Returning ASM Admin group as : " + asmAdminGroup));
        return asmAdminGroup;
    }

    public boolean isOCROrVdiskOnASM() {
        String ocrOnAsmVarVal = CVUVariables.getValue(CVUVariableConstants.OCR_ON_ASM);
        String vdiskOnAsmVarVal = CVUVariables.getValue(CVUVariableConstants.VDISK_ON_ASM);
        if (VerificationUtil.isStringGood(ocrOnAsmVarVal) && ocrOnAsmVarVal.trim().equalsIgnoreCase("true")) {
            Trace.out((String)"OCR is being placed on ASM, Returning true");
            return true;
        }
        if (VerificationUtil.isStringGood(vdiskOnAsmVarVal) && vdiskOnAsmVarVal.trim().equalsIgnoreCase("true")) {
            Trace.out((String)"Voting Disk is being placed on ASM, Returning true");
            return true;
        }
        if (this.isCRSConfigured()) {
            ArrayList<String> ocrVdiskLocationList = new ArrayList<String>();
            try {
                ocrVdiskLocationList.addAll(ClusterwareUtil.getOCRLocations());
            }
            catch (VerificationException e) {
                VerificationUtil.traceAndLogError("Failed to retrieve the ocr locations, Error is: " + e.getMessage());
            }
            try {
                ocrVdiskLocationList.addAll(ClusterwareUtil.getVoteDiskLocations());
            }
            catch (ClusterInfoException e) {
                VerificationUtil.traceAndLogError("Failed to retrieve the vote disk locations. Error is :" + e.getMessage());
            }
            for (String ocrVdiskLoc : ocrVdiskLocationList) {
                if (!VerificationUtil.isASMPath(ocrVdiskLoc)) continue;
                Trace.out((String)"Either OCR or Vote disk are on ASM");
                if (ocrVdiskLocationList.contains(ocrVdiskLoc)) {
                    CVUVariables.setValue(CVUVariableConstants.OCR_ON_ASM, "TRUE");
                } else {
                    CVUVariables.setValue(CVUVariableConstants.VDISK_ON_ASM, "TRUE");
                }
                return true;
            }
        }
        return false;
    }

    public String getOracleHome() {
        if (VerificationUtil.isStringGood(this.m_oracleHome)) {
            return this.m_oracleHome;
        }
        if (this.m_param != null && this.m_param instanceof ParamPreReqDBInst) {
            this.m_oracleHome = ((ParamPreReqDBInst)this.m_param).getOrclHome();
        }
        if (!VerificationUtil.isStringGood(this.m_oracleHome)) {
            this.m_oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        }
        return this.m_oracleHome;
    }

    public String getOracleBase() {
        if (VerificationUtil.isStringGood(this.m_oracleBase)) {
            return this.m_oracleBase;
        }
        if (this.m_param != null && this.m_param instanceof ParamPreReqDBInst) {
            this.m_oracleBase = ((ParamPreReqDBInst)this.m_param).getOracleBase();
        }
        if (!VerificationUtil.isStringGood(this.m_oracleBase)) {
            this.m_oracleBase = CVUVariables.getValue(CVUVariableConstants.ORACLE_BASE);
        }
        return this.m_oracleBase;
    }

    public String getASMQuorumGroupDisks() {
        if (this.m_asmQuorumGroupDisksChecked) {
            return this.m_asmQuorumGroupDisks;
        }
        this.m_asmQuorumGroupDisksChecked = true;
        this.m_asmQuorumGroupDisks = CVUVariables.getValue(CVUVariableConstants.QUORUM_DISKS);
        VerificationUtil.traceAndLog("Quorum list :: %s\n", this.m_asmQuorumGroupDisks);
        return this.m_asmQuorumGroupDisks;
    }
}

