/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentFactory;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.component.SystemComponent;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HealthComponent
extends Component {
    private String[] m_validNodeArr = null;

    HealthComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        CVUVariables.setValue(CVUVariableConstants.MODE_HEALTH_CHECK, "TRUE");
        super.init();
    }

    @Override
    protected boolean checkSetup() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        super.checkSetup();
        if (VerificationUtil.isCVUResource()) {
            VerificationUtil.deleteLogFiles();
        }
        return null != this.getValidNodeList();
    }

    @Override
    public boolean verify() {
        boolean retval = true;
        try {
            this.m_validNodeArr = VerificationUtil.getStaticNodelist();
        }
        catch (NodelistNotFoundException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(e.getMessage());
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        this.checkSetup();
        this.m_validNodeArr = this.getValidNodeList();
        Trace.out((String)"adding all valid cluster nodes to operation");
        this.setNodeList(this.m_validNodeArr);
        if (this.m_validNodeArr.length > 1) {
            VerificationUtil.setLocalNodeOperation(false);
        }
        switch (this.m_verificationType) {
            case COMPONENT_HEALTH: {
                return retval &= this.verifyComponents();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    private boolean verifyComponents() {
        boolean retval = true;
        boolean crsConfigured = false;
        boolean haConfigured = false;
        try {
            crsConfigured = new ClusterwareInfo().isCRSConfigured();
            haConfigured = new ClusterwareInfo().isHAConfigured();
        }
        catch (InstallException e) {
            this.reportFailure(e.getMessage());
            Trace.out((Exception)((Object)e));
            return false;
        }
        try {
            if (crsConfigured || haConfigured) {
                retval &= this.verifySystemComponent(crsConfigured, haConfigured);
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("clocksync"));
            }
            if (crsConfigured || haConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("ohasd"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("crs"));
            }
            if (haConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("ha"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("scan"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("nodeapp"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("freespace"));
            }
        }
        catch (InvalidComponentException e) {
            Trace.out((Exception)((Object)e));
            this.reportFailure(e.getMessage());
            retval = false;
        }
        catch (ComponentInitException e) {
            Trace.out((Exception)((Object)e));
            this.reportFailure(e.getMessage());
            retval = false;
        }
        return retval;
    }

    private boolean verifyComponent(Component comp) throws ComponentInitException {
        boolean retval = true;
        comp.init();
        comp.setNodeList(this.m_validNodeArr);
        ResultSet compRS = comp.getResultSet();
        this.m_resultSet.uploadResultSet(compRS);
        this.report(comp.getComponentName(), comp.getComponentDisplayName(), compRS);
        return retval &= comp.verify();
    }

    private boolean verifySystemComponent(boolean crsConfigured, boolean haConfigured) throws InvalidComponentException, ComponentInitException {
        boolean retval = true;
        Component comp = null;
        comp = ComponentFactory.createComponent("sys");
        ((SystemComponent)comp).setProduct("database");
        comp.init();
        comp.setNodeList(this.m_validNodeArr);
        ResultSet compRS = comp.getResultSet();
        this.m_resultSet.uploadResultSet(compRS);
        this.report(comp.getComponentName(), comp.getComponentDisplayName(), compRS);
        return retval &= comp.verify();
    }

    private void report(String componentName, String componentDisplayName, ResultSet rset) {
        if (!ReportUtil.isFormat()) {
            return;
        }
        Hashtable t = rset.getResultTable();
        Enumeration e = t.keys();
        ReportUtil.quietprintln(componentName + "::OVERALL_STATUS::" + ReportUtil.statusOfResultSet(rset) + "::" + componentDisplayName);
        List<VerificationError> globalErrors = rset.getErrors();
        if (globalErrors.size() > 0) {
            ReportUtil.quietprintln("MSG_START");
            for (VerificationError error : globalErrors) {
                String errorMessage = error.getErrorMessage();
                ReportUtil.quietprintln(errorMessage);
            }
            ReportUtil.quietprintln("MSG_END");
        }
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            ReportUtil.quietprintln(componentName + "::NODE_STATUS:" + node + "::" + ReportUtil.statusOfResult(result));
            List<VerificationError> nodeErrors = result.getErrors();
            if (nodeErrors.size() <= 0) continue;
            ReportUtil.quietprintln("MSG_START");
            for (VerificationError error : nodeErrors) {
                String errorMessage = error.getErrorMessage();
                ReportUtil.quietprintln(errorMessage);
            }
            ReportUtil.quietprintln("MSG_END");
        }
    }

    private void reportFailure(String message) {
        ReportUtil.quietprintln("HEALTH_FAILURES::");
        ReportUtil.quietprintln("MSG_START");
        ReportUtil.quietprintln(message);
        ReportUtil.quietprintln("MSG_END");
    }

    @Override
    public String getComponentName() {
        return "HEALTH";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9959", false);
    }
}

