/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FreeSpaceComponent
extends Component {
    private String m_location;
    private StorageSize m_requiredSize;
    private Double m_requiredPercentSizeAsDbl;

    FreeSpaceComponent(VerificationType VerificationType2) throws ComponentInitException {
        super(VerificationType2);
        this.m_verificationType = VerificationType2;
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.initializeReqdValues();
        Result result = new Result(this.m_nodeList[0]);
        String crsHome = VerificationUtil.getCRSHome(this.m_nodeList[0], result);
        if (crsHome == null) {
            Trace.out((String)"Cannot get CRS Home");
            String errMsg = s_msgBundle.getMessage("5301", true);
            ErrorDescription erD = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(erD);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            throw new ComponentInitException(errMsg);
        }
        this.m_location = crsHome;
    }

    @Override
    public boolean verify() {
        ResultSet freeSpaceRS = new ResultSet();
        ResultSet compFreeSpaceRS = new ResultSet();
        sTaskFreeSpace tfs = new sTaskFreeSpace();
        String uCmd = tfs.getCommand(this.m_location);
        GlobalExecution globalExec = new GlobalExecution();
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        retval = nativeSystem.isUnixSystem() ? globalExec.runGenericCmd(validNodeArr, uCmd, freeSpaceRS) : globalExec.getSpaceCmd(validNodeArr, this.m_location, freeSpaceRS);
        Hashtable t = freeSpaceRS.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 2) {
                compFreeSpaceRS.addResult(node, result);
                retval = false;
                continue;
            }
            String cmdOut = (String)result.getResultInfoSet().firstElement();
            String cmdVal = VerificationUtil.fetchVerificationValue(cmdOut);
            if (!VerificationUtil.fetchVerificationResult(cmdOut).equals("0")) {
                Result nodeResult = new Result(node, 3);
                String msg = s_prvgMsgBundle.getMessage("11101", true, (Object[])new String[]{this.m_location, node}) + LSEP + cmdVal;
                nodeResult.addErrorDescription(new ErrorDescription(msg));
                compFreeSpaceRS.addResult(node, nodeResult);
                ReportUtil.sureprintln(msg);
                continue;
            }
            String sizeFreeTxt = tfs.getData(cmdVal, 4);
            String sizeTotalTxt = tfs.getData(cmdVal, 2);
            String sizeUsedTxt = tfs.getData(cmdVal, 3);
            Trace.out((String)("Total size is " + sizeTotalTxt + " free size is " + sizeFreeTxt + " size used is " + sizeUsedTxt));
            Double freeSpace = new Double(sizeFreeTxt);
            Double totalSpace = new Double(sizeTotalTxt);
            Double valFromTotalSpace = this.m_requiredPercentSizeAsDbl * totalSpace;
            StorageSize requiredPercentSize = new StorageSize((double)valFromTotalSpace, StorageUnit.MBYTE);
            StorageSize minReqSize = this.m_requiredSize.compareTo(requiredPercentSize) > 1 ? this.m_requiredSize : requiredPercentSize;
            Trace.out((String)("minimum required size is " + minReqSize.toString()));
            FreeSpaceValueType fsValType = this.m_requiredSize.compareTo(requiredPercentSize) > 1 ? FreeSpaceValueType.ABSOLUTE : FreeSpaceValueType.PERCENT;
            StorageSize avlSize = new StorageSize((double)freeSpace, StorageUnit.MBYTE);
            StorageSize totalSize = new StorageSize((double)totalSpace, StorageUnit.MBYTE);
            if (avlSize.compareTo(minReqSize) < 0) {
                String errMsg;
                Trace.out((String)"free space less than minimum required");
                Result sizeResult = new Result(node, 3);
                if (fsValType == FreeSpaceValueType.ABSOLUTE) {
                    errMsg = s_prvgMsgBundle.getMessage("11105", true, (Object[])new String[]{this.m_location, node, this.m_requiredSize.toString(), avlSize.toString()});
                } else {
                    double displayReqPercent = this.m_requiredPercentSizeAsDbl * 100.0;
                    errMsg = s_prvgMsgBundle.getMessage("11104", true, (Object[])new String[]{this.m_location, node, Double.toString(displayReqPercent), requiredPercentSize.toString(), avlSize.toString(), totalSize.toString()});
                }
                sizeResult.addErrorDescription(new ErrorDescription(errMsg));
                compFreeSpaceRS.addResult(node, sizeResult);
                ReportUtil.sureprintln(errMsg);
                continue;
            }
            Trace.out((String)("Free Space in the filesystem of " + this.m_location + " found on node " + node + " was sufficient"));
            compFreeSpaceRS.addResult(node, 1);
        }
        if (compFreeSpaceRS.allSuccess()) {
            ReportUtil.sureprintln(s_prvgMsgBundle.getMessage("11106", false, (Object[])new String[]{this.m_location}));
            retval = true;
        }
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + this.m_location + "'", validNodeArr, null, compFreeSpaceRS);
        this.m_taskReportList.add(anonymousTask);
        anonymousTask.perform();
        this.m_resultSet.uploadResultSet(compFreeSpaceRS);
        return retval;
    }

    @Override
    public String getComponentName() {
        return "FREESPACE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_prvgMsgBundle.getMessage("11100", false);
    }

    private void initializeReqdValues() {
        this.m_requiredSize = new StorageSize((double)new Double(VDMUtil.getCRSHomeDefMinSpaceAlertLog(VDMUtil.FreeSpaceValueType.ABSOLUTE)), StorageUnit.MBYTE);
        this.m_requiredPercentSizeAsDbl = new Double(VDMUtil.getCRSHomeDefMinSpaceAlertLog(VDMUtil.FreeSpaceValueType.PERCENT));
    }

    public static enum FreeSpaceValueType {
        ABSOLUTE,
        PERCENT;

    }
}

