/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.List;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.report.ReportUtil;

public class FarmCheckComponent
extends Component {
    boolean m_summaryOnly;
    boolean m_firstTaskStatus = true;

    FarmCheckComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_summaryOnly = this.m_paramMgr.checkArgSummary();
    }

    @Override
    public boolean verify() {
        ReportUtil.setOldFormat(true);
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        List<Task> taskList = null;
        try {
            taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_FARM_HEALTH, validNodeArr);
            if (this.m_summaryOnly) {
                ReportUtil.setQuietModeForSession(true);
            }
            for (Task task : taskList) {
                if (task.hasSubtasks()) {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        VerificationResultSet vrset = subTask.verify();
                        retval &= ((ResultSet)vrset).allSuccess();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("\n>>>> SystemComponent:: Upload SubTask=" + subTask.getElementName() + "results >>>>>\n"));
                        }
                        this.m_resultSet.uploadResultSet((ResultSet)vrset);
                    }
                    continue;
                }
                retval &= task.perform();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\n>>>> SystemComponent:: Upload Task=" + task.getElementName() + "results >>>>>\n"));
                }
                this.m_resultSet.uploadResultSet(task.getResultSet());
                if (!this.m_summaryOnly) continue;
                ReportUtil.setQuietModeForSession(false);
                this.reportTaskStatus(task);
                ReportUtil.setQuietModeForSession(true);
            }
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(validNodeArr, 2);
            this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            ReportUtil.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(validNodeArr, 2);
            this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(validNodeArr, 2);
            this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(validNodeArr, 2);
            this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (this.m_summaryOnly) {
            ReportUtil.setQuietModeForSession(false);
            this.reportOverallStatus();
        } else {
            this.reportStatusSummary(taskList);
        }
        return retval;
    }

    private void reportStatusSummary(List<Task> taskList) {
        for (Task task : taskList) {
            this.reportTaskStatus(task);
        }
        this.reportOverallStatus();
    }

    private void reportTaskStatus(Task task) {
        if (this.m_firstTaskStatus) {
            ReportUtil.sureprintln(LSEP + "Summary of results:" + LSEP);
            this.m_firstTaskStatus = false;
        }
        String taskName = task.getElementName();
        String taskID = task.getTaskName();
        StringBuilder summary = new StringBuilder(taskID + ":" + taskName);
        ResultSet resultSet = task.getResultSet();
        int taskStatus = resultSet.getStatus();
        if (taskStatus == 1) {
            summary.append(":SUCCESSFUL");
        } else {
            summary.append(":FAILED");
        }
        ReportUtil.sureprintln(summary.toString());
    }

    private void reportOverallStatus() {
        int overallStatus = this.m_resultSet.getStatus();
        ReportUtil.sureprintln("OVERALL_STATUS:" + (overallStatus == 1 ? "SUCCESSFUL" : "FAILED"));
    }

    @Override
    public String getComponentName() {
        return "FARM_CHECK";
    }

    @Override
    public String getComponentDisplayName() {
        return s_prvgMsgBundle.getMessage("0276", false);
    }
}

