/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.asm.ASMConnectInfo;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.Target;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskEZConnect;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.xmlreport.BaselineReferenceComparisonReportGenerator;
import oracle.ops.verification.framework.report.xmlreport.BaselineReportGenerator;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.CaseInsensitiveMap;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class BaselineComponent
extends Component {
    private String[] m_validNodeArr = null;
    DBUtils m_dbUtils = null;
    private static final String DB_CREDENTIAL_OERR = "ORA-01017";
    private String m_collectionType = null;
    private boolean m_rootScript = false;
    private boolean m_postInstallCollection = false;
    private boolean m_resource = false;
    private Set<String> m_dbNameToBeChecked = new HashSet<String>();
    private HashMap<String, String> m_dbHomeToBeChecked = VerificationUtil.isPlatformWindows() ? new CaseInsensitiveMap() : new HashMap();
    private boolean m_saveToAllNodes = false;
    private List<String> databaseHomeSoftwareVerifiedList = new ArrayList<String>();
    private List<String> databaseHomeEZConnectVerifiedList = new ArrayList<String>();
    private static final String INSTALL_COLLECTION_PREFIX = "install";
    private static final String GRID_PREFIX = "grid";
    private boolean m_asmRunning = false;

    BaselineComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public BaselineComponent(VerificationType verificationType, String[] nodeList, boolean postInstallCollection) throws ComponentInitException {
        super(verificationType);
        super.init(false);
        this.setNodeList(nodeList);
        VerificationUtil.adjustTraceSize(this.m_nodeList.length);
        this.m_postInstallCollection = postInstallCollection;
        this.m_collectionType = CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT);
        this.m_saveToAllNodes = true;
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_nodeList = this.getNodeList();
        this.m_collectionType = CVUVariables.getValue("BASELINE_COLLECT");
        if (VerificationUtil.isStringGood(this.m_collectionType)) {
            String saveDirectory;
            String dbHomeString;
            CVUVariables.setValue(CVUVariableConstants.MODE_BASELINE_COLLECTION, "true");
            this.m_rootScript = "true".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.BASELINE_ROOTSCRIPT));
            this.m_resource = "true".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.BASELINE_RESOURCE));
            this.m_saveToAllNodes = "true".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.SAVE_TO_ALL_NODES));
            String dbNameString = CVUVariables.getValue(CVUVariableConstants.BASELINE_DB);
            if (VerificationUtil.isStringGood(dbNameString)) {
                this.m_dbNameToBeChecked.addAll(Arrays.asList(dbNameString.split(",")));
            }
            if (VerificationUtil.isStringGood(dbHomeString = CVUVariables.getValue(CVUVariableConstants.BASELINE_DBHOME))) {
                for (String home : dbHomeString.split(",")) {
                    try {
                        String canonicalPath = new File(home).getCanonicalPath();
                        this.m_dbHomeToBeChecked.put(canonicalPath, canonicalPath);
                    }
                    catch (IOException e) {
                        Trace.out((Exception)e);
                    }
                }
            }
            if (VerificationUtil.isCRSConfigured()) {
                ResultSet rs = new ResultSet();
                String[] nodesWithCRS = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, rs, true);
                if (nodesWithCRS == null) {
                    ReportUtil.printError(s_msgBundle.getMessage("9004", true));
                } else if (nodesWithCRS.length != this.m_nodeList.length) {
                    ReportUtil.printWarning(s_msgBundle.getMessage("4038", true));
                    ArrayList<String> failedNodes = new ArrayList<String>();
                    failedNodes.addAll(Arrays.asList(this.m_nodeList));
                    failedNodes.removeAll(Arrays.asList(nodesWithCRS));
                    ReportUtil.sureprintNodelist(failedNodes);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(nodesWithCRS);
                    this.m_nodeList = nodesWithCRS;
                }
            }
            if (ParamManager.isRuncluvfy() && !VerificationUtil.isStringGood(saveDirectory = CVUVariables.getValue(CVUVariableConstants.SAVE_DIR))) {
                MessageBundle s_prvpMsgBundle = VerificationUtil.getMessageBundle("Prvp");
                throw new ComponentInitException(s_prvpMsgBundle.getMessage("3514", true));
            }
            Trace.out((String)("==== nodelist for component is : " + VerificationUtil.strArr2List(this.m_nodeList)));
            this.initNodeManager();
        }
    }

    @Override
    public boolean verify() {
        ReportUtil.setBaselineHealthcheck(true);
        switch (this.m_verificationType) {
            case COMPONENT_BASELINE: {
                if (!VerificationUtil.isStringGood(this.m_collectionType)) {
                    return this.compareBaselines();
                }
                if (this.m_nodeList.length > 1) {
                    VerificationUtil.setLocalNodeOperation(false);
                }
                if (!this.checkSetup()) {
                    return false;
                }
                this.m_validNodeArr = this.getValidNodeList();
                if (null == this.m_validNodeArr) {
                    return false;
                }
                List<Task> taskList = null;
                try {
                    taskList = TaskFactory.getInstance().getTaskList(this.m_verificationType, this.m_validNodeArr, false);
                }
                catch (PreReqNotSupportedException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
                    this.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (TaskFactoryException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                    this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                boolean retVal = this.collectBaseline(taskList);
                ReportUtil.setBaselineHealthcheck(false);
                return retVal;
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        ReportUtil.setBaselineHealthcheck(false);
        return false;
    }

    public boolean compareBaselines() {
        boolean retval = true;
        String errorMsg = null;
        String xmlFileListString = CVUVariables.getValue(CVUVariableConstants.COMPARE);
        String baselineCrossCompareFlag = CVUVariables.getValue(CVUVariableConstants.BASELINE_CROSS_COMPARE_FLAG);
        BaselineReportGenerator generator = null;
        try {
            String saveDirectory = CVUVariables.getValue(CVUVariableConstants.SAVE_DIR);
            if (!VerificationUtil.isStringGood(saveDirectory)) {
                try {
                    saveDirectory = ReportUtilConstants.getCvuHtmlReportDefaultDirPath();
                }
                catch (ClusterException e) {
                    Trace.out((String)("Error retrieving default save directory: " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
                    saveDirectory = System.getProperty("user.dir");
                }
            }
            generator = Boolean.valueOf(baselineCrossCompareFlag) != false ? new BaselineReferenceComparisonReportGenerator(xmlFileListString) : new BaselineReportGenerator(xmlFileListString);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11611", false));
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11612", false));
            boolean displayHTML = VerificationUtil.isDisplayEnabled();
            try {
                retval &= generator.xmlToHtml(s_prvgMsgBundle.getMessage("11610", false), s_prvgMsgBundle.getMessage("0212", false), this.m_paramMgr.checkArgDeviations(), HtmlConstants.Colors.WhiteSmoke, ReportUtilConstants.ReportContext.BEST_PRACTICE, displayHTML, VerificationUtil.getConfiguredValue("CV_DEFAULT_BROWSER_LOCATION", true), true, saveDirectory);
            }
            catch (HtmlBrowserException e) {
                Trace.out((String)("Ignored Browser Exception:" + e.getClass() + ":" + errorMsg));
            }
            if (retval) {
                this.m_resultSet.addResult(this.m_nodeList, 1);
                ReportUtil.quietblankln();
                if (displayHTML) {
                    ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11613", false));
                }
            } else {
                this.m_resultSet.addResult(this.m_nodeList, 3);
            }
        }
        catch (XmlFilePathException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        catch (ReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        catch (XmlReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
            this.printError(errorMsg);
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            retval = false;
        }
        if (retval) {
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11614", false));
            ReportUtil.quietblankln();
        } else {
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11615", false));
            ReportUtil.quietblankln();
        }
        if (retval && generator != null) {
            boolean bl = retval = generator.getMismatchesFound().size() == 0;
            if ("TRUE".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.BASELINE_PRINT_MISMATCH)) && generator.getMismatchesFound().size() > 0) {
                String msg = s_prvgMsgBundle.getMessage("11636", false);
                ReportUtil.quietprintln(msg);
                ReportUtil.quietblankln();
                for (String collectionName : generator.getMismatchesFound()) {
                    ReportUtil.quietprintln(collectionName);
                }
            }
        }
        ReportUtil.setBaselineHealthcheck(false);
        return retval;
    }

    /*
     * Unable to fully structure code
     */
    public boolean collectBaseline(List<Task> taskList) {
        retval = true;
        oldMode = false;
        isXmlGenerationException = false;
        if (RootAutomationUtility.isRootExecutionConfigured()) {
            try {
                if (!RootAutomationUtility.validateRootPrivileges(this.m_validNodeArr)) {
                    this.m_resultSet.addResult(this.m_validNodeArr, 3);
                    return false;
                }
            }
            catch (RootAutomationNotConfiguredException rance) {
                Trace.out((String)"Contradictory status of root automation configuration");
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                return false;
            }
        }
        oldMode = ReportUtil.getMode();
        ReportUtil.setMode(false);
        errorMsg = null;
        xmlReportTool = null;
        details = new ReportUtilConstants.BasicClusterWareDetails();
        retval = this.performDiscovery(details);
        product = CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT);
        if (!this.m_asmRunning && CLSyntax.STR_ASM.equals(product)) {
            ReportUtil.quietprintln(BaselineComponent.LSEP + BaselineComponent.s_prvgMsgBundle.getMessage("12993", true) + BaselineComponent.LSEP);
            return false;
        }
        if (CLSyntax.STR_DATABASE.equals(product) && (this.m_dbNameToBeChecked.size() > 0 || this.m_dbHomeToBeChecked.size() > 0)) {
            databaseList = details.getDatabases();
            for (ReportUtilConstants.DatabaseDetails databaseDtails : databaseList) {
                try {
                    if (this.m_dbHomeToBeChecked.size() > 0 && this.m_dbHomeToBeChecked.keySet().contains(new File(databaseDtails.getDatabaseHome()).getCanonicalPath())) {
                        this.m_dbHomeToBeChecked.remove(new File(databaseDtails.getDatabaseHome()).getCanonicalPath());
                    }
                    if (this.m_dbNameToBeChecked.size() <= 0 || !this.m_dbNameToBeChecked.contains(databaseDtails.getDatabaseName())) continue;
                    this.m_dbNameToBeChecked.remove(databaseDtails.getDatabaseName());
                }
                catch (IOException e) {
                    Trace.out((Exception)e);
                }
            }
            statusMsg = null;
            if (this.m_dbNameToBeChecked.size() > 0 || this.m_dbHomeToBeChecked.size() > 0) {
                if (this.m_dbNameToBeChecked.size() > 0) {
                    failedDatabaseNames = "";
                    first = true;
                    for (String dbName : this.m_dbNameToBeChecked) {
                        if (first) {
                            failedDatabaseNames = dbName;
                            first = false;
                            continue;
                        }
                        failedDatabaseNames = failedDatabaseNames + "," + dbName;
                    }
                    statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11658", true, (Object[])new String[]{failedDatabaseNames});
                } else {
                    failedDatabaseHomes = "";
                    first = true;
                    for (String databaseHome : this.m_dbHomeToBeChecked.keySet()) {
                        if (first) {
                            failedDatabaseHomes = databaseHome;
                            first = false;
                            continue;
                        }
                        failedDatabaseHomes = failedDatabaseHomes + "," + databaseHome;
                    }
                    statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11659", true, (Object[])new String[]{failedDatabaseHomes});
                }
                this.m_resultSet.setStatus(3);
                this.m_resultSet.addErrorDescription(new ErrorDescription(statusMsg));
                ReportUtil.quietprintln(BaselineComponent.LSEP + statusMsg + BaselineComponent.LSEP);
                ReportUtil.quietprintln(BaselineComponent.s_prvgMsgBundle.getMessage("11639", false) + BaselineComponent.LSEP);
                return false;
            }
        }
        if (!retval) {
            ReportUtil.quietprintln(BaselineComponent.LSEP + BaselineComponent.s_msgBundle.getMessage("0007", false) + BaselineComponent.LSEP);
            return false;
        }
        CVUVariables.setValue(CVUVariableConstants.SRC_CRS_HOME_VERSION, details.getClusterwareVersion());
        CVUVariables.setValue(CVUVariableConstants.MODE_BASELINE_COLLECTION, "true");
        saveDirectory = CVUVariables.getValue(CVUVariableConstants.SAVE_DIR);
        if (!VerificationUtil.isStringGood(saveDirectory)) {
            try {
                saveDirectory = this.m_rootScript || this.m_postInstallCollection ? ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForPostInstall() : (this.m_resource ? ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForCVUResource() : ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForUsers());
            }
            catch (ClusterException e) {
                Trace.out((String)("Error retrieving default save directory: " + e.getClass() + " : " + e.getMessage()));
                saveDirectory = System.getProperty("user.dir");
            }
        }
        if (this.m_postInstallCollection) {
            homeName = CVUVariables.getValue(CVUVariableConstants.BASELINE_HOME_NAME);
            if (!VerificationUtil.isStringGood(homeName)) {
                homeName = "grid";
            }
            version = null;
            crsActiveVersion = VerificationUtil.getCRSActiveVersionObj(true);
            dbUtils = new DBUtils(crsActiveVersion);
            if (this.m_dbHomeToBeChecked.size() > 0) {
                try {
                    version = dbUtils.getDBVersionString(this.m_dbHomeToBeChecked.keySet().iterator().next());
                }
                catch (DBUtilsException e) {
                    Trace.out((Exception)e);
                }
            }
            if (!VerificationUtil.isStringGood(version)) {
                version = String.valueOf(crsActiveVersion);
            }
            reportName = homeName + " " + "install" + " " + (String)version;
            CVUVariables.setValue(CVUVariableConstants.BASELINE_REPORT_NAME, reportName);
        }
        failedDatabase = new Vector<ReportUtilConstants.DatabaseDetails>();
        try {
            xmlReportTool = new XmlReportTool();
            xmlReportTool.startDocument(saveDirectory, "cvubaseline");
            xmlReportTool.addHeader(details);
            for (Task t : taskList) {
                block92: {
                    if (!t.isTypeTarget()) break block92;
                    target = (Target)t;
                    target.setClearCache(false);
                    vfyType = target.getTargetType();
                    Trace.out((String)("Performing target " + (Object)target.getTargetType()));
                    version = details.getClusterwareVersion();
                    if (!VerificationUtil.isStringGood(version)) {
                        version = Version.getCurrentVersion().toString4();
                    }
                    versionComponents = version.split(Pattern.quote("."));
                    majorNumber = versionComponents[0];
                    minorNumber = "0".equals(versionComponents[1]) != false ? "1" : versionComponents[1];
                    release = majorNumber + "." + minorNumber;
                    block8 : switch (1.$SwitchMap$oracle$cluster$verification$util$VerificationType[vfyType.ordinal()]) {
                        case 2: 
                        case 3: 
                        case 4: {
                            if (!product.contains("all") && !product.contains("cluster")) break;
                            m_paramPreReq = new ParamPreReqCRSInst();
                            m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
                            if (!VerificationUtil.isStringGood(version)) {
                                version = "12.2";
                            }
                            m_paramPreReq.setRelease(release);
                            switch (1.$SwitchMap$oracle$cluster$verification$util$VerificationType[vfyType.ordinal()]) {
                                case 2: {
                                    if (this.m_paramMgr.checkArgBestPractice()) break;
                                    retval &= this.collectOSMandatoryChecks(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                    break block8;
                                }
                                case 3: {
                                    if (this.m_paramMgr.checkArgBestPractice()) break;
                                    retval &= this.collectOSCollections(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                    break block8;
                                }
                                case 4: {
                                    if (this.m_paramMgr.checkArgMandatory()) break;
                                    retval &= this.collectOSBestPractice(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                }
                            }
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if (!product.contains("all") && !product.contains("cluster")) break;
                            m_paramPreReq = new ParamPreReqCRSInst();
                            m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
                            m_paramPreReq.setRelease(release);
                            CVUVariables.setValue(CVUVariableConstants.CRS_HOME, VerificationUtil.getCRSHome());
                            switch (1.$SwitchMap$oracle$cluster$verification$util$VerificationType[vfyType.ordinal()]) {
                                case 5: 
                                case 6: {
                                    if (this.m_paramMgr.checkArgBestPractice()) break;
                                    retval &= this.collectClusterwareMandatoryChecks(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                    break block8;
                                }
                                case 7: 
                                case 8: {
                                    if (this.m_paramMgr.checkArgMandatory()) break;
                                    retval &= this.collectClusterwareBestPractice(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                }
                            }
                            break;
                        }
                        case 9: 
                        case 10: {
                            if (!retval || CLSyntax.STR_DATABASE.equals(product)) break;
                            m_paramPreReq = new ParamPreReqUSMConfig();
                            m_paramPreReq.setRelease(release);
                            switch (1.$SwitchMap$oracle$cluster$verification$util$VerificationType[vfyType.ordinal()]) {
                                case 9: {
                                    if (this.m_paramMgr.checkArgBestPractice()) break;
                                    retval &= this.collectASMMandatoryChecks(target, (ParamPreReqUSMConfig)m_paramPreReq, xmlReportTool);
                                    break block8;
                                }
                                case 10: {
                                    if (this.m_paramMgr.checkArgMandatory()) break;
                                    retval &= this.collectASMBestPractice(target, (ParamPreReqUSMConfig)m_paramPreReq, xmlReportTool);
                                }
                            }
                            break;
                        }
                        case 11: 
                        case 12: {
                            if (!product.contains("all") && !product.contains("database")) break;
                            databaseList = details.getDatabases();
                            databaseResult = true;
                            block48: for (ReportUtilConstants.DatabaseDetails databaseDtails : databaseList) {
                                if (this.m_dbHomeToBeChecked.size() <= 0) ** GOTO lbl179
                                try {
                                    if (!this.m_dbHomeToBeChecked.keySet().contains(new File(databaseDtails.getDatabaseHome()).getCanonicalPath())) ** GOTO lbl175
                                    this.m_dbHomeToBeChecked.remove(new File(databaseDtails.getDatabaseHome()).getCanonicalPath());
                                    ** GOTO lbl179
lbl175:
                                    // 1 sources

                                    Trace.out((int)5, (String)"DB Home %s will be skipped because it is not specified in one of the homes to be checked in %s", (Object[])new Object[]{databaseDtails.getDatabaseHome(), this.m_dbHomeToBeChecked});
                                    continue;
                                }
                                catch (IOException e) {
                                    Trace.out((Exception)e);
                                }
lbl179:
                                // 3 sources

                                if (this.m_dbNameToBeChecked.size() > 0) {
                                    if (this.m_dbNameToBeChecked.contains(databaseDtails.getDatabaseName())) {
                                        this.m_dbNameToBeChecked.remove(databaseDtails.getDatabaseName());
                                    } else {
                                        Trace.out((int)5, (String)"DB %s will be skipped because it is not specified in one of the DB to be checked in %s", (Object[])new Object[]{databaseDtails.getDatabaseName(), this.m_dbNameToBeChecked});
                                        continue;
                                    }
                                }
                                switch (1.$SwitchMap$oracle$cluster$verification$util$VerificationType[target.getTargetType().ordinal()]) {
                                    case 11: {
                                        if (this.m_paramMgr.checkArgMandatory()) break;
                                        databaseResult = this.collectDatabaseChecks(target, databaseDtails, xmlReportTool);
                                        break;
                                    }
                                    case 12: {
                                        if (this.m_paramMgr.checkArgBestPractice()) break;
                                        databaseResult = this.collectDatabaseChecks(target, databaseDtails, xmlReportTool);
                                        break;
                                    }
                                    default: {
                                        continue block48;
                                    }
                                }
                                if (!databaseResult) {
                                    failedDatabase.add(databaseDtails);
                                }
                                retval &= databaseResult;
                            }
                            details.getDatabases().removeAll(failedDatabase);
                        }
                    }
                    continue;
                }
                Trace.out((String)"This is not a target, but a task. Performing it.");
                this.verifyTask(t);
            }
            xmlReportTool.endDocument();
        }
        catch (ParserConfigurationException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught ParserConfigurationException Error:" + errorMsg));
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            isXmlGenerationException = true;
        }
        catch (XmlFilePathException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught XmlFilePathException Error:" + errorMsg));
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            isXmlGenerationException = true;
        }
        catch (XmlReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught XmlReportToolException Error:" + errorMsg));
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            isXmlGenerationException = true;
        }
        catch (ReportToolException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught ReportToolException Error:" + errorMsg));
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            isXmlGenerationException = true;
        }
        catch (SubtasksNotCompleteException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught SubtasksNotCompleteException Error:" + errorMsg));
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            isXmlGenerationException = false;
        }
        catch (VerificationException e) {
            errorMsg = e.getMessage();
            Trace.out((String)("Caught VerificationException Error:" + errorMsg));
            this.m_resultSet.setStatus(2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            isXmlGenerationException = false;
        }
        if ((!retval || isXmlGenerationException) && VerificationUtil.isStringGood(errorMsg)) {
            this.reportFailure(errorMsg + BaselineComponent.LSEP + BaselineComponent.s_msgBundle.getMessage("0007", false) + BaselineComponent.LSEP);
        }
        if (this.m_dbNameToBeChecked.size() > 0 || this.m_dbHomeToBeChecked.size() > 0) {
            retval = false;
        }
        statusMsg = null;
        if (!isXmlGenerationException && VerificationUtil.isStringGood(xmlReportTool.getXMLFilePath()) && new File(xmlReportTool.getXMLFilePath()).exists()) {
            if (retval && !this.m_resultSet.anyFailure()) {
                statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11637", false) + BaselineComponent.LSEP;
            } else {
                if (this.m_dbNameToBeChecked.size() > 0 || this.m_dbHomeToBeChecked.size() > 0) {
                    if (this.m_dbNameToBeChecked.size() > 0) {
                        failedDatabaseNames = "";
                        first = true;
                        for (String dbName : this.m_dbNameToBeChecked) {
                            if (first) {
                                failedDatabaseNames = dbName;
                                first = false;
                                continue;
                            }
                            failedDatabaseNames = failedDatabaseNames + "," + dbName;
                        }
                        statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11658", false, (Object[])new String[]{failedDatabaseNames}) + BaselineComponent.LSEP;
                    } else {
                        failedDatabaseHomes = "";
                        first = true;
                        for (String databaseHome : this.m_dbHomeToBeChecked.keySet()) {
                            if (first) {
                                failedDatabaseHomes = databaseHome;
                                first = false;
                                continue;
                            }
                            failedDatabaseHomes = failedDatabaseHomes + "," + databaseHome;
                        }
                        statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11659", false, (Object[])new String[]{failedDatabaseHomes}) + BaselineComponent.LSEP;
                    }
                } else {
                    statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11641", false) + BaselineComponent.LSEP;
                    if (failedDatabase.size() > 0) {
                        failedDatabaseNames = "";
                        first = true;
                        for (ReportUtilConstants.DatabaseDetails databaseDetails : failedDatabase) {
                            if (first) {
                                failedDatabaseNames = databaseDetails.getDatabaseName();
                                first = false;
                                continue;
                            }
                            failedDatabaseNames = failedDatabaseNames + "," + databaseDetails.getDatabaseName();
                        }
                        statusMsg = statusMsg + BaselineComponent.s_prvgMsgBundle.getMessage("11643", false, (Object[])new String[]{failedDatabaseNames}) + BaselineComponent.LSEP;
                    }
                }
                this.m_resultSet.setStatus(3);
                this.m_resultSet.addErrorDescription(new ErrorDescription(statusMsg));
            }
            if (this.m_saveToAllNodes) {
                try {
                    nodeListWithoutLocalNode = new ArrayList<String>();
                    nodeListWithoutLocalNode.addAll(Arrays.asList(this.m_nodeList));
                    nodeListWithoutLocalNode.remove(VerificationUtil.getLocalNode());
                    removeDir = ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForCVUResource();
                    Trace.out((String)("trimming files in " + removeDir + " directory"));
                    nativeSystem = new SystemFactory().CreateSystem();
                    cmd = nativeSystem.isUnixSystem() != false ? VerificationUtil.getCVUSubDirPath() + "remove_cvuresource_baseline.sh " + removeDir : VerificationUtil.getCVUSubDirPath() + "remove_cvuresource_baseline.bat " + removeDir;
                    Trace.out((String)(" command to be run " + cmd));
                    globalExec = new GlobalExecution();
                    rslt = false;
                    usrInfoRsltSet = new ResultSet();
                    rslt = globalExec.runExe(nodeListWithoutLocalNode.toArray(new String[0]), cmd, usrInfoRsltSet, false);
                    usrInfoRsltSet.traceResultSet("Results from deleting baseline xml files");
                    if (nodeListWithoutLocalNode.size() > 0) {
                        new ClusterCmd().copyFileToNodes(xmlReportTool.getXMLFilePath(), nodeListWithoutLocalNode.toArray(new String[0]));
                    }
                }
                catch (ClusterException e) {
                    this.printWarning(BaselineComponent.s_prvgMsgBundle.getMessage("11644", true, (Object[])new String[]{e.getMessage()}) + BaselineComponent.LSEP);
                }
            }
            statusMsg = statusMsg + BaselineComponent.s_prvgMsgBundle.getMessage("11638", false, (Object[])new String[]{xmlReportTool.getXMLFilePath()});
        } else {
            statusMsg = BaselineComponent.s_prvgMsgBundle.getMessage("11639", false);
        }
        ReportUtil.quietprintln(statusMsg);
        try {
            if (!"baseline".equals(ParamManager.getInstance().getCompID())) {
                ReportUtil.setMode(oldMode);
            } else {
                ReportUtil.setMode(true);
                details.setCVUOperation(ReportUtil.getCompMsg(this.m_paramMgr.getCompID()));
                ReportUtil.reportOperationalSummary(details);
                ReportUtil.setMode(false);
            }
        }
        catch (UninitializedParamManagerException var12_25) {
            // empty catch block
        }
        return retval;
    }

    private HashMap<CollectionGroup, List<Task>> collectFromTasks(VerificationType vType, List<Task> taskList) throws SubtasksUnavailableException, SubtasksNotCompleteException, VerificationException {
        HashMap<CollectionGroup, List<Task>> collectionGroupTaskList = new HashMap<CollectionGroup, List<Task>>();
        try {
            for (Task task : taskList) {
                List<Task> tList;
                if (task.hasSubtasks()) {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        this.verifyTask((Task)subTask);
                    }
                } else {
                    this.verifyTask(task);
                }
                CollectionGroup cg = task.getCollectionGroup();
                if (cg == null) {
                    cg = CollectionGroup.getCollectionGroup(vType);
                }
                if ((tList = collectionGroupTaskList.get((Object)cg)) == null) {
                    tList = new ArrayList<Task>();
                    collectionGroupTaskList.put(cg, tList);
                }
                tList.add(task);
            }
            ReportUtil.quietblankln();
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            throw e;
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            throw e;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            throw e;
        }
        return collectionGroupTaskList;
    }

    private void verifyTask(Task task) throws SubtasksNotCompleteException, VerificationException {
        String msg = s_prvgMsgBundle.getMessage("0250", false, (Object[])new String[]{task.getElementName()});
        ReportUtil.quietprint(msg);
        try {
            task.setCollectionMode(true);
            task.verify();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n>>>> SystemComponent:: Upload Task=" + task.getElementName() + "results >>>>>\n"));
            }
            this.m_resultSet.uploadResultSet(task.getResultSet());
            this.printTaskSummary(task);
        }
        catch (Exception e) {
            Trace.out((int)5, (String)"Exception caught while executing %s: %s", (Object[])new Object[]{task.getElementName(), e.getMessage()});
            Trace.out((Exception)e);
            String overAllStatusText = s_prveMsgBundle.getMessage("10132", false);
            ReportUtil.quietprintln(overAllStatusText.toLowerCase());
        }
    }

    private void printTaskSummary(Task task) {
        if (this.m_paramMgr.checkArgDeviations() && task.getResultSet().allSuccess()) {
            return;
        }
        String overAllStatusText = s_prveMsgBundle.getMessage("10131", false);
        if (!this.anyElementCollected(task)) {
            overAllStatusText = s_prveMsgBundle.getMessage("10132", false);
        }
        ReportUtil.quietprintln(overAllStatusText.toLowerCase());
    }

    private boolean anyElementCollected(Task task) {
        if (task.getResultSet().getCollectionElements().size() > 0) {
            return true;
        }
        try {
            for (VerificationResult nodeRes : task.getResultSet().getNodeResults()) {
                if (((Result)nodeRes).getCollectionElements().size() <= 0) continue;
                return true;
            }
        }
        catch (NodeResultsUnavailableException e) {
            return false;
        }
        return false;
    }

    private boolean performDiscovery(ReportUtilConstants.BasicClusterWareDetails details) {
        boolean retval;
        block26: {
            String gridHome = null;
            retval = true;
            String clusterwareVersion = null;
            Version clusterwareVersionObject = null;
            details.setOsPlatform(VerificationUtil.getOperatingSystemName());
            String localNode = VerificationUtil.getLocalNode();
            boolean haConfigured = VerificationUtil.isHAConfigured();
            String product = CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT);
            details.setnodeListStr(localNode);
            if (haConfigured) {
                gridHome = VerificationUtil.getHAHome();
                clusterwareVersion = VerificationUtil.getSIHAReleaseVersion();
                clusterwareVersionObject = VerificationUtil.getSIHAReleaseVersionObj();
            } else {
                gridHome = VerificationUtil.getCRSHome();
                clusterwareVersion = VerificationUtil.getCRSSoftwareVersion(localNode);
                clusterwareVersionObject = VerificationUtil.getCRSSoftwareVersionObj();
            }
            if (gridHome == null) {
                return true;
            }
            if (clusterwareVersion == null) {
                return true;
            }
            CollectionResult<String> oracleBaseCR = ClusterwareUtil.getOracleBase(localNode, gridHome);
            if (oracleBaseCR.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
                try {
                    details.setOracleBase(oracleBaseCR.getCollectedValue());
                }
                catch (CollectionValueUnavailableException e) {
                    Trace.out((Exception)e);
                }
            }
            try {
                String[] nodeList = VerificationUtil.getNodelist();
                details.setnodeListStr(VerificationUtil.strArr2List(nodeList));
            }
            catch (NodelistNotFoundException e1) {
                Trace.out((String)("IGNORED Exception :" + e1.getClass().getName() + " :" + e1.getMessage()));
                Trace.out((Exception)e1);
            }
            this.m_dbUtils = new DBUtils(clusterwareVersionObject);
            Result result = new Result(localNode);
            String crsUser = VerificationUtil.getCRSUser(result, haConfigured);
            if (crsUser != null) {
                details.setCrsUserName(crsUser);
            }
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            details.setClusterwareVersion(clusterwareVersion);
            details.setCrsHome(gridHome);
            try {
                String clusterName = clusterwareInfo.getClusterName(gridHome, clusterwareVersionObject);
                if (clusterName != null) {
                    details.setClusterName(clusterName);
                }
                if (product.contains("all") || product.contains("database")) {
                    String dbName = CVUVariables.getValue(CVUVariableConstants.BASELINE_DB);
                    String dbHome = CVUVariables.getValue(CVUVariableConstants.BASELINE_DBHOME);
                    if (dbName != null) {
                        try {
                            this.performDatabaseDiscovery(dbName, details);
                        }
                        catch (DBUtilsException e) {
                            String msg = e.getMessage();
                            if (VerificationUtil.isStringGood(msg)) {
                                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                                this.printError(msg + LSEP);
                            }
                            return false;
                        }
                    } else {
                        String[] dbNameList;
                        for (String dbNameStr : dbNameList = this.m_dbUtils.getDatabases()) {
                            try {
                                this.performDatabaseDiscovery(dbNameStr, details);
                            }
                            catch (DBUtilsException e) {
                                Trace.out((Exception)e);
                                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                                String msg = e.getMessage();
                                if (!VerificationUtil.isStringGood(msg)) continue;
                                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                                this.printError(msg + LSEP);
                            }
                        }
                    }
                }
                if (!product.contains("all") && !product.contains("asm")) break block26;
                ArrayList<String> runningNodeList = new ArrayList<String>();
                ArrayList<String> failedNodeList = new ArrayList<String>();
                ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
                try {
                    Trace.out((String)"checking if asm is running");
                    asmdg.checkASMRunning(VerificationUtil.getStaticNodelist(), runningNodeList, failedNodeList);
                }
                catch (ASMDiskGroupsUtilException e) {
                    Trace.out((String)("ASMDG exception while checking for asm " + e.getMessage()));
                    Object[] args = new String[]{VerificationUtil.strArr2List(this.m_nodeList)};
                    this.printError(s_prvgMsgBundle.getMessage("1008", true, args) + LSEP);
                    this.printError(e.getMessage() + LSEP);
                }
                if (runningNodeList.size() >= 1) {
                    this.m_asmRunning = true;
                }
            }
            catch (InstallException e) {
                Trace.out((Exception)((Object)e));
                this.printError(e.getMessage());
                this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
            }
            catch (Exception e) {
                Trace.out((Exception)e);
                this.printError(e.getMessage());
                this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
            }
        }
        return retval;
    }

    private void performDatabaseDiscovery(String dbName, ReportUtilConstants.BasicClusterWareDetails details) throws DBUtilsException {
        DatabaseInfo database = this.m_dbUtils.getDatabaseInfo(dbName);
        String dbHome = database.getHome();
        String dbVersion = database.getVersionString();
        details.addDatabaseDetails(dbName, dbHome, dbVersion);
    }

    private boolean collectClusterwareMandatoryChecks(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block14: {
            retval = true;
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0255", false);
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3133", false, (Object[])new String[]{version}));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
                    break block14;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
        }
        return retval;
    }

    private boolean collectClusterwareBestPractice(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block14: {
            retval = true;
            m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
            String[] versionComponents = version.split(Pattern.quote("."));
            String majorNumber = versionComponents[0];
            String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
            String release = majorNumber + "." + minorNumber;
            m_paramPreReq.setRelease(release);
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0252", false);
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3134", false, (Object[])new String[]{version}));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
                    break block14;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
        }
        return retval;
    }

    private boolean collectDatabaseChecks(Target target, ReportUtilConstants.DatabaseDetails databaseDtails, XmlReportTool xmlReportTool) {
        String dbHome = databaseDtails.getDatabaseHome();
        String dbVersion = databaseDtails.getDatabaseVersion();
        ParamPreReqDBConfig m_paramPreReq = new ParamPreReqDBConfig(dbHome);
        m_paramPreReq.setOraInv(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = dbVersion.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        String database = databaseDtails.getDatabaseName();
        String userName = "DBSNMP";
        String password = null;
        String portStr = null;
        int port = 1521;
        String dbConnectDescr = null;
        ResultSet locrs = new ResultSet();
        String dbCollectionFailedErrorMsg = s_prvgMsgBundle.getMessage("0258", true, (Object[])new String[]{databaseDtails.getDatabaseName()});
        try {
            boolean bPortReq = this.m_dbUtils.isPortRequiredForConnect(database);
            DatabaseConnectInfo dbConnInfo = null;
            if (VerificationUtil.isOTN()) {
                ConsoleUtil consoleUtil = new ConsoleUtil();
                String userNamePrompt = s_prvgMsgBundle.getMessage("11151", false, (Object[])new String[]{database, userName});
                if ((userName = consoleUtil.read(userNamePrompt)) == null || userName.length() == 0) {
                    userName = "DBSNMP";
                }
                String passwordPrompt = s_prvgMsgBundle.getMessage("11150", false, (Object[])new String[]{userName, database});
                password = new String(consoleUtil.readPassword(passwordPrompt));
                if (bPortReq) {
                    String portPrompt = s_prvgMsgBundle.getMessage("11152", false, (Object[])new String[]{database});
                    portStr = consoleUtil.read(portPrompt);
                    try {
                        if (portStr == null || portStr.length() == 0) {
                            port = 1521;
                        }
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)("Invalid port. " + portStr + ". NumberFormatException occured. msg: " + e.getMessage()));
                        Trace.out((String)"using dafault port 1521");
                        port = 1521;
                    }
                }
            } else {
                password = HeavyWeightVerificationUtil.getDBPassword(database, userName, locrs);
            }
            if (bPortReq) {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(databaseDtails.getDatabaseName(), port);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password, port);
            } else {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password);
            }
            this.testCreds(dbConnectDescr, userName, password);
            DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
        }
        catch (ConsoleUtilException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(dbCollectionFailedErrorMsg + LSEP);
            return false;
        }
        catch (DBConnectionException e) {
            String msg = e.getMessage();
            if (msg.contains(DB_CREDENTIAL_OERR)) {
                this.m_resultSet.addResult(this.m_validNodeArr, 4);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                String errorMessage = s_prvgMsgBundle.getMessage("0219", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
                this.printWarning(errorMessage);
                this.printError(dbCollectionFailedErrorMsg + LSEP);
                return true;
            }
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
            String errorMessage = s_prvgMsgBundle.getMessage("0222", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
            this.printError(errorMessage + LSEP + msg + LSEP);
            this.printError(dbCollectionFailedErrorMsg + LSEP);
            return false;
        }
        catch (DBUtilsException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(dbCollectionFailedErrorMsg + LSEP);
            return false;
        }
        catch (CVUException cvuEx) {
            if (locrs.getResult(database).getStatus() == 3) {
                return false;
            }
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = cvuEx.getMessage();
            Trace.out((String)("CVUException occured: msg" + msg));
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        CVUVariables.setValue(CVUVariableConstants.ORACLE_HOME, dbHome);
        CVUVariables.setValue(CVUVariableConstants.SRC_RAC_HOME_VERSION, dbVersion);
        CVUVariables.setValue(CVUVariableConstants.DB_NAME, database);
        boolean retval = true;
        switch (target.getTargetType()) {
            case BESTPRACTICE_POSTREQ_DB_CONFIG: {
                if (this.m_paramMgr.checkArgMandatory()) break;
                retval &= this.collectDatabaseBestPractice(target, databaseDtails, m_paramPreReq, xmlReportTool);
                break;
            }
            case POSTREQ_DB_CONFIG: {
                if (this.m_paramMgr.checkArgBestPractice()) break;
                retval &= this.collectDatabaseMandatoryChecks(target, databaseDtails, m_paramPreReq, xmlReportTool);
            }
        }
        return retval;
    }

    private boolean collectDatabaseMandatoryChecks(Target target, ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block19: {
            retval = true;
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0256", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3131", false));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, databaseDtails.getDatabaseName(), databaseDtails.getDatabaseHome());
                    break block19;
                }
                Iterator<Task> taskIterator = taskList.iterator();
                while (taskIterator.hasNext()) {
                    Task taskItem = taskIterator.next();
                    if (taskItem instanceof TaskSoftwareDistribution) {
                        taskItem.setCollectionGroup(CollectionGroup.DB_SOFTWARE_COLLECTION);
                        String home = ((TaskSoftwareDistribution)taskItem).getSoftwareComponentHome();
                        if (this.databaseHomeSoftwareVerifiedList.contains(home)) {
                            Trace.out((int)5, (String)"Home %s already verified, skipping software check", (Object[])new Object[]{home});
                            taskIterator.remove();
                        } else {
                            this.databaseHomeSoftwareVerifiedList.add(home);
                        }
                    }
                    if (!(taskItem instanceof TaskEZConnect)) continue;
                    if (this.databaseHomeEZConnectVerifiedList.contains(databaseDtails.getDatabaseHome())) {
                        Trace.out((int)5, (String)"EZconnect for Home %s already added, skipping TaskEZConnect check", (Object[])new Object[]{databaseDtails.getDatabaseHome()});
                        taskIterator.remove();
                        continue;
                    }
                    this.databaseHomeEZConnectVerifiedList.add(databaseDtails.getDatabaseHome());
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, databaseDtails.getDatabaseName(), databaseDtails.getDatabaseHome());
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                return false;
            }
        }
        return retval;
    }

    private boolean collectDatabaseBestPractice(Target target, ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block14: {
            retval = true;
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0253", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3132", false));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, databaseDtails.getDatabaseName(), databaseDtails.getDatabaseHome());
                    break block14;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, databaseDtails.getDatabaseName(), databaseDtails.getDatabaseHome());
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                return false;
            }
        }
        return retval;
    }

    private boolean collectASMMandatoryChecks(Target target, ParamPreReqUSMConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block11: {
            retval = true;
            try {
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("0228", false));
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3137", false));
                    break block11;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(VerificationType.COMPONENT_ASM_INTEGRITY, taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.printError(msg + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.printError(msg + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.printError(msg + LSEP);
                return false;
            }
        }
        return retval;
    }

    private boolean collectASMBestPractice(Target target, ParamPreReqUSMConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block12: {
            retval = true;
            try {
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("0229", false));
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3138", false));
                    break block12;
                }
                Result asmConResult = new Result(VerificationUtil.getLocalNode());
                String connectString = CVUHelperUtil.getASMConnectDescriptor(asmConResult);
                if (connectString == null) {
                    VerificationUtil.traceAndLog("failed to get ASM connection information");
                    String errorMessage = s_prvgMsgBundle.getMessage("12948", true);
                    errorMessage = errorMessage + LSEP + asmConResult.getErrorInfoString() + LSEP;
                    this.printError(errorMessage);
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errorMessage));
                    return false;
                }
                ASMConnectInfo.setASMConnectInfo(new ASMConnectInfo(connectString));
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(VerificationType.COMPONENT_ASM_INTEGRITY, taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.printError(msg + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.printError(msg + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.printError(msg + LSEP);
                return false;
            }
        }
        return retval;
    }

    private boolean collectOSMandatoryChecks(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block16: {
            retval = true;
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0254", false);
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (VerificationUtil.isCRSConfigured() || VerificationUtil.isHAConfigured()) {
                    for (Task taskItem : taskList) {
                        String taskName = taskItem.getClass().getName();
                        if (!taskName.contains("TaskNodeConnectivity")) continue;
                        Trace.out((String)"Removing 'TaskNodeConnectivity' from task list.");
                        taskList.remove(taskItem);
                        break;
                    }
                }
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3135", false, (Object[])new String[]{version}));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
                    break block16;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
        }
        return retval;
    }

    private boolean collectOSCollections(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block14: {
            retval = true;
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0259", false);
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3145", false, (Object[])new String[]{version}));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
                    break block14;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
        }
        return retval;
    }

    private boolean collectOSBestPractice(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval;
        block14: {
            retval = true;
            try {
                String contextMsg = s_prvgMsgBundle.getMessage("0251", false);
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(contextMsg);
                ReportUtil.quietblankln();
                List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
                if (taskList.size() <= 0) {
                    ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3136", false, (Object[])new String[]{version}));
                    xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
                    break block14;
                }
                try {
                    HashMap<CollectionGroup, List<Task>> collectFromTasks = this.collectFromTasks(target.getTargetType(), taskList);
                    for (CollectionGroup cg : collectFromTasks.keySet()) {
                        xmlReportTool.addTarget(cg, (Collection<Task>)collectFromTasks.get((Object)cg), null, null, null);
                    }
                }
                catch (SubtasksUnavailableException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            catch (TaskFactoryException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (VerificationException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (TransformerException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            catch (XmlReportToolException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String msg = e.getMessage();
                if (VerificationUtil.isStringGood(msg)) {
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                    this.printError(msg + LSEP);
                }
                this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
        }
        return retval;
    }

    private void reportFailure(String message) {
        this.printError(message);
    }

    private void testCreds(String dbName, String dbUser, String dbPwd) throws DBConnectionException {
        OracleConnection oracleConnection = SQLFactory.getDBConnection((String)dbName, (String)dbUser, (String)dbPwd);
        try {
            oracleConnection.close();
        }
        catch (SQLException sqlEx) {
            Trace.out((String)("SQLException while closing the connection. Mesg:" + sqlEx.getMessage()));
        }
    }

    private void printError(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + message);
    }

    private void printWarning(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP + message);
    }

    @Override
    public String getComponentName() {
        return "BASELINE";
    }

    @Override
    public String getComponentDisplayName() {
        return "Baseline";
    }
}

