/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.ArchitectureConstraint;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.ConstraintDataSegment;
import oracle.ops.verification.framework.config.DaemonAliveConstraint;
import oracle.ops.verification.framework.config.GroupConstraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.KernelParamConstraint;
import oracle.ops.verification.framework.config.KernelVersionConstraint;
import oracle.ops.verification.framework.config.OsPatchConstraint;
import oracle.ops.verification.framework.config.OsVerConstraint;
import oracle.ops.verification.framework.config.PackageConstraint;
import oracle.ops.verification.framework.config.RegKeyConstraint;
import oracle.ops.verification.framework.config.SpaceConstraint;
import oracle.ops.verification.framework.config.SwapConstraint;
import oracle.ops.verification.framework.config.TotalMemConstraint;
import oracle.ops.verification.framework.config.UserConstraint;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConstraintLoader {
    static final String TAG_ROOTCONSTRAINT = "RootConstraint";
    static final String TAG_BRANCHCONSTRAINT = "BranchConstraint";
    static final String TAG_CONSTRAINT = "Constraint";
    static final String TAG_TYPE = "Type";
    static final String TAG_QUALIFIER = "Qualifier";
    static final String TAG_FBACTION = "FallbackAction";
    static final String TAG_KEYDATA = "KeyData";
    static final String TAG_REFDATA = "RefData";
    static final String TAG_CONDITION = "Condition";
    static final String CHAR_INDIRECTION = "$";
    static final String USER_ORACLE = "CV_USER_ORACLE";
    static final String GROUP_ORAINV = "CV_GROUP_ORAINV";
    static final String GROUP_OSDBA = "CV_GROUP_OSDBA";
    static final String TMP_LOC = "CV_TMP";
    static final String VAR_TMP = "TMP";
    static final String VAR_TEMP = "TEMP";
    private static String m_conDataFile = VDMUtil.getConstraintDataFilename();
    private static ParamManager m_paramMgr = null;

    ConstraintLoader() {
    }

    ConstraintLoader(String filename) {
        m_conDataFile = filename;
    }

    static final ConstraintDataSegment createSegment() throws InvalidConstraintDataException {
        ConstraintDataSegment cds = new ConstraintDataSegment("constraint_data");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            String confDataURI = m_conDataFile;
            if (!VerificationUtil.isAbsoluteURI(confDataURI)) {
                confDataURI = new File(confDataURI).toURI().toString();
            }
            Document doc = parser.parse(confDataURI);
            Trace.out((String)("Parser validation set to: " + parser.isValidating()));
            Trace.out((String)(m_conDataFile + " is well-formed"));
            Element relm = doc.getDocumentElement();
            String rootElm = relm.getTagName();
            if (!rootElm.equalsIgnoreCase(TAG_ROOTCONSTRAINT)) {
                Trace.out((String)"ERROR: Invalid root element");
                throw new InvalidConstraintDataException("Invalid root element '" + rootElm + "'");
            }
            NodeList branches = relm.getElementsByTagName(TAG_BRANCHCONSTRAINT);
            for (int k = 0; k < branches.getLength(); ++k) {
                Element branch = (Element)branches.item(k);
                String brnName = branch.getAttribute("Name");
                Trace.out((String)("Branch Name: " + brnName + "[index=" + k + "]"));
                NodeList constraints = branch.getElementsByTagName(TAG_CONSTRAINT);
                Trace.out((String)("This branch has " + constraints.getLength() + " Constraints"));
                Vector<Constraint> conVec = new Vector<Constraint>();
                for (int i = 0; i < constraints.getLength(); ++i) {
                    Hashtable ht = ConstraintLoader.readConstraint((Element)constraints.item(i));
                    if (ht == null) continue;
                    Constraint aCon = ConstraintLoader.createConstraint(ht);
                    conVec.add(aCon);
                    Trace.out((String)("==== Constraint added: " + aCon));
                }
                cds.addBranch(brnName, conVec);
            }
        }
        catch (SAXException e) {
            String errtxt = "'" + m_conDataFile + " is not well-formed. ";
            throw new InvalidConstraintDataException(errtxt + e.getMessage());
        }
        catch (IOException e) {
            throw new InvalidConstraintDataException(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new InvalidConstraintDataException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new InvalidConstraintDataException(e.getMessage());
        }
        return cds;
    }

    private static Constraint createConstraint(Hashtable ht) throws InvalidConstraintDataException {
        Constraint con = null;
        String con_type = (String)ht.get(TAG_TYPE);
        Trace.out((String)("==== Type of Constraint: " + con_type));
        if (con_type.equals("SPACE")) {
            con = new SpaceConstraint(ht);
        } else if (con_type.equals("TOTALMEM")) {
            con = new TotalMemConstraint(ht);
        } else if (con_type.equals("SWAP")) {
            con = new SwapConstraint(ht);
        } else if (con_type.equals("ARCHITECTURE")) {
            con = new ArchitectureConstraint(ht);
        } else if (con_type.equals("OSVER")) {
            con = new OsVerConstraint(ht);
        } else if (con_type.equals("OSPATCH")) {
            con = new OsPatchConstraint(ht);
        } else if (con_type.equals("PACKAGE")) {
            con = new PackageConstraint(ht);
        } else if (con_type.equals("KRNPARAM")) {
            con = new KernelParamConstraint(ht);
        } else if (con_type.equals("ALIVE")) {
            con = new DaemonAliveConstraint(ht);
        } else if (con_type.equals("USER")) {
            con = new UserConstraint(ht);
        } else if (con_type.equals("GROUP")) {
            con = new GroupConstraint(ht);
        } else if (con_type.equals("REGENTRY")) {
            con = new RegKeyConstraint(ht);
        } else if (con_type.equals("KRNVER")) {
            con = new KernelVersionConstraint(ht);
        } else {
            throw new InvalidConstraintDataException("Unknown Constraint type.");
        }
        return con;
    }

    private static Hashtable readConstraint(Element con) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        String type = con.getAttribute(TAG_TYPE);
        ht.put(TAG_TYPE, type);
        String fbaction = con.getAttribute(TAG_FBACTION);
        ht.put(TAG_FBACTION, fbaction);
        String qualifier = con.getAttribute(TAG_QUALIFIER);
        ht.put(TAG_QUALIFIER, qualifier);
        String condition = con.getAttribute(TAG_CONDITION);
        if (VerificationUtil.isStringGood(condition)) {
            Trace.out((String)("Value of 'cond' for constraint type '" + type + "' = '" + condition + "'"));
        }
        if (VerificationUtil.isStringGood(condition) && !Boolean.valueOf(CVUVariables.getValue(condition)).booleanValue()) {
            return null;
        }
        NodeList kdlist = con.getElementsByTagName(TAG_KEYDATA);
        int kdnum = kdlist.getLength();
        if (kdnum > 0) {
            Node kdnode = kdlist.item(0);
            NodeList kdnlist = kdnode.getChildNodes();
            for (int j = 0; j < kdnlist.getLength(); ++j) {
                if (3 != kdnlist.item(j).getNodeType()) continue;
                String keydata = kdnlist.item(j).getNodeValue();
                if (keydata.startsWith(CHAR_INDIRECTION)) {
                    keydata = ConstraintLoader.getDynamicData(keydata.substring(CHAR_INDIRECTION.length()));
                }
                if (keydata != null && keydata.trim().length() > 0) {
                    ht.put(TAG_KEYDATA, keydata);
                    break;
                }
                Trace.out((String)"==== Constraint skipped due to null keydata");
                return null;
            }
        }
        NodeList rdlist = con.getElementsByTagName(TAG_REFDATA);
        int rdnum = rdlist.getLength();
        Vector<String> rdVec = new Vector<String>(rdnum);
        for (int k = 0; k < rdnum; ++k) {
            Node rdnode = rdlist.item(k);
            NodeList rdnlist = rdnode.getChildNodes();
            for (int j = 0; j < rdnlist.getLength(); ++j) {
                if (3 != rdnlist.item(j).getNodeType()) continue;
                String refdata = rdnlist.item(j).getNodeValue();
                rdVec.add(refdata);
            }
        }
        if (!rdVec.isEmpty()) {
            ht.put(TAG_REFDATA, rdVec);
        }
        return ht;
    }

    private static String getDynamicData(String var) {
        Trace.out((String)("==== Seeking redirection for " + var));
        if (m_paramMgr == null) {
            try {
                m_paramMgr = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                e.printStackTrace();
            }
        }
        if (var.equals(USER_ORACLE)) {
            String orauser = CVUVariables.getValue(USER_ORACLE);
            Trace.out((String)("==== ParamManager reports '" + orauser + "' as orauser"));
            if (orauser == null || orauser.trim().length() <= 0) {
                orauser = VerificationUtil.getDefaultOracleUser();
                Trace.out((String)("==== Using default oracle user '" + orauser + "'"));
            }
            return orauser;
        }
        if (var.equals(GROUP_OSDBA)) {
            String dbagroup = CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
            Trace.out((String)("==== ParamManager reports '" + dbagroup + "' as osdba"));
            if (dbagroup == null || dbagroup.trim().length() <= 0) {
                dbagroup = VerificationUtil.getDefaultDbaGroup();
                Trace.out((String)("==== Using default DBA group '" + dbagroup + "'"));
            }
            return dbagroup;
        }
        if (var.equals(GROUP_ORAINV)) {
            String invgroup = CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
            Trace.out((String)("==== ParamManager reports '" + invgroup + "' as orainv"));
            if (invgroup == null || invgroup.trim().length() <= 0) {
                Result result = new Result(VerificationUtil.getLocalNode());
                invgroup = VerificationUtil.getDefaultOraInvGroup(result);
                if (invgroup == null) {
                    Trace.out((int)5, (String)"%s", (Object[])new Object[]{result.traceResultInfo()});
                }
                Trace.out((String)("==== Using default ORAINV group '" + invgroup + "'"));
            }
            return invgroup;
        }
        if (var.equals(TMP_LOC)) {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String tmploc = null;
            tmploc = VerificationUtil.getEnv(VAR_TMP);
            if (tmploc != null) {
                int devIndex;
                Trace.out((String)("==== Found variable: TMP=" + tmploc));
                if (!nativeSystem.isUnixSystem() && (devIndex = tmploc.indexOf("\\")) != -1 && devIndex + 1 != tmploc.length()) {
                    String newtmploc;
                    tmploc = newtmploc = tmploc.substring(0, devIndex + 1);
                    Trace.out((String)("==== Edited: TMP=" + tmploc));
                }
                return tmploc;
            }
            tmploc = VerificationUtil.getEnv(VAR_TEMP);
            if (tmploc != null) {
                int devIndex;
                Trace.out((String)("==== Found variable: TEMP=" + tmploc));
                if (!nativeSystem.isUnixSystem() && (devIndex = tmploc.indexOf("\\")) != -1 && devIndex + 1 != tmploc.length()) {
                    String newtmploc;
                    tmploc = newtmploc = tmploc.substring(0, devIndex + 1);
                    Trace.out((String)("==== Edited: TEMP=" + tmploc));
                }
                return tmploc;
            }
            tmploc = VDMUtil.getDefaultTmpDir();
            Trace.out((String)("==== Default temp variable=" + tmploc));
            return tmploc;
        }
        String varval = VerificationUtil.getEnv(var);
        Trace.out((String)("==== Environment variable is " + var + "=" + varval));
        return varval;
    }
}

