/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetUniqueIDCommand
extends VerificationCommand {
    private static String m_arg1 = "-getuniqueID";
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private int m_numberOfIDs;
    private int m_idStartingFrom;
    private String m_node;
    private IDType m_type;

    public GetUniqueIDCommand(String nodeName, int idStartingFrom, int numberOfIDs, IDType type) {
        super(nodeName, null, null);
        this.m_node = nodeName;
        this.m_type = type;
        this.m_numberOfIDs = numberOfIDs;
        this.m_idStartingFrom = idStartingFrom;
        String[] args = new String[]{m_arg1, type.toString(), Integer.toString(this.m_idStartingFrom), Integer.toString(this.m_numberOfIDs)};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("GetUniqueIDCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetUniqueIDCommand...";
            if (Trace.isLevelEnabled((int)15)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("GetUniqueIDCommand failed");
            result.setStatus(2);
            return false;
        }
        if (this.commandResult.getStatus() && this.commandResult.getResultString() != null) {
            String[] resultString = this.getCommandResult().getResultString();
            String availableIDList = "";
            String output = VerificationUtil.strArr2String(resultString);
            availableIDList = VerificationUtil.fetchVerificationValue(output);
            result.addResultInfo(availableIDList);
            result.setStatus(1);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"GetUniqueIDCommand: Exit with success");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)15)) {
            Trace.out((String)("ERROR:GetUniqueIDCommand:: " + this.commandResult.getResultString()));
        }
        result.addErrorInfo("ERROR:GetUniqueIDCommand:: " + this.commandResult.getResultString());
        result.addTraceInfo("ERROR:GetUniqueIDCommand:: " + this.commandResult.getResultString());
        result.setStatus(2);
        String errorString = "";
        if (null != this.commandResult.getResultString()) {
            errorString = VerificationUtil.strArr2String(this.commandResult.getResultString(), LSEP);
        }
        Trace.out((String)errorString);
        VerificationLogData.logError(errorString);
        String errMsg = this.m_type == IDType.UID ? s_gMsgBundle.getMessage("9042", true, (Object[])new String[]{this.m_node}) : s_gMsgBundle.getMessage("9043", true, (Object[])new String[]{this.m_node});
        result.addErrorDescription(new ErrorDescription(errMsg));
        return false;
    }

    public static enum IDType {
        GID,
        UID;

    }
}

