/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetSysParamCommand
extends VerificationCommand {
    private static String m_arg1 = "-getsysparam";
    private String m_param;

    public GetSysParamCommand(String nodeName, String param) {
        super(nodeName, null, null);
        this.m_param = param;
        String[] args = new String[]{m_arg1, this.m_param};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetSysParamCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for sys param " + this.m_param;
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking sys param failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifySysParam(reoutput, this.m_param, result);
        return true;
    }
}

