/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;

public class CopyFileCommand
extends VerificationCommand {
    private String sourceFile;
    private String destinationFile;
    String m_location;
    private boolean m_noPreserve = false;

    public CopyFileCommand(String node, String sourceFile, String destinationFile) {
        super(node);
        this.sourceFile = sourceFile;
        this.destinationFile = destinationFile;
        this.m_noPreserve = false;
    }

    public CopyFileCommand(String node, String sourceFile, String destinationFile, boolean noPreserve) {
        super(node);
        this.sourceFile = sourceFile;
        this.destinationFile = destinationFile;
        this.m_noPreserve = noPreserve;
    }

    @Override
    public boolean execute() {
        Result result = this.getResult();
        String retval = null;
        Trace.out((String)("CopyFileCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        result.addTraceInfo("CopyFileCommand::Inside execute() " + Thread.currentThread().getName());
        try {
            retval = this.nativeSystem.copyFile("localnode", this.sourceFile, this.m_node, this.destinationFile, this.m_noPreserve);
        }
        catch (Exception e) {
            result.addTraceInfo("CopyFileCommand::execute() Exception calling native system");
            Trace.out((String)("CopyFileCommand::execute() exception calling native system: " + e.getMessage()));
            Trace.out((Exception)e);
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            result.setStatus(2);
            result.addErrorDescription(errDesc);
            return false;
        }
        CommandResult commandResult = new CommandResult(retval);
        if (commandResult == null) {
            Trace.out((String)"CopyFileCommand::execute() Command failed!");
            result.addTraceInfo("CopyFileCommand::execute() Command failed!");
            result.addErrorInfo("CopyFileCommand::execute() Command failed!");
            result.setStatus(2);
            return false;
        }
        if (commandResult.getStatus() && commandResult.getResultString() != null) {
            result.setStatus(1);
            return true;
        }
        Trace.out((String)("ERROR:CopyFileCommand:: " + commandResult.getResultString()));
        result.addErrorInfo("ERROR:CopyFileCommand:: " + commandResult.getResultString());
        result.addTraceInfo("ERROR:CopyFileCommand:: " + commandResult.getResultString());
        result.setStatus(2);
        return false;
    }
}

