/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckSwapSpaceCommand
extends VerificationCommand {
    private static String m_arg1 = "-getswapspace";
    private StorageSize m_space;

    public CheckSwapSpaceCommand(String nodeName, long space) {
        this(nodeName, new StorageSize((double)space, StorageUnit.BYTE));
    }

    public CheckSwapSpaceCommand(String nodeName, StorageSize space) {
        super(nodeName, null, null);
        this.m_space = space;
        String[] args = new String[]{m_arg1};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckSwapSpaceCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for swap space availability";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking swap space failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifySwapSpace(reoutput, this.m_space, result);
        return true;
    }
}

