/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckSameTimeZoneCommand
extends VerificationCommand {
    private static String m_arg = "-gettimezone";

    public CheckSameTimeZoneCommand(String nodeName) {
        super(nodeName, null, null);
        String[] args = new String[]{m_arg, "-pre"};
        super.setArgs(args);
    }

    public CheckSameTimeZoneCommand(String nodeName, String cfgFilePath) {
        super(nodeName, null, null);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String[] args = nativeSystem.isUnixSystem() ? new String[]{m_arg, "-post", cfgFilePath} : new String[]{m_arg, "-post"};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckSameTimeZoneCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckSameTimeZoneCommand..\nExectask result failed";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("***** Check for same time zone failed");
            result.setStatus(2);
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        return analyzer.verifyTimeZone(reoutput, result);
    }
}

