/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckOSPatchCommand
extends VerificationCommand {
    private static String m_arg1 = "-chkospatch";
    private String m_patch;

    public CheckOSPatchCommand(String nodeName, String patch) {
        super(nodeName, null, null);
        this.m_patch = patch;
        String[] args = new String[]{m_arg1, VerificationUtil.isPlatformAix() && VerificationUtil.isStringGood(patch) ? VerificationUtil.stringToAsciiValueStr(patch.trim()) : this.m_patch};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckOSPatchCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for OS patch " + this.m_patch;
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking OS patch failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyOSPatch(reoutput, this.m_patch, result);
        return true;
    }
}

