/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckDaemonAliveCommand
extends VerificationCommand {
    private static String m_arg1 = "-chkalive";
    private String m_dmnname;

    public CheckDaemonAliveCommand(String nodeName, String dmnname) {
        super(nodeName, null, null);
        this.m_dmnname = dmnname;
        String[] args = new String[]{m_arg1, dmnname};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckDaemonAliveCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckDaemonAliveCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckDaemonAlive failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2List(resultString, System.getProperty("line.separator"));
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyProcessAlive(reoutput, this.m_dmnname, result);
        return true;
    }
}

