/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.CDMMemoryConstraints;
import oracle.cluster.verification.constraints.CDMProcessChecks;
import oracle.cluster.verification.constraints.CDMShellLimitChecks;
import oracle.cluster.verification.constraints.CDMSpaceConstraints;
import oracle.cluster.verification.constraints.CDMUserGroups;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.RangeOfValue;

public class CDMSystem {
    private Vector<HashMap> m_pcLimits;
    private HashMap m_rlCheck;
    private Vector<CDMMemoryConstraints> m_cdmMemoryConstraints = new Vector();
    private Vector<CDMSpaceConstraints> m_cdmSpaceConstraints;
    private Vector<CDMUserGroups> m_cdmUserGroups;
    private Vector<CDMShellLimitChecks> m_cdmShellLimitChecks;
    private Vector<CDMProcessChecks> m_cdmProcessChecks = new Vector();
    private List<HashMap<String, String>> m_sourceHomePatches;
    private List<HashMap<String, String>> m_destinationHomePatches;
    private List<HashMap<String, Object>> m_RACHomePatches;
    private HashMap m_upgradeSuitabilityHash;

    public CDMSystem() {
        this.m_cdmSpaceConstraints = new Vector();
        this.m_cdmUserGroups = new Vector();
        this.m_cdmShellLimitChecks = new Vector();
        this.m_sourceHomePatches = new ArrayList<HashMap<String, String>>();
        this.m_destinationHomePatches = new ArrayList<HashMap<String, String>>();
        this.m_RACHomePatches = new ArrayList<HashMap<String, Object>>();
        this.m_upgradeSuitabilityHash = new HashMap();
    }

    public void addProcessChecks(String processName, String processExists, String conditionVar, String choiceVar, String selection) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("conditionVar = " + conditionVar + ", processName = " + processName + ", processExists = " + processExists));
        }
        if (this.m_pcLimits == null) {
            this.m_pcLimits = new Vector();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, processName);
        p.put(CDMConstraintTypes.EXISTS, processExists);
        p.put(CDMConstraintTypes.CONDITION, conditionVar);
        p.put(CDMConstraintTypes.CHOICE, choiceVar);
        p.put(CDMConstraintTypes.SELECTION, selection);
        this.m_pcLimits.add(p);
    }

    public void addRunLevelCheck(List<Integer> runLevels, String severity) {
        if (this.m_rlCheck == null) {
            this.m_rlCheck = new HashMap();
        }
        this.m_rlCheck.put(CDMConstraintTypes.VALUE, runLevels);
        this.m_rlCheck.put(CDMConstraintTypes.SEVERITY, severity);
    }

    public Vector<HashMap> getProcessChecksLimits() {
        return this.m_pcLimits;
    }

    public HashMap getRunLevelCheck() {
        return this.m_rlCheck;
    }

    public void addCDMMemoryConstraints(CDMMemoryConstraints cdmMemoryConstraint) {
        this.m_cdmMemoryConstraints.add(cdmMemoryConstraint);
    }

    public Vector<CDMMemoryConstraints> getCDMMemoryConstraints() {
        return this.m_cdmMemoryConstraints;
    }

    public void addCDMSpaceConstraints(CDMSpaceConstraints cdmSpaceConstraint) {
        this.m_cdmSpaceConstraints.add(cdmSpaceConstraint);
    }

    public Vector<CDMSpaceConstraints> getCDMSpaceConstraints() {
        return this.m_cdmSpaceConstraints;
    }

    public void addCDMUserGroups(CDMUserGroups cdmUserGroup) {
        this.m_cdmUserGroups.add(cdmUserGroup);
    }

    public Vector<CDMUserGroups> getCDMUserGroups() {
        return this.m_cdmUserGroups;
    }

    public void addCDMShellLimitChecks(CDMShellLimitChecks cdmShellLimitCheck) {
        this.m_cdmShellLimitChecks.add(cdmShellLimitCheck);
    }

    public Vector<CDMShellLimitChecks> getCDMShellLimitChecks() {
        return this.m_cdmShellLimitChecks;
    }

    public void addCDMProcessChecks(CDMProcessChecks cdmProcessCheck) {
        this.m_cdmProcessChecks.add(cdmProcessCheck);
    }

    public Vector<CDMProcessChecks> getCDMProcessChecks() {
        return this.m_cdmProcessChecks;
    }

    public List<HashMap<String, String>> getSourceHomePatches() {
        return this.m_sourceHomePatches;
    }

    public void addSourceHomePatch(String home, String val, String severity) {
        Trace.out((String)("value = " + val + ", severity = " + severity));
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.HOME, home);
        p.put(CDMConstraintTypes.VALUE, val);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_sourceHomePatches.add(p);
    }

    public void addSourceHomePatch(String home, boolean dummy) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.HOME, home);
        this.m_sourceHomePatches.add(p);
    }

    public List<HashMap<String, String>> getDestinationHomePatches() {
        return this.m_destinationHomePatches;
    }

    public List<HashMap<String, Object>> getRACHomePatches() {
        return this.m_RACHomePatches;
    }

    public void addRACHomePatch(String home, Vector nodes, String val, String severity) {
        Trace.out((String)("value = " + val + ", severity = " + severity));
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put(CDMConstraintTypes.HOME, home);
        p.put(CDMConstraintTypes.NODELIST, nodes);
        p.put(CDMConstraintTypes.VALUE, val);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_RACHomePatches.add(p);
    }

    public void addDestinationHomePatch(String home, boolean dummy) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.HOME, home);
        this.m_destinationHomePatches.add(p);
    }

    public void addDestinationHomePatch(String home, String val, String severity) {
        Trace.out((String)("value = " + val + ", severity = " + severity));
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.HOME, home);
        p.put(CDMConstraintTypes.VALUE, val);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_destinationHomePatches.add(p);
    }

    public void addUpgradeSuitabilityHash(RangeOfValue r, String severity) {
        ArrayList<RangeOfValue> rangeList = (ArrayList<RangeOfValue>)this.m_upgradeSuitabilityHash.get(CDMConstraintTypes.RANGE);
        if (rangeList == null) {
            rangeList = new ArrayList<RangeOfValue>();
            this.m_upgradeSuitabilityHash.put(CDMConstraintTypes.RANGE, rangeList);
        }
        rangeList.add(r);
        this.m_upgradeSuitabilityHash.put(CDMConstraintTypes.SEVERITY, severity);
    }

    public HashMap getUpgradeSuitabilityHash() {
        return this.m_upgradeSuitabilityHash;
    }
}

