/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper12101;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.ASMMode;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.ConnectionInfo;
import oracle.cluster.asm.IOServer;
import oracle.cluster.common.NodeRole;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.InstanceException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gns.GNSQueryTypes;
import oracle.cluster.gns.GNSUtils;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.install.InstallException;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.GNSClusterTypes;
import oracle.gridnamingservice.GridNamingService;
import oracle.gridnamingservice.GridNamingServiceException;
import oracle.gridnamingservice.QueryTypes;
import oracle.jdbc.driver.OracleConnection;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OneOffEntry;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.helper.helper12101.CVUHelper;

public class CVUHelper12101
extends CVUHelper {
    public CVUHelper12101() {
        this.addCommandLineOption("-getSupportedMethods", 2, "getSupportedMethods", "displays supported args");
        this.addCommandLineOption("-getNetworkInfo", 2, "getNetworkInfo", "Get subnet, interface and classification for given network");
        this.addCommandLineOption("-vipExists", 2, "isVIPExists", "checks that there is at least one VIP configured on the cluster");
        this.addCommandLineOption("-getscan", 1, "getScanDetails", "Gets scan name and IP's");
        this.addCommandLineOption("-getScanInfo", 1, "getScanInfo", "Gets scan name, IP's and multiple scan ports");
        this.addCommandLineOption("-getcrsresown", 1, "getCRSResOwners", "Gets owners of CRS resources");
        this.addCommandLineOption("-isValidOCRStorage", 2, "isValidOCRStorage", "check if given location is valid ocr storage");
        this.addCommandLineOption("-getCRSUser", 1, "getCRSUser", "gets the clusterware home user name");
        this.addCommandLineOption("-getGNSDomainAndVip", 1, "getGNSDomainAndVIP", "gets the gns domain name and vip if any");
        this.addCommandLineOption("-getGNSResourceStatus", 2, "getGNSResourceStatus", "gets the gns and GNSVIP resource status on all nodes");
        this.addCommandLineOption("-getScanName", 1, "getScanName", "gets the SCAN name");
        this.addCommandLineOption("-checkASMRunning", 2, "checkASMRunning", "check if ASM is running on nodes");
        this.addCommandLineOption("-getIOServerNodes", 1, "getIOServerNodes", "get nodes IOServers are running");
        this.addCommandLineOption("-getDiskGroupCount", 1, "getDiskGroupCount", "get number of diskgroups from crs");
        this.addCommandLineOption("-getOPatchStatus", 3, "getOPatchStatus", "return status (installed/missing) for a given oracle patch for the give oracle home");
        this.addCommandLineOption("-getOraclePatchList", 2, "getOraclePatchList", "return list of all the patches installed on the given oracle home");
        this.addCommandLineOption("-getCSSMode", 1, "getCSSMode", "return CSS mode");
        this.addCommandLineOption("-getASMResourceAttribute", 2, "getASMResourceAttribute", "return ASM resource attribute value");
        this.addCommandLineOption("-getNodeRole", 3, "getNodeRole", "returns either configured or active node role");
        this.addCommandLineOption("-getNodeNames", 2, "getNodeNames", "Gets list of cluster node names of specified role");
        this.addCommandLineOption("-validateGNSCredential", 2, "validateGNSCredential", "It validates the data client file and returns domain name");
        this.addCommandLineOption("-checkDynamicNetwork", 1, "checkDynamicNetwork", "It returns true if there is dynamic network otherwise false");
        this.addCommandLineOption("-getPolicyDBInfo", 1, "getPolicyDBInfo", "get the policy managed database information such as database name and oracle home");
        this.addCommandLineOption("-getOCRLocations", 1, "getOCRLocations", "reads the ocr locations by calling to procr_getconfig");
        this.addCommandLineOption("-getDBServiceCount", 1, "getDBServiceCount", "get the total number of DB service resources configured");
        this.addCommandLineOption("-getDbNodes", 2, "getDbNodes", "Gets list of cluster nodes for a specified unique database");
        this.addCommandLineOption("-isValidGNSVIP", 3, "isValidGNSVIP", "Check if GNS VIP is valid for more than one IP");
        this.addCommandLineOption("-getDatabaseInfos", 1, "getDatabaseInfos", "Gets database unique names, oracle homes, and versions of all configured databases  on the cluster");
        this.addCommandLineOption("-runASMQuery", 4, "runASMQuery", "Runs the specified SQL query and return the output");
        this.addCommandLineOption("-getASMConnectionInfo", 3, "getASMConnectionInfo", "Gets ASM connection information");
        this.addCommandLineOption("-getASMPWFile", 1, "getASMPWFile", "Gets ASM password file location");
    }

    public int getSupportedMethods(String[] args) {
        this.displayUsage(false);
        this.displayVRESStatus(0);
        return 0;
    }

    public int getNetworkInfo(String[] args) {
        int status = 0;
        try {
            int networkNumber = Integer.parseInt(args[1]);
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            Trace.out((String)"got nodeapps factor");
            Network nw = naf.getNetwork(networkNumber);
            Subnet subnet = nw.subnet();
            Trace.out((String)"got subnet");
            String subnetTypeStr = "PVT";
            if (networkNumber == 1) {
                subnetTypeStr = "PUB";
            }
            List ifsList = nw.networkAdapters();
            StringBuilder ifStr = new StringBuilder();
            if (ifsList == null || ifsList.size() == 0) {
                Trace.out((String)"iflist is empty");
                ifStr.append("");
            } else {
                Iterator iter = ifsList.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    NetworkAdapter na = (NetworkAdapter)iter.next();
                    ifStr.append(na.getAdapterName());
                    if (i < ifsList.size() - 1) {
                        ifStr.append(":");
                    }
                    ++i;
                }
                Trace.out((String)"creating non-empty iflist");
            }
            this.displaySuccessResult("<NET_INTERFACE>" + ifStr.toString() + "</NET_INTERFACE>" + "<NET_SUBDOMAIN>" + subnet.getName() + "</NET_SUBDOMAIN>" + "<NET_CLASS>" + subnetTypeStr + "</NET_CLASS>");
            this.displayVRESStatus(0);
        }
        catch (NotExistsException e) {
            Trace.out((String)"network resource does not exist");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        catch (NumberFormatException e) {
            this.displayErrorResult("invalid network number", 2);
            status = 0;
        }
        catch (NetworkException e) {
            Trace.out((String)"network resource error");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)"out of space");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        return status;
    }

    public int isVIPExists(String[] args) {
        String nodeName = args[1];
        int status = 0;
        Trace.out((int)2, (String)"Entry");
        try {
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            List viplist = naf.getVIPs(nodeName, null);
            if (viplist.size() == 0) {
                this.displayWarningResult("no vips", 1);
            } else {
                this.displaySuccessResult("vip's found", 0);
                status = 0;
            }
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("software module exception" + e.getMessage()));
            this.displayErrorResult("error checking", 2);
        }
        Trace.out((int)2, (String)"Exit");
        return status;
    }

    public int getScanName(String[] args) {
        Trace.out((int)2, (String)"Entry");
        try {
            ScanFactory sf = ScanFactory.getInstance();
            Scan scan = sf.getScan();
            this.displaySuccessResult("<SCN_NME>" + scan.getScanName() + "</SCN_NME>", 0);
            return 0;
        }
        catch (ScanException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getDiskGroupCount(String[] args) {
        Trace.out((int)2, (String)"Entry");
        List ldg = null;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            ldg = asmfact.getDiskGroups();
        }
        catch (ASMException e) {
            Trace.out((String)("ASMException occurred when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out((String)("NotExistsException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("SoftwareModuleException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        Trace.out((int)2, (String)"Exit");
        this.displaySuccessResult("<ASMDG_COUNT>" + ldg.size() + "</ASMDG_COUNT>", 0);
        return 0;
    }

    public int getIOServerNodes(String[] args) {
        int ioserverCount = 0;
        StringBuilder runNodesSB = new StringBuilder();
        Trace.out((String)"Entry");
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            IOServer ios = asmfact.getIOServer();
            ioserverCount = ios.getCount();
            Trace.out((String)("IOServer count " + ioserverCount));
            CRSResource crsRes = ios.crsResource();
            List runNodes = crsRes.fetchRunningNodes();
            if (runNodes != null) {
                for (Node node : runNodes) {
                    runNodesSB.append(node.getName());
                    runNodesSB.append(",");
                }
                runNodesSB.deleteCharAt(runNodesSB.length() - 1);
                Trace.out((String)("IOServers running on nodes" + runNodesSB.toString()));
            }
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (CRSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NodeException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        Trace.out((int)2, (String)"Exit");
        this.displaySuccessResult("<IOS_COUNT>" + ioserverCount + "</IOS_COUNT>" + "<IOS_NODES>" + runNodesSB.toString() + "</IOS_NODES>", 0);
        return 0;
    }

    public int checkASMRunning(String[] args) {
        String[] nodeArray = args[1].split(",");
        boolean failNodes = false;
        boolean succNodes = false;
        ASMFactory asmfact = null;
        ASM asm = null;
        ClusterASM clustASM = null;
        try {
            asmfact = ASMFactory.getInstance();
            try {
                asm = asmfact.getASM();
            }
            catch (NotExistsException e) {
                clustASM = asmfact.getClusterASM();
            }
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        for (String nodename : nodeArray) {
            try {
                Node node = ServerFactory.getInstance().getNode(nodename);
                if (asm != null) {
                    if (asm.isRunning(node)) {
                        Trace.out((int)5, (String)("ASM is running on node " + nodename));
                        succNodes = true;
                        this.displaySuccessResult("<ASM_SUCC_NODE>" + nodename + "</ASM_SUCC_NODE>");
                        continue;
                    }
                    Trace.out((int)5, (String)("ASM is NOT running on node " + nodename));
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                    continue;
                }
                if (clustASM == null) continue;
                if (clustASM.isRunning(node)) {
                    Trace.out((int)5, (String)("ASM is running on node " + nodename));
                    succNodes = true;
                    this.displaySuccessResult("<ASM_SUCC_NODE>" + nodename + "</ASM_SUCC_NODE>");
                    continue;
                }
                Trace.out((int)5, (String)("ASM is NOT running on node " + nodename));
                failNodes = true;
                this.displayWarningResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
            }
            catch (ServerException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + e.getMessage()));
            }
            catch (NodeException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + e.getMessage()));
            }
            catch (SoftwareModuleException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + e.getMessage()));
            }
        }
        if (succNodes) {
            if (failNodes) {
                this.displayVRESStatus(1);
                return 0;
            }
            this.displayVRESStatus(0);
            return 0;
        }
        this.displayVRESStatus(2);
        return 0;
    }

    public int getGNSResourceStatus(String[] args) {
        GNSFactory gnsFactory = null;
        GNS gns = null;
        GNSVIP gnsVIP = null;
        String[] nodeArray = args[1].split(",");
        try {
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            gns = gnsFactory.getGNS();
            gnsVIP = gnsFactory.getVIP();
            ServerFactory sf = ServerFactory.getInstance();
            for (String nodeName : nodeArray) {
                Trace.out((String)("checking node " + nodeName));
                Node node = sf.getNode(nodeName);
                boolean isGNSVIPEnabled = gnsVIP.isEnabled(node);
                boolean nodeGNSVIPRunningState = gnsVIP.isRunning(node);
                boolean isGNSEnabled = gns.isEnabled(node);
                boolean nodeGNSRunningState = gns.isRunning(node);
                this.displaySuccessResult("<GNS_DETAILS><GNS_NODE>" + nodeName + "</GNS_NODE>" + "<GNS_ENABLE>" + isGNSEnabled + "</GNS_ENABLE>" + "<GNS_RUN>" + nodeGNSRunningState + "</GNS_RUN>" + "<VIP_ENABLE>" + isGNSVIPEnabled + "</VIP_ENABLE>" + "<VIP_RUN>" + nodeGNSVIPRunningState + "</VIP_RUN>" + "</GNS_DETAILS>");
            }
            this.displayVRESStatus(0);
            return 0;
        }
        catch (VIPNotFoundException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GNSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (ServerException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NodeException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getGNSDomainAndVIP(String[] args) {
        String gnsDomainName = null;
        String gnsVIP = null;
        String gnsAddress = null;
        GNSFactory gnsFactory = null;
        GNS gns = null;
        try {
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            gns = gnsFactory.getGNS();
            try {
                GridNamingService.initialize((int)1);
            }
            catch (GridNamingServiceException ex) {
                this.displayExecutionError(ex.getMessage());
                Trace.out((String)ex.getMessage());
                return 0;
            }
            GNSClusterTypes gnsType = GridNamingService.getClusterType();
            Trace.out((String)("after reading GNS type " + gnsType));
            if (gnsType == GNSClusterTypes.CLIENT) {
                gnsDomainName = gnsFactory.query(GNSQueryTypes.SUBDOMAIN);
                gnsVIP = "";
                gnsAddress = "";
            } else {
                gnsDomainName = GridNamingService.query((QueryTypes[])new QueryTypes[]{QueryTypes.SUBDOMAIN}).getSubdomain();
                String addrString = gns.address().toString();
                if (addrString != null) {
                    int addrSlashIndex = addrString.indexOf("/");
                    if (addrSlashIndex == 0) {
                        gnsAddress = gnsVIP = addrString.substring(1);
                    } else {
                        gnsVIP = addrString.substring(0, addrSlashIndex);
                        gnsAddress = addrString.substring(addrSlashIndex + 1, addrString.length() - 1);
                    }
                } else {
                    gnsVIP = "";
                    gnsAddress = "";
                }
                if (gnsDomainName == null) {
                    gnsDomainName = "";
                }
            }
            this.displaySuccessResult("<GNS_DOMAIN_NAME>" + gnsDomainName + "</GNS_DOMAIN_NAME>" + "<GNS_SERVICE_DOMAIN_NAME>" + gnsDomainName + "</GNS_SERVICE_DOMAIN_NAME>" + "<GNS_VIP_NAME>" + gnsVIP + "</GNS_VIP_NAME>" + "<GNS_TYPE>" + gnsType.toString() + "</GNS_TYPE>" + "<GNS_VIP_ADDRESS>" + gnsAddress + "</GNS_VIP_ADDRESS>", 0);
            Trace.out((String)("domain=" + gnsDomainName));
            Trace.out((String)("vip=" + gnsVIP));
            Trace.out((String)("address=" + gnsAddress));
            return 0;
        }
        catch (VIPNotFoundException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GNSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GridNamingServiceException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getCRSUser(String[] args) {
        String crsHome = System.getProperty("GI_HOME");
        try {
            Util hasUtil = new Util();
            this.displaySuccessResult(hasUtil.getOracleUser(crsHome, null), 0);
            return 0;
        }
        catch (UtilException e) {
            Trace.out((String)"Couldn't get oracle user");
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int isValidOCRStorage(String[] args) {
        int isSupported = 2;
        try {
            isSupported = ClusterInfo.checkOCRStorageType((String)args[1]);
        }
        catch (ClusterInfoException ci) {
            String msg = ci.getMessage();
            Trace.out((String)("get ocr locations failed with " + msg));
            this.displayErrorResult(msg, 2);
            return 0;
        }
        switch (isSupported) {
            case 0: {
                Trace.out((String)(" OCR location " + args[1] + " is on valid Storage."));
                this.displaySuccessResult("valid", 0);
                return 0;
            }
            case 1: {
                Trace.out((String)(" OCR location " + args[1] + " is on invalid Storage."));
                this.displayErrorResult("invalid", 1);
                return 0;
            }
        }
        Trace.out((String)(" Unable to check validity of OCR location " + args[1] + " storage type."));
        this.displayErrorResult("unknown", 2);
        return 0;
    }

    public int getScanDetails(String[] args) {
        return this.getScanInfo(args, true);
    }

    public int getScanInfo(String[] args) {
        return this.getScanInfo(args, false);
    }

    private int getScanInfo(String[] args, boolean isPre122) {
        List scanList;
        ScanFactory sf;
        Object m_localName = null;
        MessageBundle s_msgBundle = MessageBundle.getMessageBundle((String)"Prvf");
        String errMsg = s_msgBundle.getMessage("5054", true);
        Object warnMsg = null;
        Object cause = null;
        Object action = null;
        String scanName = null;
        String scanUserAssignedName = null;
        String lsnrName = null;
        String runNode = null;
        Object exceptionMsg = null;
        ScanListener scanLsnr = null;
        boolean vipRun = false;
        boolean lsnrRun = false;
        int status = 0;
        ArrayList<String> scanVIPRunningNodes = new ArrayList<String>();
        Map scanAddrTypeMap = null;
        try {
            sf = ScanFactory.getInstance();
            scanList = sf.getScans();
            Trace.out((String)("Number SCANs found : " + scanList.size()));
        }
        catch (SoftwareModuleException sme) {
            errMsg = errMsg + LSEP + sme.getMessage();
            Trace.out((String)("SOFTWAREMODULEEXCEPTION: \n" + sme.getMessage()));
            this.displayErrorResult(errMsg, 2);
            return 0;
        }
        errMsg = s_msgBundle.getMessage("5059", true);
        StringBuilder sb = new StringBuilder();
        for (Scan scan : scanList) {
            boolean scanNameErr = false;
            boolean scanLsnrErr = false;
            boolean scanErr = false;
            boolean lsnrNameErr = false;
            ArrayList<String> scanNameList = new ArrayList<String>();
            sb.delete(0, sb.length());
            String exMsg = null;
            try {
                List svipList = scan.vips();
                if (svipList.size() == 0) {
                    Trace.out((String)"no scan vips configured");
                    sf.getScanVIPs();
                }
                Network net = scan.network();
                sb.append("<SCN_NME>");
                sb.append(scan.getScanName());
                sb.append("</SCN_NME>");
                sb.append("<NET_DETAILS>");
                sb.append("<NET_NUM>");
                sb.append(net.getNumber());
                sb.append("</NET_NUM>");
                Trace.out((String)("NET_NUM: " + net.getNumber() + ", dhcpServerType: " + net.dhcpServerType()));
                if (net.dhcpServerType() != null) {
                    sb.append("<DHCP_TYPE_IPV4>");
                    sb.append(net.dhcpServerType());
                    sb.append("</DHCP_TYPE_IPV4>");
                }
                Trace.out((String)("NET_NUM: " + net.getNumber() + ", dhcpServerTypeIPv6: " + net.dhcpServerTypeIPv6()));
                if (net.dhcpServerTypeIPv6() != null) {
                    sb.append("<DHCP_TYPE_IPV6>");
                    sb.append(net.dhcpServerTypeIPv6());
                    sb.append("</DHCP_TYPE_IPV6>");
                }
                Map subs = net.subnets();
                sb.append("<SUBNETS>");
                for (IPAddressUtil.IPAddrType addrType : subs.keySet()) {
                    sb.append("<SUBNET_DETAILS>");
                    sb.append("<SUBNET_TYPE>");
                    sb.append(addrType);
                    sb.append("</SUBNET_TYPE>");
                    sb.append("<SUBNET>");
                    sb.append(((Subnet)subs.get(addrType)).getName());
                    sb.append("</SUBNET>");
                    sb.append("</SUBNET_DETAILS>");
                }
                sb.append("</SUBNETS>");
                sb.append("</NET_DETAILS>");
                for (ScanVIP svip : svipList) {
                    vipRun = false;
                    lsnrRun = false;
                    runNode = "unknown";
                    scanName = svip.getScanName();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("GOT NAME: " + scanName + "\n"));
                    }
                    scanUserAssignedName = svip.getUserAssignedName();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("GOT ASSIGNED NAME: " + scanUserAssignedName + "\n"));
                    }
                    scanAddrTypeMap = svip.addresses();
                    scanLsnr = svip.listener();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT LSNR \n");
                    }
                    Scan lsnrScan = scanLsnr.scan();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT SCAN \n");
                    }
                    lsnrName = scanLsnr.getUserAssignedName();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT LSNRNAME \n");
                    }
                    vipRun = svip.isRunning();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT VIP RUN STATE \n");
                    }
                    lsnrRun = scanLsnr.isRunning();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT LSNR RUN STATE \n");
                    }
                    if (vipRun && lsnrRun) {
                        CRSResource crsRes = scanLsnr.crsResource();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)"GOT CRS RESOURCE \n");
                        }
                        List runNodes = crsRes.fetchRunningNodes();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)"GOT RUN NODES \n");
                        }
                        if (!runNodes.isEmpty() && !scanVIPRunningNodes.contains(runNode = ((Node)runNodes.get(0)).getName())) {
                            scanVIPRunningNodes.add(runNode);
                        }
                    }
                    Trace.out((String)"Getting scan ports");
                    int[] ports = scanLsnr.getEndpoints().getTCPPortArr();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT PORT \n");
                    }
                    if (scanNameList.contains(scanUserAssignedName)) continue;
                    scanNameList.add(scanUserAssignedName);
                    sb.append("<SCN_DETAILS>");
                    sb.append("<SCN_NME>");
                    sb.append(scanName);
                    sb.append("</SCN_NME>");
                    sb.append("<USR_ASGN_NAME>");
                    sb.append(scanUserAssignedName);
                    sb.append("</USR_ASGN_NAME>");
                    for (IPAddressUtil.IPAddrType addrType : scanAddrTypeMap.keySet()) {
                        sb.append("<SCN_ADDR_DETAILS>");
                        sb.append("<ADDR_TYPE>");
                        sb.append(addrType);
                        sb.append("</ADDR_TYPE>");
                        sb.append("<SCN_ADDR>");
                        sb.append(scanAddrTypeMap.get(addrType));
                        sb.append("</SCN_ADDR>");
                        sb.append("</SCN_ADDR_DETAILS>");
                    }
                    sb.append("<RUN_NODE>");
                    sb.append(runNode);
                    sb.append("</RUN_NODE>");
                    sb.append("<LSNR_NME>");
                    sb.append(lsnrName);
                    sb.append("</LSNR_NME>");
                    sb.append("<LSNR_PORT>");
                    boolean first = true;
                    for (int port : ports) {
                        if (first) {
                            sb.append(port);
                            first = false;
                            if (!isPre122) continue;
                            break;
                        }
                        sb.append(" " + port);
                    }
                    sb.append("</LSNR_PORT>");
                    sb.append("<VIP_RUN>");
                    sb.append(vipRun);
                    sb.append("</VIP_RUN>");
                    sb.append("<LSNR_RUN>");
                    sb.append(lsnrRun);
                    sb.append("</LSNR_RUN>");
                    sb.append("</SCN_DETAILS>");
                }
            }
            catch (ScanVIPException sve) {
                exMsg = sve.getMessage();
                Trace.out((String)("ScanVIPException: " + exMsg));
            }
            catch (NotExistsException nee) {
                exMsg = nee.getMessage();
                Trace.out((String)("NotExistsException: " + exMsg));
            }
            catch (ScanException se) {
                exMsg = se.getMessage();
                Trace.out((String)("ScanException: " + exMsg));
            }
            catch (CRSException crse) {
                exMsg = crse.getMessage();
                Trace.out((String)("CRSException: " + exMsg));
            }
            catch (SoftwareModuleException sme) {
                exMsg = sme.getMessage();
                Trace.out((String)("SoftwareModuleException: " + exMsg));
            }
            catch (NodeException ne) {
                exMsg = ne.getMessage();
                Trace.out((String)("NodeException: " + exMsg));
            }
            if (exMsg != null) {
                status = 1;
                this.displayErrorResult(errMsg + LSEP + exMsg);
                continue;
            }
            if (scanNameList.size() <= 0) continue;
            sb.append("<SCN_COUNT>");
            sb.append(scanNameList.size());
            sb.append("</SCN_COUNT>");
            this.displaySuccessResult(sb.toString());
        }
        this.displayVRESStatus(status);
        return status;
    }

    public int getCRSResOwners(String[] args) {
        Object m_localName = null;
        MessageBundle s_gMsgBundle = MessageBundle.getMessageBundle((String)"Prvg");
        String errMsg = s_gMsgBundle.getMessage("1112", true);
        int status = 0;
        StringBuffer returnString = new StringBuffer();
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter oraFilter = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceType.Database.NAME.name(), "ora.");
            Map resultData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, oraFilter, new String[]{ResourceType.Database.NAME.name(), ResourceLiterals.ACL_ATTR.toString()});
            for (String resName : resultData.keySet()) {
                for (String attrName : ((Map)resultData.get(resName)).keySet()) {
                    Map attrMap = (Map)resultData.get(resName);
                    if (!attrName.equals(ResourceLiterals.ACL_ATTR.toString())) continue;
                    ResourcePermissionsImpl rp = crsFactory.getPermissions(resName, (String)attrMap.get(attrName));
                    if (returnString.length() == 0) {
                        returnString.append("<CRSRESOWN>");
                    } else {
                        returnString.append(", ");
                    }
                    returnString.append(rp.getOwner());
                    Trace.out((String)("Added owner: '" + rp.getOwner() + "' for resource: '" + resName + "'"));
                    for (String user : rp.getUsers()) {
                        returnString.append(", ");
                        returnString.append(user);
                        Trace.out((String)("Added user: '" + user + "' for resource: '" + resName + "'"));
                    }
                }
            }
        }
        catch (CRSException crse) {
            Trace.out((String)("CRSException: " + crse.getMessage()));
            errMsg = errMsg + LSEP + crse.getMessage();
            this.displayErrorResult(errMsg, 2);
            return 0;
        }
        if (returnString.length() > 0) {
            returnString.append("</CRSRESOWN>");
        }
        Trace.out((String)("ReturnString: '" + returnString.toString() + "'"));
        if (returnString.length() > 0) {
            this.displaySuccessResult(returnString.toString());
        }
        this.displayVRESStatus(status);
        return status;
    }

    public int getOPatchStatus(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String oh = args[1];
        String patchId = args[2];
        int status = 0;
        ArrayList<String> oneOffEntryIds = new ArrayList<String>();
        OneOffEntry[] oneOffs = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream oldPs = System.out;
        System.setOut(ps);
        try {
            String[] requiredPatches;
            oneOffs = OPatchSDK.getAllOneOffEntry((String)oh);
            StringBuffer returnString = new StringBuffer();
            for (OneOffEntry patch : oneOffs) {
                oneOffEntryIds.add(patch.getID());
                oneOffEntryIds.addAll(Arrays.asList(patch.getBugIDsFixed()));
            }
            for (String requiredPatch : requiredPatches = patchId.split(",")) {
                String patchStatus = oneOffEntryIds.contains(requiredPatch) ? "installed" : "missing";
                returnString.append(requiredPatch + ":" + patchStatus + LSEP);
            }
            System.out.flush();
            System.setOut(oldPs);
            this.displaySuccessResult(returnString.toString());
        }
        catch (Exception e) {
            status = 1;
            String errMsg = e.getMessage();
            if (baos.toString() != null) {
                errMsg = errMsg + LSEP + baos.toString();
            }
            System.out.flush();
            System.setOut(oldPs);
            this.displayErrorResult(errMsg);
            Trace.out((String)("NODEEEXCEPTION: \n" + errMsg));
        }
        this.displayVRESStatus(status);
        return 0;
    }

    public int getOraclePatchList(String[] args) {
        Trace.out((String)"Method entry");
        String oracleHome = args[1];
        int status = 0;
        OneOffEntry[] oneOffs = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream oldPs = System.out;
        System.setOut(ps);
        try {
            oneOffs = OPatchSDK.getAllOneOffEntry((String)oracleHome);
            StringBuffer resultString = new StringBuffer();
            for (OneOffEntry patch : oneOffs) {
                resultString.append("Patch ID : " + patch.getID() + " | ");
                resultString.append("Bugs Fixed : " + Arrays.toString(patch.getBugIDsFixed()) + LSEP + LSEP);
            }
            System.out.flush();
            System.setOut(oldPs);
            this.displaySuccessResult(resultString.toString());
        }
        catch (Exception e) {
            status = 1;
            String errMsg = e.getMessage();
            if (baos.toString() != null) {
                errMsg = errMsg + LSEP + baos.toString();
            }
            System.out.flush();
            System.setOut(oldPs);
            this.displayErrorResult(errMsg);
            Trace.out((String)("NODEEEXCEPTION: \n" + errMsg));
        }
        this.displayVRESStatus(status);
        return 0;
    }

    public int getCSSMode(String[] args) {
        Trace.out((int)2, (String)"Entry");
        try {
            ClusterUtil util = new ClusterUtil();
            this.displaySuccessResult(util.getCSSMode() + "", 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getASMResourceAttribute(String[] args) {
        Trace.out((int)2, (String)"Entry");
        boolean isFoundAttribute = false;
        String attributeName = args[1];
        String value = "";
        ASM asm = null;
        ClusterASM clustASM = null;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            try {
                asm = asmfact.getASM();
            }
            catch (NotExistsException e) {
                Trace.out((String)"legacy asm instance couldn't be created");
                clustASM = asmfact.getClusterASM();
            }
            if ("ASM_INSTANCE_COUNT".equals(attributeName)) {
                clustASM = asmfact.getClusterASM();
                Trace.out((String)"getting instance count");
                value = String.valueOf(clustASM.getCount());
                isFoundAttribute = true;
            } else if ("PRESENCE".equals(attributeName)) {
                Trace.out((String)"getting presence");
                try {
                    ClusterUtil clUtil = new ClusterUtil();
                    ASMMode asmMode = clUtil.getASMMode();
                    value = ASMMode.CLIENT.equals((Object)asmMode) ? "far" : (ASMMode.REMOTE.equals((Object)asmMode) ? ResourceLiterals.REMOTE.toString() : ResourceLiterals.LEGACY.toString());
                    isFoundAttribute = true;
                }
                catch (ClusterUtilException e) {
                    this.displayErrorResult(e.getMessage(), 2);
                    return 0;
                }
            }
            if (isFoundAttribute) {
                this.displaySuccessResult(value, 0);
                return 0;
            }
            this.displayWarningResult("failed to get attribute " + attributeName, 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            if ("PRESENCE".equals(attributeName)) {
                this.displaySuccessResult("far", 0);
                return 0;
            }
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getNodeRole(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String type = args[1];
        String node = args[2];
        String value = "";
        try {
            ClusterUtil clUtil = new ClusterUtil();
            if ("ACTIVE".equalsIgnoreCase(type)) {
                value = String.valueOf(clUtil.getNodeActiveRole().getRole());
            } else if ("CONFIGURED".equalsIgnoreCase(type)) {
                value = String.valueOf(clUtil.getNodeConfiguredRole(node).getRole());
            }
            this.displaySuccessResult(value, 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getNodeNames(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String nodeRoleStr = args[1];
        NodeRole nodeRole = NodeRole.getEnumMember((int)Integer.parseInt(nodeRoleStr));
        String value = "";
        try {
            ClusterUtil clUtil = new ClusterUtil();
            value = this.strArr2List(clUtil.getNodeNames(nodeRole));
            this.displaySuccessResult(value, 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getDbNodes(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String dbUniqueName = args[1];
        ArrayList<String> dbNodes = new ArrayList<String>();
        try {
            Trace.out((String)"Trying to get node list for specific unique database name.");
            DatabaseFactory dbf = DatabaseFactory.getInstance();
            Version dbVersion = dbf.getDatabaseVersion(dbUniqueName);
            Database db = dbf.getDatabase(dbUniqueName, dbVersion);
            for (Node node : db.nodes()) {
                String nodeName = node.getName();
                if (nodeName == null || nodeName.length() <= 0) continue;
                dbNodes.add(nodeName);
            }
            this.displaySuccessResult(this.strArr2List(dbNodes.toArray(new String[0])), 0);
            return 0;
        }
        catch (NotExistsException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (DatabaseException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (InstanceException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (NodeException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
    }

    public int getDatabaseInfos(String[] args) {
        Trace.out((int)2, (String)"Entry");
        StringBuilder dbInfosSB = new StringBuilder("");
        try {
            DatabaseFactory dbf = DatabaseFactory.getInstance();
            Map databaseInfos = dbf.getDatabaseInfos();
            for (String dbUniqueName : databaseInfos.keySet()) {
                LinkedList databaseDetails = (LinkedList)databaseInfos.get(dbUniqueName);
                if (databaseDetails == null || databaseDetails.size() <= 1) continue;
                String dbHome = String.valueOf(databaseDetails.get(0));
                String dbVersion = String.valueOf(databaseDetails.get(1));
                dbInfosSB.append(dbUniqueName + "|" + dbHome + "|" + dbVersion + LSEP);
            }
            this.displaySuccessResult(dbInfosSB.toString(), 0);
            return 0;
        }
        catch (DatabaseException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (InstanceException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
    }

    public int processCommandLine(String methodName, String[] args) {
        try {
            Class<?> helperClass = Class.forName("oracle.ops.verification.helper.helper12101.CVUHelper12101");
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            Trace.out((Exception)e);
            this.displayExecutionError("Method " + methodName + " not found");
            return 2;
        }
        catch (InstantiationException e) {
            this.displayExecutionError("error while instantiating method " + methodName);
            return 2;
        }
        catch (ClassNotFoundException e) {
            this.displayExecutionError("Class CVUHelper11202 not found");
            return 2;
        }
        catch (IllegalAccessException e) {
            this.displayExecutionError("Illegal Access while running method " + methodName);
            return 2;
        }
        catch (InvocationTargetException e) {
            this.displayExecutionError("error while invoking method " + methodName);
            Trace.out((Exception)e);
            return 2;
        }
    }

    public int validateGNSCredential(String[] gnsCredFile) {
        GNSProperties gnsProp = null;
        String gnsDomainName = null;
        Trace.out((String)("GNS data file is located in " + gnsCredFile[1]));
        try {
            gnsProp = new ClusterwareInfo().getGNSProperties(gnsCredFile[1]);
            gnsDomainName = gnsProp.getGNSSubDomain();
            Trace.out((String)("Domain name readed from data file " + gnsDomainName));
        }
        catch (CredentialsException ex) {
            this.displayErrorResult(ex.getMessage(), 2);
            Trace.out((Exception)((Object)ex));
            return 0;
        }
        catch (InstallException ix) {
            this.displayErrorResult(ix.getMessage(), 2);
            Trace.out((Exception)((Object)ix));
            return 0;
        }
        this.displaySuccessResult("<GNS_DOMAIN_NAME>" + gnsDomainName + "</GNS_DOMAIN_NAME>", 0);
        return 0;
    }

    public int checkDynamicNetwork(String[] args) {
        NodeAppsFactory nodeApps = null;
        List netList = null;
        String strOut = "";
        int status = 0;
        try {
            nodeApps = NodeAppsFactory.getInstance();
            netList = nodeApps.getNetworks();
            for (Network net : netList) {
                if (net.dhcpServerType() != null && net.dhcpServerType() == DHCPServerType.DHCP || net.dhcpServerTypeIPv6() != null && net.dhcpServerTypeIPv6() == DHCPServerType.AUTOCONFIG) {
                    strOut = strOut + "<DYNAMIC_NETWORK>TRUE</DYNAMIC_NETWORK>";
                    continue;
                }
                strOut = strOut + "<DYNAMIC_NETWORK>FALSE</DYNAMIC_NETWORK>";
            }
            this.displaySuccessResult(strOut, 0);
            return status;
        }
        catch (SoftwareModuleException ex) {
            Trace.out((String)("Exception SoftwareModuleException: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage());
            Trace.out((Exception)((Object)ex));
            status = 0;
        }
        catch (NotExistsException ex) {
            Trace.out((String)("Exception NotExistsException: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage());
            status = 0;
        }
        return status;
    }

    public int getOCRLocations(String[] args) {
        int status = 0;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        HashMap ocrDisk = null;
        String strOut = "";
        try {
            Trace.out((String)"Getting OCR details");
            ocrDisk = nativeSystem.getOCRLocations(new Version());
        }
        catch (NativeException ex) {
            Trace.out((String)("Exception while reading OCR locations: " + ex.getMessage()));
            Trace.out((Exception)((Object)ex));
            this.displayErrorResult(ex.getMessage());
            status = 0;
        }
        Iterator it = ocrDisk.entrySet().iterator();
        String loc = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            loc = (String)entry.getKey();
            strOut = strOut + "<OCR_LOCATION>" + loc + "</OCR_LOCATION>";
        }
        this.displaySuccessResult(strOut, 0);
        return status;
    }

    public int getPolicyDBInfo(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String value = "";
        int status = 0;
        try {
            DatabaseFactory df = DatabaseFactory.getInstance();
            for (Database db : df.getDatabases()) {
                List groups = db.serverGroups();
                if (groups.size() <= 1 && (groups.size() != 1 || !((ServerGroup)groups.get(0)).isServerPool())) continue;
                value = "<DB_INFO>" + db.getDBName() + "," + db.getOracleHome() + "</DB_INFO>";
            }
            this.displaySuccessResult(value, 0);
        }
        catch (ServerGroupException se) {
            Trace.out((String)("Exception ServerGroupException: " + se.getMessage()));
            this.displayErrorResult(se.getMessage(), 2);
            status = 0;
        }
        catch (NotExistsException ex) {
            Trace.out((String)("Exception NotExistsException: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            status = 0;
        }
        catch (SoftwareModuleException sme) {
            Trace.out((String)("Exception SoftwareModuleException: " + sme.getMessage()));
            this.displayErrorResult(sme.getMessage(), 2);
            status = 0;
        }
        return status;
    }

    public int getDBServiceCount(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String value = "";
        int status = 0;
        try {
            CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
            List serviceResources = crsFactoryImpl.searchResources(crsFactoryImpl.create(ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.SERVICE_TYPE.toString()));
            value = "<DB_SERVICE_COUNT>" + serviceResources.size() + "</DB_SERVICE_COUNT>";
            this.displaySuccessResult(value, 0);
        }
        catch (CRSException e) {
            Trace.out((String)("Exception CRSException: " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        return status;
    }

    public int isValidGNSVIP(String[] args) {
        String gnsVIP = args[1];
        boolean isPreCheck = Boolean.parseBoolean(args[2]);
        try {
            boolean isValid = GNSUtils.isValidGNSVIP((String)gnsVIP, (boolean)isPreCheck);
            Trace.out((String)("isValidGNS ? " + isValid));
            this.displaySuccessResult("<IS_VALID_GNS>" + isValid + "</IS_VALID_GNS>", 0);
            return 0;
        }
        catch (GNSException ex) {
            Trace.out((String)("The GNSVIP is not valid " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            Trace.out((Exception)((Object)ex));
            return 0;
        }
    }

    public int runASMQuery(String[] args) {
        int status = 0;
        String sqlQuery = args[1];
        String role = args[3];
        OracleConnection asmConnection = this.getASMConnection(role);
        if (asmConnection != null) {
            try {
                int i;
                Trace.out((String)"Connection to Local ASM instance successful");
                Statement stmt = asmConnection.createStatement();
                Trace.out((String)("Executing the query " + sqlQuery));
                ResultSet queryResult = stmt.executeQuery(sqlQuery);
                ResultSetMetaData rsmd = queryResult.getMetaData();
                int colCount = rsmd.getColumnCount();
                String colNames = "";
                String colLabels = "";
                Trace.out((String)("Number of columns: " + colCount));
                String resultString = "<COLUMN_COUNT>" + colCount + "</COLUMN_COUNT>";
                for (i = 1; i <= colCount; ++i) {
                    colNames = colNames + rsmd.getColumnName(i) + "|";
                    colLabels = colLabels + rsmd.getColumnLabel(i) + "|";
                }
                resultString = resultString + "<COLUMN_NAME>" + colNames.substring(0, colNames.length() - 1) + "</COLUMN_NAME>" + "<COLUMN_LABEL>" + colLabels.substring(0, colLabels.length() - 1) + "</COLUMN_LABEL>";
                while (queryResult.next()) {
                    resultString = resultString + "<ROW_DATA>";
                    for (i = 1; i <= colCount; ++i) {
                        resultString = resultString + queryResult.getObject(i) + "|";
                    }
                    resultString = resultString.substring(0, resultString.length() - 1);
                    resultString = resultString + "</ROW_DATA>";
                }
                Trace.out((String)resultString);
                queryResult.close();
                stmt.close();
                asmConnection.close();
                this.displaySuccessResult(resultString);
            }
            catch (SQLException sqlex) {
                Trace.out((String)("SQLException occured while executing query " + sqlQuery));
                Trace.out((String)sqlex.getMessage());
                this.displayErrorResult(sqlex.getMessage(), 2);
                return 0;
            }
        } else {
            return 0;
        }
        return status;
    }

    private OracleConnection getASMConnection(String role) {
        String connectString = null;
        String user2 = null;
        String password = null;
        String driverType = null;
        HashMap userPasswordMap = null;
        ASMFactory asmFactory = null;
        try {
            asmFactory = ASMFactory.getInstance();
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("ASMFactory Exception " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return null;
        }
        if (asmFactory != null) {
            try {
                ConnectionInfo connectionInfo = asmFactory.getASMConnectionInfo("+ASM", "", "");
                connectString = connectionInfo.getConnectString().replace("(SECURITY=(AUTHENTICATION_SERVICES=NTS))", "");
                Trace.out((String)("ASM Connection Info: " + connectString));
                userPasswordMap = connectionInfo.getCredentials();
            }
            catch (ASMException e) {
                Trace.out((String)("Credential Store access failure, " + e.getMessage()));
                this.displayErrorResult(e.getMessage(), 2);
                return null;
            }
        }
        if (userPasswordMap != null && !userPasswordMap.isEmpty()) {
            Trace.out((String)"Credential Store is not Empty.");
            Boolean credFound = false;
            driverType = "thin";
            for (String user2 : userPasswordMap.keySet()) {
                Trace.out((String)("User " + user2));
                password = (String)userPasswordMap.get(user2);
                if (password == null || password.trim().length() == 0) {
                    Trace.out((String)("Couldn't obtain password for user: " + user2));
                    continue;
                }
                credFound = true;
                break;
            }
            if (!credFound.booleanValue()) {
                Trace.out((String)"Credentials not available for the connection");
                String errMsg = "<FACILITY>PRVG</FACILITY><ID>12944</ID><ARGS>" + role + "</ARGS>";
                this.displayErrorResult(errMsg, 2);
                return null;
            }
        } else {
            user2 = "";
            password = "";
            driverType = "oci";
        }
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException cnfe) {
            Trace.out((String)("Exception while loading OracleDriver " + cnfe.getMessage()));
            String errMsg = "<FACILITY>PRVG</FACILITY><ID>12943</ID>";
            this.displayErrorResult(errMsg, 2);
            return null;
        }
        String jdbcURL = "jdbc:oracle:" + driverType + ":@" + connectString;
        try {
            Properties conProperties = new Properties();
            conProperties.put("user", user2);
            conProperties.put("password", password);
            conProperties.put("internal_logon", role);
            Trace.out((String)("Trying to establish connection using thin jdbc url '" + jdbcURL + "'"));
            return (OracleConnection)DriverManager.getConnection(jdbcURL, conProperties);
        }
        catch (SQLException sqlex) {
            Trace.out((String)("SQLException: " + sqlex.getMessage()));
            String errMsg = "<FACILITY>PRVG</FACILITY><ID>12946</ID><ARGS>" + role + "|" + connectString + "</ARGS>";
            errMsg = errMsg + "<AMSG>" + sqlex.getMessage() + "</AMSG>";
            this.displayErrorResult(errMsg, 2);
            return null;
        }
    }

    public int getASMConnectionInfo(String[] args) {
        Object connectionInfo;
        int status = 0;
        String connectString = null;
        String user2 = null;
        String password = null;
        HashMap userPasswordMap = null;
        ASMFactory asmFactory = null;
        String role = args[1];
        try {
            asmFactory = ASMFactory.getInstance();
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("ASMFactory Exception " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        if (asmFactory != null) {
            try {
                connectionInfo = asmFactory.getASMConnectionInfo("+ASM");
                Trace.out((String)("ASM Connection Info: " + connectionInfo.getConnectString()));
                connectString = connectionInfo.getConnectString();
                userPasswordMap = connectionInfo.getCredentials();
            }
            catch (ASMException e) {
                Trace.out((String)("Credential Store access failure, " + e.getMessage()));
                this.displayErrorResult(e.getMessage(), 2);
                return 0;
            }
        }
        if (userPasswordMap != null && !userPasswordMap.isEmpty()) {
            Trace.out((String)"Credential Store is not Empty.");
            Boolean credFound = false;
            for (String user2 : userPasswordMap.keySet()) {
                Trace.out((String)("User " + user2));
                password = (String)userPasswordMap.get(user2);
                if (password == null || password.trim().length() == 0) {
                    Trace.out((String)("Couldn't obtain password for user: " + user2));
                    continue;
                }
                credFound = true;
                break;
            }
            if (!credFound.booleanValue()) {
                Trace.out((String)"Credentials not available for the connection");
                String errMsg = "<FACILITY>PRVG</FACILITY><ID>12944</ID><ARGS>" + role + "</ARGS>";
                this.displayErrorResult(errMsg, 2);
                return 0;
            }
        }
        connectionInfo = "<CONN_STRING>" + connectString + "</CONN_STRING>";
        this.displaySuccessResult((String)connectionInfo);
        return status;
    }

    public int getASMPWFile(String[] args) {
        MessageBundle s_gMsgBundle = MessageBundle.getMessageBundle((String)"Prvg");
        String errMsg = s_gMsgBundle.getMessage("10091", true);
        ASMFactory asmfact = null;
        ASM asm = null;
        ClusterASM clusterASM = null;
        String pwdFile = null;
        try {
            asmfact = ASMFactory.getInstance();
            try {
                asm = asmfact.getASM();
            }
            catch (NotExistsException e) {
                Trace.out((String)e.getMessage());
                clusterASM = asmfact.getClusterASM();
            }
        }
        catch (SoftwareModuleException sme) {
            Trace.out((String)sme.getMessage());
            errMsg = errMsg + LSEP + sme.getMessage();
            this.displayErrorResult(errMsg, 2);
            return 0;
        }
        catch (NotExistsException ne) {
            Trace.out((String)ne.getMessage());
            errMsg = errMsg + LSEP + ne.getMessage();
            this.displayErrorResult(errMsg, 2);
            return 0;
        }
        try {
            if (asm != null) {
                pwdFile = asm.getPWFile();
            } else if (clusterASM != null) {
                pwdFile = clusterASM.getPWFile();
            }
            if (pwdFile != null && pwdFile.trim().length() > 0) {
                Trace.out((String)("got the ASM password file " + pwdFile));
                this.displaySuccessResult(pwdFile.trim(), 0);
                return 0;
            }
            Trace.out((String)"ASM Password file location is empty or not set");
            this.displayErrorResult(errMsg, 2);
            return 0;
        }
        catch (ASMException ae) {
            Trace.out((String)ae.getMessage());
            errMsg = errMsg + LSEP + ae.getMessage();
            this.displayErrorResult(errMsg, 2);
            return 0;
        }
    }

    public static void main(String[] args) {
        int retVal = 2;
        boolean saveTraceState = Trace.isTraceEnabled();
        Trace.traceEnabled((boolean)false);
        CVUHelper12101 cvuHelper = new CVUHelper12101();
        try {
            CVUHelper12101.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            MessageBundle s_msgBundle = MessageBundle.getMessageBundle((String)"Prvf");
            String errorMsg = s_msgBundle.getMessage("0002", true) + LSEP + uhe.getMessage();
            cvuHelper.displayExecutionError(errorMsg);
            System.exit(retVal);
        }
        Trace.traceEnabled((boolean)saveTraceState);
        CVUHelper12101.setupTracing();
        Trace.out((String)"CVUHelper12101 main");
        String methodName = cvuHelper.parseArguments(args);
        if (methodName != null) {
            retVal = cvuHelper.processCommandLine(methodName, args);
            if (retVal != 2) {
                cvuHelper.displayExecutionSuccess();
            } else {
                cvuHelper.displayExecutionError("exception returned by method : " + args[0]);
            }
        }
        Trace.out((String)"==== cvuhelper exiting normally.");
        System.exit(retVal);
    }
}

