/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class ValidateUserEquiv
implements OiilQuery {
    private static final String ColonDeLimit = ":";
    private static final String UNKNOWN_HOST = "unknown host";
    private static final String PCKT_LOSS = " 100% packet loss";
    private static final String SUCC_MSG = "SUCCESS";
    private static final String CLUST_EXP = "CLUSTEREXCEPTION";

    public Object performQuery(Vector vector) {
        boolean upList = false;
        boolean errList = false;
        boolean expList = false;
        ArrayList<String> upNodes = new ArrayList<String>();
        ArrayList<String> errNodes = new ArrayList<String>();
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> expNodes = new ArrayList<String>();
        String RetMsg = "";
        String errMsg = "";
        String expMsg = "";
        String CurrNode = "";
        boolean flag = false;
        String[] s = (String[])this.retItem(vector, "nodeNames");
        String DbgQ = "";
        boolean DbgFlag = false;
        DbgQ = System.getProperty("oracle.query.debug");
        if (DbgQ != null) {
            DbgFlag = true;
        }
        try {
            ClusterCmd Ccmd = new ClusterCmd();
            if (DbgFlag) {
                for (int i = 0; i < s.length; ++i) {
                    System.out.println("Nodes are " + s[i]);
                }
            }
            flag = Ccmd.validateUserEquivalence(s);
            if (DbgFlag) {
                System.out.println("Value of flag after validateUserEquivalence call returns " + flag);
            }
            if (flag) {
                RetMsg = SUCC_MSG;
            }
        }
        catch (ClusterException ce) {
            errMsg = ce.getMessage();
            if (DbgFlag) {
                System.out.println("START OF CLUSTEREXCEPTION STACKTRACE");
                ce.printStackTrace();
                System.out.println("END OF CLUSTEREXCEPTION STACKTRACE");
                System.out.println("Error message is " + errMsg);
            }
            RetMsg = "\n" + errMsg + "\n";
        }
        catch (RemoteFileOperationException rfoe) {
            for (int i = 0; i < s.length; ++i) {
                CurrNode = s[i];
                if (DbgFlag) {
                    System.out.println("Current Node is " + CurrNode);
                }
                try {
                    int status = rfoe.getStatus(CurrNode);
                    if (DbgFlag) {
                        System.out.println("status " + status + " and message is " + rfoe.getMessage());
                    }
                    if (status == 0) {
                        flag = true;
                        upNodes.add(CurrNode);
                    }
                    if (status != 1) {
                        if (status != 2) continue;
                    }
                    if (status == 1) {
                        errMsg = "\n" + rfoe.getErrorMessage(CurrNode) + "\n";
                        errMsgList.add(errMsg);
                        errNodes.add(CurrNode);
                    } else {
                        expMsg = "\n" + rfoe.getException(CurrNode).getMessage() + "\n";
                        errMsgList.add(expMsg);
                        expNodes.add(CurrNode);
                    }
                    if (DbgFlag) {
                        System.out.println("START OF EXCEPTION STACKTRACE");
                        rfoe.printStackTrace();
                        System.out.println("END OF EXCEPTION STACKTRACE");
                        System.out.println("Error message is " + errMsg);
                    }
                    flag = false;
                    continue;
                }
                catch (NoSuchNodeException nsne) {
                    flag = false;
                    RetMsg = UNKNOWN_HOST;
                }
            }
            int UpNodeSz = upNodes.size();
            int DownNodeSz = errNodes.size();
            int expNodeSz = expNodes.size();
            if (DbgFlag) {
                System.out.println("Size of UpNodes is " + UpNodeSz);
                System.out.println("Size of errNodes is " + DownNodeSz);
            }
            RetMsg = this.ConvertString(errMsgList, errMsgList.size());
        }
        return new String(RetMsg);
    }

    private String parseErrMsg(String Msg) {
        String RetMsg = "";
        StringTokenizer st = new StringTokenizer(Msg, ColonDeLimit);
        while (st.hasMoreTokens()) {
            RetMsg = st.nextToken();
        }
        return RetMsg.toLowerCase().trim();
    }

    private String ConvertString(List StrArry, int Size) {
        String RetStr = "";
        int ListSz = Size;
        if (ListSz > 0) {
            RetStr = (String)StrArry.get(0);
            for (int i = 1; i < ListSz; ++i) {
                RetStr = RetStr + " " + (String)StrArry.get(i);
            }
        }
        return RetStr;
    }

    Object retItem(Vector vector, String s) {
        int i = OiixVectorOps.vectIndexOf((Vector)vector, (Object)s);
        if (i == -1) {
            return null;
        }
        OiilActionInputElement oiilactioninputelement = (OiilActionInputElement)vector.elementAt(i);
        return oiilactioninputelement.getObject();
    }

    public static void main(String[] args) {
        ValidateUserEquiv vue = new ValidateUserEquiv();
        Vector<OiilActionInputElement> vector = new Vector<OiilActionInputElement>();
        String[] Nodes = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Nodes[i] = args[i];
        }
        vector.addElement(new OiilActionInputElement("nodeNames", (Object)Nodes));
        String RetStr = (String)vue.performQuery(vector);
        System.out.println("Return Value is : " + RetStr);
    }

    static {
        String DbgSrvm = System.getProperty("oracle.srvm.debug");
        if (DbgSrvm != null) {
            String getCurrEnv = new String(System.getProperty("java.library.path"));
            String setNewEnv = new String(System.getProperty("oracle.installer.scratchPath") + ColonDeLimit);
            System.setProperty("java.library.path", setNewEnv + getCurrEnv);
            getCurrEnv = new String(System.getProperty("java.library.path"));
            System.setProperty("TRACING.ENABLED", "TRUE");
            System.setProperty("TRACING.LEVEL", "2");
        }
    }
}

