/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilDescQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class getSystemParameters
implements OiilDescQuery {
    public static String FILE = "/etc/system";
    public static String hpcommand = "/usr/sbin/kmtune";
    public static String decunix_command = "/sbin/sysconfig -q ";
    public static String[] decunix_command_options = new String[]{"ipc", "proc", "vm", "inet"};

    public String getDescription(Vector inputs) {
        String descStr = "";
        return descStr;
    }

    private String[] splitString(String Source, String separator) {
        StringTokenizer strtok = new StringTokenizer(Source, separator);
        String[] retArr = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            retArr[i] = strtok.nextToken();
            ++i;
        }
        return retArr;
    }

    private Vector getLinuxSystemParameters() throws OiilQueryException {
        int i;
        String linux_sem_command = "/bin/cat /proc/sys/kernel/sem";
        String linux_shmmax_command = "/bin/cat /proc/sys/kernel/shmmax";
        String linux_shmmni_command = "/bin/cat /proc/sys/kernel/shmmni";
        String linux_shmall_command = "/bin/cat /proc/sys/kernel/shmall";
        String linux_shm_misc_command = "/usr/bin/ipcs -lm";
        String linux_sem_misc_command = "/usr/bin/ipcs -ls";
        String linux_filemax_command = "/bin/cat /proc/sys/fs/file-max";
        String linux_msgmni_command = "/bin/cat /proc/sys/kernel/msgmni";
        String linux_msgmax_command = "/bin/cat /proc/sys/kernel/msgmax";
        String linux_msgmnb_command = "/bin/cat /proc/sys/kernel/msgmnb";
        String linux_softnofiles_command = "/bin/sh -c ulimit -Sn";
        String linux_hardnofiles_command = "/bin/sh -c ulimit -Hn";
        String linux_strsemmsl = "semmsl";
        String linux_strsemmns = "semmns";
        String linux_strsemopm = "semopm";
        String linux_strsemmni = "semmni";
        String linux_strsemvmx = "semvmx";
        String linux_strshmmax = "shmmax";
        String linux_strshmmni = "shmmni";
        String linux_strshmall = "shmall";
        String linux_strshmmin = "shmmin";
        String linux_strshmseg = "shmseg";
        String linux_strmsgmni = "msgmni";
        String linux_strmsgmnb = "msgmnb";
        String linux_strmsgmax = "msgmax";
        String linux_strfilemax = "filemax";
        String linux_str_softnofiles = "softnofiles";
        String linux_str_hardnofiles = "hardnofiles";
        String linux_sem_max_val_statement = "semaphore max value";
        String linux_min_seg_statement = "min seg size";
        String linux_max_seg_statement = "max number of segments";
        Vector<String> store = new Vector<String>();
        RunLocalUnixCommand commandObject = new RunLocalUnixCommand(linux_sem_command);
        String[] lines = commandObject.outStore;
        String[] tokens = this.splitString(lines[0], "\t");
        if (tokens.length != 4) {
            String exName = "FileCannotReadException";
            String exString = OiQueryFileRes.getString("FileCannotReadException_desc");
            throw new OiilQueryException(exName, exString);
        }
        store.addElement(linux_strsemmsl + "=" + tokens[0].trim());
        store.addElement(linux_strsemmns + "=" + tokens[1].trim());
        store.addElement(linux_strsemopm + "=" + tokens[2].trim());
        store.addElement(linux_strsemmni + "=" + tokens[3].trim());
        commandObject = new RunLocalUnixCommand(linux_sem_misc_command);
        lines = commandObject.outStore;
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf(61) == -1 || (tokens = this.splitString(lines[i], "="))[0].indexOf(linux_sem_max_val_statement) == -1) continue;
            store.addElement(linux_strsemvmx + "=" + tokens[1].trim());
            break;
        }
        commandObject = new RunLocalUnixCommand(linux_shmmax_command);
        lines = commandObject.outStore;
        store.addElement(linux_strshmmax + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_shmmni_command);
        lines = commandObject.outStore;
        store.addElement(linux_strshmmni + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_shmall_command);
        lines = commandObject.outStore;
        store.addElement(linux_strshmall + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_shm_misc_command);
        lines = commandObject.outStore;
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf(61) == -1) continue;
            tokens = this.splitString(lines[i], "=");
            if (tokens[0].indexOf(linux_min_seg_statement) != -1) {
                store.addElement(linux_strshmmin + "=" + tokens[1].trim());
                continue;
            }
            if (tokens[0].indexOf(linux_max_seg_statement) == -1) continue;
            store.addElement(linux_strshmseg + "=" + tokens[1].trim());
        }
        commandObject = new RunLocalUnixCommand(linux_filemax_command);
        lines = commandObject.outStore;
        store.addElement(linux_strfilemax + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_msgmni_command);
        lines = commandObject.outStore;
        store.addElement(linux_strmsgmni + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_msgmnb_command);
        lines = commandObject.outStore;
        store.addElement(linux_strmsgmnb + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_msgmax_command);
        lines = commandObject.outStore;
        store.addElement(linux_strmsgmax + "=" + lines[0].trim());
        commandObject = new RunLocalUnixCommand(linux_softnofiles_command);
        lines = commandObject.outStore;
        try {
            int temp_int = Integer.parseInt(lines[0].trim());
            store.addElement(linux_str_softnofiles + "=" + lines[0].trim());
        }
        catch (NumberFormatException ne) {
            store.addElement(linux_str_softnofiles + "=" + Integer.MAX_VALUE);
        }
        commandObject = new RunLocalUnixCommand(linux_hardnofiles_command);
        lines = commandObject.outStore;
        try {
            int temp_int = Integer.parseInt(lines[0].trim());
            store.addElement(linux_str_hardnofiles + "=" + lines[0].trim());
        }
        catch (NumberFormatException ne) {
            store.addElement(linux_str_hardnofiles + "=" + Integer.MAX_VALUE);
        }
        return store;
    }

    public Object performQuery(Vector inputs) throws OiilQueryException {
        FileReader file;
        String[] sysParams = (String[])this.retItem(inputs, "systemParams");
        if (sysParams.length < 1) {
            return null;
        }
        OiixPlatform oiiPl = new OiixPlatform();
        int platID = oiiPl.getCurrentPlatform();
        if (platID == 2) {
            RunLocalUnixCommand commandObject = new RunLocalUnixCommand(hpcommand);
            Vector<String> store = new Vector<String>();
            boolean found = false;
            String[] lines = commandObject.outStore;
            ssHPUXkmtuneProcess formula = new ssHPUXkmtuneProcess(lines);
            lines = formula.getValues();
            for (int sidx = 0; sidx < sysParams.length; ++sidx) {
                found = false;
                for (int kmidx = 0; kmidx < lines.length; ++kmidx) {
                    StringTokenizer parmstrtok = new StringTokenizer(lines[kmidx], " ");
                    if (parmstrtok.countTokens() < 2) continue;
                    String word = parmstrtok.nextToken();
                    word = word.trim();
                    String value = parmstrtok.nextToken();
                    if (!sysParams[sidx].equals(word)) continue;
                    store.addElement(sysParams[sidx]);
                    store.addElement(value);
                    found = true;
                    break;
                }
                if (found) continue;
                store.addElement(sysParams[sidx]);
                store.addElement("-1");
            }
            int size = store.size();
            String[] retVal = new String[size];
            for (int j = 0; j < size; ++j) {
                retVal[j] = (String)store.elementAt(j);
            }
            return retVal;
        }
        if (platID == 46) {
            Vector<String> store = new Vector<String>();
            Vector etcSys = this.getLinuxSystemParameters();
            boolean found = false;
            for (int sidx = 0; sidx < sysParams.length; ++sidx) {
                found = false;
                for (int eidx = 0; eidx < etcSys.size(); ++eidx) {
                    String etcStr = (String)etcSys.elementAt(eidx);
                    if (etcStr.indexOf(sysParams[sidx]) == -1) continue;
                    etcStr = (String)etcSys.elementAt(eidx);
                    String value = etcStr.substring(etcStr.indexOf(61) + 1);
                    store.addElement(sysParams[sidx]);
                    store.addElement(value);
                    found = true;
                    break;
                }
                if (found) continue;
                store.addElement(sysParams[sidx]);
                store.addElement("-1");
            }
            int size = store.size();
            String[] retVal = new String[size];
            for (int j = 0; j < size; ++j) {
                retVal[j] = (String)store.elementAt(j);
            }
            return retVal;
        }
        if (platID == 87) {
            Vector<String> store = new Vector<String>();
            Vector<String> etcSys = new Vector<String>();
            boolean found = false;
            for (int opt = 0; opt < decunix_command_options.length; ++opt) {
                RunLocalUnixCommand commandObject = new RunLocalUnixCommand(decunix_command + " " + decunix_command_options[opt]);
                String[] lines = commandObject.outStore;
                for (int outidx = 0; outidx < lines.length; ++outidx) {
                    if (lines[outidx].indexOf(61) == -1) continue;
                    etcSys.addElement(lines[outidx]);
                }
            }
            for (int sidx = 0; sidx < sysParams.length; ++sidx) {
                found = false;
                for (int eidx = 0; eidx < etcSys.size(); ++eidx) {
                    String etcStr = (String)etcSys.elementAt(eidx);
                    if (etcStr.indexOf(sysParams[sidx]) == -1) continue;
                    etcStr = (String)etcSys.elementAt(eidx);
                    String value = etcStr.substring(etcStr.indexOf(61) + 1).trim();
                    store.addElement(sysParams[sidx]);
                    store.addElement(value);
                    found = true;
                    break;
                }
                if (found) continue;
                store.addElement(sysParams[sidx]);
                store.addElement("-1");
            }
            int size = store.size();
            String[] retVal = new String[size];
            for (int j = 0; j < size; ++j) {
                retVal[j] = (String)store.elementAt(j);
            }
            return retVal;
        }
        try {
            file = new FileReader(FILE);
        }
        catch (FileNotFoundException e) {
            System.out.println("FileNotFoundException is thrown");
            String exName = "FileNotFoundException";
            String exString = OiQueryFileRes.getString("FileNotFoundException_desc");
            throw new OiilQueryException(exName, exString);
        }
        BufferedReader in = new BufferedReader(file);
        Vector<String> store = new Vector<String>();
        Vector<String> etcSys = new Vector<String>();
        boolean found = false;
        try {
            String word;
            while ((word = in.readLine()) != null) {
                String trword = word.trim();
                if (trword.equals("") || trword.startsWith("*") || trword.startsWith("#")) continue;
                etcSys.addElement(trword.trim());
            }
            for (int sidx = 0; sidx < sysParams.length; ++sidx) {
                found = false;
                for (int eidx = 0; eidx < etcSys.size(); ++eidx) {
                    String etcStr = (String)etcSys.elementAt(eidx);
                    if (etcStr.indexOf(sysParams[sidx]) == -1) continue;
                    etcStr = (String)etcSys.elementAt(eidx);
                    String value = etcStr.substring(etcStr.indexOf(61) + 1);
                    store.addElement(sysParams[sidx]);
                    store.addElement(value.trim());
                    found = true;
                    break;
                }
                if (found) continue;
                store.addElement(sysParams[sidx]);
                store.addElement("-1");
            }
            int size = store.size();
            String[] retVal = new String[size];
            for (int j = 0; j < size; ++j) {
                retVal[j] = (String)store.elementAt(j);
            }
            return retVal;
        }
        catch (IOException ioe) {
            String exName = "FileCannotReadException";
            String exString = OiQueryFileRes.getString("FileCannotReadException_desc");
            throw new OiilQueryException(exName, exString);
        }
    }

    public Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public static void main(String[] args) {
        getSystemParameters gsy = new getSystemParameters();
        Vector<OiilActionInputElement> inp = new Vector<OiilActionInputElement>();
        String[] filenames = null;
        OiixPlatform oiiPl = new OiixPlatform();
        int platID = oiiPl.getCurrentPlatform();
        if (platID == 453) {
            filenames = new String[]{new String("shmmax"), new String("shmxxx")};
        } else {
            filenames = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                filenames[i] = new String(args[i]);
            }
        }
        inp.addElement(new OiilActionInputElement("systemParams", (Object)filenames));
        try {
            String[] foobar = (String[])gsy.performQuery(inp);
            for (int x = 0; x < foobar.length; ++x) {
                System.out.println(foobar[x]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

