/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;

public class ViewInfo {
    View view;
    int viewId;
    byte[] lock = new byte[0];
    Vector epList;
    int index;
    MessageBuffer msgbuf;

    public ViewInfo(int n) {
        this.viewId = n;
        this.view = null;
        this.epList = null;
        this.index = -1;
        this.msgbuf = new MessageBuffer();
    }

    public ViewInfo(View view) {
        this.view = view;
        this.epList = null;
        Vector vector = this.view.getMembers();
        this.index = vector.indexOf(Transport.getLocalAddress());
        this.msgbuf = new MessageBuffer(view);
    }

    public ViewInfo(View view, int n) {
        this.view = view;
        this.epList = null;
        this.index = n;
        this.msgbuf = new MessageBuffer(view);
    }

    public void init(View view) {
        this.view = view;
        this.epList = null;
        Vector vector = this.view.getMembers();
        this.index = vector.indexOf(Transport.getLocalAddress());
    }

    public View getView() {
        return this.view;
    }

    public int getViewId() {
        return this.viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEPList() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.epList != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.epList;
            }
            Vector<EndPoint> vector = new Vector<EndPoint>();
            Vector vector2 = this.view.getMembers();
            Enumeration enumeration = vector2.elements();
            Hashtable hashtable = Transport.getEndPointList();
            while (enumeration.hasMoreElements()) {
                Address address = (Address)enumeration.nextElement();
                EndPoint endPoint = (EndPoint)hashtable.get(address);
                if (endPoint == null) continue;
                vector.addElement(endPoint);
            }
            this.epList = vector;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.epList;
        }
    }

    public int getMyIndex() {
        return this.index;
    }

    public MessageBuffer getMessageBuffer() {
        return this.msgbuf;
    }

    public boolean equals(Object object) {
        ViewInfo viewInfo = (ViewInfo)object;
        return this.view.equals(viewInfo.getView());
    }

    void dump() {
        GroupCommunication.log("--- Begin ViewInfo Dump ---");
        if (this.view != null) {
            GroupCommunication.log(this.view.toString());
        }
        this.msgbuf.dump();
        GroupCommunication.log("--- End ViewInfo Dump ---");
    }
}

