/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.MsgInfo;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

class MessageBuffer {
    View curView;
    int size;
    int index;
    byte[] und_lock = new byte[0];
    Vector unDeliverableMsgList;
    byte[] atomic_lock = new byte[0];
    List[] unStableMsgMatrix;
    long[][] stableMatrix;
    long[] stableVector;
    long[] receiveVector;
    Hashtable deliveredVector;
    static byte[] ton_lock = new byte[0];
    static long receivedTONumber = -1L;
    byte[] total_lock = new byte[0];
    Vector totalOrderedMsgList;
    long head;
    long[] stableTOVector;
    Hashtable to_deliveredVector;
    boolean updated;

    MessageBuffer(View view) {
        this.curView = view;
        this.size = view.size();
        this.index = view.getMembers().indexOf(Transport.getLocalAddress());
        this.updated = false;
        this.unDeliverableMsgList = new Vector();
        this.deliveredVector = new Hashtable();
        this.totalOrderedMsgList = new Vector();
        this.to_deliveredVector = new Hashtable();
        this.head = -1L;
        this.init(view);
    }

    MessageBuffer() {
        this.curView = null;
        this.size = 0;
        this.index = -1;
        this.updated = false;
        this.unDeliverableMsgList = new Vector();
        this.deliveredVector = new Hashtable();
        this.totalOrderedMsgList = new Vector();
        this.to_deliveredVector = new Hashtable();
        this.head = -1L;
        receivedTONumber = -1L;
    }

    void init(View view) {
        this.curView = view;
        this.size = view.size();
        this.index = view.getMembers().indexOf(Transport.getLocalAddress());
        this.unStableMsgMatrix = new List[this.size];
        this.stableMatrix = new long[this.size][this.size];
        this.stableVector = new long[this.size];
        this.receiveVector = new long[this.size];
        this.stableTOVector = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.unStableMsgMatrix[i] = Collections.synchronizedList(new LinkedList());
            for (int j = 0; j < this.size; ++j) {
                this.stableMatrix[i][j] = i != j ? 0L : Long.MAX_VALUE;
            }
            this.stableVector[0] = 0L;
            this.receiveVector[i] = 0L;
            this.stableTOVector[i] = 0L;
        }
        Enumeration enumeration = view.getMembers().elements();
        while (enumeration.hasMoreElements()) {
            Address address = (Address)enumeration.nextElement();
            this.deliveredVector.put(address, new Long(-1L));
            this.to_deliveredVector.put(address, new Long(-1L));
        }
    }

    void setView(View view) {
        this.init(view);
    }

    void initDeliveredVector(Hashtable hashtable) {
        if (this.curView == null) {
            return;
        }
        Enumeration enumeration = this.curView.getMembers().elements();
        while (enumeration.hasMoreElements()) {
            Address address = (Address)enumeration.nextElement();
            if (!hashtable.contains(address)) continue;
            this.deliveredVector.put(address, hashtable.get(address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getReceivedTONumber() {
        byte[] byArray = ton_lock;
        synchronized (ton_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return receivedTONumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReceivedTONumber(long l) {
        byte[] byArray = ton_lock;
        synchronized (ton_lock) {
            receivedTONumber = l;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void delivered(Packet packet) {
        if (packet.isTotal()) {
            if (packet.getSequenceNumber() <= this.getReceivedTONumber()) return;
            this.setReceivedTONumber(packet.getSequenceNumber());
            byte[] byArray = this.total_lock;
            synchronized (this.total_lock) {
                this.stableTOVector[this.index] = this.getReceivedTONumber();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.deliveredVector.put(packet.getSourceAddress(), new Long(packet.getSerialNumber()));
                return;
            }
        }
        if (!packet.isAtomic()) return;
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            this.deliveredVector.put(packet.getSourceAddress(), new Long(packet.getSerialNumber()));
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasDelivered(Packet packet) {
        boolean bl = false;
        if (Transport.isMyself((Address)packet.getSourceAddress()) && !packet.isTotal()) {
            return true;
        }
        if (packet.isTotal()) {
            if (this.getReceivedTONumber() == -1L) return false;
            if (packet.getSequenceNumber() == -1L) {
                return false;
            }
            if (packet.getSequenceNumber() <= this.getReceivedTONumber()) {
                return true;
            }
            byte[] byArray = this.total_lock;
            synchronized (this.total_lock) {
                Long l = (Long)this.to_deliveredVector.get(packet.getSourceAddress());
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (l == null) return bl;
                if (packet.getSerialNumber() <= l) return bl;
                return true;
            }
        }
        if (!packet.isAtomic()) return bl;
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            Long l = (Long)this.deliveredVector.get(packet.getSourceAddress());
            if (l == -1L) return bl;
            if (packet.getSerialNumber() > l) return bl;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getDeliveredVector() {
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.deliveredVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replace(Packet packet) {
        byte[] byArray = this.total_lock;
        synchronized (this.total_lock) {
            ListIterator listIterator = this.totalOrderedMsgList.listIterator();
            while (listIterator.hasNext()) {
                Packet packet2 = (Packet)listIterator.next();
                if (packet2.getSerialNumber() != packet.getSerialNumber() || !packet2.source.equals(packet.source)) continue;
                listIterator.remove();
                break;
            }
            this.totalOrderedMsgList.add(packet);
            this.head = ((Packet)this.totalOrderedMsgList.firstElement()).getSequenceNumber();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void save(Packet packet) throws InterruptedException {
        if (this.size < 3) {
            return;
        }
        if (packet.isTotal()) {
            byte[] byArray = this.total_lock;
            // MONITORENTER : this.total_lock
            this.totalOrderedMsgList.add(packet);
            // MONITOREXIT : byArray
            if (this.head == -1L) {
                this.head = packet.getSequenceNumber();
            }
            this.update(packet);
        } else {
            Object object = this.atomic_lock;
            // MONITORENTER : this.atomic_lock
            this.unStableMsgMatrix[packet.getSenderIndex()].add(packet);
            // MONITOREXIT : object
            if (!packet.isTotal() || !Transport.isMyself((Address)packet.getSourceAddress())) {
                GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                object = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                byte[] byArray = this.atomic_lock;
                // MONITORENTER : this.atomic_lock
                this.stableMatrix[packet.getSenderIndex()][((ViewInfo)object).getMyIndex()] = packet.getSerialNumber();
                this.receiveVector[packet.getSenderIndex()] = packet.getSerialNumber();
                // MONITOREXIT : byArray
                this.update(packet.getReceiveArray(), packet.getSenderIndex());
            }
        }
        this.updated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hold(Packet packet) {
        byte[] byArray = this.und_lock;
        synchronized (this.und_lock) {
            if (!this.unDeliverableMsgList.contains(packet)) {
                this.unDeliverableMsgList.add(packet);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    ListIterator getUnstableMsgs() {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < this.size; ++i) {
            linkedList.addAll(this.unStableMsgMatrix[i]);
        }
        return linkedList.listIterator();
    }

    Vector getUnDeliverableMsgs() {
        return this.unDeliverableMsgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getUnDeliverableMsgList() {
        Vector<MsgInfo> vector = null;
        byte[] byArray = this.und_lock;
        synchronized (this.und_lock) {
            if (this.unDeliverableMsgList != null) {
                vector = new Vector<MsgInfo>();
                Enumeration enumeration = this.unDeliverableMsgList.elements();
                while (enumeration.hasMoreElements()) {
                    Packet packet = (Packet)enumeration.nextElement();
                    vector.add(new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber()));
                }
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(long[] lArray) {
        if (lArray == null || lArray.length != this.size) {
            return;
        }
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            for (int i = 0; i < this.size; ++i) {
                long l = this.stableVector[i] - lArray[i];
                if (l >= 0L) continue;
                this.stableVector[i] = lArray[i];
                for (int j = 0; j < this.size; ++j) {
                    if (this.stableMatrix[i][j] >= lArray[i]) continue;
                    this.stableMatrix[i][j] = lArray[i];
                }
                ListIterator listIterator = this.unStableMsgMatrix[i].listIterator();
                while (listIterator.hasNext()) {
                    Packet packet = (Packet)listIterator.next();
                    if (lArray[i] < packet.getSerialNumber()) continue;
                    listIterator.remove();
                }
                this.updated = true;
            }
            // ** MonitorExit[var6_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(long l) {
        byte[] byArray = this.total_lock;
        synchronized (this.total_lock) {
            if (l >= this.head) {
                ListIterator listIterator = this.totalOrderedMsgList.listIterator();
                while (listIterator.hasNext()) {
                    Packet packet = (Packet)listIterator.next();
                    if (packet.getSequenceNumber() > l) continue;
                    listIterator.remove();
                    this.head = packet.getSequenceNumber();
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(long[] lArray, int n) {
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            if (lArray == null || lArray.length != this.size) {
                // ** MonitorExit[var9_3] (shouldn't be in output)
                return;
            }
            if ((n < 0 || n >= this.size) && GroupCommunication.shouldLog(6)) {
                GroupCommunication.log("Internal: receiverIndex out of bound, receiverIndex=" + n);
            }
            for (int i = 0; i < this.size; ++i) {
                if (i != n) {
                    this.stableMatrix[i][n] = lArray[i];
                } else {
                    this.stableMatrix[i][i] = Long.MAX_VALUE;
                }
                long l = Long.MAX_VALUE;
                for (int j = 0; j < this.size; ++j) {
                    if (this.stableMatrix[i][j] >= l) continue;
                    l = this.stableMatrix[i][j];
                }
                if (l <= this.stableVector[i]) continue;
                ListIterator listIterator = this.unStableMsgMatrix[i].listIterator();
                while (listIterator.hasNext()) {
                    Packet packet = (Packet)listIterator.next();
                    if (l < packet.getSerialNumber()) continue;
                    listIterator.remove();
                }
                this.stableVector[i] = l;
            }
            // ** MonitorExit[var9_3] (shouldn't be in output)
            this.updated = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Packet packet) {
        if (this.curView == null) {
            return;
        }
        byte[] byArray = this.total_lock;
        synchronized (this.total_lock) {
            if (packet.getVid() != this.curView.getVid()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (packet.getReceivedTONumber() != -1L) {
                this.stableTOVector[packet.getSenderIndex()] = packet.getReceivedTONumber();
                long l = Long.MAX_VALUE;
                for (int i = 0; i < this.size; ++i) {
                    if (l <= this.stableTOVector[i]) continue;
                    l = this.stableTOVector[i];
                }
                if (l >= this.head) {
                    this.cleanup(l);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.updated = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List[] getUnStableMsgMatrix() {
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.unStableMsgMatrix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getStableVector() {
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.stableVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getReceiveVector() {
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.receiveVector;
        }
    }

    Vector getTotalOrderedMsgList() {
        return this.totalOrderedMsgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void dump() {
        try {
            try {
                Packet packet;
                int n;
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\n");
                stringBuffer.append("=== Message Buffer Dump: ");
                stringBuffer.append(this);
                stringBuffer.append(" ===");
                stringBuffer.append("\n");
                stringBuffer.append("Dump Stable Matrix:\n");
                for (n2 = 0; n2 < this.size; ++n2) {
                    for (n = 0; n < this.size; ++n) {
                        stringBuffer.append(" ");
                        stringBuffer.append(String.valueOf(this.stableMatrix[n2][n]));
                    }
                    stringBuffer.append("\n");
                }
                stringBuffer.append("\n");
                GroupCommunication.log(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < this.size; ++n2) {
                    stringBuffer.append(" ");
                    stringBuffer.append(String.valueOf(this.stableVector[n2]));
                }
                GroupCommunication.log("\n");
                GroupCommunication.log("stableVector:\n" + stringBuffer.toString());
                stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < this.size; ++n2) {
                    stringBuffer.append(" ");
                    stringBuffer.append(String.valueOf(this.receiveVector[n2]));
                }
                GroupCommunication.log("\n");
                GroupCommunication.log("receiveVector:\n" + stringBuffer.toString());
                stringBuffer = new StringBuffer();
                Enumeration enumeration = this.unDeliverableMsgList.elements();
                while (enumeration.hasMoreElements()) {
                    packet = (Packet)enumeration.nextElement();
                    stringBuffer.append(" ");
                    stringBuffer.append(String.valueOf(packet.getSerialNumber()));
                }
                GroupCommunication.log("\n");
                GroupCommunication.log("unDeliverableMsgList:" + stringBuffer.toString());
                GroupCommunication.log("\n");
                GroupCommunication.log("unStableMsgMatrix:");
                for (n = 0; n < this.size; ++n) {
                    ListIterator listIterator = this.unStableMsgMatrix[n].listIterator();
                    GroupCommunication.log("       Sender=" + n);
                    stringBuffer = new StringBuffer();
                    while (listIterator.hasNext()) {
                        packet = (Packet)listIterator.next();
                        stringBuffer.append(" ");
                        stringBuffer.append(String.valueOf(packet.getSerialNumber()));
                    }
                    GroupCommunication.log(stringBuffer.toString() + "\n");
                }
                GroupCommunication.log(" receivedTONumber=" + this.getReceivedTONumber());
                GroupCommunication.log("\n");
                GroupCommunication.log("totalOrderedMsgList:");
                stringBuffer = new StringBuffer();
                for (n = 0; n < this.size; ++n) {
                    stringBuffer.append(" ");
                    stringBuffer.append(String.valueOf(((Packet)this.totalOrderedMsgList.elementAt(n)).getSequenceNumber()));
                }
                GroupCommunication.log(stringBuffer.toString());
                GroupCommunication.log("head=" + this.head);
                stringBuffer = new StringBuffer();
                for (n = 0; n < this.size; ++n) {
                    stringBuffer.append(" ");
                    stringBuffer.append(String.valueOf(this.stableTOVector[n]));
                }
                GroupCommunication.log("stableTOVector:" + stringBuffer.toString());
            }
            catch (Exception exception) {
                Object var7_9 = null;
                GroupCommunication.log("\n");
                GroupCommunication.log("=== End Message Buffer Dump: " + this + " ===");
                return;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            GroupCommunication.log("\n");
            GroupCommunication.log("=== End Message Buffer Dump: " + this + " ===");
            throw throwable;
        }
        GroupCommunication.log("\n");
        GroupCommunication.log("=== End Message Buffer Dump: " + this + " ===");
    }

    public boolean updated() {
        return this.updated;
    }

    public void setUpdated(boolean bl) {
        this.updated = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasReceivedAll(long[] lArray) {
        boolean bl = false;
        if (lArray == null) {
            return true;
        }
        byte[] byArray = this.atomic_lock;
        synchronized (this.atomic_lock) {
            if (lArray.length != this.receiveVector.length) {
                return true;
            }
            bl = true;
            int n = 0;
            while (n < lArray.length) {
                if (lArray[n] > this.receiveVector[n] && n != this.index) {
                    return false;
                }
                ++n;
            }
            return bl;
        }
    }
}

