/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.FlushInfo;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.MessageQueue;
import oracle.ias.cache.group.MsgInfo;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.RWLock;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewChange;
import oracle.ias.cache.group.ViewInfo;

public class GroupManager {
    public static final String SYSTEM_GROUP = new String("SYSTEM_GROUP");
    static byte[] flush_lock = new byte[0];
    static RWLock curview_lock = new RWLock();
    static RWLock latestview_lock = new RWLock();
    static RWLock deliver_lock = new RWLock();
    static boolean flushing = false;
    static BitSet flushedFlags;
    static Vector flushInfoVector;
    static int flushcounter;
    static int viewCounter;
    static ViewInfo latestViewInfo;
    static ViewInfo curViewInfo;
    static Hashtable unDeliverableViewInfo;
    static final int RETRY = 3;
    static boolean initializing;

    static void term() {
        viewCounter = 0;
        latestViewInfo = new ViewInfo(-1);
        curViewInfo = new ViewInfo(-1);
        initializing = true;
        flushcounter = 0;
        flushing = false;
    }

    static void dump() {
        GroupCommunication.log("------Begin Dumping GroupManager ------");
        GroupCommunication.log("Current View Info:");
        curViewInfo.dump();
        GroupCommunication.log("Latest View Info:");
        latestViewInfo.dump();
        GroupCommunication.log("current view lock: " + curview_lock);
        GroupCommunication.log("latest view lock: " + latestview_lock);
        GroupCommunication.log("deliver lock: " + deliver_lock);
        GroupCommunication.log("viewCounter=" + viewCounter);
        GroupCommunication.log("flushing=" + flushing);
        GroupCommunication.log("------End Dumping GroupManager ------");
    }

    static void createGroup(String string) {
    }

    static void joinGroup(String string, Packet packet) throws GroupException, IOException, InterruptedException {
        Packet packet2 = null;
        View view = GroupManager.newView(SYSTEM_GROUP, (Address)packet.getSourceAddress(), true);
        packet2 = new Packet(4, 0, Transport.getLocalAddress(), (Serializable)((Object)SYSTEM_GROUP), view);
        curview_lock.acquireReadLock();
        MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
        curview_lock.releaseReadLock();
        packet2.setReceiveArray(messageBuffer.getReceiveVector());
        packet2.setUnDeliverableMsgList(GroupManager.getUnDeliverableMsgInfo());
        packet2.setReceivedTONumber(messageBuffer.getReceivedTONumber());
        messageBuffer.setUpdated(false);
        Transport.multicast(packet2);
    }

    static synchronized void leaveGroup(String string, Address address) throws GroupException, IOException, InterruptedException {
        Packet packet = null;
        View view = null;
        View view2 = null;
        boolean bl = false;
        boolean bl2 = false;
        latestview_lock.acquireReadLock();
        view = latestViewInfo.getView();
        latestview_lock.releaseReadLock();
        Vector vector = view.getMembers();
        if (!vector.contains(address)) {
            return;
        }
        if (Transport.isMyself(FailureDetector.getCoordinator())) {
            if (GroupCommunication.shouldLog(10)) {
                GroupCommunication.log("Removing member:" + address + ", from view:" + view.getVid());
            }
            Transport.removeAddress(address);
            view2 = GroupManager.newView(SYSTEM_GROUP, address, false);
            Hashtable hashtable = Transport.getEndPointList();
            if (view2.size() == 1 || hashtable != null && hashtable.size() == 0) {
                GroupManager.updateView(SYSTEM_GROUP);
            } else {
                packet = new Packet(4, 0, Transport.getLocalAddress(), (Serializable)((Object)SYSTEM_GROUP), view2);
                curview_lock.acquireReadLock();
                MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
                curview_lock.releaseReadLock();
                packet.setReceiveArray(messageBuffer.getReceiveVector());
                packet.setUnDeliverableMsgList(GroupManager.getUnDeliverableMsgInfo());
                packet.setReceivedTONumber(messageBuffer.getReceivedTONumber());
                messageBuffer.setUpdated(false);
            }
        }
        if (packet != null) {
            Transport.multicast(packet);
        }
    }

    static void destroyGroup(String string) {
    }

    public static RWLock getCurrentViewInfoRWLock(String string) {
        return curview_lock;
    }

    public static RWLock getLatestViewInfoRWLock(String string) {
        return latestview_lock;
    }

    public static RWLock getDeliverRWLock(String string) {
        return deliver_lock;
    }

    static ViewInfo getCurrentViewInfo(String string) {
        return curViewInfo;
    }

    static ViewInfo getLatestViewInfo(String string) {
        return latestViewInfo;
    }

    static void initView(View view) {
        Vector vector = null;
        if (view == null) {
            View view2 = new View(++viewCounter, 0, Transport.getAddrList());
            latestViewInfo = curViewInfo = new ViewInfo(view2);
            vector = view2.getMembers();
        } else {
            latestViewInfo = curViewInfo = new ViewInfo(view);
            viewCounter = view.getVid();
            vector = view.getMembers();
        }
        if (vector != null) {
            Transport.resetCleanInterval(vector.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setView(View view) throws InterruptedException {
        latestview_lock.acquireWriteLock();
        try {
            latestViewInfo = new ViewInfo(view);
            unDeliverableViewInfo.put(new Integer(view.getVid()), latestViewInfo);
        }
        catch (Exception exception) {
            if (GroupCommunication.shouldLog(3)) {
                GroupCommunication.log("Unable to set view: ", exception);
            }
        }
        finally {
            latestview_lock.releaseWriteLock();
        }
        Object object = flush_lock;
        synchronized (flush_lock) {
            flushing = true;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            viewCounter = view.getVid();
            if (view != null && (object = (Object)view.getMembers()) != null) {
                Transport.resetCleanInterval(((Vector)object).size());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateView(String string) throws GroupException, InterruptedException {
        Object object;
        Vector vector = new Vector();
        boolean bl = false;
        while (unDeliverableViewInfo.size() > 0) {
            block17: {
                int n = curViewInfo.getView().getVid();
                ViewInfo viewInfo = curViewInfo;
                object = GroupManager.getOldestViewIdFrom(unDeliverableViewInfo);
                if (object == null) break;
                if (n + 1 > (Integer)object) {
                    unDeliverableViewInfo.remove(object);
                    continue;
                }
                ViewInfo viewInfo2 = (ViewInfo)unDeliverableViewInfo.remove(object);
                if (viewInfo2 == null || viewInfo2.getView() == null) {
                    if (!GroupCommunication.shouldLog(15)) break;
                    GroupCommunication.log("Got an empty newViewInfo from unDeliverableViewInfo for vid:" + n);
                    GroupCommunication.log("unDeliverableViewInfo size: " + unDeliverableViewInfo.size() + ", keys: " + unDeliverableViewInfo.keys());
                    break;
                }
                curview_lock.acquireWriteLock();
                curViewInfo = viewInfo2;
                MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
                MessageBuffer messageBuffer2 = viewInfo.getMessageBuffer();
                messageBuffer.initDeliveredVector(messageBuffer2.getDeliveredVector());
                curview_lock.releaseWriteLock();
                if (unDeliverableViewInfo.size() == 0) {
                    bl = true;
                }
                if (curViewInfo == null) {
                    throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_VIEWINFOEMPTY);
                }
                try {
                    if (viewInfo == null) {
                        GroupManager.viewChanged(null, curViewInfo.getView());
                    } else {
                        GroupManager.viewChanged(viewInfo.getView(), curViewInfo.getView());
                    }
                }
                catch (Exception exception) {
                    if (GroupCommunication.shouldLog(3)) {
                        GroupCommunication.log("viewChanged callback exception: ", exception);
                    }
                }
                catch (Error error) {
                    if (!GroupCommunication.shouldLog(3)) break block17;
                    GroupCommunication.log("viewChanged callback error: ", error);
                }
            }
            deliver_lock.acquireWriteLock();
            MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
            Vector vector2 = messageBuffer.getUnDeliverableMsgs();
            if (vector2 != null) {
                ListIterator listIterator = vector2.listIterator();
                while (listIterator.hasNext()) {
                    Packet packet = (Packet)listIterator.next();
                    listIterator.remove();
                    if (bl && packet.isAtomic()) {
                        messageBuffer.save(packet);
                    }
                    Receiver.deliver(packet, messageBuffer);
                }
            }
            deliver_lock.releaseWriteLock();
        }
        object = flush_lock;
        synchronized (flush_lock) {
            flushing = false;
            flushedFlags = null;
            flushInfoVector = null;
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return;
        }
    }

    static View currentAddrList(String string) {
        int n = viewCounter + 1;
        View view = new View(n, 0, Transport.getAddrList());
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static View newView(String string, Address address, boolean bl) throws InterruptedException, GroupException {
        ++viewCounter;
        latestview_lock.acquireReadLock();
        View view = latestViewInfo.getView();
        latestview_lock.releaseReadLock();
        if (view == null) {
            if (GroupCommunication.shouldLog(3)) {
                GroupCommunication.log("Internal Error: view is null in newView.");
            }
            throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_VIEWNULL);
        }
        Vector<Address> vector = new Vector<Address>(view.getMembers());
        if (bl) {
            vector.add(address);
        } else {
            vector.remove(address);
        }
        view = new View(viewCounter, 0, vector);
        ViewInfo viewInfo = (ViewInfo)unDeliverableViewInfo.get(new Integer(viewCounter));
        if (viewInfo != null) {
            viewInfo.init(view);
        } else {
            viewInfo = new ViewInfo(view);
            unDeliverableViewInfo.put(new Integer(viewCounter), viewInfo);
        }
        latestview_lock.acquireWriteLock();
        latestViewInfo = viewInfo;
        latestview_lock.releaseWriteLock();
        byte[] byArray = flush_lock;
        synchronized (flush_lock) {
            flushing = true;
            flushedFlags = new BitSet(view.size());
            flushedFlags.set(0);
            flushInfoVector = new Vector(view.size());
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return viewInfo.getView();
        }
    }

    static ViewInfo getViewInfo(String string, int n) throws GroupException, InterruptedException {
        ViewInfo viewInfo = null;
        curview_lock.acquireReadLock();
        if (n == curViewInfo.getView().getVid()) {
            viewInfo = curViewInfo;
        }
        curview_lock.releaseReadLock();
        if (viewInfo == null) {
            ViewInfo viewInfo2 = (ViewInfo)unDeliverableViewInfo.get(new Integer(n));
            if (viewInfo2 != null) {
                viewInfo = viewInfo2;
            } else {
                latestview_lock.acquireReadLock();
                int n2 = latestViewInfo.getView().getVid();
                latestview_lock.releaseReadLock();
                if (n > n2) {
                    viewInfo2 = new ViewInfo(n);
                    unDeliverableViewInfo.put(new Integer(n), viewInfo2);
                    viewInfo = viewInfo2;
                }
            }
        }
        return viewInfo;
    }

    static void viewChanged(View view, View view2) {
        if (GroupCommunication.shouldLog(15)) {
            GroupCommunication.log("Deliver view change. oldView:" + view + ", newView:" + view2);
        }
        if (GroupCommunication.shouldLog(7) && view != null && view2 != null) {
            GroupCommunication.log("Deliver view change. old:" + view.getVid() + ", new:" + view2.getVid());
        }
        Enumeration enumeration = Transport.receivingQList.elements();
        while (enumeration.hasMoreElements()) {
            MessageQueue messageQueue = (MessageQueue)enumeration.nextElement();
            messageQueue.enqueue(new GroupMessage(1, new ViewChange(view, view2)));
        }
    }

    static Vector getUnDeliverableMsgInfo() throws InterruptedException {
        Packet packet;
        curview_lock.acquireReadLock();
        MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
        curview_lock.releaseReadLock();
        Vector<MsgInfo> vector = new Vector<MsgInfo>();
        Vector vector2 = messageBuffer.getUnDeliverableMsgs();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            packet = (Packet)enumeration.nextElement();
            if (!packet.isAtomic()) continue;
            vector.add(new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber()));
        }
        Enumeration enumeration2 = unDeliverableViewInfo.elements();
        while (enumeration2.hasMoreElements()) {
            ViewInfo viewInfo = (ViewInfo)enumeration2.nextElement();
            vector2 = viewInfo.getMessageBuffer().getUnDeliverableMsgs();
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                packet = (Packet)enumeration.nextElement();
                if (!packet.isAtomic()) continue;
                vector.add(new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber()));
            }
        }
        return vector;
    }

    static Vector getUnDeliverableMsgList() throws InterruptedException {
        curview_lock.acquireReadLock();
        MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
        curview_lock.releaseReadLock();
        Vector vector = new Vector();
        vector.addAll(messageBuffer.getUnDeliverableMsgs());
        Enumeration enumeration = unDeliverableViewInfo.elements();
        while (enumeration.hasMoreElements()) {
            ViewInfo viewInfo = (ViewInfo)enumeration.nextElement();
            Vector vector2 = viewInfo.getMessageBuffer().getUnDeliverableMsgs();
            vector.addAll(vector2);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isFlushing() {
        byte[] byArray = flush_lock;
        synchronized (flush_lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return flushing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BitSet getFlushedFlags() {
        byte[] byArray = flush_lock;
        synchronized (flush_lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return flushedFlags;
        }
    }

    static void flush(Packet packet) throws GroupException, IOException, InterruptedException {
        block7: {
            Packet packet2;
            Packet packet3;
            long[] lArray = packet.getReceiveArray();
            long l = packet.getReceivedTONumber();
            if (initializing) {
                initializing = false;
                Packet packet4 = new Packet(15, 0, Transport.getLocalAddress(), FailureDetector.getCoordinator(), null);
                Transport.send(packet4);
                return;
            }
            curview_lock.acquireReadLock();
            MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
            View view = curViewInfo.getView();
            curview_lock.releaseReadLock();
            Address address = FailureDetector.getCoordinator();
            ListIterator listIterator = messageBuffer.getUnstableMsgs();
            while (listIterator.hasNext()) {
                packet3 = (Packet)listIterator.next();
                if (lArray != null && lArray.length > packet3.getSenderIndex() && packet3.getSerialNumber() <= lArray[packet3.getSenderIndex()] || address.equals((Address)packet3.getSourceAddress())) continue;
                packet2 = new Packet(13, 0, Transport.getLocalAddress(), address, packet3);
                Transport.send(packet2);
            }
            listIterator = messageBuffer.getTotalOrderedMsgList().listIterator();
            while (listIterator.hasNext()) {
                packet3 = (Packet)listIterator.next();
                if (packet3.getSequenceNumber() <= l || address.equals((Address)packet3.getSourceAddress())) continue;
                packet2 = new Packet(13, 0, Transport.getLocalAddress(), address, packet3);
                Transport.send(packet2);
            }
            Vector vector = packet.getUnDeliverableMsgList();
            Enumeration enumeration = unDeliverableViewInfo.elements();
            while (enumeration.hasMoreElements()) {
                ViewInfo viewInfo = (ViewInfo)enumeration.nextElement();
                Vector vector2 = viewInfo.getMessageBuffer().getUnDeliverableMsgs();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    MsgInfo msgInfo;
                    packet3 = (Packet)enumeration2.nextElement();
                    if (!packet3.isAtomic() || vector.contains(msgInfo = new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber())) || address.equals((Address)packet3.getSourceAddress())) continue;
                    packet2 = new Packet(13, 0, Transport.getLocalAddress(), FailureDetector.getCoordinator(), packet3);
                    Transport.send(packet2);
                }
            }
            packet2 = new Packet(15, 0, Transport.getLocalAddress(), FailureDetector.getCoordinator(), null);
            packet2.setReceiveArray(messageBuffer.getReceiveVector());
            packet2.setUnDeliverableMsgList(GroupManager.getUnDeliverableMsgInfo());
            packet2.setReceivedTONumber(messageBuffer.getReceivedTONumber());
            try {
                Transport.send(packet2);
            }
            catch (Exception exception) {
                if (!GroupCommunication.shouldLog(6) || !GroupCommunication.isReady()) break block7;
                GroupCommunication.log("Warning: Can't send a FLUSH message.", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endFlush(Packet packet) throws GroupException, IOException, InterruptedException {
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = new Vector();
        long l = -1L;
        Vector<Packet> vector4 = new Vector<Packet>();
        Object object = flush_lock;
        synchronized (flush_lock) {
            Serializable serializable;
            if (flushedFlags != null) {
                flushedFlags.set(packet.getSenderIndex());
                serializable = new FlushInfo((Address)packet.getSourceAddress(), packet.getReceiveVector(), packet.getUnDeliverableMsgList(), packet.getReceivedTONumber());
                flushInfoVector.add(serializable);
            } else if (GroupCommunication.shouldLog(3)) {
                GroupCommunication.log("Internal Error: flushedFlags is null.");
            }
            // ** MonitorExit[var13_6] (shouldn't be in output)
            latestview_lock.acquireReadLock();
            try {
                object = latestViewInfo.getView();
                serializable = ((View)object).getMembers();
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    if (flushedFlags.get(i)) continue;
                    return;
                }
            }
            finally {
                latestview_lock.releaseReadLock();
            }
            curview_lock.acquireReadLock();
            View view = curViewInfo.getView();
            MessageBuffer messageBuffer = curViewInfo.getMessageBuffer();
            curview_lock.releaseReadLock();
            object = flushInfoVector.listIterator();
            serializable = messageBuffer.getUnStableMsgMatrix();
            Vector vector5 = GroupManager.getUnDeliverableMsgList();
            Vector vector6 = messageBuffer.getTotalOrderedMsgList();
            while (object.hasNext()) {
                Enumeration enumeration;
                Packet packet2;
                FlushInfo flushInfo = (FlushInfo)object.next();
                if (flushInfo != null) {
                    vector = flushInfo.receiveVector;
                    vector2 = flushInfo.unDeliverableVector;
                    l = flushInfo.totalOrderedMsgNumber;
                }
                int n = view.getMembers().indexOf(flushInfo.source);
                if (vector != null) {
                    for (int i = 0; i < vector.size() && i < ((Serializable)serializable).length; ++i) {
                        ListIterator listIterator = serializable[i].listIterator();
                        while (listIterator.hasNext() && i != n) {
                            Packet packet3 = (Packet)listIterator.next();
                            if ((Long)vector.elementAt(i) >= packet3.getSerialNumber()) continue;
                            packet2 = new Packet(14, 0, Transport.getLocalAddress(), flushInfo.source, packet3);
                            try {
                                Transport.send(packet2);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    enumeration = vector6.elements();
                    while (enumeration.hasMoreElements()) {
                        packet2 = (Packet)enumeration.nextElement();
                        if (packet2.getSequenceNumber() <= l) continue;
                        packet2 = new Packet(14, 0, Transport.getLocalAddress(), flushInfo.source, packet2);
                        try {
                            Transport.send(packet2);
                        }
                        catch (Exception exception) {}
                    }
                }
                enumeration = vector5.elements();
                while (enumeration.hasMoreElements()) {
                    packet2 = (Packet)enumeration.nextElement();
                    if (!packet2.isAtomic()) continue;
                    MsgInfo msgInfo = new MsgInfo(packet2.getVid(), packet2.getSenderIndex(), packet2.getSerialNumber());
                    if (vector2 == null || packet2 == null || vector2.contains(msgInfo) || packet2.getSenderIndex() == n) continue;
                    packet2 = new Packet(14, 0, Transport.getLocalAddress(), flushInfo.source, packet2);
                    try {
                        Transport.send(packet2);
                    }
                    catch (Exception exception) {}
                }
                if (n == 0) continue;
                packet2 = new Packet(16, 0, Transport.getLocalAddress(), flushInfo.source, null);
                packet2.setReceiveArray(messageBuffer.getReceiveVector());
                packet2.setReceivedTONumber(messageBuffer.getReceivedTONumber());
                vector4.addElement(packet2);
            }
            GroupManager.updateView(SYSTEM_GROUP);
            for (int i = 0; i < vector4.size(); ++i) {
                Packet packet4 = null;
                try {
                    packet4 = (Packet)vector4.elementAt(i);
                    Transport.send(packet4);
                    continue;
                }
                catch (Exception exception) {
                    if (!GroupCommunication.shouldLog(10)) continue;
                    GroupCommunication.log("Unable to send " + packet4 + ". " + exception.getMessage());
                }
            }
            return;
        }
    }

    static void releaseCurrentViewLock(String string, boolean bl) {
        block4: {
            try {
                if (bl) {
                    GroupManager.getCurrentViewInfoRWLock(string).releaseReadLock();
                } else {
                    GroupManager.getCurrentViewInfoRWLock(string).releaseWriteLock();
                }
            }
            catch (Exception exception) {
                if (!GroupCommunication.shouldLog(10)) break block4;
                GroupCommunication.log("Unable to release view lock: ", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer getOldestViewIdFrom(Hashtable hashtable) {
        Integer n = null;
        if (hashtable != null) {
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                if (hashtable.size() > 0) {
                    Set set = hashtable.keySet();
                    TreeSet treeSet = new TreeSet(set);
                    n = (Integer)treeSet.first();
                }
            }
        }
        return n;
    }

    static {
        flushcounter = 0;
        viewCounter = 0;
        latestViewInfo = new ViewInfo(-1);
        curViewInfo = new ViewInfo(-1);
        unDeliverableViewInfo = new Hashtable();
        initializing = true;
    }
}

