/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.TimeElement;

class TimeQ {
    TimeElement head = null;
    TimeElement tail = null;
    int count = 0;
    boolean iamworking = true;

    TimeQ() {
    }

    synchronized TimeElement getNext() {
        if (this.head == null) {
            return null;
        }
        TimeElement timeElement = this.head;
        this.head = this.head.next;
        if (this.head != null) {
            this.head.prev = null;
        }
        --this.count;
        return timeElement;
    }

    long getNextTime() {
        if (this.head == null) {
            return 0L;
        }
        return this.head.expireTime;
    }

    synchronized void putTimeElement(TimeElement timeElement) {
        if (this.head == null) {
            this.head = timeElement;
            this.tail = timeElement;
            this.wakeup();
        } else {
            TimeElement timeElement2 = this.tail;
            while (timeElement2 != null && timeElement2.expireTime > timeElement.expireTime) {
                timeElement2 = timeElement2.prev;
            }
            if (timeElement2 == null) {
                timeElement.next = this.head;
                this.head.prev = timeElement;
                this.head = timeElement;
                this.wakeup();
            } else {
                timeElement.next = timeElement2.next;
                timeElement.prev = timeElement2;
                if (timeElement2.next != null) {
                    timeElement2.next.prev = timeElement;
                }
                timeElement2.next = timeElement;
            }
            if (timeElement2 == this.tail) {
                this.tail = timeElement;
            }
        }
        ++this.count;
    }

    synchronized void removeElement(long l) {
        TimeElement timeElement = this.head;
        while (timeElement != null && timeElement.objid != l) {
            timeElement = timeElement.next;
        }
        if (timeElement != null) {
            if (timeElement == this.head) {
                this.head = timeElement.next;
            }
            if (timeElement == this.tail) {
                this.tail = timeElement.prev;
            }
            if (timeElement.next != null) {
                timeElement.next.prev = timeElement.prev;
            }
            if (timeElement.prev != null) {
                timeElement.prev.next = timeElement.next;
            }
            --this.count;
        }
        timeElement = null;
    }

    synchronized void flush() {
        this.head = null;
        this.tail = null;
        this.count = 0;
    }

    void printQ() {
        TimeElement timeElement = this.head;
        while (timeElement != null) {
            timeElement.printElement();
            timeElement = timeElement.next;
        }
    }

    synchronized void waitForWork(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void wakeup() {
        this.notifyAll();
    }

    synchronized void rest() {
        this.iamworking = false;
    }

    synchronized boolean isWorking() {
        return this.iamworking;
    }
}

