/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.Serializable;
import oracle.ias.cache.CacheEvent;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.Message;
import oracle.ias.cache.Net;
import oracle.ias.cache.ObjectReq;
import oracle.ias.cache.TaskQ;
import oracle.ias.cache.UpdateMessage;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.ViewChange;

class Task
implements Serializable {
    static final long serialVersionUID = 8570680506499807241L;
    static final int RESPOND = 1;
    static final int INVALIDATE = 2;
    static final int UPDATE = 3;
    static final int TODISK = 5;
    static final int DISKUPDATE = 6;
    static final int NETSEARCH = 7;
    static final int SEARCHRESULT = 8;
    static final int GETLOCK = 9;
    static final int RESPLOCK = 10;
    static final int NEWVIEW = 11;
    static final int SEARCHRESULTLIST = 12;
    static final int CACHEWATCH = 13;
    static final int DISKSEARCH = 14;
    static final int FLUSH = 15;
    static final int CLEANLOCK = 16;
    static final int DISABLE = 17;
    static final int ENABLE = 18;
    static final int DISKMAP = 19;
    static final int REMOTEUPDATE = 20;
    static final int REMOTEREQUEST = 21;
    static final int NETSEARCHLIST = 22;
    static final int ASYNCLOAD = 31;
    static final int INVOBJEVENT = 32;
    static final int DESTROY = 33;
    static final int OBJEVENT = 34;
    static final int GROUPMESSAGE = 41;
    static final int DEATHDETECTION = 51;
    static final int CLEANDISK = 52;
    static final int TASK_MAX_INDEX = 53;
    static final String[] TASK_NAMES = new String[53];
    int taskType;
    Object info;
    long id;
    long maxWaitTime;
    transient Object replyAddr;
    transient long[] receivedVector;
    transient int viewId;
    transient Task prev;
    transient Task next;
    transient boolean session;
    transient boolean self;

    Task(int n, Object object) {
        this.taskType = n;
        this.info = object;
        this.id = 0L;
        this.session = false;
        this.self = false;
        this.maxWaitTime = 0L;
    }

    Task(int n, Object object, boolean bl) {
        this.taskType = n;
        this.info = object;
        this.id = 0L;
        this.session = bl;
        this.maxWaitTime = 0L;
    }

    Task(int n, Object object, long l) {
        this.taskType = n;
        this.info = object;
        this.id = l;
        this.session = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void execute() throws CacheException {
        block33: {
            CacheHandle cacheHandle;
            block32: {
                cacheHandle = null;
                if ((CacheInternal.flags & 1) == 0) {
                    return;
                }
                if (CacheInternal.shouldLog(15)) {
                    CacheInternal.logger.log("[CMg] execute: " + this);
                }
                try {
                    block31: {
                        if (this.taskType == 41) {
                            GroupMessage groupMessage = (GroupMessage)this.info;
                            switch (groupMessage.type) {
                                case 0: {
                                    Packet packet = (Packet)groupMessage.messageInfo;
                                    Task task = (Task)packet.getMessage();
                                    task.replyAddr = packet.getSourceAddress();
                                    task.self = packet.isFromMyself();
                                    task.receivedVector = packet.getReceiveArray();
                                    task.viewId = packet.getVid();
                                    if (task.info instanceof UpdateMessage) {
                                        UpdateMessage updateMessage = (UpdateMessage)task.info;
                                        if ((updateMessage.objectType & 0x2001000L) != 0L) {
                                            updateMessage.updateObj = packet.getAttachedFileName();
                                        }
                                    }
                                    Net.receive(task);
                                    break;
                                }
                                case 1: {
                                    ViewChange viewChange = (ViewChange)groupMessage.messageInfo;
                                    Net.resetView(viewChange.oldView, viewChange.newView);
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            break block31;
                        }
                        cacheHandle = CacheHandleQ.getHandle();
                        switch (this.taskType) {
                            case 33: {
                                cacheHandle.invalidate(this.id, false, true, false);
                                break;
                            }
                            case 2: {
                                cacheHandle.invalidate(this.id, false, false, false);
                                break;
                            }
                            case 1: {
                                Message message = (Message)this.info;
                                if (CacheInternal.respQ.record(message.messageId, message.senderId, (int)message.objectType, message.exception, message.cacheName, message.qualifier)) break;
                                CacheInternal.asyncTaskQ.putTask(this);
                                Thread.yield();
                                break;
                            }
                            case 10: {
                                Message message = (Message)this.info;
                                if (CacheInternal.respQ.awaitOwnership(message.messageId, message.senderId, this.self, (int)message.objectType)) break;
                                CacheInternal.asyncTaskQ.putTask(this);
                                Thread.yield();
                                break;
                            }
                            case 5: {
                                Mdslot mdslot = (Mdslot)this.info;
                                cacheHandle.spoolDisk(mdslot);
                                break;
                            }
                            case 8: 
                            case 12: {
                                UpdateMessage updateMessage = (UpdateMessage)this.info;
                                if (CacheInternal.respQ.record(updateMessage.messageId, updateMessage.senderId, (int)updateMessage.objectType, updateMessage.exception, updateMessage.cacheName, updateMessage.qualifier)) break;
                                CacheInternal.asyncTaskQ.putTask(this);
                                Thread.yield();
                                break;
                            }
                            case 34: {
                                CacheEvent cacheEvent = (CacheEvent)this.info;
                                cacheEvent.listener.handleEvent(cacheEvent);
                                break;
                            }
                            case 31: {
                                ObjectReq objectReq = (ObjectReq)this.info;
                                cacheHandle.asyncLoad(objectReq);
                                break;
                            }
                            case 16: {
                                CacheInternal.cleanLock();
                                break;
                            }
                            case 51: {
                                CacheInternal.deathDetect();
                                break;
                            }
                            case 52: {
                                CacheInternal.freeDisk();
                                break;
                            }
                        }
                    }
                    Object var10_15 = null;
                    if (cacheHandle == null) break block32;
                }
                catch (Throwable throwable) {
                    Object var10_18 = null;
                    if (cacheHandle != null) {
                        CacheHandleQ.releaseHandle(cacheHandle);
                    }
                    TaskQ.getInstance().endDeliver(this);
                    throw throwable;
                }
                CacheHandleQ.releaseHandle(cacheHandle);
            }
            TaskQ.getInstance().endDeliver(this);
            {
                break block33;
                catch (Exception exception) {
                    CacheInternal.logger.log("[CMg] ", exception);
                    CacheInternal.logger.flush();
                    Object var10_16 = null;
                    if (cacheHandle != null) {
                        CacheHandleQ.releaseHandle(cacheHandle);
                    }
                    TaskQ.getInstance().endDeliver(this);
                    break block33;
                }
                catch (Error error) {
                    CacheInternal.logger.log("[CMg] ", error);
                    CacheInternal.logger.flush();
                    Object var10_17 = null;
                    if (cacheHandle != null) {
                        CacheHandleQ.releaseHandle(cacheHandle);
                    }
                    TaskQ.getInstance().endDeliver(this);
                }
            }
        }
    }

    void setWaitTime(long l) {
        this.maxWaitTime = l;
    }

    void update(int n, Object object) {
        this.taskType = n;
        this.info = object;
    }

    String getName() {
        if (this.taskType >= 0 && this.taskType < 53) {
            return TASK_NAMES[this.taskType];
        }
        return "Unknown";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("taskType=");
        stringBuffer.append(this.getName());
        if (this.info != null) {
            stringBuffer.append(", info=");
            stringBuffer.append(this.info.toString());
        }
        return stringBuffer.toString();
    }

    static {
        Task.TASK_NAMES[1] = "RESPOND";
        Task.TASK_NAMES[2] = "INVALIDATE";
        Task.TASK_NAMES[3] = "UPDATE";
        Task.TASK_NAMES[5] = "TODISK";
        Task.TASK_NAMES[6] = "DISKUPDATE";
        Task.TASK_NAMES[7] = "NETSEARCH";
        Task.TASK_NAMES[8] = "SEARCHRESULT";
        Task.TASK_NAMES[9] = "GETLOCK";
        Task.TASK_NAMES[10] = "RESPLOCK";
        Task.TASK_NAMES[11] = "NEWVIEW";
        Task.TASK_NAMES[12] = "SEARCHRESULTLIST";
        Task.TASK_NAMES[13] = "CACHEWATCH";
        Task.TASK_NAMES[14] = "DISKSEARCH";
        Task.TASK_NAMES[15] = "FLUSH";
        Task.TASK_NAMES[16] = "CLEANLOCK";
        Task.TASK_NAMES[17] = "DISABLE";
        Task.TASK_NAMES[18] = "ENABLE";
        Task.TASK_NAMES[19] = "DISKMAP";
        Task.TASK_NAMES[20] = "REMOTEUPDATE";
        Task.TASK_NAMES[21] = "REMOTEREQUEST";
        Task.TASK_NAMES[22] = "NETSEARCHLIST";
        Task.TASK_NAMES[31] = "ASYNCLOAD";
        Task.TASK_NAMES[32] = "INVOBJEVENT";
        Task.TASK_NAMES[33] = "DESTROY";
        Task.TASK_NAMES[34] = "OBJEVENT";
        Task.TASK_NAMES[41] = "GROUPMESSAGE";
        Task.TASK_NAMES[51] = "DEATHDETECTION";
        Task.TASK_NAMES[52] = "CLEANDISK";
    }
}

