/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ias.cache.Cache;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInfoComp;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheObjectInfo;
import oracle.ias.cache.CacheSorter;
import oracle.ias.cache.Configurator;
import oracle.ias.cache.Message;
import oracle.ias.cache.Net;
import oracle.ias.cache.Task;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;

public class CacheWatchUtil {
    private static final String PROMPT = "cache> ";
    private final int NET_TIMEOUT = 60000;
    private final String SERVLETFONT = "<font face=\"Verdana\" size=-3>";
    private final String SERVLETTITLEFONT = "<font face=\"Verdana\" size=-3 color=\"ffffff\">";
    private final String OBJLISTTITLE = " REGION   OBJNAME   GROUP   TYPE   REFCNT   ACCCNT   EXPIRE   VALID   LOCK\n-------- --------- ------- ------ -------- -------- -------- ------- ------\n";
    private final Hashtable emptyParameters = new Hashtable();
    public static final String CACHEID_ = "cacheid";
    public static final String REGION_ = "region";
    public static final String OBJECT_ = "object";
    public static final String SORT_ = "sort";
    public static final String CONFIG_ = "config";
    public static final String LISTOBJ_ = "listobj";
    public static final String ACTION_PARAM_ = "Action";
    public static final String DUMP_ = "dump";
    public static final String INVALIDATE_ = "invalidate";
    public static final String DESTROY_ = "destroy";
    public static final String LOGSEVERITY_ = "severity";
    public static final int SORTBY_REGION_ = 0;
    public static final int SORTBY_NAME_ = 1;
    public static final int SORTBY_GROUP_ = 2;
    public static final int SORTBY_TYPE_ = 3;
    public static final int SORTBY_VALID_ = 4;
    public static final int SORTBY_REFCOUNT_ = 5;
    public static final int SORTBY_ACCESSES_ = 6;
    public static final int SORTBY_EXPIRED_ = 7;
    public static final int SORTBY_LOCK_ = 8;
    private InputStream in_ = System.in;
    private PrintStream out_ = null;
    private PrintStream err_out_ = null;
    private Address localCacheAddr_ = null;
    private int timeout_ = 60000;

    public CacheWatchUtil() {
        this.out_ = System.out;
        this.err_out_ = System.err;
        this.localCacheAddr_ = this.getLocalAddress();
    }

    public CacheWatchUtil(PrintStream printStream, PrintStream printStream2) {
        this.out_ = printStream;
        this.err_out_ = printStream2;
        this.localCacheAddr_ = this.getLocalAddress();
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("-config=")) {
                    string = stringArray[i].substring(8);
                }
                if (!stringArray[i].startsWith("-help")) continue;
                CacheWatchUtil.programUsage();
                return;
            }
            CacheAttributes cacheAttributes = new CacheAttributes();
            if (string != null) {
                int n = string.lastIndexOf("xml");
                if (n > 0 && n == string.length() - 3) {
                    Configurator configurator = null;
                    configurator = new Configurator(string, false);
                    cacheAttributes = configurator.getCacheAttributes();
                } else {
                    cacheAttributes.readConfig(string, false);
                }
            }
            cacheAttributes.maxIdleTime = 3600;
            Cache.init(cacheAttributes);
            CacheWatchUtil cacheWatchUtil = new CacheWatchUtil();
            cacheWatchUtil.execute(stringArray);
            Cache.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void programUsage() {
        System.out.println("Java Object Cache CacheWatch Utility V1.00.01\n---------------------------------\nUsage: java oracle.ias.cache.CacheWatchUtil [-config=configFileName] [-help]\n where \n  -config=configFileName: define cache configuration file\n  -help: Display this helpl");
    }

    public void execute(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in_));
        String string = null;
        do {
            this.out_.print(PROMPT);
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                this.err_out_.println("read input error!");
                iOException.printStackTrace(this.err_out_);
                break;
            }
        } while (string != null && !this.commandProcess(string));
    }

    public void commandUsage() {
        this.out_.println("Usage:\n list caches : print reachable Cache(s) info including CacheId(s)\n lc : shortcut for \"list caches\"\n list objects [CacheId] [region=<region>] [sort=<0..7>]: print objects list\n lo [CacheId] [region=<region>] [sort=<0..7>]: shortcut for \"list objects\"\n   0: By region name\n   1: By object name\n   2: By group name\n   3: By object type\n   4: By valid status\n   5: By reference count\n   6: By access count\n   7: By expiration\n set severity=n [CacheId] : set logger severity to n\n set timeout=n : set Group Communication timeout value to n\n get config [CacheId] : get configuration info\n dump [CacheId] : cause Cache(s) dump its contents to the logger\n invalidate: cause Cache to invalidate all objects in the cache\n destroy: cause Cache to destroy all objects in the cache\n help or ? : Display this help\n quit or exit: quit");
    }

    public boolean commandProcess(String string) {
        if ((string = string.trim()).equals("")) {
            return false;
        }
        if (string.equals("quit") || string.equals("exit")) {
            return true;
        }
        if (string.equals("help") || string.equals("?")) {
            this.commandUsage();
            return false;
        }
        if (string.equals("list caches") || string.equals("lc")) {
            this.out_.println(this.listCaches());
            return false;
        }
        if (string.startsWith("list objects")) {
            this.out_.println(this.listObjects(this.genParameters(string.substring(12))));
            return false;
        }
        if (string.startsWith("lo")) {
            this.out_.println(this.listObjects(this.genParameters(string.substring(2))));
            return false;
        }
        if (string.startsWith("set ")) {
            this.out_.println(this.netset(this.genParameters(string.substring(4)), false, null));
            return false;
        }
        if (string.startsWith("get ")) {
            this.out_.println(this.netget(this.genParameters(string.substring(4)), false, null));
            return false;
        }
        if (string.startsWith(DUMP_)) {
            this.out_.println(this.netdump(this.genParameters(string.substring(4)), false, null));
            return false;
        }
        if (string.startsWith("groupdump")) {
            this.out_.println(this.groupdump(this.genParameters(string.substring(4)), false, null));
            return false;
        }
        if (string.startsWith(INVALIDATE_)) {
            this.out_.println(this.invalidate(false));
            return false;
        }
        if (string.startsWith(DESTROY_)) {
            this.out_.println(this.destroy(false));
            return false;
        }
        this.err_out_.println("unknown command: " + string);
        return false;
    }

    private Hashtable genParameters(String string) {
        if (string == null || string.equals("")) {
            return this.emptyParameters;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object[] objectArray;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                try {
                    int n2 = Integer.parseInt(string2);
                    if (hashtable.containsKey(CACHEID_)) {
                        objectArray = (int[])hashtable.get(CACHEID_);
                        object = new int[objectArray.length + 1];
                        System.arraycopy(objectArray, 0, object, 0, objectArray.length);
                        object[objectArray.length] = n2;
                    } else {
                        object = new int[]{n2};
                    }
                    hashtable.put(CACHEID_, object);
                }
                catch (NumberFormatException numberFormatException) {
                    if (hashtable.containsKey(string2)) continue;
                    hashtable.put(string2, "");
                }
                continue;
            }
            String string3 = string2.substring(0, n);
            object = string2.substring(n + 1);
            if (hashtable.containsKey(string3)) {
                String[] stringArray = (String[])hashtable.get(string3);
                objectArray = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
                objectArray[stringArray.length] = (int)object;
            } else {
                objectArray = new String[1];
                objectArray[0] = (int)object;
            }
            hashtable.put(string3, objectArray);
        }
        return hashtable;
    }

    public String listCaches() {
        return this.listCaches(false, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listCaches(boolean bl, String string, boolean bl2) {
        String string2 = null;
        try {
            if (!bl) {
                string2 = "Current coordinator: " + FailureDetector.getCoordinator() + "\n\n";
                string2 = string2 + "#\tUID\tCacheAddress\n-\t---\t---------------------\n";
            } else {
                string2 = "<table BORDER=3 CELLPADDING=3 WIDTH=\"100%\"><tr bgcolor=\"666666\"><td><font face=\"Verdana\" size=-3 color=\"ffffff\">CacheId</font></td><td><font face=\"Verdana\" size=-3 color=\"ffffff\">CacheAddress</font></td></tr>\n";
            }
            if (CacheInternal.cAttr.distribute) {
                Vector vector = Net.chan.getView().getMembers();
                for (int i = 0; i < vector.size(); ++i) {
                    Address address = (Address)vector.elementAt(i);
                    if (!bl) {
                        string2 = string2 + (i + 1) + "\t" + address.getPosition() + "\t" + address.getString() + (this.localCacheAddr_.equals(address) ? "\t<-- this cache watcher" : "") + (address.getUserDefinedId() != null ? "\t" + address.getUserDefinedId() : "") + "\n";
                        continue;
                    }
                    String string3 = "";
                    string3 = bl2 ? CONFIG_ : LISTOBJ_;
                    string2 = string2 + "<tr><td><font face=\"Verdana\" size=-3><a href=\"" + string + "?" + ACTION_PARAM_ + "=" + string3 + "#" + CACHEID_ + address.getPosition() + "\">" + address.getPosition() + "</a></font></td><td>" + "<font face=\"Verdana\" size=-3>" + address.getString() + "</font></td></tr>\n";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.err_out_);
        }
        finally {
            if (bl) {
                string2 = string2 + "</table>\n";
            }
        }
        return string2;
    }

    public String listObjects(Hashtable hashtable) {
        return this.listObjects(hashtable, false, null);
    }

    public String listObjects(Hashtable hashtable, boolean bl, String string) {
        Vector<String> vector = null;
        String string2 = "";
        String string3 = null;
        String string4 = null;
        int n = -1;
        Address address = null;
        if (hashtable.containsKey(CACHEID_)) {
            address = this.getCacheAddress(((int[])hashtable.get(CACHEID_))[0]);
        }
        if (hashtable.containsKey(REGION_)) {
            string3 = ((String[])hashtable.get(REGION_))[0];
        }
        if (hashtable.containsKey(OBJECT_)) {
            string4 = ((String[])hashtable.get(OBJECT_))[0];
        }
        if (hashtable.containsKey(SORT_)) {
            try {
                n = Integer.parseInt(((String[])hashtable.get(SORT_))[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (address != null && address.equals(this.localCacheAddr_)) {
            vector = new Vector<String>();
            vector.addElement(CacheInternal.dumpToString(string3));
        } else {
            vector = this.netListObjects(string3, n, address);
        }
        if (vector == null) {
            return "Cache service is unavailable.";
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object e = vector.elementAt(i);
            if (!(e instanceof String)) continue;
            Vector vector2 = this.objsInfoStringToList((String)e);
            String string5 = (String)vector2.firstElement();
            vector2.removeElementAt(0);
            int n2 = string5.indexOf("@");
            String string6 = string5.substring(0, n2);
            string5 = string5.substring(n2 + 1);
            if (n != -1) {
                object = new CacheInfoComp(n);
                CacheWatchUtil.sort(vector2, (CacheInfoComp)object);
            }
            object = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (!CacheInternal.cAttr.distribute) {
                string5 = this.localCacheAddr_.toString();
                string6 = "0";
            }
            if (!bl) {
                stringBuffer.append("Cache " + string6 + " at " + string5 + "\n\n" + " REGION   OBJNAME   GROUP   TYPE   REFCNT   ACCCNT   EXPIRE   VALID   LOCK\n-------- --------- ------- ------ -------- -------- -------- ------- ------\n");
            } else {
                stringBuffer.append("<a name=\"cacheid" + string6 + "\"></a><b>" + "<font face=\"Verdana\" size=-3>" + "Cache " + string6 + " at " + string5 + "</font></b> ");
                stringBuffer.append("<font face=\"Verdana\" size=-3><a href=\"" + string + "?" + ACTION_PARAM_ + "=" + LISTOBJ_ + "#" + CACHEID_ + string6 + "\">Show all regions</a> | " + "</font>\n");
                stringBuffer.append("<font face=\"Verdana\" size=-3><a href=\"" + string + "?" + ACTION_PARAM_ + "=" + CONFIG_ + "#" + CACHEID_ + string6 + "\">Cache Configuration</a> | " + "</font>\n");
                stringBuffer.append("<br><table  BORDER=3 CELLPADDING=3 WIDTH=\"100%\">");
                stringBuffer.append(this.getObjListHeader(string, string6));
            }
            for (int j = 0; j < vector2.size(); ++j) {
                object = (CacheObjectInfo)vector2.elementAt(j);
                if (string4 != null && !string4.equals(((CacheObjectInfo)object).name)) continue;
                if (!bl) {
                    stringBuffer.append("[").append(((CacheObjectInfo)object).region).append("]\t[");
                    stringBuffer.append(((CacheObjectInfo)object).name);
                    stringBuffer.append("]\t[").append(((CacheObjectInfo)object).group).append("]\t");
                    stringBuffer.append(((CacheObjectInfo)object).type);
                    stringBuffer.append("\t" + ((CacheObjectInfo)object).refcount).append("\t");
                    stringBuffer.append(((CacheObjectInfo)object).accesses);
                    stringBuffer.append("\t").append(((CacheObjectInfo)object).expire).append("\t");
                    stringBuffer.append(((CacheObjectInfo)object).valid).append("\t");
                    stringBuffer.append(((CacheObjectInfo)object).ownerInfo).append("\n");
                    continue;
                }
                stringBuffer.append("<tr><td><font face=\"Verdana\" size=-3><a href=\"" + string + "?" + REGION_ + "=" + ((CacheObjectInfo)object).region + "&" + ACTION_PARAM_ + "=" + LISTOBJ_ + "#" + CACHEID_ + string6 + "\">" + ((CacheObjectInfo)object).region + "</a></font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3><a href=\"" + string + "?" + REGION_ + "=" + ((CacheObjectInfo)object).region + "&" + OBJECT_ + "=" + ((CacheObjectInfo)object).name + "&" + ACTION_PARAM_ + "=" + LISTOBJ_ + "#" + CACHEID_ + string6 + "\">" + ((CacheObjectInfo)object).name + "</a>" + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).group + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).type + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).refcount + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).accesses + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).expire + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).valid + "</font></td>");
                stringBuffer.append("<td><font face=\"Verdana\" size=-3>" + ((CacheObjectInfo)object).ownerInfo + "</font></td></tr>\n");
            }
            if (bl) {
                stringBuffer.append("</table><font face=\"Verdana\" size=-3><a href=\"#top\">Go to top</a></font><P>\n");
            }
            string2 = string2 + "\n" + stringBuffer.toString();
        }
        return string2;
    }

    private String getObjListHeader(String string, String string2) {
        String string3 = "";
        try {
            string3 = "<tr bgcolor=\"666666\">";
            string3 = string3 + this.makeColumnHeader("REGION", 0, string2, string);
            string3 = string3 + this.makeColumnHeader("OBJECTNAME", 1, string2, string);
            string3 = string3 + this.makeColumnHeader("GROUP", 2, string2, string);
            string3 = string3 + this.makeColumnHeader("TYPE", 3, string2, string);
            string3 = string3 + this.makeColumnHeader("REFCNT", 5, string2, string);
            string3 = string3 + this.makeColumnHeader("ACCESSCNT", 6, string2, string);
            string3 = string3 + this.makeColumnHeader("EXPIRE", 7, string2, string);
            string3 = string3 + this.makeColumnHeader("VALID", 4, string2, string);
            string3 = string3 + this.makeColumnHeader("LOCK", 8, string2, string);
            string3 = string3 + "</tr>";
        }
        catch (Exception exception) {
            exception.printStackTrace(this.err_out_);
        }
        return string3;
    }

    private String makeColumnHeader(String string, int n, String string2, String string3) {
        String string4 = "<td><font face=\"Verdana\" size=-3 color=\"ffffff\"><a href=\"" + string3 + "?" + SORT_ + "=" + n + "&" + ACTION_PARAM_ + "=" + LISTOBJ_ + "#" + CACHEID_ + string2 + "\" class=\"t\" >" + string + "</a></font></td>";
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector netListObjects(String string, int n, Address address) {
        Vector<String> vector = null;
        try {
            CacheHandle cacheHandle = new CacheHandle();
            Message message = new Message(LISTOBJ_, string, null, n, true);
            Task task = new Task(13, message);
            try {
                if (address != null) {
                    Net.send(address, task, cacheHandle);
                } else {
                    Net.broadcast(task, cacheHandle, 0);
                }
                cacheHandle.resp.waitFor(this.timeout_);
                Object object = cacheHandle.resp.retObj;
                vector = (Vector<String>)object;
                if (vector != null) {
                    vector = this.deSerializeBuf(vector);
                }
                if (address == null) {
                    if (vector != null) {
                        vector.addElement(CacheInternal.dumpToString(string));
                    } else {
                        vector = new Vector<String>();
                        vector.addElement(CacheInternal.dumpToString(string));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.err_out_);
                cacheHandle.cancelResponse();
            }
            finally {
                try {
                    cacheHandle.release();
                }
                catch (CacheException cacheException) {
                    cacheException.printStackTrace(this.err_out_);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.err_out_);
        }
        return vector;
    }

    public Vector deSerializeBuf(Vector vector) {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof byte[])) continue;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])e);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = objectInputStream.readObject();
                vector.removeElementAt(i);
                vector.insertElementAt(object, i);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.out_);
        }
        return vector;
    }

    private Vector objsInfoStringToList(String string) {
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|");
            try {
                CacheObjectInfo cacheObjectInfo = new CacheObjectInfo();
                cacheObjectInfo.region = stringTokenizer2.nextToken();
                cacheObjectInfo.name = stringTokenizer2.nextToken();
                cacheObjectInfo.group = stringTokenizer2.nextToken();
                cacheObjectInfo.type = stringTokenizer2.nextToken();
                cacheObjectInfo.expire = stringTokenizer2.nextToken();
                cacheObjectInfo.valid = Boolean.valueOf(stringTokenizer2.nextToken());
                cacheObjectInfo.ownerInfo = stringTokenizer2.nextToken();
                cacheObjectInfo.refcount = Integer.parseInt(stringTokenizer2.nextToken());
                cacheObjectInfo.accesses = Integer.parseInt(stringTokenizer2.nextToken());
                vector.addElement(cacheObjectInfo);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.out_.println("pass obj info error: " + string3);
            }
        }
        vector.insertElementAt(string2, 0);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formataddrList(String string, boolean bl, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "@");
            if (!bl) {
                string3 = string3 + "Cache " + stringTokenizer2.nextToken();
                string3 = string3 + " at " + stringTokenizer2.nextToken() + "\n";
            } else {
                string5 = stringTokenizer2.nextToken();
                string3 = string3 + "<a name=\"cacheid" + string5 + "\"</a>" + "<font face=\"Verdana\" size=-3>" + "<b>Cache " + string5 + " at " + stringTokenizer2.nextToken() + "</b></font> ";
                string3 = string3 + "<font face=\"Verdana\" size=-3><a href=\"" + string2 + "?" + ACTION_PARAM_ + "=" + LISTOBJ_ + "#" + CACHEID_ + string5 + "\">Object Information</a></font><br>\n";
                string3 = string3 + "<table  BORDER=3 CELLPADDING=3 WIDTH=\"100%\">\n";
            }
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                stringTokenizer2 = new StringTokenizer(string4, "|");
                if (!bl) {
                    string3 = string3 + "distribute = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "version = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "max objects = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "max cache size = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "diskSize = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "diskPath = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "clean interval = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "LogFileName = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "Logger = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "Log severity = " + stringTokenizer2.nextToken() + "\n";
                    string3 = string3 + "cache address list = " + stringTokenizer2.nextToken() + "\n\n";
                    continue;
                }
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>distribute</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>version</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>max objects</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>max cache size</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>diskSize</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>diskPath</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>clean interval</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>LogFileName</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>Logger</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>Log severity</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3><form name=\"cache_config_form\" method=\"post\" action=\"" + string2 + "\">" + "<font face=\"Verdana\" size=-3>" + "<input type=\"text\" name=\"" + LOGSEVERITY_ + "\" " + "value=\"" + stringTokenizer2.nextToken() + "\">" + "<input type=\"hidden\" name=\"" + ACTION_PARAM_ + "\" value=\"" + LOGSEVERITY_ + "\">" + "<input type=\"hidden\" name=\"" + CACHEID_ + "\" value=\"" + string5 + "\">" + "<input type=\"reset\"><input " + "type=\"submit\" value=\"Update\">" + "</font></form></td></tr>\n";
                string3 = string3 + "<tr><td><font face=\"Verdana\" size=-3>cache address list</font></td><td>";
                string3 = string3 + "<td><font face=\"Verdana\" size=-3>" + stringTokenizer2.nextToken() + "</font></td></tr>\n";
            }
        }
        catch (Exception exception) {
            this.err_out_.println("parse addr list error");
            exception.printStackTrace(this.err_out_);
        }
        finally {
            if (bl) {
                string3 = string3 + "</table><font face=\"Verdana\" size=-3><a href=\"#top\">Go to top</a></font><P>\n";
            }
        }
        return string3;
    }

    private Address getCacheAddress(int n) {
        Address address;
        block6: {
            address = null;
            try {
                if (CacheInternal.cAttr.distribute) {
                    Vector vector = Net.chan.getView().getMembers();
                    for (int i = 0; i < vector.size(); ++i) {
                        Address address2 = (Address)vector.elementAt(i);
                        if (n != address2.getPosition()) continue;
                        address = address2;
                        break block6;
                    }
                    break block6;
                }
                try {
                    address = new Address(InetAddress.getLocalHost(), 12345);
                }
                catch (Exception exception) {
                }
            }
            catch (GroupException groupException) {
                groupException.printStackTrace(this.err_out_);
            }
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String netset(Hashtable hashtable, boolean bl, String string) {
        Vector vector = null;
        Address address = null;
        int n = -1;
        String string2 = "";
        if (hashtable.containsKey(LOGSEVERITY_)) {
            try {
                n = Integer.parseInt(((String[])hashtable.get(LOGSEVERITY_))[0]);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "unknown severity level";
                return string2;
            }
        } else {
            if (hashtable.containsKey("timeout")) {
                try {
                    this.timeout_ = Integer.parseInt(((String[])hashtable.get("timeout"))[0]);
                    return "Set network timeout to " + this.timeout_ + " msec.";
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = "unknown network timeout value";
                    return string2;
                }
            }
            string2 = "unknown set command";
            return string2;
        }
        if (hashtable.containsKey(CACHEID_)) {
            address = this.getCacheAddress(((int[])hashtable.get(CACHEID_))[0]);
        }
        if (address != null && address.equals(this.localCacheAddr_)) {
            vector = new Vector();
            if (!bl) {
                vector.addElement(new String("Cache " + CacheInternal.cacheId + " at " + CacheInternal.cacheAddress + ", set logger severity" + ", old=" + CacheInternal.logger.getSeverity() + ", new=" + n));
            } else {
                vector.addElement(new String("<font face=\"Verdana\" size=-3>Cache " + CacheInternal.cacheId + " at " + CacheInternal.cacheAddress + ", set logger severity" + ", old=" + CacheInternal.logger.getSeverity() + ", new=" + n + "</font><br>\n"));
            }
            Cache.setLogSeverity(n);
        } else {
            CacheHandle cacheHandle = new CacheHandle();
            Message message = new Message(LOGSEVERITY_, null, null, n, true);
            Task task = new Task(13, message);
            try {
                if (address != null) {
                    Net.send(address, task, cacheHandle);
                } else {
                    Net.broadcast(task, cacheHandle, 0);
                }
                cacheHandle.resp.waitFor(this.timeout_);
                Object object = cacheHandle.resp.retObj;
                vector = (Vector)object;
                if (vector != null) {
                    vector = this.deSerializeBuf(vector);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.out_);
                cacheHandle.cancelResponse();
            }
            finally {
                try {
                    cacheHandle.release();
                }
                catch (CacheException cacheException) {
                    cacheException.printStackTrace(this.out_);
                }
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof String)) continue;
                string2 = !bl ? string2 + (String)e + "\n" : string2 + "<font face=\"Verdana\" size=-3>" + (String)e + "</font><br>\n";
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String netget(Hashtable hashtable, boolean bl, String string) {
        Vector<String> vector = null;
        Address address = null;
        String string2 = "";
        if (!hashtable.containsKey(CONFIG_)) {
            string2 = "unknown set command";
            return string2;
        }
        if (hashtable.containsKey(CACHEID_)) {
            address = this.getCacheAddress(((int[])hashtable.get(CACHEID_))[0]);
        }
        if (address != null && address.equals(this.localCacheAddr_)) {
            vector = new Vector<String>();
            vector.addElement(CacheInternal.getConfig());
        } else {
            CacheHandle cacheHandle = new CacheHandle();
            Message message = new Message("getconfig", null, null, 0L, true);
            Task task = new Task(13, message);
            try {
                if (address != null) {
                    Net.send(address, task, cacheHandle);
                } else {
                    Net.broadcast(task, cacheHandle, 0);
                }
                cacheHandle.resp.waitFor(this.timeout_);
                Object object = cacheHandle.resp.retObj;
                vector = (Vector<String>)object;
                if (vector != null) {
                    vector = this.deSerializeBuf(vector);
                }
                if (address == null) {
                    if (vector != null) {
                        vector.addElement(CacheInternal.getConfig());
                    } else {
                        vector = new Vector<String>();
                        vector.addElement(CacheInternal.getConfig());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.out_);
                cacheHandle.cancelResponse();
            }
            finally {
                try {
                    cacheHandle.release();
                }
                catch (CacheException cacheException) {
                    cacheException.printStackTrace(this.out_);
                }
            }
        }
        if (vector == null) {
            string2 = !bl ? "cache unavailable" : "<font face=\"Verdana\" size=-3>Cache service is unavailable.</font><P>";
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof String)) continue;
                string2 = string2 + this.formataddrList((String)e, bl, string);
            }
        }
        return string2;
    }

    public String groupdump(Hashtable hashtable, boolean bl, String string) {
        Vector vector = null;
        String string2 = "";
        Vector vector2 = null;
        Object var10_7 = null;
        if (hashtable.containsKey(CACHEID_)) {
            vector2 = new Vector();
            int[] nArray = (int[])hashtable.get(CACHEID_);
            for (int i = 0; i < nArray.length; ++i) {
                Address address;
                boolean bl2 = false;
                for (int j = 0; j < i; ++j) {
                    if (nArray[j] != nArray[i]) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 || (address = this.getCacheAddress(nArray[i])) == null) continue;
                vector2.addElement(address);
            }
        } else {
            try {
                vector2 = Net.chan.getView().getMembers();
            }
            catch (GroupException groupException) {
                string2 = !bl ? "error: unable get current cache list\n" : "Unable to get current cache list.<br>\n";
                groupException.printStackTrace(this.err_out_);
                return string2;
            }
        }
        CacheHandle cacheHandle = new CacheHandle();
        for (int i = 0; i < vector2.size(); ++i) {
            Address address = (Address)vector2.elementAt(i);
            if (this.localCacheAddr_.equals(address)) {
                GroupCommunication.dump();
                string2 = string2 + "Cache " + address.getPosition() + " at " + address.getString() + " group dump completed.";
                if (!bl) {
                    string2 = string2 + "\n";
                    continue;
                }
                string2 = string2 + "<br>\n";
                continue;
            }
            Message message = new Message("groupdump", null, null, 0L, true);
            Task task = new Task(13, message);
            try {
                Object e;
                Net.send(address, task, cacheHandle);
                cacheHandle.resp.waitFor(this.timeout_);
                Object object = cacheHandle.resp.retObj;
                vector = (Vector)object;
                if (vector == null || !((e = (vector = this.deSerializeBuf(vector)).elementAt(0)) instanceof String)) continue;
                string2 = (String)e;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(this.err_out_);
                cacheHandle.cancelResponse();
            }
        }
        try {
            cacheHandle.release();
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace(this.err_out_);
        }
        string2 = !bl ? string2 + "\nPlease check output in the log file.\n" : string2 + "<br>Please check output in the log file.<br><center><a href=\"javascript:window.close()\">Close this window</a></center><br>\n";
        return string2;
    }

    public String netdump(Hashtable hashtable, boolean bl, String string) {
        Vector vector = null;
        String string2 = "";
        Vector vector2 = null;
        Object var10_7 = null;
        if (hashtable.containsKey(CACHEID_)) {
            vector2 = new Vector();
            int[] nArray = (int[])hashtable.get(CACHEID_);
            for (int i = 0; i < nArray.length; ++i) {
                Address address;
                boolean bl2 = false;
                for (int j = 0; j < i; ++j) {
                    if (nArray[j] != nArray[i]) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 || (address = this.getCacheAddress(nArray[i])) == null) continue;
                vector2.addElement(address);
            }
        } else {
            try {
                vector2 = Net.chan.getView().getMembers();
            }
            catch (GroupException groupException) {
                string2 = !bl ? "error: unable get current cache list\n" : "Unable to get current cache list.<br>\n";
                groupException.printStackTrace(this.err_out_);
                return string2;
            }
        }
        CacheHandle cacheHandle = new CacheHandle();
        for (int i = 0; i < vector2.size(); ++i) {
            Address address = (Address)vector2.elementAt(i);
            if (this.localCacheAddr_.equals(address)) {
                CacheInternal.dump();
                string2 = string2 + "Cache " + address.getPosition() + " at " + address.getString() + " dump completed.";
                if (!bl) {
                    string2 = string2 + "\n";
                    continue;
                }
                string2 = string2 + "<br>\n";
                continue;
            }
            Message message = new Message("netdump", null, null, 0L, true);
            Task task = new Task(13, message);
            try {
                Object e;
                Net.send(address, task, cacheHandle);
                cacheHandle.resp.waitFor(this.timeout_);
                Object object = cacheHandle.resp.retObj;
                vector = (Vector)object;
                if (vector == null || !((e = (vector = this.deSerializeBuf(vector)).elementAt(0)) instanceof String)) continue;
                string2 = (String)e;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(this.err_out_);
                cacheHandle.cancelResponse();
            }
        }
        try {
            cacheHandle.release();
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace(this.err_out_);
        }
        string2 = !bl ? string2 + "\nPlease check output in the log file.\n" : string2 + "<br>Please check output in the log file.<br><center><a href=\"javascript:window.close()\">Close this window</a></center><br>\n";
        return string2;
    }

    public String invalidate(boolean bl) {
        String string = "";
        try {
            Cache.invalidate();
            string = string + " invalidate finished.";
        }
        catch (Exception exception) {
            string = string + " invalidate failed.";
            exception.printStackTrace(this.err_out_);
        }
        string = !bl ? string + "\n" : string + "<br>\n";
        if (bl) {
            string = string + "<br><center><a href=\"javascript:window.close()\">Close this window</a></center><br>\n";
        }
        return string;
    }

    public String destroy(boolean bl) {
        String string = "";
        try {
            Cache.destroy();
            string = string + " destroy finished.";
        }
        catch (Exception exception) {
            string = string + " destroy failed.";
            exception.printStackTrace(this.err_out_);
        }
        string = !bl ? string + "\n" : string + "<br>\n";
        if (bl) {
            string = string + "<br><center><a href=\"javascript:window.close()\">Close this window</a></center><br>\n";
        }
        return string;
    }

    public static void sort(Vector vector, CacheInfoComp cacheInfoComp) {
        block2: {
            try {
                CacheSorter.sort(vector, cacheInfoComp);
            }
            catch (Exception exception) {
                if (!CacheInternal.logger.shouldLog(15)) break block2;
                CacheInternal.logger.log("sort error", exception);
            }
        }
    }

    Address getLocalAddress() {
        Address address = null;
        try {
            address = CacheInternal.cAttr.distribute ? (Address)Net.chan.getLocalAddress() : new Address(InetAddress.getLocalHost(), 12345);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }
}

