/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.Serializable;
import oracle.ias.cache.Mdslot;

public class CacheObjectInfo
implements Serializable {
    public String region;
    public Object name;
    public String group;
    public String type;
    public String expire;
    public boolean valid;
    public int refcount;
    public int accesses;
    public String ownerInfo;

    void set(Mdslot mdslot) {
        long l;
        this.region = mdslot.qualifier;
        this.name = mdslot.name;
        this.group = mdslot.group;
        this.refcount = mdslot.refcount;
        this.accesses = mdslot.objStatus.accessCount;
        if (mdslot.ownerInfo != null) {
            this.ownerInfo = mdslot.ownerInfo.toString();
        }
        this.valid = (mdslot.state & 0x10L) != 0L;
        this.type = this.getType(mdslot);
        this.expire = mdslot.timeToLive > 0L ? ((l = mdslot.timeToLive - System.currentTimeMillis()) < 0L ? "Expired" : new String((l + 500L) / 1000L + " Seconds")) : "None";
    }

    private String getType(Mdslot mdslot) {
        if ((mdslot.state & 0x1000000L) != 0L) {
            return "Loader";
        }
        if ((mdslot.state & 0x4000L) != 0L) {
            return "Memory";
        }
        if ((mdslot.state & 0x2000000L) != 0L) {
            return "StreamAccess";
        }
        if ((mdslot.state & 0x1000L) != 0L) {
            return "Disk";
        }
        if ((mdslot.state & 0x80L) != 0L) {
            if (mdslot.name.equals(mdslot.qualifier)) {
                return "Region";
            }
            if (mdslot.poolMgr != null) {
                return "Pool";
            }
            return "Group";
        }
        if ((mdslot.state & 0x1000L) != 0L) {
            return "Disk";
        }
        return "Unknown";
    }

    public String toString() {
        return new String(this.region + "\t" + this.name + "\t" + this.group + "\t" + this.type + "\t" + this.valid + "\t" + this.refcount + "\t" + this.accesses + "\t" + this.ownerInfo + "\t" + this.expire);
    }
}

