/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.Bucket;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheEvent;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheFullException;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheListLoader;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.CacheObjectInputStream;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.CacheOutputStream;
import oracle.ias.cache.CachePermissionsException;
import oracle.ias.cache.CallbackException;
import oracle.ias.cache.CantSynchronizeGroupException;
import oracle.ias.cache.CleanLists;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskMessage;
import oracle.ias.cache.Flag;
import oracle.ias.cache.GroupInfo;
import oracle.ias.cache.Groups;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.InvalidHandleException;
import oracle.ias.cache.InvalidObjectException;
import oracle.ias.cache.ListLoadInfo;
import oracle.ias.cache.ListObject;
import oracle.ias.cache.ListObjectsEnumeration;
import oracle.ias.cache.LoadConflictException;
import oracle.ias.cache.LockMessage;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.Message;
import oracle.ias.cache.Net;
import oracle.ias.cache.NetworkException;
import oracle.ias.cache.NotOwnerException;
import oracle.ias.cache.NullObj;
import oracle.ias.cache.NullObjectException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectExaminer;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.ObjectNotSynchronizedException;
import oracle.ias.cache.ObjectReq;
import oracle.ias.cache.ObjectStatus;
import oracle.ias.cache.OwnerInfo;
import oracle.ias.cache.PoolMgr;
import oracle.ias.cache.RegionCount;
import oracle.ias.cache.RegionFullException;
import oracle.ias.cache.RegionNotFoundException;
import oracle.ias.cache.RemoteCacheNotFoundException;
import oracle.ias.cache.Response;
import oracle.ias.cache.ResponseFailedException;
import oracle.ias.cache.ResponseList;
import oracle.ias.cache.SyncObjectDestroyedException;
import oracle.ias.cache.Task;
import oracle.ias.cache.TimeoutException;
import oracle.ias.cache.UpdateMessage;
import oracle.ias.cache.group.Address;

class CacheHandle {
    static final int DEFAULT_NET_TIMEOUT = 300000;
    static final int DEFAULT_LOCKSLEEP = 200;
    static final int OP_INVALIDATE = 1;
    static final int OP_DISABLE = 2;
    static final int OP_ENABLE = 4;
    static final int OP_DESTROY = 8;
    private static int s_lockSleep = 200;
    private static final String LOCKSLEEP_PROP = "oracle.ias.cache.locksleep";
    long objid = 0L;
    Mdslot slot;
    Object object = null;
    ObjectReq objReq = new ObjectReq();
    boolean released = true;
    boolean free;
    Response resp = null;
    ResponseList respList = null;
    int regionNumber;
    CacheHandle next;
    Flag gFlag = new Flag();
    CacheOutputStream outStream;
    Hashtable lockTable;
    ListObject listObject;
    ListLoadInfo listLoad = null;
    Object lockName = null;
    boolean releaseLock = false;
    boolean remote = false;
    int cacheInstance = CacheInternal.cacheInstance;

    CacheHandle() {
    }

    void register(Object object, String string, String string2, Attributes attributes) throws CacheException, IOException, InterruptedException {
        Attributes attributes2 = new Attributes();
        Flag flag = new Flag();
        int n = CacheInternal.hashName(object);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        int n2 = bucket.canDefine(object, string, this.regionNumber, n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if ((attributes.flags & 1L) != 0L) break;
                throw new ObjectExistsException(CacheInternal.EXP_REDEFINELOCAL + " " + object);
            }
            default: {
                throw new ObjectExistsException(CacheInternal.EXP_ATTRSET + " " + object);
            }
        }
        Attributes attributes3 = attributes != null ? (Attributes)attributes.clone() : null;
        this.objReq.set(25182208L, object, string, string2, attributes3, 0);
        this.findObject();
        if (attributes3 != null && (attributes3.flags & 0x44L) != 0L) {
            this.slot.ownerInfo = new OwnerInfo(this.slot);
        }
        attributes2.setFlags(32L);
        this.setAttributes(attributes2);
        this.release();
    }

    void resetAttributes(Object object, String string, Attributes attributes) throws CacheException, IOException {
        if (attributes == null) {
            throw new InvalidArgumentException();
        }
        Attributes attributes2 = (Attributes)attributes.clone();
        attributes2.flagsSet = false;
        attributes2.loader = null;
        try {
            this.objReq.set(262144L, object, string, null, null, this.regionNumber);
            this.findObject();
            if ((this.slot.state & 0x8000000L) == 0L) {
                this.setRegAttrs(attributes2);
            }
            this.release();
            return;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            try {
                this.objReq.set(0x1044000L, object, string, null, null, 0);
                this.findObject();
                Attributes attributes3 = (Attributes)this.slot.object;
                attributes3.reset(attributes2);
            }
            catch (ObjectNotFoundException objectNotFoundException2) {
                // empty catch block
            }
            this.release();
            return;
        }
    }

    void setRegionNumber() throws InvalidHandleException, RegionNotFoundException {
        if (this.slot == null) {
            throw new InvalidHandleException(CacheInternal.EXP_INVALHDL);
        }
        if (this.slot.regionNumber == 0) {
            int n = this.findBucket(this.objid);
            Bucket bucket = CacheInternal.hashtab[n];
            int n2 = CacheInternal.getRegionNumber();
            this.regionNumber = bucket.setRegionNumber(this.slot, n2);
        }
        this.regionNumber = this.slot.regionNumber;
    }

    private void setRegAttrs(Attributes attributes) throws CacheException, IOException {
        int n = this.findBucket(this.slot.objid);
        int n2 = CacheHandle.findSlot(this.slot.objid);
        Bucket bucket = CacheInternal.hashtab[n];
        if (attributes.loader != null) {
            this.slot.loader = attributes.loader;
        }
        if (attributes.userClassLoader != null) {
            this.slot.userClassLoader = attributes.userClassLoader;
            CacheInternal.setUserClassLoader(this.slot.qualifier, attributes.userClassLoader);
        }
        if (attributes.attrSet) {
            RegionCount regionCount;
            bucket.setAttributes(n2, this.slot.objid, attributes);
            if ((attributes.maxCount > 0 || attributes.maxSize > 0L) && (regionCount = bucket.checkCapacity(this.slot)) != null) {
                this.regionOverflow(this.slot.objid, this.slot.objStatus.priority, regionCount, null);
            }
        }
        if (attributes.flagsSet && (this.slot.state & 0x80L) != 0L) {
            if ((attributes.flags & 0x40L) != 0L) {
                this.slot.lockTable = new Hashtable();
                this.slot.ownerInfo = new OwnerInfo(this.slot);
            } else if ((attributes.flags & 4L) != 0L) {
                this.slot.ownerInfo = new OwnerInfo(this.slot);
            }
        }
    }

    void setPoolMgr(PoolMgr poolMgr) {
        this.slot.poolMgr = poolMgr;
    }

    PoolMgr getPoolMgr() throws CacheException {
        if (this.slot != null) {
            return this.slot.poolMgr;
        }
        throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND);
    }

    Object putObject(Object object, String string, String string2, Object object2, Attributes attributes) throws CacheException, IOException, InterruptedException {
        this.objReq.setPut(0x804000L, object, string, string2, object2, this.regionNumber, attributes);
        this.findObject();
        if (this.object.equals(CacheInternal.NULL_OBJECT) && object2 != null) {
            this.invalidate(this.objid, true, false, true);
            this.clearHandle();
            this.objReq.setPut(0x804000L, object, string, string2, object2, this.regionNumber, attributes);
            this.findObject();
        }
        return this.object;
    }

    Object replaceObject(Object object, String string, String string2, Object object2) throws CacheException, IOException, InterruptedException {
        this.objReq.set(49152L, object, string, string2, object2, this.regionNumber, this, null);
        this.findObject();
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceRemoteObject(Object object, String string, String string2, Object object2, CacheAddress cacheAddress) throws CacheException, IOException, InterruptedException {
        Groups[] groupsArray = null;
        long l = 16384L;
        Address address = cacheAddress.getAddress();
        if (address.equals(Net.getLocalAddressObject())) {
            this.objReq.set(49664L, object, string, string2, object2, this.regionNumber, this, null);
            this.findObject();
            return;
        }
        if (address == null) {
            throw new InvalidArgumentException("CacheAddress");
        }
        if (!CacheInternal.isDistributed()) {
            throw new RemoteCacheNotFoundException(CacheInternal.EXP_REMCACHENFOUND + cacheAddress);
        }
        UpdateMessage updateMessage = new UpdateMessage(object, string, string2, groupsArray, l, object2, 0L, true);
        Task task = new Task(20, (Object)updateMessage, false);
        Net.send(task, object2, address, this);
        try {
            this.resp.waitFor(600000);
            if (this.resp.status != 1) {
                if (this.resp.exception == null) {
                    throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL);
                }
                throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL, this.resp.getException(), this.resp.cacheName);
            }
            Object var13_11 = null;
            CacheInternal.respQ.freeRespSlot(this.resp.id);
            this.resp = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            CacheInternal.respQ.freeRespSlot(this.resp.id);
            this.resp = null;
            throw throwable;
        }
    }

    void preLoadObject(Object object, String string, String string2, Object object2) throws CacheException, RegionNotFoundException, IOException, ObjectNotFoundException, InterruptedException {
        block5: {
            if (!this.getRegionNumber(string)) {
                throw new RegionNotFoundException();
            }
            this.objReq.set(0x1040000L, object, string, null, null, this.regionNumber);
            try {
                this.findObject();
                Attributes attributes = (Attributes)this.slot.object;
                if (attributes.loader == null) {
                    this.release();
                    throw new ObjectNotFoundException(CacheInternal.EXP_NOLOAD);
                }
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                if (string2 == null) {
                    throw objectNotFoundException;
                }
                this.objReq.set(262272L, string2, string, null, null, this.regionNumber);
                this.findObject();
                if (this.slot.loader != null) break block5;
                this.release();
                throw new ObjectNotFoundException(CacheInternal.EXP_NOLOAD);
            }
        }
        this.release();
        ObjectReq objectReq = new ObjectReq(0x204000L, object, string, string2, object2, this.regionNumber);
        Task task = new Task(31, objectReq);
        CacheInternal.asyncTaskQ.putTask(task);
    }

    void asyncLoad(ObjectReq objectReq) {
        if ((CacheInternal.flags & 1) == 0) {
            return;
        }
        this.objReq = objectReq;
        try {
            this.findObject();
            this.release();
        }
        catch (LoadConflictException loadConflictException) {
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
    }

    Object locateObject(Object object, String string, String string2, Object object2) throws CacheException, IOException, InterruptedException {
        if (!this.getRegionNumber(string)) {
            throw new RegionNotFoundException();
        }
        this.objReq.set(0L, object, string, string2, object2, this.regionNumber);
        try {
            this.findObject();
            this.objReq.reset();
            return this.object;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.objReq.set(0L, string2, string, null, null, this.regionNumber);
            this.findObject();
            this.objReq.reset();
            if ((this.slot.state & 0x40000000L) != 0L) {
                return null;
            }
            throw objectNotFoundException;
        }
        catch (ObjectExistsException objectExistsException) {
            this.findObject();
            this.objReq.reset();
            return this.object;
        }
    }

    void loadList(Object[] objectArray, String string, String string2, Object object) throws CacheException, IOException, InterruptedException {
        int n;
        long l = 0L;
        CacheListLoader cacheListLoader = null;
        int n2 = 0;
        boolean bl = true;
        CacheException cacheException = null;
        if (!this.getRegionNumber(string)) {
            throw new RegionNotFoundException();
        }
        this.listLoad = new ListLoadInfo(objectArray, this);
        Object[] objectArray2 = new Object[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            if (bl) {
                this.objReq.set(0x100000000L, objectArray[n], string, string2, object, this.regionNumber);
            } else {
                this.objReq.set(0L, objectArray[n], string, string2, object, this.regionNumber);
            }
            try {
                this.findObject();
                if ((this.gFlag.mask & 8L) != 0L) {
                    if (this.slot.loader == null || !(this.slot.loader instanceof CacheListLoader) || cacheListLoader != null && this.slot.loader != cacheListLoader) {
                        bl = false;
                    } else {
                        cacheListLoader = (CacheListLoader)this.slot.loader;
                    }
                    objectArray2[n2] = this.lockName;
                    this.listLoad.slotList[n2++] = this.slot;
                    this.slot = null;
                    this.released = true;
                    continue;
                }
                this.release();
                continue;
            }
            catch (TimeoutException timeoutException) {
                CacheInternal.exceptionLog("[Mem] ", timeoutException);
                continue;
            }
            catch (CacheException cacheException2) {
                cacheException = cacheException2;
                CacheInternal.exceptionLog("[Mem] ", cacheException2);
            }
        }
        if (n2 > 0 && bl) {
            long l2 = System.currentTimeMillis();
            this.slot = this.listLoad.slotList[0];
            try {
                cacheListLoader.loadList(this, object);
            }
            catch (CacheException cacheException3) {
                cacheException = cacheException3;
                CacheInternal.exceptionLog("[Mem] ", cacheException3);
            }
            l = System.currentTimeMillis() - l2;
        }
        this.listLoad.loadFromList = true;
        this.gFlag.mask = 8L;
        for (n = 0; n < n2; ++n) {
            this.slot = this.listLoad.slotList[n];
            this.objid = this.slot.objid;
            this.released = false;
            this.lockName = objectArray2[n];
            if (objectArray2[n] != null) {
                this.releaseLock = true;
            }
            try {
                if (!bl) {
                    this.listLoad.listLoader = this.listLoad.slotList[n].loader;
                    this.objReq.set(0L, this.listLoad.slotList[n].name, string, string2, object, this.regionNumber);
                    this.findObject();
                } else {
                    this.objReq.set(0L, this.listLoad.slotList[n].name, string, string2, this.listLoad.slotList[n].object, this.regionNumber);
                    this.findObject();
                    this.slot.objStatus.loadTime = l;
                }
                this.release();
                continue;
            }
            catch (TimeoutException timeoutException) {
                CacheInternal.exceptionLog("[Mem] ", timeoutException);
                continue;
            }
            catch (CacheException cacheException4) {
                cacheException = cacheException4;
                CacheInternal.exceptionLog("[Mem] ", cacheException4);
            }
        }
        this.objReq.reset();
        this.listLoad = null;
        if (cacheException != null) {
            throw cacheException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findObject() throws CacheException, IOException {
        Object object;
        block78: {
            long l;
            boolean bl;
            block77: {
                block73: {
                    Object object2;
                    block74: {
                        block75: {
                            Bucket bucket;
                            boolean bl2;
                            block79: {
                                bl2 = true;
                                bl = false;
                                CacheHandle.cacheReady();
                                int n = CacheInternal.hashName(this.objReq.name);
                                bucket = CacheInternal.hashtab[n % 523];
                                if (this.listLoad == null || !this.listLoad.loadFromList) {
                                    Mdslot mdslot = bucket.findSlot(this.objReq, n, this.gFlag);
                                    if (mdslot == null) {
                                        throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name);
                                    }
                                    if (this.checkTtl(mdslot, false, true) && (mdslot = bucket.findSlot(this.objReq, n, this.gFlag)) == null) {
                                        throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name);
                                    }
                                    if (!this.released) {
                                        if (this.object != null && mdslot.objid == this.objid) {
                                            bucket.deccounts(mdslot);
                                            return;
                                        }
                                        this.release();
                                    }
                                    this.slot = mdslot;
                                    this.objid = this.slot.objid;
                                    this.released = false;
                                }
                                l = 2L;
                                if ((this.objReq.type & 0x48000L) == 262144L) {
                                    if ((this.slot.state & 0x2000000L) != 0L) {
                                        this.object = this.getInStream(this.objReq);
                                        return;
                                    }
                                    this.object = this.slot.object;
                                    return;
                                }
                                if ((this.gFlag.mask & 2L) != 0L) break block78;
                                if ((this.gFlag.mask & 4L) == 0L) break block79;
                                if ((this.objReq.type & 0x100000000L) == 0L) {
                                    try {
                                        object = this.slot.loadLock;
                                        synchronized (object) {
                                            while ((this.slot.state & 4L) != 0L) {
                                                this.slot.loadLock.wait();
                                            }
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        this.invalidate(this.objid, true, false, true);
                                        this.clearHandle();
                                        l = 0L;
                                        throw CacheInternal.exceptionHandler(interruptedException);
                                    }
                                    if (this.slot.object == null) {
                                        this.release();
                                        throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.slot.name);
                                    }
                                }
                                break block78;
                            }
                            if ((this.gFlag.mask & 8L) == 0L) {
                                this.invalidate(this.objid, true, false, true);
                                this.clearHandle();
                                throw new CacheException(CacheInternal.EXP_INTERNAL);
                            }
                            try {
                                try {
                                    if ((this.slot.state & 0x80L) == 0L && (this.objReq.type & 0x1808000L) != 0L) {
                                        bl2 = false;
                                        if (this.lockTable != null && "000DESTROYED$$".equals(this.lockTable.get(this.slot.name))) {
                                            this.lockTable.remove(this.slot.name);
                                            throw new SyncObjectDestroyedException(CacheInternal.EXP_SYNCDESTROYED + this.slot.name);
                                        }
                                    }
                                    if (this.slot.group == null && this.objReq.group != null) {
                                        String string;
                                        if (this.objReq.parent != null) {
                                            string = this.objReq.parent;
                                            this.slot.regionNumber = CacheInternal.getRegionNumber();
                                        } else {
                                            string = this.objReq.qualifier;
                                        }
                                        ObjectReq objectReq = new ObjectReq(262272L, this.objReq.group, string, null, null, this.objReq.qualId);
                                        this.findGroup(objectReq, this.slot);
                                    }
                                    if ((this.slot.state & 0x1000080L) == 0L) {
                                        this.findRegAttrs(this.objReq);
                                    }
                                    if ((this.slot.state & 0x80L) != 0L) {
                                        this.slot.objStatus.createTime = System.currentTimeMillis();
                                        this.slot.state |= 0x40L;
                                        this.slot.state &= 0xFFFFFFFFFF7FFFFFL;
                                        if (this.objReq.loadArgs != null) {
                                            this.setRegAttrs((Attributes)this.objReq.loadArgs);
                                        }
                                    } else if ((this.slot.state & 0x100L) != 0L) {
                                        if ((this.slot.state & 0x1000L) == 0L) {
                                            this.readDiskObject(this.slot);
                                        }
                                        this.slot.regionNumber = this.regionNumber;
                                        this.slot.state &= 0xFFFFFFFFF7FFFFFFL;
                                    } else {
                                        this.slot.oldSize = this.slot.objStatus.size;
                                        if ((this.slot.state & 0x120000L) != 0L && (this.objReq.type & 0x200L) == 0L && this.slot.ownerInfo.lockHolder != this) {
                                            if ((this.slot.state & 0x8000L) != 0L) throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + this.slot.name);
                                            if ((this.slot.state & 0x800000L) != 0L) {
                                                throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + this.slot.name);
                                            }
                                            this.lockName = this.getOwnership(this.slot.name, this.slot.qualifier, this.slot.group, 300000);
                                            this.releaseLock = true;
                                        }
                                        if ((this.objReq.type & 0x100000000L) != 0L) {
                                            Object var11_15 = null;
                                            if ((this.objReq.type & 0x100000000L) != 0L) break block73;
                                            if (!this.releaseLock) break block74;
                                            object2 = this.lockName;
                                            this.releaseLock = false;
                                            this.lockName = null;
                                            break block75;
                                        }
                                        if (bl2 && this.slot.loader != null) {
                                            block76: {
                                                try {
                                                    long l2 = System.currentTimeMillis();
                                                    this.slot.object = this.listLoad != null && this.listLoad.loadFromList ? this.listLoad.listLoader.load(this, this.objReq.loadArgs) : this.slot.loader.load(this, this.objReq.loadArgs);
                                                    this.slot.objStatus.loadTime = System.currentTimeMillis() - l2;
                                                    if ((this.slot.state & 0x2000000L) != 0L) {
                                                        this.closeOutStream(bucket);
                                                        break block76;
                                                    }
                                                    if ((this.slot.state & 0x1000L) != 0L) {
                                                        this.closeDiskLoad(bucket);
                                                    }
                                                }
                                                catch (ObjectExistsException objectExistsException) {
                                                    // empty catch block
                                                }
                                            }
                                            if ((this.slot.state & 0x10L) == 0L) {
                                                bucket.setEvent(this.slot, 0);
                                            }
                                        } else if (bl2) {
                                            this.slot.object = CacheInternal.isDistributedObject(this.slot) ? this.netSearch(300000) : null;
                                        } else {
                                            if (this.objReq.attr != null) {
                                                this.setAttributes(this.objReq.attr);
                                            }
                                            this.slot.object = this.objReq.loadArgs;
                                        }
                                        if ((this.slot.state & 0x80000000L) != 0L) {
                                            this.slot.objStatus.size = ObjectExaminer.getEntireObjectSize(this.slot.object, true);
                                        }
                                        if (this.slot.object == null) {
                                            if ((this.slot.state & 0x40000000L) == 0L) {
                                                throw new NullObjectException(CacheInternal.EXP_NULLOBJ);
                                            }
                                            this.slot.object = CacheInternal.NULL_OBJECT;
                                        }
                                        if (!this.slot.isFile) {
                                            this.slot.state |= 0x4040L;
                                        }
                                    }
                                    if ((this.objReq.type & 0x8000L) != 0L) {
                                        this.finishUpdate(this.slot, this.objReq);
                                    }
                                    if ((this.slot.state & 0x80L) == 0L) {
                                        if (this.slot.objStatus.createTime == 0L) {
                                            this.slot.objStatus.createTime = System.currentTimeMillis();
                                        }
                                        if (this.slot.ttlInterval > 0L) {
                                            this.slot.timeToLive = this.slot.objStatus.createTime + this.slot.ttlInterval * 1000L;
                                        }
                                    }
                                    if ((this.slot.state & 0x1000080L) != 0L) break block77;
                                    if ((this.slot.state & 0x20000000L) != 0L) {
                                        this.invalidate(this.objid, false, false, true);
                                    }
                                    if ((this.slot.state & 0x40L) == 0L) break block77;
                                    if (this.checkRegionCount(this.slot)) {
                                        if ((this.objReq.type & 0x808000L) != 0L) {
                                            throw new RegionFullException(CacheInternal.EXP_RFULL);
                                        }
                                        this.invalidate(this.objid, false, false, true);
                                    }
                                    if (CacheInternal.incrCurCnt(this.slot)) break block77;
                                    if ((this.slot.state & 0x2000L) != 0L && CacheInternal.rootDiskPath != null && this.slot.object instanceof Serializable) {
                                        bucket.spoolToDisk(this.slot);
                                        break block77;
                                    } else {
                                        if ((this.objReq.type & 0x808000L) != 0L) {
                                            throw new CacheFullException(CacheInternal.EXP_FULL);
                                        }
                                        this.invalidate(this.objid, false, false, true);
                                    }
                                    break block77;
                                }
                                catch (Exception exception) {
                                    if (!this.released) {
                                        try {
                                            this.invalidate(this.objid, true, false, true);
                                        }
                                        catch (Exception exception2) {
                                            // empty catch block
                                        }
                                    }
                                    l = 0L;
                                    bl = true;
                                    throw CacheInternal.exceptionHandler(exception);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var11_17 = null;
                                if ((this.objReq.type & 0x100000000L) == 0L) {
                                    Object object3;
                                    if (this.releaseLock) {
                                        object3 = this.lockName;
                                        this.releaseLock = false;
                                        this.lockName = null;
                                        this.releaseOwnership(object3, this.objReq.qualifier, -1);
                                    }
                                    object3 = this.slot.loadLock;
                                    synchronized (object3) {
                                        this.slot.state |= l;
                                        this.slot.state &= 0xFFFFFFFFFFFFFBFBL;
                                        this.slot.loadLock.notifyAll();
                                    }
                                }
                                if (!bl) throw throwable;
                                this.clearHandle();
                                throw throwable;
                            }
                        }
                        this.releaseOwnership(object2, this.objReq.qualifier, -1);
                    }
                    object2 = this.slot.loadLock;
                    synchronized (object2) {
                        this.slot.state |= l;
                        this.slot.state &= 0xFFFFFFFFFFFFFBFBL;
                        this.slot.loadLock.notifyAll();
                    }
                }
                if (!bl) return;
                this.clearHandle();
                return;
            }
            Object var11_16 = null;
            if ((this.objReq.type & 0x100000000L) == 0L) {
                Object object4;
                if (this.releaseLock) {
                    object4 = this.lockName;
                    this.releaseLock = false;
                    this.lockName = null;
                    this.releaseOwnership(object4, this.objReq.qualifier, -1);
                }
                object4 = this.slot.loadLock;
                synchronized (object4) {
                    this.slot.state |= l;
                    this.slot.state &= 0xFFFFFFFFFFFFFBFBL;
                    this.slot.loadLock.notifyAll();
                }
            }
            if (bl) {
                this.clearHandle();
            }
        }
        if (this.slot.group == null && this.objReq.group != null) {
            object = new ObjectReq(262272L, this.objReq.group, this.objReq.qualifier, null, null, this.objReq.qualId);
            this.findGroup((ObjectReq)object, this.slot);
        }
        if (this.objReq.parent == null) {
            this.regionNumber = this.slot.regionNumber;
        }
        if ((this.slot.state & 0x2000000L) != 0L) {
            this.object = this.getInStream(this.objReq);
            return;
        }
        this.object = this.slot.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findGroup(ObjectReq objectReq, Mdslot mdslot) throws CacheException, SecurityException, IOException {
        Flag flag = new Flag();
        int n = CacheInternal.hashName(objectReq.name);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        Mdslot mdslot2 = bucket.findSlot(objectReq, n, flag);
        if (mdslot2 == null) {
            if (objectReq.qualifier.equals(objectReq.name)) {
                throw new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + objectReq.qualifier + "\"");
            }
            throw new ObjectNotFoundException(CacheInternal.EXP_NOGROUP + ": \"" + objectReq.name + "\"");
        }
        if (this.checkTtl(mdslot2, false, false)) {
            throw new ObjectNotFoundException();
        }
        try {
            bucket.addChild(mdslot2, mdslot);
        }
        finally {
            bucket.objRelease(CacheHandle.findSlot(mdslot2.objid), mdslot2.objid, true);
        }
    }

    private void findRegAttrs(ObjectReq objectReq) throws CacheException, SecurityException, IOException {
        Flag flag = new Flag();
        ObjectReq objectReq2 = new ObjectReq(0x1040000L, objectReq.name, objectReq.qualifier, null, null, this.regionNumber);
        int n = CacheInternal.hashName(objectReq.name);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        int n2 = CacheHandle.findSlot(this.objid);
        Mdslot mdslot = bucket.findSlot(objectReq2, n, flag);
        if (mdslot == null) {
            return;
        }
        Attributes attributes = (Attributes)mdslot.object;
        if (attributes.loader != null) {
            this.slot.loader = attributes.loader;
        }
        if (mdslot.ownerInfo != null) {
            this.slot.ownerInfo = mdslot.ownerInfo;
        }
        if (attributes.group != null && objectReq.group == null) {
            objectReq.group = attributes.group;
        }
        if (attributes.attrSet) {
            bucket.setAttributes(n2, this.objid, attributes);
        }
        if (attributes.loader == null && attributes.handlers == null && !attributes.attrSet) {
            this.slot.loaderInherit = true;
        }
        this.release(mdslot, mdslot.objid, true);
    }

    void disable(Object object, String string) throws CacheException, IOException, InterruptedException {
        this.manipulateObject(2, object, string, true, false, false);
    }

    void enable(Object object, String string) throws CacheException, IOException, InterruptedException {
        this.manipulateObject(4, object, string, true, false, false);
    }

    boolean isDisabled(Object object, String string) throws CacheException, ObjectNotFoundException, IOException {
        Mdslot mdslot = null;
        Bucket bucket = null;
        Flag flag = new Flag();
        ObjectReq objectReq = new ObjectReq();
        long l = 0L;
        boolean bl = false;
        objectReq.set(262144L, object, string, null, null, 0);
        int n = CacheInternal.hashName(object);
        bucket = CacheInternal.hashtab[n % 523];
        mdslot = bucket.findSlot(objectReq, n, flag);
        if (mdslot == null) {
            objectReq.set(0x1040000L, object, string, null, null, 0);
            mdslot = bucket.findSlot(objectReq, n, flag);
            if (mdslot == null) {
                throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + " \"" + object + "\"");
            }
            Attributes attributes = (Attributes)mdslot.object;
            bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
            if ((attributes.flags & 0x100L) != 0L) {
                bl = true;
            }
        } else {
            l = mdslot.state;
            bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
            if ((l & 0x20000000L) != 0L) {
                bl = true;
            }
        }
        return bl;
    }

    void invalidate(Object object, String string) throws CacheException, IOException, InterruptedException {
        this.manipulateObject(1, object, string, true, false, false);
    }

    void invalidate(Object object, String string, boolean bl) throws CacheException, IOException, InterruptedException {
        this.manipulateObject(1, object, string, !bl, false, false);
    }

    void destroy(Object object, String string) throws CacheException, IOException, InterruptedException {
        this.manipulateObject(8, object, string, true, false, false);
    }

    void destroy(Object object, String string, boolean bl) throws CacheException, IOException, InterruptedException {
        this.manipulateObject(8, object, string, !bl, false, false);
    }

    void invalidate(Object[] objectArray, String string, boolean bl) throws CacheException, IOException, InterruptedException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            this.manipulateObject(1, objectArray[i], string, !bl, false, false);
        }
    }

    void destroy(Object[] objectArray, String string, boolean bl) throws CacheException, IOException, InterruptedException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            this.manipulateObject(8, objectArray[i], string, !bl, false, false);
        }
    }

    void remoteInvalidate(Object object, String string, boolean bl, boolean bl2) throws CacheException, IOException, InterruptedException {
        try {
            this.regionNumber = 0;
            if (!this.getRegionNumber(string)) {
                return;
            }
            if (bl) {
                this.manipulateObject(8, object, string, false, true, bl2);
            } else {
                this.manipulateObject(1, object, string, false, true, bl2);
            }
        }
        catch (CacheNotAvailableException cacheNotAvailableException) {
            // empty catch block
        }
    }

    void remoteEnable(Object object, String string, boolean bl) throws CacheException, IOException, InterruptedException {
        try {
            this.regionNumber = 0;
            if (!this.getRegionNumber(string)) {
                return;
            }
            this.manipulateObject(4, object, string, false, true, bl);
        }
        catch (CacheNotAvailableException cacheNotAvailableException) {
            // empty catch block
        }
    }

    void remoteDisable(Object object, String string, boolean bl) throws CacheException, IOException, InterruptedException {
        try {
            this.regionNumber = 0;
            if (!this.getRegionNumber(string)) {
                return;
            }
            this.manipulateObject(2, object, string, false, true, bl);
        }
        catch (CacheNotAvailableException cacheNotAvailableException) {
            // empty catch block
        }
    }

    private void manipulateObject(int n, Object object, String string, boolean bl, boolean bl2, boolean bl3) throws CacheException, IOException, InterruptedException {
        boolean bl4 = false;
        Mdslot mdslot = null;
        Bucket bucket = null;
        int n2 = CacheInternal.hashName(object);
        bucket = CacheInternal.hashtab[n2 % 523];
        this.objReq.set(262144L, object, string, null, null, this.regionNumber);
        mdslot = bucket.findSlot(this.objReq, n2, this.gFlag);
        if (mdslot != null) {
            if (bl2 && (mdslot.state & 0x200L) == 0L) {
                this.release(mdslot, mdslot.objid, true);
                return;
            }
            if (CacheInternal.isDistributedObject(mdslot)) {
                if (bl) {
                    this.broadcastManipulation(n, mdslot, false);
                } else if ((mdslot.state & 0x100L) != 0L && (n & 0xB) != 0) {
                    CacheInternal.addInvalidation(mdslot, bl3 || CacheInternal.isDiskLeader);
                }
                bl4 = true;
            }
            if (!bl) {
                bl4 = true;
            }
        } else {
            this.objReq.set(0x1040000L, object, string, null, null, this.regionNumber);
            mdslot = bucket.findSlot(this.objReq, n2, this.gFlag);
            if (mdslot != null) {
                if (bl && CacheInternal.distributed && (((Attributes)mdslot.object).flags & 1L) != 0L) {
                    this.broadcastManipulation(n, null, false);
                    bl4 = true;
                }
                if (n == 2) {
                    ((Attributes)mdslot.object).setFlags(((Attributes)mdslot.object).flags | 0x100L);
                } else if (n == 4) {
                    ((Attributes)mdslot.object).setFlags(((Attributes)mdslot.object).flags & 0xFFFFFFFFFFFFFEFFL);
                }
                if (n != 8) {
                    return;
                }
                if (bl2 && (((Attributes)mdslot.object).flags & 1L) == 0L) {
                    this.release(mdslot, mdslot.objid, true);
                    return;
                }
            } else {
                n2 = CacheInternal.hashName(string);
                bucket = CacheInternal.hashtab[n2 % 523];
                this.objReq.set(262144L, string, string, null, null, this.regionNumber);
                mdslot = bucket.findSlot(this.objReq, n2, this.gFlag);
                if (mdslot != null && CacheInternal.isDistributedObject(mdslot) && bl) {
                    this.objReq.set(262144L, object, string, null, null, this.regionNumber);
                    this.broadcastManipulation(n, null, false);
                    bl4 = true;
                }
                return;
            }
        }
        this.manipulate(n, mdslot.objid, true, bl4);
    }

    void invalidate(long l, boolean bl, boolean bl2, boolean bl3) throws CacheException, IOException {
        if (bl2) {
            this.manipulate(8, l, bl, bl3);
        } else {
            this.manipulate(1, l, bl, bl3);
        }
    }

    void manipulate(int n, long l, boolean bl, boolean bl2) throws CacheException, IOException {
        GroupInfo groupInfo = null;
        groupInfo = this.manipulateCascade(n, l, bl, bl2);
        if (groupInfo != null) {
            int n2 = this.findBucket(groupInfo.id);
            int n3 = CacheHandle.findSlot(groupInfo.id);
            Bucket bucket = CacheInternal.hashtab[n2];
            bucket.objReleaseGroup(n3, groupInfo, l);
        }
    }

    GroupInfo manipulateCascade(int n, long l, boolean bl, boolean bl2) throws CacheException, IOException {
        Mdslot mdslot;
        int n2 = 0;
        String string = null;
        long[] lArray = null;
        boolean bl3 = false;
        GroupInfo groupInfo = null;
        Object object = null;
        int n3 = this.findBucket(l);
        int n4 = CacheHandle.findSlot(l);
        Bucket bucket = CacheInternal.hashtab[n3];
        try {
            mdslot = bucket.getSlot(n4, l, false);
        }
        catch (InvalidObjectException invalidObjectException) {
            if (bl) {
                throw invalidObjectException;
            }
            return null;
        }
        if (!bl2 && CacheInternal.isDistributedObject(mdslot)) {
            bl2 = true;
            this.broadcastManipulation(n, mdslot, true);
        }
        if ((mdslot.state & 0x80L) != 0L) {
            if (n == 2) {
                mdslot.state |= 0x20000000L;
            } else if (n == 4) {
                mdslot.state &= 0xFFFFFFFFDFFFFFFFL;
            }
            if (mdslot.children != null) {
                lArray = bucket.clearChildList(mdslot, n == 8);
            }
        }
        if ((n & 0xE) != 0 && !mdslot.loaderInherit) {
            object = mdslot.name;
            string = mdslot.qualifier;
            n2 = mdslot.regionNumber;
        }
        if (((n & 3) != 0 && (mdslot.state & 0x1000080L) == 0L || n == 8) && mdslot.groupId != 0L) {
            groupInfo = new GroupInfo(mdslot.groupId, mdslot.mygId);
        }
        if ((n & 3) != 0 && (mdslot.state & 0x1000000L) == 0L || n == 8) {
            bucket.objInvalidate(n4, l, bl, n == 8);
        }
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == 0L) continue;
                this.manipulateCascade(n, lArray[i], false, bl2);
            }
        }
        if (object != null) {
            this.objReq.set(0x1040000L, object, string, null, null, n2);
            int n5 = CacheInternal.hashName(object);
            bucket = CacheInternal.hashtab[n5 % 523];
            mdslot = bucket.findSlot(this.objReq, n5, new Flag());
            if (mdslot != null) {
                if (n == 8) {
                    this.manipulateCascade(n, mdslot.objid, true, true);
                } else if (n == 2) {
                    ((Attributes)mdslot.object).setFlags(((Attributes)mdslot.object).flags | 0x100L);
                } else if (n == 4) {
                    ((Attributes)mdslot.object).setFlags(((Attributes)mdslot.object).flags & 0xFFFFFFFFFFFFFEFFL);
                }
            }
        }
        lArray = null;
        return groupInfo;
    }

    void broadcastManipulation(int n, Mdslot mdslot, boolean bl) throws NetworkException {
        boolean bl2;
        int n2 = 1;
        boolean bl3 = bl2 = !bl && mdslot != null && (mdslot.state & 0x800L) != 0L;
        if ((n & 0xB) != 0 && mdslot != null && (mdslot.state & 0x100L) != 0L) {
            CacheInternal.addInvalidation(mdslot, true);
            n2 = 0;
        }
        Message message = mdslot != null ? new Message(mdslot.name, mdslot.qualifier, mdslot.group, n2, bl2, n == 8) : new Message(this.objReq.name, this.objReq.qualifier, this.objReq.group, n2, bl2, n == 8);
        Task task = (n & 9) != 0 ? new Task(2, message) : (n == 2 ? new Task(17, message) : new Task(18, message));
        n2 = 1;
        Net.broadcast(task, this, n2);
        if (bl2) {
            if (this.respList == null) {
                this.respList = new ResponseList();
            }
            this.respList.addToReplyList(this.resp);
            this.resp = null;
        }
    }

    void broadcastUpdate(Object object, Mdslot mdslot) throws IOException, InvalidObjectException, NetworkException {
        Groups[] groupsArray = null;
        boolean bl = false;
        int n = 3;
        long l = this.objReq.type & 0x5080L;
        boolean bl2 = (mdslot.state & 0x800L) != 0L;
        UpdateMessage updateMessage = new UpdateMessage(mdslot.name, mdslot.qualifier, mdslot.group, groupsArray, l, object, mdslot.objStatus.createTime, bl2);
        Task task = new Task(n, (Object)updateMessage, bl);
        int n2 = 1;
        Net.broadcast(task, this, n2);
        if (bl2) {
            if (mdslot.ownerInfo != null && mdslot.ownerInfo.lockHolder == this) {
                mdslot.ownerInfo.addResponse(this.resp);
                this.resp = null;
            } else {
                if (this.respList == null) {
                    this.respList = new ResponseList();
                }
                this.respList.addToReplyList(this.resp);
                this.resp = null;
            }
        }
    }

    void cancelResponse() {
        if (this.resp == null) {
            return;
        }
        CacheInternal.respQ.freeRespSlot(this.resp.id);
        this.resp = null;
    }

    void release(Mdslot mdslot, long l, boolean bl) throws CacheException {
        GroupInfo groupInfo;
        int n = this.findBucket(l);
        int n2 = CacheHandle.findSlot(l);
        Bucket bucket = CacheInternal.hashtab[n];
        if ((mdslot.state & 0x2000000L) != 0L && this.object instanceof InputStream) {
            this.closeInStream();
        }
        if ((groupInfo = bucket.objRelease(n2, l, bl)) != null) {
            n = this.findBucket(groupInfo.id);
            n2 = CacheHandle.findSlot(groupInfo.id);
            bucket = CacheInternal.hashtab[n];
            bucket.objReleaseGroup(n2, groupInfo, l);
        }
    }

    void release() throws CacheException {
        if (this.resp != null) {
            this.cancelResponse();
        }
        if (this.released) {
            return;
        }
        this.release(this.slot, this.objid, true);
        this.clearHandle();
    }

    void clearLockTable() {
        if (this.lockTable == null) {
            return;
        }
        if (!this.lockTable.isEmpty()) {
            Enumeration enumeration = this.lockTable.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    Object k = enumeration.nextElement();
                    Object v = this.lockTable.get(k);
                    if (v == null || v.equals("000DESTROYED$$")) continue;
                    this.releaseOwnership(k, ((Mdslot)v).qualifier, -1);
                }
                catch (Exception exception) {}
            }
            this.lockTable.clear();
        }
        this.lockTable = null;
    }

    void releaseHandle() {
        try {
            this.release();
            this.regionNumber = 0;
            this.cancelAllResponse();
            this.clearLockTable();
            this.objReq.reset();
        }
        catch (Exception exception) {
            CacheInternal.exceptionHandler(exception);
        }
    }

    Attributes getAttributes(Object object, String string) throws CacheException, ObjectNotFoundException, IOException {
        Mdslot mdslot = null;
        Bucket bucket = null;
        Flag flag = new Flag();
        ObjectReq objectReq = new ObjectReq();
        objectReq.set(262144L, object, string, null, null, 0);
        int n = CacheInternal.hashName(object);
        bucket = CacheInternal.hashtab[n % 523];
        mdslot = bucket.findSlot(objectReq, n, flag);
        if (mdslot != null) {
            Attributes attributes = this.getAttributes(mdslot);
            bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
            return attributes;
        }
        objectReq.set(0x1040000L, object, string, null, null, 0);
        mdslot = bucket.findSlot(objectReq, n, flag);
        if (mdslot == null) {
            throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + object);
        }
        Attributes attributes = (Attributes)mdslot.object;
        bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
        return (Attributes)attributes.clone();
    }

    Attributes getAttributes(Mdslot mdslot) {
        Attributes attributes = new Attributes();
        long l = 0L;
        long l2 = 0L;
        if (mdslot.ttlInterval > 0L) {
            attributes.ttl = mdslot.ttlInterval;
        }
        if ((mdslot.state & 0x200L) != 0L) {
            l2 |= 1L;
        }
        if ((mdslot.state & 0x800L) != 0L) {
            l2 |= 2L;
        }
        if ((mdslot.state & 0x20000L) != 0L) {
            l2 |= 4L;
        }
        if ((mdslot.state & 0x2000L) != 0L) {
            l2 |= 8L;
        }
        if ((mdslot.state & 0x400000L) != 0L) {
            l2 |= 0x10L;
        }
        if ((mdslot.state & 0x10000L) != 0L) {
            l2 |= 0x20L;
        }
        if ((mdslot.state & 0x40000000L) != 0L) {
            l2 |= 0x200L;
        }
        if ((mdslot.state & 0x80000000L) != 0L) {
            l2 |= 0x400L;
        }
        attributes.flags = l2;
        attributes.version = mdslot.version;
        attributes.ttl = mdslot.ttlInterval;
        attributes.idleTime = mdslot.idleTime;
        attributes.createTime = mdslot.objStatus.createTime;
        attributes.defaultTtl = mdslot.ttlDefaultInterval;
        attributes.userAttrs = mdslot.userAttrs;
        attributes.priority = mdslot.objStatus.priority;
        attributes.maxCount = mdslot.regionCount == null ? 0 : mdslot.regionCount[mdslot.regionCount.length - 1].max;
        if (mdslot.eventHandlers != null) {
            for (int i = 0; i < 6; ++i) {
                if (mdslot.eventHandlers[i] == null) continue;
                try {
                    attributes.setCacheEventListener(i, mdslot.eventHandlers[i], mdslot.eventDefault[i]);
                    continue;
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
        }
        return attributes;
    }

    void setAttributes(Attributes attributes) throws InvalidHandleException, IOException, CantSynchronizeGroupException, InvalidObjectException {
        this.checkHandle();
        int n = this.findBucket(this.objid);
        int n2 = CacheHandle.findSlot(this.objid);
        Bucket bucket = CacheInternal.hashtab[n];
        bucket.setAttributes(n2, this.objid, attributes);
    }

    ObjectStatus getStatus(Object object, String string) throws CacheException, ObjectNotFoundException, IOException {
        ObjectStatus objectStatus = null;
        Flag flag = new Flag();
        ObjectReq objectReq = new ObjectReq();
        objectReq.set(262144L, object, string, null, null, 0);
        int n = CacheInternal.hashName(object);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        Mdslot mdslot = bucket.findSlot(objectReq, n, flag);
        if (mdslot != null) {
            objectStatus = mdslot.objStatus;
            bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
        }
        return objectStatus;
    }

    AggregateStatus getAggregateStatus(Object object, String string) throws CacheException, ObjectNotFoundException, IOException {
        AggregateStatus aggregateStatus = null;
        Flag flag = new Flag();
        ObjectReq objectReq = new ObjectReq();
        objectReq.set(262144L, object, string, null, null, 0);
        int n = CacheInternal.hashName(object);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        Mdslot mdslot = bucket.findSlot(objectReq, n, flag);
        if (mdslot != null) {
            if ((mdslot.state & 0x80L) != 0L) {
                aggregateStatus = mdslot.aggStatus;
            }
            bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
        }
        return aggregateStatus;
    }

    Object getOwnership(Object object, String string, String string2, int n) throws InvalidHandleException, ObjectNotFoundException, InvalidObjectException, ObjectNotSynchronizedException, ResponseFailedException, TimeoutException, InterruptedException, IOException, CacheException, NetworkException {
        Mdslot mdslot = null;
        Bucket bucket = null;
        Flag flag = new Flag();
        ObjectReq objectReq = new ObjectReq();
        boolean bl = false;
        Object object2 = object;
        objectReq.set(0x1040000L, object, string, null, null, 0);
        int n2 = CacheInternal.hashName(object);
        bucket = CacheInternal.hashtab[n2 % 523];
        mdslot = bucket.findSlot(objectReq, n2, flag);
        if (mdslot != null && (mdslot.state & 0x8000000L) == 0L && mdslot.ownerInfo != null) {
            object2 = mdslot.ownerInfo.slot.name;
            bl = true;
        }
        if (!bl) {
            objectReq.set(262144L, object, string, null, null, 0);
            n2 = CacheInternal.hashName(object);
            bucket = CacheInternal.hashtab[n2 % 523];
            mdslot = bucket.findSlot(objectReq, n2, flag);
            if (mdslot != null) {
                if ((mdslot.state & 0x20080L) == 131200L) {
                    object2 = mdslot.ownerInfo.slot.name;
                    bl = true;
                } else {
                    bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
                }
            }
        }
        if (!bl && string2 != null) {
            objectReq.set(262144L, string2, string, null, null, 0);
            n2 = CacheInternal.hashName(string2);
            bucket = CacheInternal.hashtab[n2 % 523];
            mdslot = bucket.findSlot(objectReq, n2, flag);
            if (mdslot != null) {
                if ((mdslot.state & 0x80L) != 0L) {
                    if ((mdslot.state & 0x100000L) != 0L) {
                        bl = true;
                    } else if ((mdslot.state & 0x20000L) != 0L) {
                        bl = true;
                        object2 = mdslot.ownerInfo.slot.name;
                    } else {
                        bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
                    }
                } else {
                    bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
                }
            }
        }
        if (!bl) {
            throw new ObjectNotSynchronizedException(CacheInternal.EXP_OBJNOSYNC + object);
        }
        this.getOwnership(n, mdslot, object2);
        bucket.objRelease(CacheHandle.findSlot(mdslot.objid), mdslot.objid, true);
        return object2;
    }

    private void getOwnership(int n, Mdslot mdslot, Object object) throws ObjectNotFoundException, ObjectNotSynchronizedException, InvalidObjectException, CacheException, ResponseFailedException, TimeoutException, InterruptedException, NetworkException {
        Object object2;
        OwnerInfo ownerInfo;
        boolean bl;
        Mdslot mdslot2;
        int n2 = 1;
        int n3 = 3000;
        if ((mdslot.state & 0x80L) != 0L) {
            mdslot2 = mdslot.ownerInfo.slot;
            boolean bl2 = bl = !CacheInternal.isDistributedObject(mdslot);
            if ((mdslot.state & 0x100000L) != 0L) {
                ownerInfo = (OwnerInfo)mdslot.lockTable.get(object);
                if (ownerInfo == null) {
                    ownerInfo = new OwnerInfo(mdslot2);
                    mdslot.lockTable.put(object, ownerInfo);
                }
            } else {
                if (!object.equals(mdslot2.name)) {
                    throw new ObjectNotSynchronizedException(CacheInternal.EXP_OBJNOSYNC + object);
                }
                ownerInfo = mdslot.ownerInfo;
            }
        } else {
            object2 = (Attributes)mdslot.object;
            ownerInfo = mdslot.ownerInfo;
            bl = !CacheInternal.isDistributedObject(mdslot);
            mdslot2 = mdslot;
        }
        int n4 = this.findBucket(mdslot2.objid);
        int n5 = CacheHandle.findSlot(mdslot2.objid);
        Bucket bucket = CacheInternal.hashtab[n4];
        if (ownerInfo == null) {
            throw new ObjectNotSynchronizedException(CacheInternal.EXP_OBJNOSYNC + mdslot2.name);
        }
        if (n < n3) {
            n = n3;
        }
        long l = System.currentTimeMillis();
        while (n > 0) {
            block23: {
                long l2;
                if (bucket.getLock(mdslot, ownerInfo, this, bl, n)) {
                    if (this.lockTable == null) {
                        this.lockTable = new Hashtable();
                    }
                    this.lockTable.put(object, mdslot2);
                    return;
                }
                long l3 = mdslot2.state & 0x5080L;
                LockMessage lockMessage = new LockMessage(mdslot2.name, mdslot2.qualifier, mdslot2.group, object, l3, true);
                object2 = new Task(9, lockMessage);
                if (ownerInfo.retry) {
                    try {
                        Thread.sleep(s_lockSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l2 = System.currentTimeMillis();
                    n = (int)((long)n - (l2 - l));
                    l = l2;
                    if (n < 0) break;
                }
                ((Task)object2).setWaitTime(n);
                Net.broadcast((Task)object2, this, 2);
                try {
                    this.resp.waitFor(n);
                    bucket.checkOwnershipResponse(ownerInfo, this.resp);
                    n2 = this.resp.status;
                    CacheInternal.respQ.freeRespSlot(this.resp.id);
                    this.resp = null;
                    if (n2 == 1) {
                        if (this.lockTable == null) {
                            this.lockTable = new Hashtable();
                        }
                        this.lockTable.put(object, mdslot2);
                        return;
                    }
                    if (n2 != 7) break block23;
                    if (ownerInfo.lockHolder == null) {
                        try {
                            Thread.sleep(s_lockSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    l2 = System.currentTimeMillis();
                    n = (int)((long)n - (l2 - l));
                    l = l2;
                    continue;
                }
                catch (CacheException cacheException) {
                    bucket.checkOwnershipResponse(ownerInfo, this.resp);
                    CacheInternal.respQ.freeRespSlot(this.resp.id);
                    this.resp = null;
                    throw cacheException;
                }
            }
            if (n2 == 6 || (mdslot.state & 0x10L) == 0L) {
                throw new InvalidObjectException(CacheInternal.EXP_INVALOBJ);
            }
            if (this.resp.exception == null) {
                throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL);
            }
            throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL, this.resp.getException(), this.resp.cacheName);
        }
        throw new TimeoutException();
    }

    void releaseOwnership(Object object, String string, int n) throws NotOwnerException, IOException, CacheException {
        if (this.lockTable == null) {
            throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + object);
        }
        Object v = this.lockTable.get(object);
        if (v == null) {
            throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + object);
        }
        if ("000DESTROYED$$".equals(v)) {
            throw new SyncObjectDestroyedException(CacheInternal.EXP_SYNCDESTROYED + object);
        }
        Mdslot mdslot = (Mdslot)v;
        OwnerInfo ownerInfo = object.equals(mdslot.name) ? mdslot.ownerInfo : (OwnerInfo)mdslot.lockTable.get(object);
        if (ownerInfo == null || ownerInfo.state == 3) {
            throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + object);
        }
        if (ownerInfo.lockHolder != this) {
            throw new NotOwnerException(CacheInternal.EXP_NOTOWNER + object);
        }
        int n2 = this.findBucket(mdslot.objid);
        int n3 = CacheHandle.findSlot(mdslot.objid);
        Bucket bucket = CacheInternal.hashtab[n2];
        if (n > 0 && ownerInfo.respList != null) {
            try {
                ownerInfo.respList.waitForAll(n);
            }
            catch (TimeoutException timeoutException) {
                throw timeoutException;
            }
            catch (Exception exception) {
                ownerInfo.respList.cancelAll();
                bucket.releaseLock(ownerInfo, this);
                throw CacheInternal.exceptionHandler(exception);
            }
        }
        bucket.releaseLock(ownerInfo, this);
        this.lockTable.remove(object);
    }

    void updateRemote(UpdateMessage updateMessage, int n) throws CacheException, IOException, NetworkException, InterruptedException, ClassNotFoundException {
        Object object;
        Groups[] groupsArray = updateMessage.groups;
        if (updateMessage.updateObj != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])updateMessage.updateObj);
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, updateMessage.qualifier);
            try {
                object = cacheObjectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (CacheInternal.shouldLog(6)) {
                    CacheInternal.exceptionLog("[Mem] ", classNotFoundException);
                }
                return;
            }
        } else {
            object = null;
        }
        String string = groupsArray != null ? groupsArray[0].name : updateMessage.group;
        if (!this.getRegionNumber(updateMessage.qualifier)) {
            return;
        }
        if (n == 20) {
            this.objReq.set(0x20C200L, updateMessage.name, updateMessage.qualifier, string, object, 0);
        } else {
            this.objReq.set(2408960L, updateMessage.name, updateMessage.qualifier, string, object, 0);
        }
        try {
            this.findObject();
        }
        catch (CacheFullException cacheFullException) {
            this.manipulateObject(1, updateMessage.name, updateMessage.qualifier, false, true, false);
            this.release();
            throw cacheFullException;
        }
        this.release();
    }

    void spool(Object object, String string) throws CacheException, IOException, InterruptedException {
        this.objReq.set(262144L, object, string, null, null, this.regionNumber);
        try {
            this.findObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return;
        }
        catch (LoadConflictException loadConflictException) {
            return;
        }
        Task task = new Task(5, (Object)this.slot, this.slot.objid);
        CacheInternal.asyncTaskQ.putTask(task);
        this.release();
    }

    void saveObject(Object object, String string) throws CacheException, IOException, InterruptedException {
        this.objReq.set(0x240000L, object, string, null, null, this.regionNumber);
        try {
            this.findObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return;
        }
        catch (LoadConflictException loadConflictException) {
            return;
        }
        this.saveCascade(this.objid);
        this.release();
    }

    private void saveCascade(long l) {
        int n = this.findBucket(l);
        int n2 = CacheHandle.findSlot(l);
        Bucket bucket = CacheInternal.hashtab[n];
        try {
            Mdslot mdslot = bucket.getSlot(n2, l, false);
            if ((mdslot.state & 0x100L) != 0L || (mdslot.state & 4L) != 0L || (mdslot.state & 0x1000000L) != 0L) {
                return;
            }
            if ((mdslot.state & 0x80L) != 0L) {
                if (mdslot.children != null) {
                    long[] lArray = bucket.getChildIdList(mdslot);
                    for (int i = 0; i < lArray.length; ++i) {
                        if (lArray[i] == 0L) continue;
                        this.saveCascade(lArray[i]);
                    }
                }
            } else {
                long l2 = bucket.checkDiskSlot(mdslot);
                if (l2 == -1L) {
                    throw new DiskCacheException(CacheInternal.EXP_DISKCACHE + " " + this.slot.name);
                }
                if (l2 == 8L) {
                    this.writeDiskObject(mdslot);
                    bucket.updateDiskSlot(mdslot);
                    if (CacheInternal.isDistributedObject(mdslot)) {
                        DiskMessage diskMessage = new DiskMessage(mdslot.name, null, null, 0, 0);
                        Task task = new Task(6, diskMessage);
                        try {
                            Net.broadcast(task, this, 1);
                        }
                        catch (NetworkException networkException) {
                            CacheInternal.exceptionLog("[Mem] ", networkException);
                        }
                    }
                } else {
                    --mdslot.refcount;
                }
            }
        }
        catch (InvalidObjectException invalidObjectException) {
        }
        catch (Exception exception) {
            CacheInternal.exceptionHandler(exception);
        }
    }

    private boolean checkRegionCount(Mdslot mdslot) {
        RegionCount regionCount = null;
        RegionCount[] regionCountArray = mdslot.regionCount;
        if (regionCountArray == null) {
            return false;
        }
        for (int i = 0; i < regionCountArray.length; ++i) {
            if (!regionCountArray[i].incNcheck(mdslot.objStatus.size)) continue;
            regionCount = regionCountArray[i];
        }
        if (regionCount == null) {
            return false;
        }
        return this.regionOverflow(regionCount.getId(), mdslot.objStatus.priority, regionCount, null);
    }

    private boolean regionOverflow(long l, int n, RegionCount regionCount, AggregateStatus aggregateStatus) {
        int n2 = this.findBucket(l);
        int n3 = CacheHandle.findSlot(l);
        Bucket bucket = CacheInternal.hashtab[n2];
        try {
            Mdslot mdslot = bucket.getSlot(n3, l, true);
            if (aggregateStatus == null) {
                aggregateStatus = mdslot.aggStatus;
            }
            CleanLists cleanLists = bucket.getChildList(mdslot);
            Mdslot[] mdslotArray = cleanLists.slots;
            long[] lArray = cleanLists.ids;
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < mdslotArray.length && regionCount.check(); ++i) {
                if (lArray[i] == 0L || lArray[i] != mdslotArray[i].objid) continue;
                if ((mdslotArray[i].state & 0x80L) != 0L) {
                    this.regionOverflow(lArray[i], n, regionCount, aggregateStatus);
                    continue;
                }
                if (mdslotArray[i].objStatus.priority > n) continue;
                this.foundVictim(mdslotArray[i], lArray[i], n, aggregateStatus, l2);
            }
            bucket.deccounts(mdslot);
            return regionCount.check();
        }
        catch (InvalidObjectException invalidObjectException) {
            return regionCount.check();
        }
    }

    private void foundVictim(Mdslot mdslot, long l, int n, AggregateStatus aggregateStatus, long l2) {
        try {
            if ((mdslot.state & 0x10L) == 0L || (mdslot.state & 0x1000004L) != 0L) {
                return;
            }
            if (mdslot.refcount > 0) {
                return;
            }
            if ((mdslot.state & 0x10000L) != 0L) {
                if (CacheInternal.rootDiskPath == null || (mdslot.state & 0x2000L) == 0L || !(mdslot.object instanceof Serializable)) {
                    return;
                }
                int n2 = this.findBucket(mdslot.groupId);
                Bucket bucket = CacheInternal.hashtab[n2];
                bucket.spoolToDisk(mdslot);
                return;
            }
            if (mdslot.capacityPolicy == null) {
                mdslot.state |= 0x400000000L;
                this.invalidate(l, false, false, true);
                return;
            }
            if (mdslot.capacityPolicy.policy(mdslot, aggregateStatus, l2, this.slot)) {
                mdslot.state |= 0x400000000L;
                this.invalidate(l, false, false, true);
                return;
            }
        }
        catch (CacheException cacheException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector netSearchList(Object object, String string, int n, boolean bl) throws CacheException, NetworkException, InterruptedException, IOException {
        boolean bl2 = true;
        boolean bl3 = true;
        this.release();
        byte[] byArray = null;
        long l = 16384L;
        Message message = new Message(object, string, null, l, true);
        Task task = new Task(22, (Object)message, false);
        if (CacheInternal.isDistributed()) {
            Net.broadcast(task, this, 0);
        }
        this.objReq.set(262144L, object, string, null, null, 0);
        try {
            this.findObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            bl3 = false;
        }
        Vector<Object> vector = new Vector<Object>();
        if (bl3 && this.object != null) {
            if (this.object instanceof NullObj) {
                vector.add(null);
            } else {
                vector.add(this.object);
            }
        }
        try {
            this.resp.waitFor(n);
            Vector vector2 = (Vector)this.resp.retObj;
            Exception exception = this.resp.getException();
            if (!bl && exception != null) {
                throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL, exception);
            }
            if (vector2 != null) {
                if (this.resp.isStream) {
                    bl2 = false;
                    for (int i = 0; i < vector2.size(); ++i) {
                        String string2 = (String)vector2.get(i);
                        FileInputStream fileInputStream = new FileInputStream(string2);
                        vector.add(fileInputStream);
                    }
                } else if (this.resp.isDisk) {
                    bl2 = false;
                    for (int i = 0; i < vector2.size(); ++i) {
                        vector.add((String)vector2.get(i));
                    }
                } else {
                    for (int i = 0; i < vector2.size(); ++i) {
                        byArray = (byte[])vector2.get(i);
                        try {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, string);
                            Object object2 = cacheObjectInputStream.readObject();
                            if (object2 instanceof NullObj) {
                                object2 = null;
                            }
                            vector.add(object2);
                            continue;
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        finally {
            if (bl2) {
                this.cancelResponse();
            }
        }
        return vector;
    }

    protected Object netSearch(int n) throws CallbackException, ObjectNotFoundException, CacheException, CachePermissionsException, NetworkException {
        return this.netSearch(n, false);
    }

    protected Object netSearch(int n, boolean bl) throws CallbackException, ObjectNotFoundException, CacheException, CachePermissionsException, NetworkException {
        byte[] byArray = null;
        long l = this.objReq.type & 0x5080L;
        Message message = new Message(this.objReq.name, this.objReq.qualifier, this.objReq.group, l, true);
        Task task = new Task(7, (Object)message, false);
        if ((this.slot.state & 4L) == 0L) {
            throw new CallbackException();
        }
        if (!CacheInternal.isDistributed()) {
            throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name);
        }
        Net.broadcast(task, this, 0);
        try {
            this.resp.waitFor(n);
        }
        catch (Exception exception) {
            this.cancelResponse();
            throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name + ", " + exception.toString());
        }
        UpdateMessage updateMessage = (UpdateMessage)this.resp.retObj;
        if (updateMessage != null) {
            byArray = (byte[])updateMessage.updateObj;
        }
        this.cancelResponse();
        if (byArray == null) {
            throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name);
        }
        if (bl) {
            this.slot.objStatus.createTime = updateMessage.createTime;
            this.slot.ttlInterval = updateMessage.ttlInterval;
            this.slot.idleTime = updateMessage.idleTime;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, updateMessage.qualifier);
            Object object = cacheObjectInputStream.readObject();
            if (object instanceof NullObj) {
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getFromRemote(CacheAddress cacheAddress, int n, boolean bl) throws CallbackException, ObjectNotFoundException, CacheException, CachePermissionsException, NetworkException {
        Object object;
        block21: {
            object = null;
            byte[] byArray = null;
            long l = 16384L;
            Message message = new Message(this.objReq.name, this.objReq.qualifier, this.objReq.group, l, true);
            Task task = new Task(21, (Object)message, false);
            if ((this.slot.state & 4L) == 0L) {
                throw new CallbackException();
            }
            if (cacheAddress == null || cacheAddress.equals(CacheInternal.getLocalAddressObject())) {
                throw new InvalidArgumentException("CacheAddress");
            }
            if (!CacheInternal.isDistributed()) {
                throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name);
            }
            Net.send(task, null, cacheAddress.getAddress(), this);
            try {
                this.resp.waitFor(n);
            }
            catch (Exception exception) {
                this.cancelResponse();
                throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name, exception);
            }
            UpdateMessage updateMessage = (UpdateMessage)this.resp.retObj;
            this.resp.retObj = null;
            Exception exception = this.resp.getException();
            String string = this.resp.cacheName;
            this.cancelResponse();
            if (updateMessage == null || updateMessage.updateObj == null) {
                if (exception != null) {
                    throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL, exception, string);
                }
                throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name);
            }
            if (bl) {
                this.slot.objStatus.createTime = updateMessage.createTime;
                this.slot.ttlInterval = updateMessage.ttlInterval;
                this.slot.idleTime = updateMessage.idleTime;
            }
            try {
                if (updateMessage.objectType == 0x2000000L) {
                    File file;
                    block20: {
                        FileInputStream fileInputStream = null;
                        byte[] byArray2 = new byte[4096];
                        String string2 = (String)updateMessage.updateObj;
                        file = new File(string2);
                        try {
                            int n2;
                            object = this.createStream();
                            fileInputStream = new FileInputStream(file);
                            while ((n2 = fileInputStream.read(byArray2)) > 0) {
                                this.outStream.write(byArray2, 0, n2);
                            }
                            Object var21_23 = null;
                            if (fileInputStream == null) break block20;
                        }
                        catch (Throwable throwable) {
                            Object var21_24 = null;
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            file.delete();
                            throw throwable;
                        }
                        fileInputStream.close();
                    }
                    file.delete();
                    {
                        break block21;
                    }
                }
                if (updateMessage.objectType == 4096L) {
                    String string3 = (String)updateMessage.updateObj;
                    File file = new File(string3);
                    this.slot.state |= 0x1000L;
                    File file2 = this.getDiskFile();
                    if (!file.renameTo(file2)) {
                        this.moveFile(file, file2);
                    }
                    object = this.slot.object = file2.getAbsolutePath();
                } else {
                    byArray = (byte[])updateMessage.updateObj;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, updateMessage.qualifier);
                    object = cacheObjectInputStream.readObject();
                    cacheObjectInputStream.close();
                    if (object instanceof NullObj) {
                        return null;
                    }
                }
            }
            catch (ObjectExistsException objectExistsException) {
                throw objectExistsException;
            }
            catch (Exception exception2) {
                throw new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + this.objReq.name, exception2);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block6: {
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            byte[] byArray = new byte[2048];
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                while ((n = fileInputStream.read(byArray)) >= 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                Object var8_7 = null;
                if (fileInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    Mdslot remoteSearch(Object object, String string, String string2, int n, boolean bl) {
        if (bl) {
            this.objReq.set(n, object, string, string2, null, 0);
        } else {
            this.objReq.set(0x40000L | (long)n, object, string, string2, null, 0);
        }
        this.remote = true;
        try {
            this.findObject();
        }
        catch (Exception exception) {
            this.remote = false;
            return null;
        }
        this.remote = false;
        return this.slot;
    }

    boolean isRemoteRequest() {
        return this.remote;
    }

    int findOwner(Object object, String string, String string2, Task task, Object object2) {
        OwnerInfo ownerInfo = null;
        this.objReq.set(0x1040000L | (long)task.taskType, object, string, string2, null, 0);
        try {
            this.findObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            try {
                this.objReq.set(0x40000L | (long)task.taskType, object, string, string2, null, 0);
                this.findObject();
                if ((this.slot.state & 0x80L) == 0L) {
                    this.release();
                    return 4;
                }
            }
            catch (ObjectNotFoundException objectNotFoundException2) {
                return 4;
            }
            catch (Exception exception) {
                CacheInternal.exceptionLog("[Mem] ", exception);
                return 2;
            }
        }
        catch (CacheNotAvailableException cacheNotAvailableException) {
            return 4;
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
            return 2;
        }
        int n = this.findBucket(this.objid);
        int n2 = CacheHandle.findSlot(this.objid);
        Bucket bucket = CacheInternal.hashtab[n];
        if (object2.equals(this.slot.name)) {
            ownerInfo = this.slot.ownerInfo;
        } else if (this.slot.lockTable != null) {
            ownerInfo = (OwnerInfo)this.slot.lockTable.get(object2);
        }
        if (ownerInfo == null) {
            return 4;
        }
        return bucket.giveupOwnership(ownerInfo, task);
    }

    private void finishUpdate(Mdslot mdslot, ObjectReq objectReq) throws IOException, CacheException {
        boolean bl = false;
        if (CacheInternal.isDistributedObject(mdslot) && (objectReq.type & 0x200L) == 0L) {
            bl = (mdslot.state & 0x800L) != 0L;
            this.broadcastUpdate(mdslot.object, mdslot);
        }
        if (mdslot.group != null) {
            int n = this.findBucket(mdslot.groupId);
            int n2 = CacheHandle.findSlot(mdslot.groupId);
            Bucket bucket = CacheInternal.hashtab[n];
            bucket.setGroup(n2, mdslot);
        }
        if (mdslot.eventHandlers != null && mdslot.eventHandlers[2] != null) {
            CacheEvent cacheEvent = new CacheEvent(2, mdslot.name, mdslot.qualifier, mdslot.object, mdslot.eventHandlers[2]);
            cacheEvent.listener.handleEvent(cacheEvent);
        }
    }

    boolean isPresent(Object object, String string) throws CacheNotAvailableException, NullObjectNameException {
        CacheHandle.cacheReady();
        if (!this.getRegionNumber(string)) {
            return false;
        }
        int n = CacheInternal.hashName(object);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        return bucket.isPresent(object, string, this.regionNumber, n);
    }

    boolean getRegionNumber(String string) throws NullObjectNameException {
        if (this.regionNumber > 0) {
            return true;
        }
        int n = CacheInternal.hashName(string);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        this.regionNumber = bucket.getRegionNumber(string, n);
        return this.regionNumber > 0;
    }

    int getRegionCount(String string) {
        try {
            int n = CacheInternal.hashName(string);
            Bucket bucket = CacheInternal.hashtab[n % 523];
            return bucket.getRegionCount(string, n);
        }
        catch (NullObjectNameException nullObjectNameException) {
            return 0;
        }
    }

    String getParent(String string) throws RegionNotFoundException, NullObjectNameException {
        int n = CacheInternal.hashName(string);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        return bucket.getParent(string, n);
    }

    static boolean regionExists(Object object, String string) throws CacheNotAvailableException, NullObjectNameException {
        CacheHandle.cacheReady();
        int n = CacheInternal.hashName(object);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        return bucket.isPresent(object, string, 0, n);
    }

    private boolean checkTtl(Mdslot mdslot, boolean bl, boolean bl2) throws CacheException, IOException {
        boolean bl3 = false;
        boolean bl4 = true;
        if (mdslot.timeToLive > 0L && mdslot.timeToLive <= System.currentTimeMillis()) {
            if ((mdslot.state & 0x80L) != 0L) {
                if ((mdslot.state & 0x400000L) == 0L) {
                    bl2 = false;
                    bl4 = false;
                } else {
                    bl3 = true;
                }
            }
            try {
                mdslot.state |= 0x200000000L;
                this.invalidate(mdslot.objid, bl2, bl3, false);
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
            if (bl) {
                this.clearHandle();
            }
            return bl4;
        }
        return false;
    }

    OutputStream createStream() throws ObjectExistsException, DiskCacheException, CacheException {
        this.slot.state |= 0x2002000L;
        try {
            File file = this.getDiskFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.outStream = new CacheOutputStream(file, fileOutputStream);
        }
        catch (ObjectExistsException objectExistsException) {
            throw objectExistsException;
        }
        catch (Exception exception) {
            throw CacheInternal.exceptionHandler(exception);
        }
        return this.outStream;
    }

    private void closeOutStream(Bucket bucket) throws IOException, DiskCacheException {
        this.slot.object = this.outStream.getObject();
        this.slot.isFile = this.outStream.isFile();
        this.slot.objStatus.size = this.outStream.getSize();
        if (!this.slot.isFile && !CacheInternal.incrCurCnt(this.slot)) {
            this.slot.objStatus.size = 0L;
            this.slot.isFile = true;
            this.outStream.forceToDisk();
            this.slot.object = this.outStream.getObject();
        }
        this.outStream.close();
        this.outStream = null;
        bucket.updateDiskSlot(this.slot);
    }

    private void closeDiskLoad(Bucket bucket) throws IOException, DiskCacheException {
        bucket.updateDiskSlot(this.slot);
        this.slot.object = this.slot.path + File.separator + this.slot.fileName;
        this.slot.isFile = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getDiskFile() throws ObjectExistsException, CacheException, IOException {
        Object object;
        if (!CacheInternal.isDiskCacheConfigured()) {
            throw new DiskCacheException(CacheInternal.EXP_DISKNA);
        }
        int n = CacheInternal.hashName(this.slot.name);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        long l = bucket.checkDiskSlot(this.slot);
        if (l == -1L) {
            throw new DiskCacheException(CacheInternal.EXP_DISKCACHE + " " + this.slot.name);
        }
        if (l == 4L) {
            while ((this.slot.state & 0x4000000L) != 0L) {
                bucket.updateDiskNotify();
                object = this.slot.loadLock;
                synchronized (object) {
                    if ((this.slot.state & 0x4000000L) != 0L) {
                        try {
                            this.slot.loadLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw CacheInternal.exceptionHandler(interruptedException);
                        }
                    }
                }
            }
        }
        File file = new File(this.slot.path, this.slot.fileName);
        if (l != 8L) {
            if ((this.slot.state & 0x2000000L) != 0L) {
                long l2;
                this.slot.objStatus.size = l2 = file.length();
                try {
                    if (l2 <= (long)CacheInternal.streamBufSize && CacheInternal.incrCurCnt(this.slot)) {
                        byte[] byArray = new byte[(int)l2];
                        object = new FileInputStream(file);
                        ((FileInputStream)object).read(byArray);
                        ((FileInputStream)object).close();
                        this.slot.object = byArray;
                        this.slot.isFile = false;
                    }
                    this.slot.isFile = true;
                    this.slot.object = file.getAbsolutePath();
                    this.slot.objStatus.size = 0L;
                }
                catch (Exception exception) {
                    throw CacheInternal.exceptionHandler(exception);
                }
            } else {
                this.slot.isFile = true;
                this.slot.object = file.getAbsolutePath();
            }
            --this.slot.refcount;
            throw new ObjectExistsException();
        }
        return file;
    }

    private void closeInStream() {
        try {
            if (this.object != null) {
                ((InputStream)this.object).close();
            }
        }
        catch (IOException iOException) {
            CacheInternal.exceptionLog("[Mem] ", iOException);
        }
    }

    private Object getInStream(ObjectReq objectReq) throws IOException, FileNotFoundException, CacheException {
        if (this.slot.isFile) {
            return new FileInputStream((String)this.slot.object);
        }
        return new ByteArrayInputStream((byte[])this.slot.object);
    }

    void checkHandle() throws InvalidHandleException {
        if (this.released) {
            throw new InvalidHandleException(CacheInternal.EXP_BADHANDLE);
        }
    }

    protected void clearHandle() {
        this.objid = 0L;
        this.object = null;
        this.slot = null;
        this.released = true;
        this.regionNumber = 0;
    }

    static void cacheReady() throws CacheNotAvailableException {
        if ((CacheInternal.flags & 1) == 0) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
    }

    static long makeid(int n, int n2) {
        return (long)n << 53 | (long)n2 << 20;
    }

    static long updateid(long l) {
        long l2 = l + 1L & 0xFFFFFL;
        return l & 0xFFFFFFFFFFF00000L | l2;
    }

    int findBucket(long l) {
        return (int)(l >> 53);
    }

    static int findSlot(long l) {
        return (int)(l >> 20 & 0xFFFFFFFFFFFFFFFFL);
    }

    long getObjid() {
        return this.objid;
    }

    Object getName() {
        return this.objReq.name;
    }

    void spoolDisk(Mdslot mdslot) throws DiskCacheException, IOException, CacheException {
        int n = this.findBucket(mdslot.objid);
        int n2 = CacheHandle.findSlot(mdslot.objid);
        Bucket bucket = CacheInternal.hashtab[n];
        long l = bucket.checkDiskSlot(mdslot);
        if (l == 8L) {
            this.writeDiskObject(mdslot);
        }
        if (l != -1L) {
            bucket.updateSpooledSlot(mdslot);
        }
        if (l == 8L && CacheInternal.isDistributedObject(mdslot)) {
            DiskMessage diskMessage = new DiskMessage(mdslot.name, null, null, 0, 0);
            Task task = new Task(6, diskMessage);
            try {
                Net.broadcast(task, this, 1);
            }
            catch (NetworkException networkException) {
                CacheInternal.exceptionLog("[Mem] ", networkException);
            }
        }
    }

    private void writeDiskObject(Mdslot mdslot) throws IOException, CacheException {
        File file = new File(mdslot.path, mdslot.fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(fileOutputStream);
        cacheObjectOutputStream.writeObject(mdslot.object);
        cacheObjectOutputStream.close();
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDiskObject(Mdslot mdslot) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
        Object object;
        Object object2;
        while ((mdslot.state & 0x4000000L) != 0L) {
            int n = this.findBucket(mdslot.objid);
            object2 = CacheInternal.hashtab[n];
            ((Bucket)object2).updateDiskNotify();
            object = mdslot.loadLock;
            synchronized (object) {
                if ((mdslot.state & 0x4000000L) != 0L) {
                    mdslot.loadLock.wait(1000L);
                }
            }
        }
        object = new File(mdslot.path, mdslot.fileName);
        object2 = new FileInputStream((File)object);
        if ((mdslot.state & 0x2000000L) != 0L) {
            if (mdslot.objStatus.fileSize > 0L && mdslot.objStatus.fileSize <= (long)CacheInternal.streamBufSize) {
                byte[] byArray = new byte[(int)mdslot.objStatus.fileSize];
                mdslot.object = byArray;
                ((FileInputStream)object2).read(byArray);
                mdslot.state |= 0x40L;
            } else {
                mdslot.isFile = true;
                mdslot.object = new String(mdslot.path + File.separator + mdslot.fileName);
            }
        } else {
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream((InputStream)object2, mdslot.qualifier);
            mdslot.object = cacheObjectInputStream.readObject();
            cacheObjectInputStream.close();
            mdslot.state |= 0x40L;
        }
        ((FileInputStream)object2).close();
    }

    void updateDisk(DiskMessage diskMessage) throws CacheException {
        int n = CacheInternal.hashName(diskMessage.name);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        bucket.updateDiskNotify();
    }

    boolean checkDiskRef(DiskMessage diskMessage) throws CacheException {
        int n = CacheInternal.hashName(diskMessage.name);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        return bucket.checkObjectRef(diskMessage);
    }

    byte[] getGlobalDiskMap(Message message) throws CacheException {
        Bucket bucket = CacheInternal.hashtab[(int)message.objectType];
        return bucket.getGlobalDiskMap().toBytes();
    }

    Object locateGroup(Object object, String string, String string2) throws CacheException, IOException, InterruptedException {
        this.objReq.set(128L, object, string, string2, null, this.regionNumber);
        this.findObject();
        return this.object;
    }

    void findGroup(Object object, String string, String string2) throws CacheException, IOException, InterruptedException {
        this.objReq.set(262272L, object, string, string2, null, this.regionNumber);
        this.findObject();
    }

    void createGroup(Object object, String string, String string2, String string3, Attributes attributes) throws CacheException, IOException, InterruptedException {
        if (string2 == null) {
            if (object.equals(string)) {
                this.objReq.set(0x10800080L, object, string, string3, attributes, this.regionNumber);
            } else {
                this.objReq.set(0x800080L, object, string, string3, attributes, this.regionNumber);
            }
        } else {
            this.regionNumber = 0;
            if (!this.getRegionNumber(string2)) {
                throw new RegionNotFoundException();
            }
            this.objReq.set(0x10800080L, object, string, string3, attributes, 0, string2);
        }
        try {
            this.findObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            try {
                this.destroy(object, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw objectNotFoundException;
        }
    }

    void waitForAllResponse(int n) throws CacheException {
        CacheHandle.cacheReady();
        if (this.respList == null) {
            return;
        }
        try {
            this.respList.waitForAll(n);
        }
        catch (TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (Exception exception) {
            this.cancelAllResponse();
            throw CacheInternal.exceptionHandler(exception);
        }
    }

    void cancelAllResponse() {
        this.cancelResponse();
        if (this.respList == null) {
            return;
        }
        this.respList.cancelAll();
        this.respList = null;
    }

    Object[] listNames(String string) throws CacheException {
        Mdslot mdslot;
        if (!this.getRegionNumber(string)) {
            throw new RegionNotFoundException();
        }
        int n = CacheInternal.hashName(string);
        Bucket bucket = CacheInternal.hashtab[n % 523];
        this.objReq.set(262144L, string, string, null, null, this.regionNumber);
        try {
            mdslot = bucket.findSlot(this.objReq, n, this.gFlag);
        }
        catch (IOException iOException) {
            return null;
        }
        long[] lArray = bucket.getChildIdList(mdslot);
        Object[] objectArray = new Object[lArray.length];
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            int n3 = this.findBucket(lArray[i]);
            int n4 = CacheHandle.findSlot(lArray[i]);
            bucket = CacheInternal.hashtab[n3];
            try {
                mdslot = bucket.getSlot(n4, lArray[i], true);
                if (mdslot != null && (mdslot.state & 0x1000080L) == 0L) {
                    objectArray[n2++] = mdslot.name;
                }
                bucket.deccounts(mdslot);
                continue;
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    String[] listRegions(String string) throws CacheException {
        int n;
        Mdslot mdslot;
        if (!this.getRegionNumber(string)) {
            throw new RegionNotFoundException();
        }
        int n2 = CacheInternal.hashName(string);
        Bucket bucket = CacheInternal.hashtab[n2 % 523];
        this.objReq.set(262144L, string, string, null, null, this.regionNumber);
        try {
            mdslot = bucket.findSlot(this.objReq, n2, this.gFlag);
            n = ((String)mdslot.name).length() + 1;
        }
        catch (IOException iOException) {
            return null;
        }
        long[] lArray = bucket.getChildIdList(mdslot);
        String[] stringArray = new String[lArray.length];
        int n3 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            int n4 = this.findBucket(lArray[i]);
            int n5 = CacheHandle.findSlot(lArray[i]);
            bucket = CacheInternal.hashtab[n4];
            try {
                mdslot = bucket.getSlot(n5, lArray[i], true);
                if (mdslot != null && (mdslot.state & 0x80L) != 0L) {
                    stringArray[n3++] = ((String)mdslot.name).substring(n);
                }
                bucket.deccounts(mdslot);
                continue;
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        return stringArray2;
    }

    Enumeration createList(String string) throws CacheException {
        Object[] objectArray = this.listNames(string);
        return new ListObjectsEnumeration(string, this, objectArray);
    }

    ListObject getNext(Object object, String string) {
        this.objReq.set(262144L, object, string, null, null, this.regionNumber);
        try {
            this.findObject();
            if (this.listObject == null) {
                this.listObject = new ListObject();
            }
            this.listObject.name = this.slot.name;
            this.listObject.object = this.slot.object instanceof NullObj ? null : this.slot.object;
            return this.listObject;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    Object getObject() {
        return this.object;
    }

    public void finalize() {
        if (this.cacheInstance == CacheInternal.cacheInstance) {
            this.releaseHandle();
        }
    }

    static {
        String string = System.getProperty(LOCKSLEEP_PROP);
        if (string != null) {
            try {
                s_lockSleep = Integer.parseInt(string);
            }
            catch (Exception exception) {
                s_lockSleep = 200;
            }
        }
    }
}

