/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.group.Address;

public class CacheAttributes {
    public static final int TCP = 0;
    public static final int HTTP = 1;
    static final String TRANSPORT_TCP = "TCP";
    static final String TRANSPORT_HTTP = "HTTP";
    static final String DEFAULT_CONFIG = "CacheDefaultConfig.properties";
    static final String CACHE_CONFIG = "javacache.properties";
    public boolean distribute;
    public String version;
    public int maxObjects;
    public int maxSize;
    public int diskSize;
    public String diskPath;
    public int cleanInterval;
    public int pingInterval;
    public String logger;
    public String logFileName;
    public int logSeverity;
    Vector cacheAddr;
    public String capacityPolicy;
    public int capacityBuffer;
    public int maxIdleTime;
    public int transport;
    public boolean isSSLEnabled;
    public String keyStoreLocation;
    public String sslConfigFilePath;
    public String localAddress;
    public String cacheName;
    public boolean autoInit;
    public boolean nlDeathDetectable = true;
    public int overrideNLPort = -1;
    public String multicastAddr = "228.6.8.9";
    public int multicastPort = 11111;
    public int multicastInterval = 300;
    public boolean useMulticast = false;
    public int multicastTTL = 0;
    public long resolutionInterval = 3000L;
    public boolean usePriorityOrder = false;
    public int lowerPortBoundry = 0;
    public int upperPortBoundry = 0;
    boolean maxObjectsSet;
    boolean maxSizeSet;
    boolean diskSizeSet;
    boolean logSeveritySet;
    boolean cleanIntervalSet;
    boolean capacityBufferSet;
    boolean nameSet;
    boolean autoInitSet;
    private Hashtable configTable;
    private Address defaultDiscovery;
    static /* synthetic */ Class class$oracle$ias$cache$CacheAttributes;

    public CacheAttributes() throws CacheException {
        try {
            this.maxObjectsSet = false;
            this.maxSizeSet = false;
            this.diskSizeSet = false;
            this.logSeveritySet = false;
            this.cleanIntervalSet = false;
            this.capacityBufferSet = false;
            this.nameSet = false;
            this.capacityBuffer = 15;
            this.autoInit = true;
            this.readConfig(DEFAULT_CONFIG, true);
            this.defaultDiscovery = (Address)this.cacheAddr.get(0);
            this.cacheAddr.remove(0);
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(null, exception);
        }
    }

    void readConfig(String string, boolean bl) throws Exception {
        String string2;
        this.getConfigInfo(string);
        if (bl && (string2 = this.getConfigItem("version")) != null) {
            this.version = string2;
        }
        if ((string2 = this.getConfigItem("cleanInterval")) != null) {
            this.cleanInterval = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("pingInterval")) != null) {
            this.pingInterval = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("maxSize")) != null) {
            this.maxSize = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("maxObjects")) != null) {
            this.maxObjects = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("logFileName")) != null) {
            this.logFileName = string2;
        }
        if ((string2 = this.getConfigItem("logSeverity")) != null) {
            this.logSeverity = CacheLogger.parseLogSeverity(string2);
        }
        if ((string2 = this.getConfigItem("logger")) != null) {
            this.logger = string2;
        }
        if ((string2 = this.getConfigItem("diskPath")) != null && !string2.equalsIgnoreCase("null")) {
            this.diskPath = string2.replace('/', File.separatorChar);
        }
        if ((string2 = this.getConfigItem("diskSize")) != null) {
            this.diskSize = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("distribute")) != null) {
            this.distribute = string2.equalsIgnoreCase("true");
        }
        if ((string2 = this.getConfigItem("useMulticast")) != null) {
            this.useMulticast = string2.equalsIgnoreCase("true");
        }
        if ((string2 = this.getConfigItem("multicastAddr")) != null) {
            this.multicastAddr = string2;
        }
        if ((string2 = this.getConfigItem("multicastPort")) != null) {
            this.multicastPort = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("multicastInterval")) != null) {
            this.multicastInterval = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("multicastTTL")) != null) {
            this.multicastTTL = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("discoveryAddress")) != null) {
            this.buildAddrList(string2);
        }
        this.configTable = null;
    }

    void getConfigInfo(String string) throws Exception {
        String string2;
        String string3;
        this.configTable = new Hashtable();
        InputStream inputStream = (class$oracle$ias$cache$CacheAttributes == null ? (class$oracle$ias$cache$CacheAttributes = CacheAttributes.class$("oracle.ias.cache.CacheAttributes")) : class$oracle$ias$cache$CacheAttributes).getResourceAsStream(string3 = "/" + string);
        if (inputStream == null) {
            inputStream = new FileInputStream(string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            char[] cArray = string2.toCharArray();
            if (cArray.length == 0 || cArray[0] == '#') continue;
            for (n2 = 0; n2 < cArray.length && cArray[n2] != '='; ++n2) {
            }
            if (n2 == cArray.length) continue;
            for (n = n2; n < cArray.length && cArray[n] != '#'; ++n) {
            }
            String string4 = new String(cArray, 0, n2).trim();
            String string5 = new String(cArray, n2 + 1, n - n2 - 1).trim();
            if (string5.equals("")) continue;
            this.configTable.put(string4.toLowerCase(), string5);
        }
        bufferedReader.close();
    }

    private String getConfigItem(String string) {
        return (String)this.configTable.get(string.toLowerCase());
    }

    private void buildAddrList(String string) throws UnknownHostException {
        InetAddress inetAddress = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":,", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) continue;
            if (string2.equals(":")) {
                if (inetAddress != null) continue;
                inetAddress = InetAddress.getLocalHost();
                continue;
            }
            if (inetAddress != null) {
                int n = Integer.parseInt(string2);
                this.addCacheAddr(inetAddress, n, true);
                inetAddress = null;
                continue;
            }
            inetAddress = InetAddress.getByName(string2);
        }
    }

    public void setDistribute(boolean bl) {
        this.distribute = bl;
    }

    public void setMaxObjects(int n) {
        this.maxObjects = n;
        this.maxObjectsSet = true;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
        this.maxSizeSet = true;
    }

    public void setDiskSize(int n) {
        this.diskSize = n;
        this.diskSizeSet = true;
    }

    public void setDiskPath(String string) {
        this.diskPath = string;
    }

    public void setCleanInterval(int n) {
        this.cleanInterval = n;
        this.cleanIntervalSet = true;
    }

    public void setPingInterval(int n) {
        this.pingInterval = n;
    }

    public void setLogger(String string) {
        this.logger = string;
    }

    public void setLogSeverity(int n) {
        this.logSeverity = n;
        this.logSeveritySet = true;
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public void setCapacityPolicy(String string) {
        this.capacityPolicy = string;
    }

    public void setAutoInit(boolean bl) {
        this.autoInit = bl;
        this.autoInitSet = true;
    }

    public void setCacheName(String string) {
        this.cacheName = string;
        this.nameSet = true;
    }

    public void setKeyStore(String string) {
        this.keyStoreLocation = string;
    }

    public void setSSLConfigFile(String string) {
        this.sslConfigFilePath = string;
    }

    public void setEnableSSL(boolean bl) {
        this.isSSLEnabled = bl;
    }

    public void setTransport(int n) {
        this.transport = n;
    }

    public void setLocalAddress(String string) {
        this.localAddress = string;
    }

    public void setCapacityBuffer(int n) throws InvalidArgumentException {
        if (n < 0 || n > 100) {
            throw new InvalidArgumentException();
        }
        this.capacityBuffer = n;
        this.capacityBufferSet = true;
    }

    public void addCacheAddr(InetAddress inetAddress, int n) {
        this.addCacheAddr(inetAddress, n, false);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl) {
        this.addCacheAddr(inetAddress, n, false, false, 0);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2) {
        this.addCacheAddr(inetAddress, n, bl, bl2, 0);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2, int n2) {
        Address address = null;
        Address address2 = null;
        if (this.cacheAddr == null) {
            this.cacheAddr = new Vector();
        }
        address = new Address(inetAddress, n, bl2, n2);
        int n3 = this.cacheAddr.size();
        for (int i = 0; i < n3; ++i) {
            address2 = (Address)this.cacheAddr.elementAt(i);
            if (address2 == null || !address2.getIPString().equals(address.getIPString())) continue;
            if (bl) {
                this.cacheAddr.setElementAt(address, i);
                return;
            }
            if (n != address2.getPort()) continue;
            return;
        }
        this.cacheAddr.addElement(address);
    }

    public synchronized void addPrimaryCacheAddr(InetAddress inetAddress, int n) {
        Address address = null;
        Address address2 = null;
        if (this.cacheAddr == null) {
            this.cacheAddr = new Vector();
            address = new Address(inetAddress, n, false, 0);
            this.cacheAddr.addElement(address);
            return;
        }
        int n2 = this.cacheAddr.size();
        address = new Address(inetAddress, n, false, n2 - 1);
        Vector<Address> vector = new Vector<Address>();
        vector.addElement(address);
        for (int i = 0; i < n2; ++i) {
            address2 = (Address)this.cacheAddr.elementAt(i);
            if (address2 == null) continue;
            if (address2.getIPString().equals(address.getIPString()) && n == address2.getPort()) {
                if (!address2.isOriginal()) continue;
                int n3 = address2.getPriorityOrder();
                address = new Address(inetAddress, n, true, n3);
                vector.setElementAt(address, 0);
                continue;
            }
            vector.addElement(address2);
        }
        this.cacheAddr = vector;
    }

    public boolean addressIsOriginal(InetAddress inetAddress, int n) {
        Address address = null;
        Address address2 = null;
        if (this.cacheAddr == null) {
            this.cacheAddr = new Vector();
        }
        address = new Address(inetAddress, n);
        int n2 = this.cacheAddr.size();
        for (int i = 0; i < n2; ++i) {
            address2 = (Address)this.cacheAddr.elementAt(i);
            if (address2 == null || !address2.getString().equals(address.getString())) continue;
            return address2.isOriginal();
        }
        return false;
    }

    public boolean removeCacheAddr(InetAddress inetAddress, int n) {
        if (this.cacheAddr == null || this.cacheAddr.isEmpty()) {
            return false;
        }
        Address address = new Address(inetAddress, n, false, 0);
        for (int i = 0; i < this.cacheAddr.size(); ++i) {
            Address address2 = (Address)this.cacheAddr.elementAt(i);
            if (address2 == null || !address2.equals(address)) continue;
            this.cacheAddr.remove(i);
            return true;
        }
        return false;
    }

    public Enumeration getCacheAddrs() {
        return new AddrEnumerator();
    }

    public CacheAddress[] getCoordinatorList() {
        int n = this.cacheAddr.size();
        if (n == 0) {
            CacheAddress[] cacheAddressArray = new CacheAddress[]{new CacheAddress(this.defaultDiscovery)};
            return cacheAddressArray;
        }
        CacheAddress[] cacheAddressArray = new CacheAddress[n];
        for (int i = 0; i < cacheAddressArray.length; ++i) {
            cacheAddressArray[i] = new CacheAddress((Address)this.cacheAddr.get(i));
        }
        return cacheAddressArray;
    }

    public Vector getAddrList() {
        if (this.cacheAddr == null || this.cacheAddr.size() == 0) {
            Vector<Address> vector = new Vector<Address>();
            vector.add(this.defaultDiscovery);
            return vector;
        }
        return this.cacheAddr;
    }

    public String getAddrListString() {
        String string = "none";
        if (this.cacheAddr == null || this.cacheAddr.isEmpty()) {
            string = this.defaultDiscovery.toString();
        } else {
            Address address = (Address)this.cacheAddr.elementAt(0);
            string = address.toString();
            for (int i = 1; i < this.cacheAddr.size(); ++i) {
                address = (Address)this.cacheAddr.elementAt(i);
                string = string + "," + address.toString();
            }
        }
        return string;
    }

    public String getAddrString() {
        String string = "none";
        if (this.cacheAddr == null || this.cacheAddr.isEmpty()) {
            string = this.defaultDiscovery.getString();
        } else {
            Address address = (Address)this.cacheAddr.elementAt(0);
            string = address.getString();
            for (int i = 1; i < this.cacheAddr.size(); ++i) {
                address = (Address)this.cacheAddr.elementAt(i);
                string = string + "," + address.getString();
            }
        }
        return string;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public boolean isNodeListenerDeathDetectable() {
        return this.nlDeathDetectable;
    }

    public void setNodeListenerDeathDetectable(boolean bl) {
        this.nlDeathDetectable = bl;
    }

    public void setOverrideNodeListenerPort(int n) {
        this.overrideNLPort = n;
    }

    public int getOverrideNodeListenerPort() {
        return this.overrideNLPort;
    }

    public String getMulticastAddress() {
        return this.multicastAddr;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getMulticastInterval() {
        return this.multicastInterval;
    }

    public int getMulticastTTL() {
        return this.multicastTTL;
    }

    public boolean isMulticast() {
        return this.useMulticast;
    }

    public long getResolutionInterval() {
        return this.resolutionInterval;
    }

    public boolean isPriorityOrderEnabled() {
        return this.usePriorityOrder;
    }

    public int getLowerPortBoundry() {
        return this.lowerPortBoundry;
    }

    public int getUpperPortBoundry() {
        return this.upperPortBoundry;
    }

    public void setLowerPortBoundry(int n) {
        this.lowerPortBoundry = n;
    }

    public void setUpperPortBoundry(int n) {
        this.upperPortBoundry = n;
    }

    public String toString() {
        String string = this.maxSize == 0 ? "using count only" : String.valueOf(this.maxSize) + " mb";
        String string2 = CacheLogger.severityToString(this.logSeverity);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("distribute = ");
        stringBuffer.append(this.distribute);
        stringBuffer.append(", \nversion = ");
        stringBuffer.append(this.version);
        stringBuffer.append(", \nmax objects = ");
        stringBuffer.append(this.maxObjects);
        stringBuffer.append(", \nmax cache size = ");
        stringBuffer.append(string);
        stringBuffer.append(", \ndiskSize = ");
        stringBuffer.append(this.diskSize);
        stringBuffer.append(" mb");
        stringBuffer.append(", \ndiskPath = ");
        stringBuffer.append(this.diskPath);
        stringBuffer.append(", \nclean interval = ");
        stringBuffer.append(this.cleanInterval);
        stringBuffer.append(", \nping interval = ");
        stringBuffer.append(this.pingInterval);
        stringBuffer.append(", \nLogFileName = ");
        stringBuffer.append(this.logFileName);
        stringBuffer.append(", \nLogger = ");
        stringBuffer.append(this.logger);
        stringBuffer.append(", \nLog severity = ");
        stringBuffer.append(string2);
        stringBuffer.append(", \ncache address list = ");
        stringBuffer.append(this.getAddrListString());
        stringBuffer.append(", \ntransport = ");
        stringBuffer.append(this.transport);
        stringBuffer.append(", \nisSSLEnabled = ");
        stringBuffer.append(this.isSSLEnabled);
        stringBuffer.append(", \nkeyStore = ");
        stringBuffer.append(this.keyStoreLocation);
        stringBuffer.append(", \nsslConfigFilePath = ");
        stringBuffer.append(this.sslConfigFilePath);
        stringBuffer.append(", \nlocalAddress = ");
        stringBuffer.append(this.localAddress);
        stringBuffer.append(", \nlDeathDetectable = ");
        stringBuffer.append(this.nlDeathDetectable);
        stringBuffer.append(", \noverrideNLPort = ");
        stringBuffer.append(this.overrideNLPort);
        stringBuffer.append(", \nuseMulticast = ");
        stringBuffer.append(this.useMulticast);
        stringBuffer.append(", \nmulticastAddr = ");
        stringBuffer.append(this.multicastAddr);
        stringBuffer.append(", \nmulticastPort = ");
        stringBuffer.append(this.multicastPort);
        stringBuffer.append(", \nmulticastInterval = ");
        stringBuffer.append(this.multicastInterval);
        stringBuffer.append(", \nmulticastTTL = ");
        stringBuffer.append(this.multicastTTL);
        stringBuffer.append(", \nresolutionInterval = ");
        stringBuffer.append(this.resolutionInterval);
        stringBuffer.append(", \nusePriorityOrder ");
        stringBuffer.append(this.usePriorityOrder);
        stringBuffer.append(", \nlowerPortBoundry ");
        stringBuffer.append(this.lowerPortBoundry);
        stringBuffer.append(", \nupperPortBoundry ");
        stringBuffer.append(this.upperPortBoundry);
        return stringBuffer.toString();
    }

    static int parseTransportInt(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.equals(TRANSPORT_TCP)) {
            n = 0;
        } else if (string.equals(TRANSPORT_HTTP)) {
            n = 1;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AddrEnumerator
    implements Enumeration {
        int next = 0;

        private AddrEnumerator() {
        }

        public boolean hasMoreElements() {
            return !(CacheAttributes.this.cacheAddr == null ? this.next > 0 : this.next >= CacheAttributes.this.cacheAddr.size());
        }

        public Object nextElement() {
            if (CacheAttributes.this.cacheAddr == null) {
                throw new NoSuchElementException();
            }
            Address address = (Address)CacheAttributes.this.cacheAddr.elementAt(this.next);
            ++this.next;
            return address.getString();
        }
    }
}

