/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CNamedTypeAccessor
extends NamedTypeAccessor {
    static final int MAXLENGTH = Integer.MAX_VALUE;
    final int[] meta = new int[1];
    T4CMAREngine mare;

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long l2 = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(l2);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                bl = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return bl;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    T4CNamedTypeAccessor(OracleStatement oracleStatement, String string, short s2, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, string, s2, n2, bl);
        this.mare = t4CMAREngine;
    }

    T4CNamedTypeAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, String string, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2, string);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        byte[] byArray = this.mare.unmarshalDALC();
        byte[] byArray2 = this.mare.unmarshalDALC();
        byte[] byArray3 = this.mare.unmarshalDALC();
        int n2 = this.mare.unmarshalUB2();
        long l2 = this.mare.unmarshalUB4();
        int n3 = this.mare.unmarshalUB2();
        this.setOffset(this.lastRowProcessed);
        if (l2 > 0L) {
            int n4 = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
            this.setLength(this.lastRowProcessed, n4);
            this.setNull(this.lastRowProcessed, false);
        } else {
            this.setNull(this.lastRowProcessed, true);
        }
        this.processIndicator((int)l2);
        return false;
    }
}

