/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk.patchrepresentation;

import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.patchrepresentation.InvalidPatchPackageException;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchAutomation;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchBundleEntity;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchSingletonVariant;
import oracle.opatch.opatchsdk.patchrepresentation.PatchType;
import oracle.opatch.opatchsdk.patchrepresentation.PatchVariant;
import oracle.opatch.opatchsdk.patchrepresentation.SystemPatchVariant;
import oracle.opatch.patchsdk.OPatchEngineeredSystemPatch;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import oracle.opatch.patchsdk.util.BundleValidationException;
import oracle.opatch.patchsdk.util.BundleXmlException;
import oracle.opatch.patchsdk.util.BundleXmlHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchEngineeredSystemVariant
extends SystemPatchVariant
implements OPatchAutomation {
    public OPatchEngineeredSystemVariant(PatchPackage patch) throws InvalidPatchPackageException {
        super(patch);
        if (!(patch instanceof OPatchEngineeredSystemPatch)) {
            throw new InvalidPatchPackageException("OPatchEngineeredSystemPatch", "OPatchEngineeredSystemVariant");
        }
    }

    @Override
    public PatchVariant[] getSubPatches() {
        OPatchEngineeredSystemPatch oesPatch = (OPatchEngineeredSystemPatch)this.patch;
        List subPatchList = oesPatch.getSubPatches();
        ArrayList<OPatchSingletonVariant> patchVariantList = new ArrayList<OPatchSingletonVariant>();
        for (GenericPatch subPatch : subPatchList) {
            try {
                if (!(subPatch instanceof OPatchSingletonPatch)) continue;
                patchVariantList.add(new OPatchSingletonVariant((PatchPackage)subPatch));
            }
            catch (InvalidPatchPackageException invalidPatchPackageException) {}
        }
        PatchVariant[] patchVariants = new PatchVariant[patchVariantList.size()];
        patchVariantList.toArray(patchVariants);
        return patchVariants;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public OPatchBundleEntity getBundleEntity() throws PatchPackageException {
        SystemPatchBundleXML esysbundle;
        OPatchEngineeredSystemPatch oesPatch = (OPatchEngineeredSystemPatch)this.patch;
        String bundleContent = oesPatch.getBundleXml();
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(bundleContent);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", (Throwable)e);
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
        }
        return new OPatchBundleEntity(esysbundle);
    }

    @Override
    public PatchType getPatchType() {
        return PatchType.ENGSYSTEM;
    }

    @Override
    public String getApplyAutomationXml() {
        OPatchEngineeredSystemPatch oesPatch = (OPatchEngineeredSystemPatch)this.patch;
        return oesPatch.getApplyAutomationXMLLoc();
    }

    @Override
    public String getRollbackAutomationXml() {
        OPatchEngineeredSystemPatch oesPatch = (OPatchEngineeredSystemPatch)this.patch;
        return oesPatch.getRollbackAutomationXMLLoc();
    }

    public List<String> getAutomationXmls() {
        OPatchEngineeredSystemPatch oesPatch = (OPatchEngineeredSystemPatch)this.patch;
        return oesPatch.getAutoXmls();
    }
}

