/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk.homecollection;

public class InstalledPatch {
    private String patchId;
    private String uniquePatchId;
    private String language;
    private String installedTime;
    private String patchDesc;
    private FixedBug[] bugs;
    private PatchComponent[] comps;

    InstalledPatch(String patchId, String uniquePatchId, String language, String installedTime, String patchDesc) {
        this.patchId = patchId;
        this.uniquePatchId = uniquePatchId;
        this.language = language;
        this.installedTime = installedTime;
        this.patchDesc = patchDesc;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public String getUniquePatchId() {
        return this.uniquePatchId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getInstalledTime() {
        return this.installedTime;
    }

    public String getPatchDesc() {
        return this.patchDesc;
    }

    public FixedBug[] getFixedBugs() {
        return this.bugs;
    }

    public PatchComponent[] getComps() {
        return this.comps;
    }

    void addBugs(FixedBug[] bugList) {
        this.bugs = bugList;
    }

    void addComps(PatchComponent[] compList) {
        this.comps = compList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append("patchId: " + this.patchId + " ");
        sb.append("uniquePatchId: " + this.uniquePatchId + " ");
        sb.append("language: " + this.language + " ");
        sb.append("installedTime: " + this.installedTime + " ");
        sb.append("patchDesc: " + this.patchDesc + " ");
        for (FixedBug bug : this.bugs) {
            sb.append("bugs: " + bug + " ");
        }
        for (PatchComponent comp : this.comps) {
            sb.append("comps: " + comp + " ");
        }
        sb.append("] ");
        return sb.toString();
    }

    public static class FixedBug {
        private String bugId;
        private String bugDesc;

        FixedBug(String bugId, String bugDesc) {
            this.bugId = bugId;
            this.bugDesc = bugDesc;
        }

        public String getBugId() {
            return this.bugId;
        }

        public String getBugDesc() {
            return this.bugDesc;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" [");
            sb.append("bugId: " + this.bugId + " ");
            sb.append("bugDesc: " + this.bugDesc + " ");
            sb.append("] ");
            return sb.toString();
        }
    }

    public static class PatchComponent {
        String compName;
        String compVersion;
        ComponentFile[] compFiles;

        PatchComponent(String compName, String compVersion) {
            this.compName = compName;
            this.compVersion = compVersion;
        }

        void addComponentFiles(ComponentFile[] compFiles) {
            this.compFiles = compFiles;
        }

        public String getCompName() {
            return this.compName;
        }

        public String getCompVersion() {
            return this.compVersion;
        }

        public ComponentFile[] getCompFiles() {
            return this.compFiles;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" [");
            sb.append("compName: " + this.compName + " ");
            sb.append("compVersion: " + this.compVersion + " ");
            for (ComponentFile file : this.compFiles) {
                sb.append("compFiles: " + file + " ");
            }
            sb.append("] ");
            return sb.toString();
        }
    }

    public static class ComponentFile {
        private String fileName;
        private String fileVersion;

        ComponentFile(String fileName, String fileVersion) {
            this.fileName = fileName;
            this.fileVersion = fileVersion;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileVersion() {
            return this.fileVersion;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" [");
            sb.append("fileName: " + this.fileName + " ");
            sb.append("fileVersion: " + this.fileVersion + " ");
            sb.append("] ");
            return sb.toString();
        }
    }
}

