/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import model.common.AbstractBaseTarget;
import model.fafmw.BI;
import model.fafmw.LDAP;
import model.fafmw.NodeManager;
import model.fafmw.SOAComposite;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import model.fafmw.WLServer;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.MultiClient;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchsdk.FAExecutionContext;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchBIPDeployAction;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchExecutedArtifact;
import oracle.opatch.opatchsdk.OPatchExecutionStep;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAConfigContext;
import oracle.opatch.opatchsdk.OPatchFAConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAPrereq;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchInterviewAction;
import oracle.opatch.opatchsdk.OPatchJEELifecycleAction;
import oracle.opatch.opatchsdk.OPatchManagedServerConfigProperties;
import oracle.opatch.opatchsdk.OPatchMultipleBIPDeploy;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPrereqArtifactStatus;
import oracle.opatch.opatchsdk.OPatchSOACompositeLifecycleAction;
import oracle.opatch.opatchsdk.OPatchSOADeployAction;
import oracle.opatch.opatchsdk.OPatchSOARbDeployAction;
import oracle.opatch.opatchsdk.OPatchStandAloneDeployAction;
import oracle.opatch.opatchsdk.OPatchStandAloneOperations;
import oracle.opatch.opatchsdk.OPatchStandAloneSOADeployAction;
import oracle.opatch.opatchsdk.OPatchStartException;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchStopException;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdk.OPatchUtils;

public class OPatchFATarget
extends OPatchTarget {
    private boolean isFAConfigCloned = false;
    private OPatchFAClonedConfigInstance faInstance = null;
    private static OPatchFAClonedConfigInstance privateCopy = null;
    private String commonComponentsHome = "";
    private static OPatchFAConfigContext faConfigContext = null;
    private ArrayList<FAExecutionContext> exContext = new ArrayList();
    private FAExecutionContext lifeContext = null;
    private FAExecutionContext saDeployContext = null;
    private static String lifeCycleTimeStamp = "";
    private static String saDeployTimeStamp = "";
    private ArrayList<OPatchFAAutomationAction> allOperatedLifeCycleActions = new ArrayList();

    public OPatchFATarget(OPatchContext oc, String commonComponentsHome) throws OPatchException {
        super(oc);
        this.commonComponentsHome = commonComponentsHome;
        this.lifeContext = new FAExecutionContext();
        this.saDeployContext = new FAExecutionContext();
        this.exContext.add(this.lifeContext);
        this.exContext.add(this.saDeployContext);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        String formattedDate = dateFormatter.format(new Date());
        lifeCycleTimeStamp = formattedDate;
        saDeployTimeStamp = formattedDate;
    }

    protected static String getLifeCycleTimeStamp() {
        return "lifecycle_" + lifeCycleTimeStamp;
    }

    protected static String getStandAloneDeployTimeStamp() {
        return "standalone_" + saDeployTimeStamp;
    }

    protected void addContext(FAExecutionContext context) {
        if (context != null) {
            this.exContext.add(context);
        }
    }

    public static OPatchFAConfigContext getConfigContext() {
        return faConfigContext;
    }

    public static OPatchFAAutomationAction[] mergeArtifactsList(OPatchFAAutomationAction[] act1, OPatchFAAutomationAction[] act2) {
        OPatchFAAutomationAction action;
        int i;
        ArrayList<OPatchFAAutomationAction> faActionArr = new ArrayList<OPatchFAAutomationAction>();
        if (act1 != null && act1.length != 0) {
            for (i = 0; i < act1.length; ++i) {
                action = act1[i];
                faActionArr.add(action);
            }
        }
        if (act2 != null && act2.length != 0) {
            for (i = 0; i < act2.length; ++i) {
                action = act2[i];
                faActionArr.add(action);
            }
        }
        OPatchFAAutomationAction[] finalList = new OPatchFAAutomationAction[faActionArr.size()];
        faActionArr.toArray(finalList);
        return finalList;
    }

    public FAExecutionContext getLifeCycleContext() {
        return this.lifeContext;
    }

    public FAExecutionContext getStandAloneDeployContext() {
        return this.saDeployContext;
    }

    public FAExecutionContext[] getAllExecutionContexts() {
        FAExecutionContext[] exContextArr = new FAExecutionContext[this.exContext.size()];
        this.exContext.toArray(exContextArr);
        return exContextArr;
    }

    public OPatchFAAutomationAction[] getAllOperatedLifeCycleActions() {
        OPatchFAAutomationAction[] lifeActions = new OPatchFAAutomationAction[this.allOperatedLifeCycleActions.size()];
        this.allOperatedLifeCycleActions.toArray(lifeActions);
        return lifeActions;
    }

    public FAExecutionContext getExecutionContext(OPatchPatch patch) {
        if (patch == null) {
            return null;
        }
        if (this.exContext == null || this.exContext.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.exContext.size(); ++i) {
            FAExecutionContext context = this.exContext.get(i);
            OPatchPatch storedPatch = context.getPatch();
            if (storedPatch == null || !storedPatch.equals(patch)) continue;
            return context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPatchFAAutomationAction[] getPrePatchArtifactsList(OPatchPatch patch) throws OPatchException {
        HashMap<String, OPatchCopyAction> copyPaths;
        OPatchDeployAction clonedFaAction;
        OPatchInterviewAction[] clonedInterviewList;
        ArrayList<OPatchDeployAction> clonedArtifacts;
        OPatchFAAutomationAction[] artifactsList;
        block32: {
            OPatchException ex;
            block29: {
                if (patch == null) {
                    throw new OPatchException("The input OPatchPatch object is <null>. Please check input.");
                }
                String oh = patch.getOracleHome();
                if (oh != null && !oh.equals("")) {
                    throw new OPatchException("Please provide an OPatchPatch object that is based on patch location.");
                }
                artifactsList = patch.getFAAutomationMetadata();
                OPatchInterviewAction[] interviewList = patch.getInterviewElements();
                if (artifactsList == null || artifactsList.length == 0) {
                    throw new OPatchException("OPatch was not able to find any artifacts from the automation content of the patch.");
                }
                if (interviewList == null) {
                    interviewList = new OPatchInterviewAction[]{};
                }
                clonedArtifacts = new ArrayList<OPatchDeployAction>();
                clonedInterviewList = new OPatchInterviewAction[interviewList.length];
                for (int i = 0; i < clonedInterviewList.length; ++i) {
                    clonedInterviewList[i] = (OPatchInterviewAction)interviewList[i].clone();
                }
                clonedFaAction = null;
                ex = null;
                copyPaths = new HashMap<String, OPatchCopyAction>();
                String setOH = this.getContext().getOracleHome();
                try {
                    Object var20_24;
                    try {
                        OPatchUtils.lockHome(setOH);
                        Vector includedPC = new Vector();
                        PrereqAPI.checkComponents((String)setOH, (PatchObject)patch.po, includedPC);
                        Vector validActions = new Vector();
                        for (int i = 0; i < includedPC.size(); ++i) {
                            PatchComponent validPC = (PatchComponent)includedPC.get(i);
                            OPatchComponent oPC = new OPatchComponent(validPC);
                            OPatchAction[] oa = patch.getActions(oPC);
                            for (int j = 0; j < oa.length; ++j) {
                                if (!(oa[j] instanceof OPatchCopyAction)) continue;
                                OPatchCopyAction oca = (OPatchCopyAction)oa[j];
                                copyPaths.put(new File(oca.getCompleteFilePath(setOH)).getCanonicalPath(), oca);
                            }
                        }
                        var20_24 = null;
                        if (setOH.equals("")) break block29;
                    }
                    catch (Throwable t) {
                        OPatchException oe = new OPatchException(t.getMessage());
                        oe.setStackTrace(t.getStackTrace());
                        ex = oe;
                        var20_24 = null;
                        if (!setOH.equals("")) {
                            try {
                                OPatchUtils.unlockHome(setOH);
                            }
                            catch (Throwable t2) {
                                OPatchException oe2 = new OPatchException(t2.getMessage());
                                oe2.setStackTrace(t2.getStackTrace());
                                throw oe2;
                            }
                        }
                        if (ex != null) {
                            throw ex;
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    Object var20_25 = null;
                    if (!setOH.equals("")) {
                        try {}
                        catch (Throwable t2) {
                            OPatchException oe2 = new OPatchException(t2.getMessage());
                            oe2.setStackTrace(t2.getStackTrace());
                            throw oe2;
                        }
                        OPatchUtils.unlockHome(setOH);
                    }
                    if (ex != null) {
                        throw ex;
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable t2) {
                    OPatchException oe2 = new OPatchException(t2.getMessage());
                    oe2.setStackTrace(t2.getStackTrace());
                    throw oe2;
                }
                OPatchUtils.unlockHome(setOH);
            }
            if (ex != null) {
                throw ex;
            }
        }
        int i = 0;
        while (true) {
            block37: {
                block35: {
                    OPatchFAAutomationAction faAction;
                    block36: {
                        block34: {
                            if (i >= artifactsList.length) {
                                OPatchFAAutomationAction[] clonedArtifactsList = new OPatchFAAutomationAction[clonedArtifacts.size()];
                                clonedArtifacts.toArray(clonedArtifactsList);
                                return clonedArtifactsList;
                            }
                            faAction = artifactsList[i];
                            if (!(faAction instanceof OPatchSOADeployAction)) break block34;
                            OPatchSOADeployAction soaDeploy = (OPatchSOADeployAction)faAction;
                            soaDeploy.setInterviewList(clonedInterviewList);
                            OPatchSOADeployAction clonedSOAAction = (OPatchSOADeployAction)soaDeploy.clone();
                            clonedFaAction = clonedSOAAction;
                            clonedArtifacts.add(clonedSOAAction);
                            break block35;
                        }
                        if (!(faAction instanceof OPatchBIPDeployAction)) break block36;
                        OPatchBIPDeployAction bipDeploy = (OPatchBIPDeployAction)faAction;
                        bipDeploy.setInterviewList(clonedInterviewList);
                        OPatchBIPDeployAction clonedBIPAction = (OPatchBIPDeployAction)bipDeploy.clone();
                        clonedFaAction = clonedBIPAction;
                        clonedArtifacts.add(clonedBIPAction);
                        break block35;
                    }
                    if (!(faAction instanceof OPatchSOARbDeployAction)) break block37;
                    OPatchSOARbDeployAction soaRbDeploy = (OPatchSOARbDeployAction)faAction;
                    soaRbDeploy.setInterviewList(clonedInterviewList);
                    OPatchSOARbDeployAction clonedSOARbAction = (OPatchSOARbDeployAction)soaRbDeploy.clone();
                    clonedFaAction = clonedSOARbAction;
                    clonedArtifacts.add(clonedSOARbAction);
                }
                clonedFaAction.setCommonComponentsHome(this.commonComponentsHome);
                clonedFaAction.setOracleHomePath(this.getContext().getOracleHome());
                clonedFaAction.setWrapperPatch(patch);
                clonedFaAction.setDryRun(true);
                if (clonedFaAction instanceof OPatchDeployAction) {
                    OPatchDeployAction oda = clonedFaAction;
                    if (copyPaths.size() != 0) {
                        oda.setCopyPathsWithOracleHomeComp(copyPaths);
                    } else {
                        oda.setCopyPathsWithOracleHomeComp(null);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPatchFAAutomationAction[] getPostPatchArtifactsList(OPatchPatch patch) throws OPatchException {
        String execLogFile;
        String configLogFile;
        FAExecutionContext context;
        OPatchFAAutomationAction[] clonedArtifactsList;
        block24: {
            block23: {
                if (patch == null) {
                    throw new OPatchException("The input OPatchPatch object is <null>. Please check input.");
                }
                String oh = patch.getOracleHome();
                if (oh == null || oh.equals("")) {
                    throw new OPatchException("Please provide an OPatchPatch object obtained from installed patch(es) APIs.");
                }
                OPatchFAAutomationAction[] artifactsList = patch.getFAAutomationMetadata();
                OPatchInterviewAction[] interviewList = patch.getInterviewElements();
                if (artifactsList == null || artifactsList.length == 0) {
                    throw new OPatchException("OPatch was not able to find any artifacts from the automation content of the patch.");
                }
                if (interviewList == null) {
                    interviewList = new OPatchInterviewAction[]{};
                }
                ArrayList<OPatchDeployAction> clonedArtifacts = new ArrayList<OPatchDeployAction>();
                OPatchInterviewAction[] clonedInterviewList = new OPatchInterviewAction[interviewList.length];
                for (int i = 0; i < clonedInterviewList.length; ++i) {
                    clonedInterviewList[i] = (OPatchInterviewAction)interviewList[i].clone();
                }
                OPatchDeployAction clonedFaAction = null;
                for (int i = 0; i < artifactsList.length; ++i) {
                    OPatchFAAutomationAction faAction = artifactsList[i];
                    if (faAction instanceof OPatchSOADeployAction) {
                        OPatchSOADeployAction soaDeploy = (OPatchSOADeployAction)faAction;
                        soaDeploy.setInterviewList(clonedInterviewList);
                        OPatchSOADeployAction clonedSOAAction = (OPatchSOADeployAction)soaDeploy.clone();
                        clonedFaAction = clonedSOAAction;
                        clonedArtifacts.add(clonedSOAAction);
                    } else if (faAction instanceof OPatchBIPDeployAction) {
                        OPatchBIPDeployAction bipDeploy = (OPatchBIPDeployAction)faAction;
                        bipDeploy.setInterviewList(clonedInterviewList);
                        OPatchBIPDeployAction clonedBIPAction = (OPatchBIPDeployAction)bipDeploy.clone();
                        clonedFaAction = clonedBIPAction;
                        clonedArtifacts.add(clonedBIPAction);
                    } else {
                        if (!(faAction instanceof OPatchSOARbDeployAction)) continue;
                        OPatchSOARbDeployAction soaRbDeploy = (OPatchSOARbDeployAction)faAction;
                        soaRbDeploy.setInterviewList(clonedInterviewList);
                        OPatchSOARbDeployAction clonedSOARbAction = (OPatchSOARbDeployAction)soaRbDeploy.clone();
                        clonedFaAction = clonedSOARbAction;
                        clonedArtifacts.add(clonedSOARbAction);
                    }
                    clonedFaAction.setCommonComponentsHome(this.commonComponentsHome);
                    clonedFaAction.setOracleHomePath(this.getContext().getOracleHome());
                    clonedFaAction.setWrapperPatch(patch);
                }
                clonedArtifactsList = new OPatchFAAutomationAction[clonedArtifacts.size()];
                clonedArtifacts.toArray(clonedArtifactsList);
                context = null;
                boolean needToAdd = true;
                for (int i = 0; i < this.exContext.size(); ++i) {
                    OPatchPatch storedPatch = this.exContext.get(i).getPatch();
                    if (storedPatch == null || !storedPatch.equals(patch)) continue;
                    needToAdd = false;
                    context = this.exContext.get(i);
                    break;
                }
                if (needToAdd) {
                    context = new FAExecutionContext(patch);
                    this.exContext.add(context);
                }
                configLogFile = "";
                execLogFile = "";
                try {
                    Object var15_18;
                    try {
                        configLogFile = OPatchUtils.initLogFile(this.getContext().getOracleHome(), patch.getLogTimeStamp(), "ConfigContext", false);
                    }
                    catch (Throwable t) {
                        configLogFile = "";
                        var15_18 = null;
                        OPatchUtils.closeLogFile();
                        break block23;
                    }
                    var15_18 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    OPatchUtils.closeLogFile();
                    throw throwable;
                }
                OPatchUtils.closeLogFile();
            }
            try {
                Object var17_27;
                try {
                    execLogFile = OPatchUtils.initLogFile(this.getContext().getOracleHome(), patch.getLogTimeStamp(), "ExecutionContext", false);
                }
                catch (Throwable t) {
                    execLogFile = "";
                    var17_27 = null;
                    OPatchUtils.closeLogFile();
                    break block24;
                }
                var17_27 = null;
            }
            catch (Throwable throwable) {
                Object var17_28 = null;
                OPatchUtils.closeLogFile();
                throw throwable;
            }
            OPatchUtils.closeLogFile();
        }
        for (int i = 0; i < clonedArtifactsList.length; ++i) {
            OPatchFAAutomationAction faAction = clonedArtifactsList[i];
            faAction.setOperatingFAContext(context);
            faAction.setConfigLogFile(configLogFile);
            faAction.setExecLogFile(execLogFile);
        }
        File fcLog = new File(configLogFile);
        File feLog = new File(execLogFile);
        if (fcLog.exists()) {
            fcLog.delete();
        }
        if (feLog.exists()) {
            feLog.delete();
        }
        return clonedArtifactsList;
    }

    protected static OPatchFAClonedConfigInstance getPrivateCopy() {
        return privateCopy;
    }

    public boolean isFAConfigCloned() {
        return this.isFAConfigCloned;
    }

    public OPatchFAClonedConfigInstance cloneConfigInstance(OPatchFAConfigInstance originalInstance) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: cloneConfigInstance(OPatchFAConfigInstance originalInstance)");
        if (this.isFAConfigCloned()) {
            throw new OPatchException("User has already cloned the FA Configuration for the OPatchFATarget object.");
        }
        OPatchUtils.validateEndPointInstances(originalInstance);
        ArrayList<AbstractBaseTarget> newEndPointInstances = new ArrayList<AbstractBaseTarget>();
        if (faConfigContext == null) {
            faConfigContext = new OPatchFAConfigContext();
        }
        ArrayList<AbstractBaseTarget> privateCopyInstances = new ArrayList<AbstractBaseTarget>();
        List<AbstractBaseTarget> endPointInstances = originalInstance.getEndPointInstances();
        for (int i = 0; i < endPointInstances.size(); ++i) {
            NodeManager cloneBTPrivate;
            NodeManager cloneBT;
            AbstractBaseTarget bt = endPointInstances.get(i);
            if (bt instanceof NodeManager) {
                cloneBT = this.cloneNodeManager((NodeManager)bt);
                cloneBTPrivate = this.cloneNodeManager((NodeManager)bt);
                newEndPointInstances.add((AbstractBaseTarget)cloneBT);
                privateCopyInstances.add((AbstractBaseTarget)cloneBTPrivate);
                faConfigContext.addConfigNodeManager(cloneBT);
            }
            if (bt instanceof WLDomain) {
                cloneBT = this.cloneWLDomain((WLDomain)bt);
                cloneBTPrivate = this.cloneWLDomain((WLDomain)bt);
                faConfigContext.addConfigWLDomain((WLDomain)cloneBT);
                newEndPointInstances.add((AbstractBaseTarget)cloneBT);
                privateCopyInstances.add((AbstractBaseTarget)cloneBTPrivate);
            }
            if (bt instanceof BI) {
                cloneBT = this.cloneBI((BI)bt);
                cloneBTPrivate = this.cloneBI((BI)bt);
                newEndPointInstances.add((AbstractBaseTarget)cloneBT);
                privateCopyInstances.add((AbstractBaseTarget)cloneBTPrivate);
            }
            if (bt instanceof SOAComposite) {
                cloneBT = this.cloneSOAComposite((SOAComposite)bt);
                cloneBTPrivate = this.cloneSOAComposite((SOAComposite)bt);
                newEndPointInstances.add((AbstractBaseTarget)cloneBT);
                privateCopyInstances.add((AbstractBaseTarget)cloneBTPrivate);
            }
            if (!(bt instanceof WLServer)) continue;
            cloneBT = this.cloneManagedServer((WLServer)bt);
            cloneBTPrivate = this.cloneManagedServer((WLServer)bt);
            newEndPointInstances.add((AbstractBaseTarget)cloneBT);
            privateCopyInstances.add((AbstractBaseTarget)cloneBTPrivate);
        }
        this.faInstance = new OPatchFAClonedConfigInstance(newEndPointInstances);
        privateCopy = new OPatchFAClonedConfigInstance(privateCopyInstances);
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: cloneConfigInstance(OPatchFAConfigInstance originalInstance)");
        return this.faInstance;
    }

    public OPatchStandAloneDeployAction getStandAloneExecutionHandle(OPatchStandAloneOperations op, String deployFileName, String relativeDeployFilePath) {
        OPatchStandAloneSOADeployAction sda = null;
        OPatchContext oc = this.getContext();
        switch (op) {
            case STAND_ALONE_SOA_COMPOSITE_DEPLOY: {
                sda = new OPatchStandAloneSOADeployAction(deployFileName, relativeDeployFilePath);
                break;
            }
        }
        if (oc != null && sda != null) {
            sda.setOracleHomePath(oc.getOracleHome());
            sda.setWrapperPatch(null);
            sda.setOperatingFAContext(this.saDeployContext);
        }
        return sda;
    }

    public Object getManagedServerConfigAttribute(WLDomain domain, WLServer server, OPatchManagedServerConfigProperties p) throws OPatchException {
        if (domain == null || server == null) {
            throw new OPatchException("Input parameter <model.fafmw.WLDomain(domain)> (or) <model.fafmw.WLServer(server)> cannot be null.");
        }
        if (p == null) {
            throw new OPatchException("Config properties <p> cannot be given as null.");
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        WLAdminServer adminServer = domain.getWLAdminServer();
        if (adminServer == null) {
            throw new OPatchException("Admin server got from <domain> object is null. Please set <model.fafmw.WLAdminServer> object.");
        }
        String domainName = OPatchUtils.norm(domain.getName());
        if (domainName.equals("")) {
            throw new OPatchException("Please set proper Domain name for <model.fafmw.WLDomain(domain)> object.");
        }
        String serverName = OPatchUtils.norm(server.getName());
        if (serverName.equals("")) {
            throw new OPatchException("Please set proper Server name for <model.fafmw.Server(server)> object.");
        }
        String oh = this.getContext().getOracleHome();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.ORACLE_HOME", this.getContext().getOracleHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        FMWClient client = null;
        try {
            try {
                client = FMWClientFactory.getDomainClient(env);
                if (client == null) {
                    throw new OPatchException("OPatch was not able to create <client> object for this API call.");
                }
                client.setServerAttribute(serverName, p.getAttributeName());
                client.done();
                OPatchUtils.disableConsoleOutput();
                client.checkServerAttribute();
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var17_14 = null;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            OPatchUtils.enableConsoleOutput();
            OPatchUtils.unlockHome(oh);
            client.close();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        OPatchUtils.unlockHome(oh);
        client.close();
        return client.getServerAttrValue();
    }

    public void setManagedServerConfigAttribute(WLDomain domain, WLServer server, OPatchManagedServerConfigProperties p, String value, boolean errorOnActiveEditSession) throws OPatchException {
        if (domain == null || server == null) {
            throw new OPatchException("Input parameter <model.fafmw.WLDomain(domain)> (or) <model.fafmw.WLServer(server)> cannot be null.");
        }
        if (p == null) {
            throw new OPatchException("Config properties <p> cannot be given as null.");
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        WLAdminServer adminServer = domain.getWLAdminServer();
        if (adminServer == null) {
            throw new OPatchException("Admin server got from <domain> object is null. Please set <model.fafmw.WLAdminServer> object.");
        }
        String domainName = OPatchUtils.norm(domain.getName());
        if (domainName.equals("")) {
            throw new OPatchException("Please set proper Domain name for <model.fafmw.WLDomain(domain)> object.");
        }
        String serverName = OPatchUtils.norm(server.getName());
        if (serverName.equals("")) {
            throw new OPatchException("Please set proper Server name for <model.fafmw.Server(server)> object.");
        }
        String oh = this.getContext().getOracleHome();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.ORACLE_HOME", this.getContext().getOracleHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        FMWClient client = null;
        try {
            try {
                client = FMWClientFactory.getDomainClient(env);
                if (client == null) {
                    throw new OPatchException("OPatch was not able to create <client> object for this API call.");
                }
                client.setServerAttribute(server.getName(), p.getAttributeName(), value, p.getObjectType(), errorOnActiveEditSession);
                client.done();
                OPatchUtils.disableConsoleOutput();
                client.checkServerAttribute();
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var19_16 = null;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            OPatchUtils.enableConsoleOutput();
            OPatchUtils.unlockHome(oh);
            client.close();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        OPatchUtils.unlockHome(oh);
        client.close();
    }

    public void setManagedServerConfigAttribute(WLDomain domain, WLServer server, OPatchManagedServerConfigProperties p, String value) throws OPatchException {
        this.setManagedServerConfigAttribute(domain, server, p, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPatchFAPrereq runPrereqOnAllArtifacts(OPatchFAAutomationAction[] artifactsList, String patchLocation) {
        OPatchFAPrereq prereq = new OPatchFAPrereq();
        OPatchFAAutomationAction faAction = null;
        boolean errOccurred = false;
        String errMessage = "";
        RuntimeException excep = null;
        try {
            OPatchDeployAction.setCopyVerHashMap(this.getOracleHome());
        }
        catch (OPatchException e) {
            OPatchDeployAction.resetCopyVerHashMap();
        }
        int i = 0;
        while (true) {
            block21: {
                OPatchPrereqArtifactStatus status;
                OPatchPrereqArtifactStatus status2;
                OPatchStepOperation step;
                String stepMsg;
                String errorMsg;
                Object var11_12;
                if (i >= artifactsList.length) {
                    return prereq;
                }
                try {
                    block20: {
                        try {
                            faAction = artifactsList[i];
                            if (faAction instanceof OPatchMultipleBIPDeploy) {
                                OPatchMultipleBIPDeploy multipleBIP = (OPatchMultipleBIPDeploy)faAction;
                                multipleBIP.doPrereq(OPatchFAOperation.PREREQ_DEPLOY, patchLocation);
                            }
                            if (faAction instanceof OPatchSOADeployAction) {
                                OPatchSOADeployAction soaDeploy = (OPatchSOADeployAction)faAction;
                                soaDeploy.doPrereq(OPatchFAOperation.PREREQ_DEPLOY, patchLocation);
                                break block20;
                            }
                            if (faAction instanceof OPatchBIPDeployAction) {
                                OPatchBIPDeployAction bipDeploy = (OPatchBIPDeployAction)faAction;
                                bipDeploy.doPrereq(OPatchFAOperation.PREREQ_DEPLOY, patchLocation);
                                break block20;
                            }
                            if (!(faAction instanceof OPatchSOARbDeployAction)) break block20;
                            OPatchSOARbDeployAction soaRbDeploy = (OPatchSOARbDeployAction)faAction;
                            soaRbDeploy.doPrereq(OPatchFAOperation.PREREQ_DEPLOY, patchLocation);
                        }
                        catch (Throwable t) {
                            errOccurred = true;
                            errMessage = t.getMessage();
                            excep = new RuntimeException(t);
                            var11_12 = null;
                            OPatchDeployAction.resetCopyVerHashMap();
                            if (faAction != null && errOccurred && faAction.getFailedPrereqStep() == null) {
                                errorMsg = "OPatch encountered serious exception while doing prereqs.";
                                stepMsg = "Check for serious failures.";
                                step = OPatchUtils.constructFailedStep(OPatchFAStep.UNKNOWN_FAILURE, stepMsg, errorMsg, excep);
                                status2 = new OPatchPrereqArtifactStatus(step, faAction);
                                prereq.addPrereqObject(status2);
                            } else if (faAction != null) {
                                status = new OPatchPrereqArtifactStatus(faAction.getFailedPrereqStep(), faAction);
                                prereq.addPrereqObject(status);
                            }
                            excep = null;
                            errOccurred = false;
                            break block21;
                        }
                    }
                    var11_12 = null;
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    OPatchDeployAction.resetCopyVerHashMap();
                    if (faAction != null && errOccurred && faAction.getFailedPrereqStep() == null) {
                        errorMsg = "OPatch encountered serious exception while doing prereqs.";
                        stepMsg = "Check for serious failures.";
                        step = OPatchUtils.constructFailedStep(OPatchFAStep.UNKNOWN_FAILURE, stepMsg, errorMsg, excep);
                        status2 = new OPatchPrereqArtifactStatus(step, faAction);
                        prereq.addPrereqObject(status2);
                    } else if (faAction != null) {
                        status = new OPatchPrereqArtifactStatus(faAction.getFailedPrereqStep(), faAction);
                        prereq.addPrereqObject(status);
                    }
                    excep = null;
                    errOccurred = false;
                    throw throwable;
                }
                OPatchDeployAction.resetCopyVerHashMap();
                if (faAction != null && errOccurred && faAction.getFailedPrereqStep() == null) {
                    errorMsg = "OPatch encountered serious exception while doing prereqs.";
                    stepMsg = "Check for serious failures.";
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.UNKNOWN_FAILURE, stepMsg, errorMsg, excep);
                    status2 = new OPatchPrereqArtifactStatus(step, faAction);
                    prereq.addPrereqObject(status2);
                } else if (faAction != null) {
                    status = new OPatchPrereqArtifactStatus(faAction.getFailedPrereqStep(), faAction);
                    prereq.addPrereqObject(status);
                }
                excep = null;
                errOccurred = false;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPatchFAPrereq runPrereqOnAllArtifacts(OPatchFAAutomationAction[] artifactsList) throws OPatchException {
        OPatchFAPrereq prereq = new OPatchFAPrereq();
        OPatchFAAutomationAction faAction = null;
        boolean errOccurred = false;
        String errMessage = "";
        RuntimeException excep = null;
        try {
            OPatchDeployAction.setCopyVerHashMap(this.getOracleHome());
        }
        catch (OPatchException e) {
            OPatchDeployAction.resetCopyVerHashMap();
        }
        int i = 0;
        while (true) {
            block24: {
                OPatchPrereqArtifactStatus status;
                OPatchPrereqArtifactStatus status2;
                OPatchStepOperation step;
                String stepMsg;
                String errorMsg;
                Object var10_11;
                if (i >= artifactsList.length) {
                    return prereq;
                }
                try {
                    block23: {
                        try {
                            faAction = artifactsList[i];
                            if (faAction instanceof OPatchMultipleBIPDeploy) {
                                OPatchMultipleBIPDeploy multipleBIP = (OPatchMultipleBIPDeploy)faAction;
                                multipleBIP.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                            }
                            if (faAction instanceof OPatchSOADeployAction) {
                                OPatchSOADeployAction soaDeploy = (OPatchSOADeployAction)faAction;
                                soaDeploy.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                                break block23;
                            }
                            if (faAction instanceof OPatchBIPDeployAction) {
                                OPatchBIPDeployAction bipDeploy = (OPatchBIPDeployAction)faAction;
                                bipDeploy.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                                break block23;
                            }
                            if (faAction instanceof OPatchSOARbDeployAction) {
                                OPatchSOARbDeployAction soaRbDeploy = (OPatchSOARbDeployAction)faAction;
                                soaRbDeploy.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                                break block23;
                            }
                            if (faAction instanceof OPatchStandAloneSOADeployAction) {
                                OPatchStandAloneSOADeployAction standAloneSOA = (OPatchStandAloneSOADeployAction)faAction;
                                standAloneSOA.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                                break block23;
                            }
                            if (faAction instanceof OPatchJEELifecycleAction) {
                                OPatchJEELifecycleAction jee = (OPatchJEELifecycleAction)faAction;
                                jee.setCommonComponentsHome(this.commonComponentsHome);
                                jee.setOracleHomePath(this.getContext().getOracleHome());
                                jee.setWrapperPatch(null);
                                jee.setOperatingFAContext(this.lifeContext);
                                jee.doPrereq(OPatchFAOperation.PREREQ_JEE_LIFECYCLE);
                                break block23;
                            }
                            if (!(faAction instanceof OPatchSOACompositeLifecycleAction)) break block23;
                            OPatchSOACompositeLifecycleAction soaComp = (OPatchSOACompositeLifecycleAction)faAction;
                            soaComp.setCommonComponentsHome(this.commonComponentsHome);
                            soaComp.setOracleHomePath(this.getContext().getOracleHome());
                            soaComp.setWrapperPatch(null);
                            soaComp.setOperatingFAContext(this.lifeContext);
                            soaComp.doPrereq(OPatchFAOperation.PREREQ_COMPOSITE_LIFECYCLE);
                        }
                        catch (Throwable t) {
                            errOccurred = true;
                            errMessage = t.getMessage();
                            excep = new RuntimeException(t);
                            var10_11 = null;
                            OPatchDeployAction.resetCopyVerHashMap();
                            if (faAction != null && errOccurred && faAction.getFailedPrereqStep() == null) {
                                errorMsg = "OPatch encountered serious exception while doing prereqs.";
                                stepMsg = "Check for serious failures.";
                                step = OPatchUtils.constructFailedStep(OPatchFAStep.UNKNOWN_FAILURE, stepMsg, errorMsg, excep);
                                status2 = new OPatchPrereqArtifactStatus(step, faAction);
                                prereq.addPrereqObject(status2);
                            } else if (faAction != null) {
                                status = new OPatchPrereqArtifactStatus(faAction.getFailedPrereqStep(), faAction);
                                prereq.addPrereqObject(status);
                            }
                            excep = null;
                            errOccurred = false;
                            break block24;
                        }
                    }
                    var10_11 = null;
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    OPatchDeployAction.resetCopyVerHashMap();
                    if (faAction != null && errOccurred && faAction.getFailedPrereqStep() == null) {
                        errorMsg = "OPatch encountered serious exception while doing prereqs.";
                        stepMsg = "Check for serious failures.";
                        step = OPatchUtils.constructFailedStep(OPatchFAStep.UNKNOWN_FAILURE, stepMsg, errorMsg, excep);
                        status2 = new OPatchPrereqArtifactStatus(step, faAction);
                        prereq.addPrereqObject(status2);
                    } else if (faAction != null) {
                        status = new OPatchPrereqArtifactStatus(faAction.getFailedPrereqStep(), faAction);
                        prereq.addPrereqObject(status);
                    }
                    excep = null;
                    errOccurred = false;
                    throw throwable;
                }
                OPatchDeployAction.resetCopyVerHashMap();
                if (faAction != null && errOccurred && faAction.getFailedPrereqStep() == null) {
                    errorMsg = "OPatch encountered serious exception while doing prereqs.";
                    stepMsg = "Check for serious failures.";
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.UNKNOWN_FAILURE, stepMsg, errorMsg, excep);
                    status2 = new OPatchPrereqArtifactStatus(step, faAction);
                    prereq.addPrereqObject(status2);
                } else if (faAction != null) {
                    status = new OPatchPrereqArtifactStatus(faAction.getFailedPrereqStep(), faAction);
                    prereq.addPrereqObject(status);
                }
                excep = null;
                errOccurred = false;
            }
            ++i;
        }
    }

    public boolean isSOACompositeUp(WLDomain domain, SOAComposite composite) throws OPatchException {
        boolean bl;
        if (domain == null) {
            throw new OPatchException("Input parameter <model.fafmw.WLDomain(domain)> cannot be null.");
        }
        WLAdminServer adminServer = domain.getWLAdminServer();
        if (adminServer == null) {
            throw new OPatchException("Admin server got from <domain> object is null. Please set <model.fafmw.WLAdminServer> object.");
        }
        String domainName = OPatchUtils.norm(domain.getName());
        if (domainName.equals("")) {
            throw new OPatchException("Please set proper Domain name for <model.fafmw.WLDomain(domain)> object.");
        }
        if (composite == null) {
            throw new OPatchException("SOA Composite object <composite> is null. Please set <model.fafmw.SOAComposite> object.");
        }
        String compositeCheckName = composite.getName();
        if (compositeCheckName == null || compositeCheckName.equals("")) {
            throw new OPatchException("SOA Composite name is <null> or empty in <composite> object. Please provide a valid composite name.");
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        String oh = this.getContext().getOracleHome();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.ORACLE_HOME", this.getContext().getOracleHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        FMWClient client = null;
        try {
            client = FMWClientFactory.getDomainClient(env);
            if (client == null) {
                throw new OPatchException("OPatch was not able to create <client> object for this API call.");
            }
            client.addSOAComposite(compositeCheckName, OPatchUtils.norm(composite.getRevisionId()));
            client.done();
            OPatchUtils.disableConsoleOutput();
            bl = client.isSOACompositeUp();
            Object var16_15 = null;
        }
        catch (Throwable t) {
            try {
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                OPatchUtils.enableConsoleOutput();
                OPatchUtils.unlockHome(oh);
                throw throwable;
            }
        }
        OPatchUtils.enableConsoleOutput();
        OPatchUtils.unlockHome(oh);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSOAInfrastructureReady(WLDomain domain) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: isSOAInfrastructureReady(model.fafmw.WLDomain domain)");
        if (domain == null) {
            throw new OPatchException("Input parameter <model.fafmw.WLDomain(domain)> cannot be null.");
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        WLAdminServer adminServer = domain.getWLAdminServer();
        if (adminServer == null) {
            throw new OPatchException("Admin server got from <domain> object is null. Please set <model.fafmw.WLAdminServer> object.");
        }
        String domainName = OPatchUtils.norm(domain.getName());
        if (domainName.equals("")) {
            throw new OPatchException("Please set proper Domain name for <model.fafmw.WLDomain(domain)> object.");
        }
        String oh = this.getContext().getOracleHome();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.ORACLE_HOME", this.getContext().getOracleHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        FMWClient client = null;
        try {
            client = FMWClientFactory.getDomainClient(env);
            if (client == null) {
                throw new OPatchException("OPatch was not able to create <client> object for this API call.");
            }
            client.setSOAInfraTest(true);
            client.done();
        }
        catch (Throwable t) {
            OPatchException re = new OPatchException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        try {
            try {
                OPatchUtils.disableConsoleOutput();
                client.testSOAInfra();
            }
            catch (Throwable t) {
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: isSOAInfrastructureReady(model.fafmw.WLDomain domain)");
                boolean bl = false;
                Object var14_16 = null;
                OPatchUtils.enableConsoleOutput();
                OPatchUtils.unlockHome(oh);
                client.close();
                return bl;
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            OPatchUtils.enableConsoleOutput();
            OPatchUtils.unlockHome(oh);
            client.close();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        OPatchUtils.unlockHome(oh);
        client.close();
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: isSOAInfrastructureReady(model.fafmw.WLDomain domain)");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String startServer(OPatchFAClonedConfigInstance clonedInstance, WLDomain domain, NodeManager nm, WLServer server) throws OPatchStartException {
        OPatchJEELifecycleAction startAction = null;
        OPatchStartException os = null;
        try {
            try {
                startAction = new OPatchJEELifecycleAction(clonedInstance, server, domain, nm);
                startAction.setCommonComponentsHome(this.commonComponentsHome);
                startAction.setOracleHomePath(this.getContext().getOracleHome());
                startAction.setWrapperPatch(null);
                startAction.setOperatingFAContext(this.lifeContext);
                startAction.start();
            }
            catch (Throwable e) {
                OPatchStartException re = new OPatchStartException(e.getMessage());
                re.setTopLogFile(startAction.getLastOperatedLogFile());
                re.setStackTrace(e.getStackTrace());
                os = re;
                Object var10_8 = null;
                this.allOperatedLifeCycleActions.add(startAction);
                if (os == null) return startAction.getLastOperatedLogFile();
                throw os;
            }
            Object var10_7 = null;
            this.allOperatedLifeCycleActions.add(startAction);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.allOperatedLifeCycleActions.add(startAction);
            if (os == null) throw throwable;
            throw os;
        }
        if (os == null) return startAction.getLastOperatedLogFile();
        throw os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String stopServer(OPatchFAClonedConfigInstance clonedInstance, WLDomain domain, NodeManager nm, WLServer server) throws OPatchStopException {
        OPatchJEELifecycleAction stopAction = null;
        OPatchStopException os = null;
        try {
            try {
                stopAction = new OPatchJEELifecycleAction(clonedInstance, server, domain, nm);
                stopAction.setCommonComponentsHome(this.commonComponentsHome);
                stopAction.setOracleHomePath(this.getContext().getOracleHome());
                stopAction.setWrapperPatch(null);
                stopAction.setOperatingFAContext(this.lifeContext);
                stopAction.stop();
            }
            catch (Throwable e) {
                OPatchStopException re = new OPatchStopException(e.getMessage());
                re.setTopLogFile(stopAction.getLastOperatedLogFile());
                re.setStackTrace(e.getStackTrace());
                os = re;
                Object var10_8 = null;
                this.allOperatedLifeCycleActions.add(stopAction);
                if (os == null) return stopAction.getLastOperatedLogFile();
                throw os;
            }
            Object var10_7 = null;
            this.allOperatedLifeCycleActions.add(stopAction);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.allOperatedLifeCycleActions.add(stopAction);
            if (os == null) throw throwable;
            throw os;
        }
        if (os == null) return stopAction.getLastOperatedLogFile();
        throw os;
    }

    private boolean continueOnPrereqFailure(ArrayList lifecycleActions, OPatchFAPrereq prereq, ArrayList prereqFailedActions) throws OPatchException {
        if (lifecycleActions == null || prereq == null || prereqFailedActions == null) {
            throw new OPatchException("Incoming lifecycle actions list, prerequisite check result of them, and list of prereq failed  lifecycle actions cannot be null");
        }
        if (!prereq.isOK()) {
            OPatchPrereqArtifactStatus[] artifactStatus = prereq.getStatusOfOperationOnArtifacts();
            for (int i = 0; i < artifactStatus.length; ++i) {
                OPatchJEELifecycleAction action = (OPatchJEELifecycleAction)artifactStatus[i].getArtifactAction();
                if (artifactStatus[i].isOK()) continue;
                prereqFailedActions.add(action);
                lifecycleActions.remove(action);
            }
        }
        return lifecycleActions.size() != 0;
    }

    private ArrayList getServerNames(ArrayList lifecycleActions) throws OPatchException {
        if (lifecycleActions == null) {
            throw new OPatchException("Input lifecycle action list cannot be null");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < lifecycleActions.size(); ++i) {
            Object action = lifecycleActions.get(i);
            if (!(action instanceof OPatchJEELifecycleAction)) {
                throw new OPatchException("Element of input lifecycle action list must be OPatchJEELifecycleAction.");
            }
            OPatchJEELifecycleAction jee = (OPatchJEELifecycleAction)action;
            names.add(OPatchUtils.norm(jee.getBoundServer().getName()));
        }
        return names;
    }

    public String startServers(OPatchJEELifecycleAction[] lifecycleActions) throws OPatchStartException {
        return this.startServers(lifecycleActions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String startServers(OPatchJEELifecycleAction[] lifecycleActions, boolean continueOnPrereqFailure) throws OPatchStartException {
        String logFile;
        block85: {
            StringBuffer buff2;
            int i8;
            for (int i2 = 0; i2 < lifecycleActions.length; ++i2) {
                lifecycleActions[i2].setNoCloseConnection(true);
                lifecycleActions[i2].setDisplayLogFile(false);
            }
            ArrayList<OPatchJEELifecycleAction> incomingJEEActions = new ArrayList<OPatchJEELifecycleAction>(Arrays.asList(lifecycleActions));
            ArrayList failedPrereqLifecycleActions = new ArrayList();
            OPatchStartException se = null;
            String oracleHomePath = this.getContext().getOracleHome();
            boolean prereqSuccess = true;
            OPatchStartException prereqException = null;
            OPatchStartException loginitEx = null;
            logFile = "";
            OPatchFAPrereq prereq = this.runPrereqOnAllArtifacts(lifecycleActions);
            String failedPrereqs = "";
            if (!prereq.isOK()) {
                OPatchPrereqArtifactStatus[] artifactStatus = prereq.getStatusOfOperationOnArtifacts();
                for (int i3 = 0; i3 < artifactStatus.length; ++i3) {
                    if (artifactStatus[i3].isOK()) continue;
                    prereqSuccess = false;
                    failedPrereqs = failedPrereqs + artifactStatus[i3].getFailedPrereqStep().toString() + "\n";
                }
                prereqException = new OPatchStartException(failedPrereqs);
            }
            try {
                logFile = OPatchUtils.initLogFile(oracleHomePath, this.getLifeCycleTimeStamp(), "Start_Servers_Parallel_Master", true);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg = t.getMessage();
                OPatchStepOperation failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep, lifecycleActions);
                prereqSuccess = false;
                loginitEx = new OPatchStartException(t.getMessage());
                loginitEx.setStackTrace(t.getStackTrace());
                throw loginitEx;
            }
            OLogger.justlog((int)OLogger.INFO, (String)"----------Prerequisite log files----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            for (int i4 = 0; i4 < lifecycleActions.length; ++i4) {
                String prereqLogFile = lifecycleActions[i4].getLastOperatedLogFile();
                String serverName = "";
                String domainName = "";
                if (lifecycleActions[i4].getBoundServer() != null) {
                    serverName = lifecycleActions[i4].getBoundServer().getName();
                }
                if (lifecycleActions[i4].getBoundDomain() != null) {
                    domainName = lifecycleActions[i4].getBoundDomain().getName();
                }
                serverName = OPatchUtils.norm(serverName);
                domainName = OPatchUtils.norm(domainName);
                OLogger.justlog((int)OLogger.INFO, (String)("Server name=\"" + serverName + "\"" + "," + "Domain name=" + "\"" + domainName + "\"" + ",log file=" + "\"" + prereqLogFile + "\""));
            }
            OLogger.justlog((int)OLogger.INFO, (String)"----------Status of prerequisite checks----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            if (!prereqSuccess) {
                if (prereqException != null) {
                    OLogger.justlog((int)OLogger.INFO, (String)prereqException.getMessage());
                    se = prereqException;
                }
            } else {
                OLogger.justlog((int)OLogger.INFO, (String)"All prerequisite checks passed for start operation.");
            }
            if (se != null) {
                prereqSuccess = this.continueOnPrereqFailure(incomingJEEActions, prereq, failedPrereqLifecycleActions);
                if (!continueOnPrereqFailure || !prereqSuccess) {
                    prereqSuccess = false;
                    throw se;
                }
                if (failedPrereqLifecycleActions.size() > 0) {
                    OLogger.justlog((int)OLogger.INFO, (String)("The server(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check while the remaining server(s) " + this.getServerNames(incomingJEEActions).toString() + " continue to start."));
                }
            }
            lifecycleActions = new OPatchJEELifecycleAction[incomingJEEActions.size()];
            incomingJEEActions.toArray(lifecycleActions);
            MultiClient mclient = new MultiClient();
            mclient.setLogPath(oracleHomePath, this.getLifeCycleTimeStamp());
            for (int i5 = 0; i5 < lifecycleActions.length; ++i5) {
                FMWClient client = lifecycleActions[i5].getClient();
                mclient.addClient(client, lifecycleActions[i5]);
            }
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.lockHome(oracleHomePath);
                }
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                OPatchStepOperation failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedPrereqStep(failedStep, lifecycleActions);
                prereqSuccess = false;
                OPatchStartException lockEx = new OPatchStartException(t.getMessage());
                lockEx.setStackTrace(t.getStackTrace());
                throw lockEx;
            }
            OLogger.justlog((int)OLogger.INFO, (String)"---------Parallel start operation----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            mclient.run(true);
            Object var21_35 = null;
            for (i8 = 0; i8 < lifecycleActions.length; ++i8) {
                lifecycleActions[i8].getClient().close();
            }
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re = new RuntimeException(t2.getMessage());
                re.setStackTrace(t2.getStackTrace());
                OPatchStepOperation failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedClosingStep(failedStep, lifecycleActions);
            }
            if (!prereqSuccess) {
                OPatchUtils.closeLogFile();
                throw se;
            }
            for (i8 = 0; i8 < lifecycleActions.length; ++i8) {
                OPatchJEELifecycleAction jeeAction = lifecycleActions[i8];
                FMWClient client = jeeAction.getClient();
                boolean failure = false;
                List steps = client.getAllExecutedSteps();
                for (int j = 0; j < steps.size(); ++j) {
                    OPatchStepAdapter step = (OPatchStepAdapter)steps.get(j);
                    if (step.isSuccess()) continue;
                    failure = true;
                }
                OPatchUtils.updateExecutionContext(client, jeeAction, OPatchFAOperation.JEE_SERVER_START);
                OPatchUtils.updateConfig(jeeAction.getBoundDomain(), jeeAction.getBoundServer(), true, failure);
            }
            String failedExecutionSteps = "";
            String failedPrereqStr = "";
            boolean execSuccess = true;
            FAExecutionContext context = this.getLifeCycleContext();
            OLogger.justlog((int)OLogger.INFO, (String)"----------Status of parallel start operation----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            if (failedPrereqLifecycleActions.size() > 0) {
                try {
                    failedPrereqStr = failedPrereqStr + "These sever(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check: " + prereqException.getMessage() + "\n";
                }
                catch (OPatchException e) {
                    se = new OPatchStartException(e.getMessage());
                    throw se;
                }
            }
            ArrayList<String> execFailedServerNames = new ArrayList<String>();
            for (int i6 = 0; i6 < lifecycleActions.length; ++i6) {
                boolean actionSuccess = true;
                String str = "";
                OPatchExecutedArtifact executedArtifact = context.getLastExecutedArtifact(lifecycleActions[i6]);
                OPatchExecutionStep[] execSteps = executedArtifact.getExecutionSteps();
                for (int j = 0; j < execSteps.length; ++j) {
                    if (execSteps[j].isOperationSuccess()) continue;
                    str = str + execSteps[j].getExecutionStep().toString();
                    actionSuccess = false;
                    execSuccess = false;
                }
                if (actionSuccess) continue;
                String serverName = "";
                String domainName = "";
                if (lifecycleActions[i6].getBoundServer() != null) {
                    serverName = lifecycleActions[i6].getBoundServer().getName();
                }
                if (lifecycleActions[i6].getBoundDomain() != null) {
                    domainName = lifecycleActions[i6].getBoundDomain().getName();
                }
                OLogger.justlog((int)OLogger.INFO, (String)("Server name=" + serverName + ", Domain name=" + domainName + ", Failed step =" + str));
                failedExecutionSteps = failedExecutionSteps + str + "\n";
                execFailedServerNames.add(serverName);
            }
            if (!execSuccess) {
                OPatchStartException ose;
                buff2 = new StringBuffer(failedPrereqStr);
                buff2.append("These server(s) ");
                buff2.append(execFailedServerNames.toString());
                buff2.append(" failed in parallel start operation :\n");
                buff2.append(failedExecutionSteps);
                se = ose = new OPatchStartException(buff2.toString());
            } else {
                try {
                    buff2 = new StringBuffer();
                    if (failedPrereqLifecycleActions.size() > 0) {
                        buff2.append("Prerequisite check failed for following servers ");
                        buff2.append(this.getServerNames(failedPrereqLifecycleActions).toString() + "\n");
                    }
                    buff2.append("Parallel start operation completed successfully for the following servers only ");
                    buff2.append(this.getServerNames(incomingJEEActions).toString());
                    OLogger.justlog((int)OLogger.INFO, (String)buff2.toString());
                }
                catch (OPatchException e) {
                    se = new OPatchStartException(e.getMessage());
                }
            }
            OPatchUtils.closeLogFile();
            for (int i7 = 0; i7 < lifecycleActions.length; ++i7) {
                OPatchJEELifecycleAction jeeAction = lifecycleActions[i7];
                jeeAction.setExecLogFile(OPatchJEELifecycleAction.execLog);
                OPatchUtils.logExecutionContext(oracleHomePath, jeeAction.getOperatingFAContext(), this.getLifeCycleTimeStamp(), jeeAction);
                OPatchJEELifecycleAction.execLog = jeeAction.getExecLogFile();
                jeeAction.setConfigLogFile(OPatchJEELifecycleAction.configLog);
                OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), jeeAction);
                OPatchJEELifecycleAction.configLog = jeeAction.getConfigLogFile();
            }
            if (se != null) {
                se.setTopLogFile(logFile);
                throw se;
            }
            break block85;
            {
                catch (Throwable t) {
                    StringBuffer buff2;
                    OPatchStartException ex = new OPatchStartException(t.getMessage());
                    ex.setStackTrace(t.getStackTrace());
                    se = ex;
                    Object var21_36 = null;
                    for (int i8 = 0; i8 < lifecycleActions.length; ++i8) {
                        lifecycleActions[i8].getClient().close();
                    }
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re = new RuntimeException(t2.getMessage());
                        re.setStackTrace(t2.getStackTrace());
                        OPatchStepOperation failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                        this.setFailedClosingStep(failedStep, lifecycleActions);
                    }
                    if (!prereqSuccess) {
                        OPatchUtils.closeLogFile();
                        throw se;
                    }
                    for (int i9 = 0; i9 < lifecycleActions.length; ++i9) {
                        OPatchJEELifecycleAction jeeAction = lifecycleActions[i9];
                        FMWClient client = jeeAction.getClient();
                        boolean failure = false;
                        List steps = client.getAllExecutedSteps();
                        for (int j = 0; j < steps.size(); ++j) {
                            OPatchStepAdapter step = (OPatchStepAdapter)steps.get(j);
                            if (step.isSuccess()) continue;
                            failure = true;
                        }
                        OPatchUtils.updateExecutionContext(client, jeeAction, OPatchFAOperation.JEE_SERVER_START);
                        OPatchUtils.updateConfig(jeeAction.getBoundDomain(), jeeAction.getBoundServer(), true, failure);
                    }
                    failedExecutionSteps = "";
                    failedPrereqStr = "";
                    execSuccess = true;
                    context = this.getLifeCycleContext();
                    OLogger.justlog((int)OLogger.INFO, (String)"----------Status of parallel start operation----------");
                    OLogger.justlog((int)OLogger.INFO, (String)"\n");
                    if (failedPrereqLifecycleActions.size() > 0) {
                        try {
                            failedPrereqStr = failedPrereqStr + "These sever(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check: " + prereqException.getMessage() + "\n";
                        }
                        catch (OPatchException e) {
                            se = new OPatchStartException(e.getMessage());
                            throw se;
                        }
                    }
                    execFailedServerNames = new ArrayList<String>();
                    for (int i6 = 0; i6 < lifecycleActions.length; ++i6) {
                        boolean actionSuccess = true;
                        String str = "";
                        OPatchExecutedArtifact executedArtifact = context.getLastExecutedArtifact(lifecycleActions[i6]);
                        OPatchExecutionStep[] execSteps = executedArtifact.getExecutionSteps();
                        for (int j = 0; j < execSteps.length; ++j) {
                            if (execSteps[j].isOperationSuccess()) continue;
                            str = str + execSteps[j].getExecutionStep().toString();
                            actionSuccess = false;
                            execSuccess = false;
                        }
                        if (actionSuccess) continue;
                        String serverName = "";
                        String domainName = "";
                        if (lifecycleActions[i6].getBoundServer() != null) {
                            serverName = lifecycleActions[i6].getBoundServer().getName();
                        }
                        if (lifecycleActions[i6].getBoundDomain() != null) {
                            domainName = lifecycleActions[i6].getBoundDomain().getName();
                        }
                        OLogger.justlog((int)OLogger.INFO, (String)("Server name=" + serverName + ", Domain name=" + domainName + ", Failed step =" + str));
                        failedExecutionSteps = failedExecutionSteps + str + "\n";
                        execFailedServerNames.add(serverName);
                    }
                    if (!execSuccess) {
                        OPatchStartException ose;
                        buff2 = new StringBuffer(failedPrereqStr);
                        buff2.append("These server(s) ");
                        buff2.append(execFailedServerNames.toString());
                        buff2.append(" failed in parallel start operation :\n");
                        buff2.append(failedExecutionSteps);
                        se = ose = new OPatchStartException(buff2.toString());
                    } else {
                        try {
                            buff2 = new StringBuffer();
                            if (failedPrereqLifecycleActions.size() > 0) {
                                buff2.append("Prerequisite check failed for following servers ");
                                buff2.append(this.getServerNames(failedPrereqLifecycleActions).toString() + "\n");
                            }
                            buff2.append("Parallel start operation completed successfully for the following servers only ");
                            buff2.append(this.getServerNames(incomingJEEActions).toString());
                            OLogger.justlog((int)OLogger.INFO, (String)buff2.toString());
                        }
                        catch (OPatchException e) {
                            se = new OPatchStartException(e.getMessage());
                        }
                    }
                    OPatchUtils.closeLogFile();
                    for (int i7 = 0; i7 < lifecycleActions.length; ++i7) {
                        OPatchJEELifecycleAction jeeAction = lifecycleActions[i7];
                        jeeAction.setExecLogFile(OPatchJEELifecycleAction.execLog);
                        OPatchUtils.logExecutionContext(oracleHomePath, jeeAction.getOperatingFAContext(), this.getLifeCycleTimeStamp(), jeeAction);
                        OPatchJEELifecycleAction.execLog = jeeAction.getExecLogFile();
                        jeeAction.setConfigLogFile(OPatchJEELifecycleAction.configLog);
                        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), jeeAction);
                        OPatchJEELifecycleAction.configLog = jeeAction.getConfigLogFile();
                    }
                    if (se != null) {
                        se.setTopLogFile(logFile);
                        throw se;
                    }
                }
            }
            catch (Throwable throwable) {
                StringBuffer buff2;
                Object var21_37 = null;
                for (int i8 = 0; i8 < lifecycleActions.length; ++i8) {
                    lifecycleActions[i8].getClient().close();
                }
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    OPatchStepOperation failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    this.setFailedClosingStep(failedStep, lifecycleActions);
                }
                if (!prereqSuccess) {
                    OPatchUtils.closeLogFile();
                    throw se;
                }
                for (int i9 = 0; i9 < lifecycleActions.length; ++i9) {
                    OPatchJEELifecycleAction jeeAction = lifecycleActions[i9];
                    FMWClient client = jeeAction.getClient();
                    boolean failure = false;
                    List steps = client.getAllExecutedSteps();
                    for (int j = 0; j < steps.size(); ++j) {
                        OPatchStepAdapter step = (OPatchStepAdapter)steps.get(j);
                        if (step.isSuccess()) continue;
                        failure = true;
                    }
                    OPatchUtils.updateExecutionContext(client, jeeAction, OPatchFAOperation.JEE_SERVER_START);
                    OPatchUtils.updateConfig(jeeAction.getBoundDomain(), jeeAction.getBoundServer(), true, failure);
                }
                failedExecutionSteps = "";
                failedPrereqStr = "";
                execSuccess = true;
                context = this.getLifeCycleContext();
                OLogger.justlog((int)OLogger.INFO, (String)"----------Status of parallel start operation----------");
                OLogger.justlog((int)OLogger.INFO, (String)"\n");
                if (failedPrereqLifecycleActions.size() > 0) {
                    try {
                        failedPrereqStr = failedPrereqStr + "These sever(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check: " + prereqException.getMessage() + "\n";
                    }
                    catch (OPatchException e) {
                        se = new OPatchStartException(e.getMessage());
                        throw se;
                    }
                }
                execFailedServerNames = new ArrayList<String>();
                for (int i6 = 0; i6 < lifecycleActions.length; ++i6) {
                    boolean actionSuccess = true;
                    String str = "";
                    OPatchExecutedArtifact executedArtifact = context.getLastExecutedArtifact(lifecycleActions[i6]);
                    OPatchExecutionStep[] execSteps = executedArtifact.getExecutionSteps();
                    for (int j = 0; j < execSteps.length; ++j) {
                        if (execSteps[j].isOperationSuccess()) continue;
                        str = str + execSteps[j].getExecutionStep().toString();
                        actionSuccess = false;
                        execSuccess = false;
                    }
                    if (actionSuccess) continue;
                    String serverName = "";
                    String domainName = "";
                    if (lifecycleActions[i6].getBoundServer() != null) {
                        serverName = lifecycleActions[i6].getBoundServer().getName();
                    }
                    if (lifecycleActions[i6].getBoundDomain() != null) {
                        domainName = lifecycleActions[i6].getBoundDomain().getName();
                    }
                    OLogger.justlog((int)OLogger.INFO, (String)("Server name=" + serverName + ", Domain name=" + domainName + ", Failed step =" + str));
                    failedExecutionSteps = failedExecutionSteps + str + "\n";
                    execFailedServerNames.add(serverName);
                }
                if (!execSuccess) {
                    OPatchStartException ose;
                    buff2 = new StringBuffer(failedPrereqStr);
                    buff2.append("These server(s) ");
                    buff2.append(execFailedServerNames.toString());
                    buff2.append(" failed in parallel start operation :\n");
                    buff2.append(failedExecutionSteps);
                    se = ose = new OPatchStartException(buff2.toString());
                } else {
                    try {
                        buff2 = new StringBuffer();
                        if (failedPrereqLifecycleActions.size() > 0) {
                            buff2.append("Prerequisite check failed for following servers ");
                            buff2.append(this.getServerNames(failedPrereqLifecycleActions).toString() + "\n");
                        }
                        buff2.append("Parallel start operation completed successfully for the following servers only ");
                        buff2.append(this.getServerNames(incomingJEEActions).toString());
                        OLogger.justlog((int)OLogger.INFO, (String)buff2.toString());
                    }
                    catch (OPatchException e) {
                        se = new OPatchStartException(e.getMessage());
                    }
                }
                OPatchUtils.closeLogFile();
                for (int i7 = 0; i7 < lifecycleActions.length; ++i7) {
                    OPatchJEELifecycleAction jeeAction = lifecycleActions[i7];
                    jeeAction.setExecLogFile(OPatchJEELifecycleAction.execLog);
                    OPatchUtils.logExecutionContext(oracleHomePath, jeeAction.getOperatingFAContext(), this.getLifeCycleTimeStamp(), jeeAction);
                    OPatchJEELifecycleAction.execLog = jeeAction.getExecLogFile();
                    jeeAction.setConfigLogFile(OPatchJEELifecycleAction.configLog);
                    OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), jeeAction);
                    OPatchJEELifecycleAction.configLog = jeeAction.getConfigLogFile();
                }
                if (se != null) {
                    se.setTopLogFile(logFile);
                    throw se;
                }
                throw throwable;
            }
        }
        return logFile;
    }

    public String stopServers(OPatchJEELifecycleAction[] lifecycleActions) throws OPatchStopException {
        return this.stopServers(lifecycleActions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String stopServers(OPatchJEELifecycleAction[] lifecycleActions, boolean continueOnPrereqFailure) throws OPatchStopException {
        String logFile;
        block85: {
            StringBuffer buff2;
            int i8;
            for (int i2 = 0; i2 < lifecycleActions.length; ++i2) {
                lifecycleActions[i2].setNoCloseConnection(true);
                lifecycleActions[i2].setDisplayLogFile(false);
            }
            ArrayList<OPatchJEELifecycleAction> incomingJEEActions = new ArrayList<OPatchJEELifecycleAction>(Arrays.asList(lifecycleActions));
            ArrayList failedPrereqLifecycleActions = new ArrayList();
            OPatchStopException se = null;
            String oracleHomePath = this.getContext().getOracleHome();
            boolean prereqSuccess = true;
            OPatchStopException prereqException = null;
            OPatchStepOperation failedStep = null;
            logFile = "";
            OPatchFAPrereq prereq = this.runPrereqOnAllArtifacts(lifecycleActions);
            String failedPrereqs = "";
            if (!prereq.isOK()) {
                OPatchPrereqArtifactStatus[] artifactStatus = prereq.getStatusOfOperationOnArtifacts();
                for (int i3 = 0; i3 < artifactStatus.length; ++i3) {
                    if (artifactStatus[i3].isOK()) continue;
                    prereqSuccess = false;
                    failedPrereqs = failedPrereqs + artifactStatus[i3].getFailedPrereqStep().toString() + "\n";
                }
                prereqException = new OPatchStopException(failedPrereqs);
            }
            try {
                logFile = OPatchUtils.initLogFile(oracleHomePath, this.getLifeCycleTimeStamp(), "Stop_Servers_Parallel_Master", true);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep, lifecycleActions);
                prereqSuccess = false;
                OPatchStartException loginitEx = new OPatchStartException(t.getMessage());
                loginitEx.setStackTrace(t.getStackTrace());
                throw loginitEx;
            }
            OLogger.justlog((int)OLogger.INFO, (String)"----------Prerequisite log files----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            for (int i4 = 0; i4 < lifecycleActions.length; ++i4) {
                String prereqLogFile = lifecycleActions[i4].getLastOperatedLogFile();
                String serverName = "";
                String domainName = "";
                if (lifecycleActions[i4].getBoundServer() != null) {
                    serverName = lifecycleActions[i4].getBoundServer().getName();
                }
                if (lifecycleActions[i4].getBoundDomain() != null) {
                    domainName = lifecycleActions[i4].getBoundDomain().getName();
                }
                serverName = OPatchUtils.norm(serverName);
                domainName = OPatchUtils.norm(domainName);
                OLogger.justlog((int)OLogger.INFO, (String)("Server name=\"" + serverName + "\"" + "," + "Domain name=" + "\"" + domainName + "\"" + ",log file=" + "\"" + prereqLogFile + "\""));
            }
            OLogger.justlog((int)OLogger.INFO, (String)"----------Status of prerequisite checks----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            if (!prereqSuccess) {
                if (prereqException != null) {
                    se = prereqException;
                    OLogger.justlog((int)OLogger.INFO, (String)prereqException.getMessage());
                }
            } else {
                OLogger.justlog((int)OLogger.INFO, (String)"All prereqs passed for stop operation.");
            }
            if (se != null) {
                prereqSuccess = this.continueOnPrereqFailure(incomingJEEActions, prereq, failedPrereqLifecycleActions);
                if (!continueOnPrereqFailure || !prereqSuccess) {
                    prereqSuccess = false;
                    throw se;
                }
                if (failedPrereqLifecycleActions.size() > 0) {
                    OLogger.justlog((int)OLogger.INFO, (String)("The server(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequiste check while the remaining server(s) " + this.getServerNames(incomingJEEActions).toString() + " continue to stop."));
                }
            }
            lifecycleActions = new OPatchJEELifecycleAction[incomingJEEActions.size()];
            incomingJEEActions.toArray(lifecycleActions);
            MultiClient mclient = new MultiClient();
            mclient.setLogPath(oracleHomePath, this.getLifeCycleTimeStamp());
            for (int i5 = 0; i5 < lifecycleActions.length; ++i5) {
                FMWClient client = lifecycleActions[i5].getClient();
                mclient.addClient(client, lifecycleActions[i5]);
            }
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.lockHome(oracleHomePath);
                }
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedPrereqStep(failedStep, lifecycleActions);
                prereqSuccess = false;
                OPatchStartException lockEx = new OPatchStartException(t.getMessage());
                lockEx.setStackTrace(t.getStackTrace());
                throw lockEx;
            }
            OLogger.justlog((int)OLogger.INFO, (String)"---------Parallel stop operation----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            mclient.run(false);
            Object var20_31 = null;
            for (i8 = 0; i8 < lifecycleActions.length; ++i8) {
                lifecycleActions[i8].getClient().close();
            }
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re = new RuntimeException(t2.getMessage());
                re.setStackTrace(t2.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedClosingStep(failedStep, lifecycleActions);
            }
            if (!prereqSuccess) {
                OPatchUtils.closeLogFile();
                throw se;
            }
            for (i8 = 0; i8 < lifecycleActions.length; ++i8) {
                OPatchJEELifecycleAction jeeAction = lifecycleActions[i8];
                FMWClient client = jeeAction.getClient();
                boolean failure = false;
                List steps = client.getAllExecutedSteps();
                for (int j = 0; j < steps.size(); ++j) {
                    OPatchStepAdapter step = (OPatchStepAdapter)steps.get(j);
                    if (step.isSuccess()) continue;
                    failure = true;
                }
                OPatchUtils.updateExecutionContext(client, jeeAction, OPatchFAOperation.JEE_SERVER_STOP);
                OPatchUtils.updateConfig(jeeAction.getBoundDomain(), jeeAction.getBoundServer(), false, failure);
            }
            String failedExecutionSteps = "";
            String prereqFailedStr = "";
            boolean execSuccess = true;
            FAExecutionContext context = this.getLifeCycleContext();
            OLogger.justlog((int)OLogger.INFO, (String)"----------Status of parallel stop operation----------");
            OLogger.justlog((int)OLogger.INFO, (String)"\n");
            if (failedPrereqLifecycleActions.size() > 0) {
                try {
                    prereqFailedStr = "These sever(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check: " + prereqException.getMessage() + "\n";
                }
                catch (OPatchException e) {
                    se = new OPatchStopException(e.getMessage());
                    throw se;
                }
            }
            ArrayList<String> execFailedServerNames = new ArrayList<String>();
            for (int i6 = 0; i6 < lifecycleActions.length; ++i6) {
                boolean actionSuccess = true;
                String str = "";
                OPatchExecutedArtifact executedArtifact = context.getLastExecutedArtifact(lifecycleActions[i6]);
                OPatchExecutionStep[] execSteps = executedArtifact.getExecutionSteps();
                for (int j = 0; j < execSteps.length; ++j) {
                    if (execSteps[j].isOperationSuccess()) continue;
                    str = str + execSteps[j].getExecutionStep().toString();
                    actionSuccess = false;
                    execSuccess = false;
                }
                if (actionSuccess) continue;
                String serverName = "";
                String domainName = "";
                if (lifecycleActions[i6].getBoundServer() != null) {
                    serverName = lifecycleActions[i6].getBoundServer().getName();
                }
                if (lifecycleActions[i6].getBoundDomain() != null) {
                    domainName = lifecycleActions[i6].getBoundDomain().getName();
                }
                OLogger.justlog((int)OLogger.INFO, (String)("server name=" + serverName + ", domain name=" + domainName + ", failed step =" + str));
                failedExecutionSteps = failedExecutionSteps + str + "\n";
                execFailedServerNames.add(serverName);
            }
            if (!execSuccess) {
                OPatchStopException ose;
                buff2 = new StringBuffer(prereqFailedStr);
                buff2.append("These server(s) ");
                buff2.append(execFailedServerNames.toString());
                buff2.append(" failed in parallel stop operation :\n");
                buff2.append(failedExecutionSteps);
                se = ose = new OPatchStopException(buff2.toString());
            } else {
                try {
                    buff2 = new StringBuffer();
                    if (failedPrereqLifecycleActions.size() > 0) {
                        buff2.append("Prerequisite check failed for following servers ");
                        buff2.append(this.getServerNames(failedPrereqLifecycleActions).toString() + "\n");
                    }
                    buff2.append("Parallel stop operation completed successfully for the following servers only ");
                    buff2.append(this.getServerNames(incomingJEEActions).toString());
                    OLogger.justlog((int)OLogger.INFO, (String)buff2.toString());
                }
                catch (OPatchException e) {
                    se = new OPatchStopException(e.getMessage());
                }
            }
            OPatchUtils.closeLogFile();
            for (int i7 = 0; i7 < lifecycleActions.length; ++i7) {
                OPatchJEELifecycleAction jeeAction = lifecycleActions[i7];
                jeeAction.setExecLogFile(OPatchJEELifecycleAction.execLog);
                OPatchUtils.logExecutionContext(oracleHomePath, jeeAction.getOperatingFAContext(), this.getLifeCycleTimeStamp(), jeeAction);
                OPatchJEELifecycleAction.execLog = jeeAction.getExecLogFile();
                jeeAction.setConfigLogFile(OPatchJEELifecycleAction.configLog);
                OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), jeeAction);
                OPatchJEELifecycleAction.configLog = jeeAction.getConfigLogFile();
            }
            if (se != null) {
                se.setTopLogFile(logFile);
                throw se;
            }
            break block85;
            {
                catch (Throwable t) {
                    StringBuffer buff2;
                    OPatchStopException ex = new OPatchStopException(t.getMessage());
                    ex.setStackTrace(t.getStackTrace());
                    se = ex;
                    Object var20_32 = null;
                    for (int i8 = 0; i8 < lifecycleActions.length; ++i8) {
                        lifecycleActions[i8].getClient().close();
                    }
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re = new RuntimeException(t2.getMessage());
                        re.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                        this.setFailedClosingStep(failedStep, lifecycleActions);
                    }
                    if (!prereqSuccess) {
                        OPatchUtils.closeLogFile();
                        throw se;
                    }
                    for (int i9 = 0; i9 < lifecycleActions.length; ++i9) {
                        OPatchJEELifecycleAction jeeAction = lifecycleActions[i9];
                        FMWClient client = jeeAction.getClient();
                        boolean failure = false;
                        List steps = client.getAllExecutedSteps();
                        for (int j = 0; j < steps.size(); ++j) {
                            OPatchStepAdapter step = (OPatchStepAdapter)steps.get(j);
                            if (step.isSuccess()) continue;
                            failure = true;
                        }
                        OPatchUtils.updateExecutionContext(client, jeeAction, OPatchFAOperation.JEE_SERVER_STOP);
                        OPatchUtils.updateConfig(jeeAction.getBoundDomain(), jeeAction.getBoundServer(), false, failure);
                    }
                    failedExecutionSteps = "";
                    prereqFailedStr = "";
                    execSuccess = true;
                    context = this.getLifeCycleContext();
                    OLogger.justlog((int)OLogger.INFO, (String)"----------Status of parallel stop operation----------");
                    OLogger.justlog((int)OLogger.INFO, (String)"\n");
                    if (failedPrereqLifecycleActions.size() > 0) {
                        try {
                            prereqFailedStr = "These sever(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check: " + prereqException.getMessage() + "\n";
                        }
                        catch (OPatchException e) {
                            se = new OPatchStopException(e.getMessage());
                            throw se;
                        }
                    }
                    execFailedServerNames = new ArrayList<String>();
                    for (int i6 = 0; i6 < lifecycleActions.length; ++i6) {
                        boolean actionSuccess = true;
                        String str = "";
                        OPatchExecutedArtifact executedArtifact = context.getLastExecutedArtifact(lifecycleActions[i6]);
                        OPatchExecutionStep[] execSteps = executedArtifact.getExecutionSteps();
                        for (int j = 0; j < execSteps.length; ++j) {
                            if (execSteps[j].isOperationSuccess()) continue;
                            str = str + execSteps[j].getExecutionStep().toString();
                            actionSuccess = false;
                            execSuccess = false;
                        }
                        if (actionSuccess) continue;
                        String serverName = "";
                        String domainName = "";
                        if (lifecycleActions[i6].getBoundServer() != null) {
                            serverName = lifecycleActions[i6].getBoundServer().getName();
                        }
                        if (lifecycleActions[i6].getBoundDomain() != null) {
                            domainName = lifecycleActions[i6].getBoundDomain().getName();
                        }
                        OLogger.justlog((int)OLogger.INFO, (String)("server name=" + serverName + ", domain name=" + domainName + ", failed step =" + str));
                        failedExecutionSteps = failedExecutionSteps + str + "\n";
                        execFailedServerNames.add(serverName);
                    }
                    if (!execSuccess) {
                        OPatchStopException ose;
                        buff2 = new StringBuffer(prereqFailedStr);
                        buff2.append("These server(s) ");
                        buff2.append(execFailedServerNames.toString());
                        buff2.append(" failed in parallel stop operation :\n");
                        buff2.append(failedExecutionSteps);
                        se = ose = new OPatchStopException(buff2.toString());
                    } else {
                        try {
                            buff2 = new StringBuffer();
                            if (failedPrereqLifecycleActions.size() > 0) {
                                buff2.append("Prerequisite check failed for following servers ");
                                buff2.append(this.getServerNames(failedPrereqLifecycleActions).toString() + "\n");
                            }
                            buff2.append("Parallel stop operation completed successfully for the following servers only ");
                            buff2.append(this.getServerNames(incomingJEEActions).toString());
                            OLogger.justlog((int)OLogger.INFO, (String)buff2.toString());
                        }
                        catch (OPatchException e) {
                            se = new OPatchStopException(e.getMessage());
                        }
                    }
                    OPatchUtils.closeLogFile();
                    for (int i7 = 0; i7 < lifecycleActions.length; ++i7) {
                        OPatchJEELifecycleAction jeeAction = lifecycleActions[i7];
                        jeeAction.setExecLogFile(OPatchJEELifecycleAction.execLog);
                        OPatchUtils.logExecutionContext(oracleHomePath, jeeAction.getOperatingFAContext(), this.getLifeCycleTimeStamp(), jeeAction);
                        OPatchJEELifecycleAction.execLog = jeeAction.getExecLogFile();
                        jeeAction.setConfigLogFile(OPatchJEELifecycleAction.configLog);
                        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), jeeAction);
                        OPatchJEELifecycleAction.configLog = jeeAction.getConfigLogFile();
                    }
                    if (se != null) {
                        se.setTopLogFile(logFile);
                        throw se;
                    }
                }
            }
            catch (Throwable throwable) {
                StringBuffer buff2;
                Object var20_33 = null;
                for (int i8 = 0; i8 < lifecycleActions.length; ++i8) {
                    lifecycleActions[i8].getClient().close();
                }
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    this.setFailedClosingStep(failedStep, lifecycleActions);
                }
                if (!prereqSuccess) {
                    OPatchUtils.closeLogFile();
                    throw se;
                }
                for (int i9 = 0; i9 < lifecycleActions.length; ++i9) {
                    OPatchJEELifecycleAction jeeAction = lifecycleActions[i9];
                    FMWClient client = jeeAction.getClient();
                    boolean failure = false;
                    List steps = client.getAllExecutedSteps();
                    for (int j = 0; j < steps.size(); ++j) {
                        OPatchStepAdapter step = (OPatchStepAdapter)steps.get(j);
                        if (step.isSuccess()) continue;
                        failure = true;
                    }
                    OPatchUtils.updateExecutionContext(client, jeeAction, OPatchFAOperation.JEE_SERVER_STOP);
                    OPatchUtils.updateConfig(jeeAction.getBoundDomain(), jeeAction.getBoundServer(), false, failure);
                }
                failedExecutionSteps = "";
                prereqFailedStr = "";
                execSuccess = true;
                context = this.getLifeCycleContext();
                OLogger.justlog((int)OLogger.INFO, (String)"----------Status of parallel stop operation----------");
                OLogger.justlog((int)OLogger.INFO, (String)"\n");
                if (failedPrereqLifecycleActions.size() > 0) {
                    try {
                        prereqFailedStr = "These sever(s) " + this.getServerNames(failedPrereqLifecycleActions).toString() + " failed in prerequisite check: " + prereqException.getMessage() + "\n";
                    }
                    catch (OPatchException e) {
                        se = new OPatchStopException(e.getMessage());
                        throw se;
                    }
                }
                execFailedServerNames = new ArrayList<String>();
                for (int i6 = 0; i6 < lifecycleActions.length; ++i6) {
                    boolean actionSuccess = true;
                    String str = "";
                    OPatchExecutedArtifact executedArtifact = context.getLastExecutedArtifact(lifecycleActions[i6]);
                    OPatchExecutionStep[] execSteps = executedArtifact.getExecutionSteps();
                    for (int j = 0; j < execSteps.length; ++j) {
                        if (execSteps[j].isOperationSuccess()) continue;
                        str = str + execSteps[j].getExecutionStep().toString();
                        actionSuccess = false;
                        execSuccess = false;
                    }
                    if (actionSuccess) continue;
                    String serverName = "";
                    String domainName = "";
                    if (lifecycleActions[i6].getBoundServer() != null) {
                        serverName = lifecycleActions[i6].getBoundServer().getName();
                    }
                    if (lifecycleActions[i6].getBoundDomain() != null) {
                        domainName = lifecycleActions[i6].getBoundDomain().getName();
                    }
                    OLogger.justlog((int)OLogger.INFO, (String)("server name=" + serverName + ", domain name=" + domainName + ", failed step =" + str));
                    failedExecutionSteps = failedExecutionSteps + str + "\n";
                    execFailedServerNames.add(serverName);
                }
                if (!execSuccess) {
                    OPatchStopException ose;
                    buff2 = new StringBuffer(prereqFailedStr);
                    buff2.append("These server(s) ");
                    buff2.append(execFailedServerNames.toString());
                    buff2.append(" failed in parallel stop operation :\n");
                    buff2.append(failedExecutionSteps);
                    se = ose = new OPatchStopException(buff2.toString());
                } else {
                    try {
                        buff2 = new StringBuffer();
                        if (failedPrereqLifecycleActions.size() > 0) {
                            buff2.append("Prerequisite check failed for following servers ");
                            buff2.append(this.getServerNames(failedPrereqLifecycleActions).toString() + "\n");
                        }
                        buff2.append("Parallel stop operation completed successfully for the following servers only ");
                        buff2.append(this.getServerNames(incomingJEEActions).toString());
                        OLogger.justlog((int)OLogger.INFO, (String)buff2.toString());
                    }
                    catch (OPatchException e) {
                        se = new OPatchStopException(e.getMessage());
                    }
                }
                OPatchUtils.closeLogFile();
                for (int i7 = 0; i7 < lifecycleActions.length; ++i7) {
                    OPatchJEELifecycleAction jeeAction = lifecycleActions[i7];
                    jeeAction.setExecLogFile(OPatchJEELifecycleAction.execLog);
                    OPatchUtils.logExecutionContext(oracleHomePath, jeeAction.getOperatingFAContext(), this.getLifeCycleTimeStamp(), jeeAction);
                    OPatchJEELifecycleAction.execLog = jeeAction.getExecLogFile();
                    jeeAction.setConfigLogFile(OPatchJEELifecycleAction.configLog);
                    OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), jeeAction);
                    OPatchJEELifecycleAction.configLog = jeeAction.getConfigLogFile();
                }
                if (se != null) {
                    se.setTopLogFile(logFile);
                    throw se;
                }
                throw throwable;
            }
        }
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String stopComposite(OPatchFAClonedConfigInstance clonedInstance, WLDomain domain, SOAComposite composite) throws OPatchStopException {
        OPatchSOACompositeLifecycleAction stopAction = null;
        OPatchStopException os = null;
        try {
            try {
                stopAction = new OPatchSOACompositeLifecycleAction(clonedInstance, composite, domain);
                stopAction.setCommonComponentsHome(this.commonComponentsHome);
                stopAction.setOracleHomePath(this.getContext().getOracleHome());
                stopAction.setWrapperPatch(null);
                stopAction.setOperatingFAContext(this.lifeContext);
                stopAction.stop();
            }
            catch (OPatchException e) {
                OPatchStopException re = new OPatchStopException(e.getMessage());
                re.setTopLogFile(stopAction.getLastOperatedLogFile());
                re.setStackTrace(e.getStackTrace());
                os = re;
                Object var9_7 = null;
                this.allOperatedLifeCycleActions.add(stopAction);
                if (os == null) return stopAction.getLastOperatedLogFile();
                throw os;
            }
            Object var9_6 = null;
            this.allOperatedLifeCycleActions.add(stopAction);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.allOperatedLifeCycleActions.add(stopAction);
            if (os == null) throw throwable;
            throw os;
        }
        if (os == null) return stopAction.getLastOperatedLogFile();
        throw os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String startComposite(OPatchFAClonedConfigInstance clonedInstance, WLDomain domain, SOAComposite composite) throws OPatchStartException {
        OPatchSOACompositeLifecycleAction startAction = null;
        OPatchStartException os = null;
        try {
            try {
                startAction = new OPatchSOACompositeLifecycleAction(clonedInstance, composite, domain);
                startAction.setCommonComponentsHome(this.commonComponentsHome);
                startAction.setOracleHomePath(this.getContext().getOracleHome());
                startAction.setWrapperPatch(null);
                startAction.setOperatingFAContext(this.lifeContext);
                startAction.start();
            }
            catch (Throwable e) {
                OPatchStartException re = new OPatchStartException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                re.setTopLogFile(startAction.getLastOperatedLogFile());
                os = re;
                Object var9_7 = null;
                this.allOperatedLifeCycleActions.add(startAction);
                if (os == null) return startAction.getLastOperatedLogFile();
                throw os;
            }
            Object var9_6 = null;
            this.allOperatedLifeCycleActions.add(startAction);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.allOperatedLifeCycleActions.add(startAction);
            if (os == null) throw throwable;
            throw os;
        }
        if (os == null) return startAction.getLastOperatedLogFile();
        throw os;
    }

    private void setFailedPrereqStep(OPatchStepOperation op, OPatchJEELifecycleAction[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setFailedPrereqStep(op);
        }
    }

    private void setFailedClosingStep(OPatchStepOperation op, OPatchJEELifecycleAction[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setFailedClosingStep(op);
        }
    }

    private NodeManager cloneNodeManager(NodeManager nm) {
        NodeManager clonedNM = new NodeManager();
        String nmName = nm.getName();
        clonedNM.setName(OPatchUtils.norm(nmName));
        clonedNM.setUsername(OPatchUtils.norm(nm.getUsername()));
        clonedNM.setPassword(OPatchUtils.norm(nm.getPassword()));
        return clonedNM;
    }

    private WLServer cloneManagedServer(WLServer server) {
        WLServer clonedServer = new WLServer();
        clonedServer.setName(OPatchUtils.norm(server.getName()));
        return clonedServer;
    }

    private SOAComposite cloneSOAComposite(SOAComposite soa) {
        SOAComposite clonedSOA = new SOAComposite();
        clonedSOA.setName(OPatchUtils.norm(soa.getName()));
        clonedSOA.setRevisionId(OPatchUtils.norm(soa.getRevisionId()));
        return clonedSOA;
    }

    private WLDomain cloneWLDomain(WLDomain domain) {
        WLDomain clonedWLDomain = new WLDomain();
        String domainName = domain.getName();
        clonedWLDomain.setName(OPatchUtils.norm(domainName));
        WLAdminServer adminServer = domain.getWLAdminServer();
        WLAdminServer cloneAdminServer = new WLAdminServer();
        cloneAdminServer.setURL(OPatchUtils.norm(adminServer.getURL()));
        cloneAdminServer.setPort(adminServer.getPort());
        cloneAdminServer.setUserName(OPatchUtils.norm(adminServer.getUserName()));
        cloneAdminServer.setPassword(OPatchUtils.norm(adminServer.getPassword()));
        clonedWLDomain.setWLAdminServer(cloneAdminServer);
        return clonedWLDomain;
    }

    private LDAP cloneLDAP(LDAP ldap) {
        LDAP cloneLdap = new LDAP();
        cloneLdap.setLogon(OPatchUtils.norm(ldap.getLogon()));
        cloneLdap.setPassword(OPatchUtils.norm(ldap.getPassword()));
        cloneLdap.setURL(OPatchUtils.norm(ldap.getURL()));
        cloneLdap.setPort(ldap.getPort());
        return cloneLdap;
    }

    private BI cloneBI(BI bi) {
        BI clonedBI = new BI();
        clonedBI.setOracle_instance(OPatchUtils.norm(bi.getOracle_instance()));
        clonedBI.setRoot(OPatchUtils.norm(bi.getRoot()));
        return clonedBI;
    }
}

