/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixAssert;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPatchFormatException;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPatch;

public class OipchSolarisPatchReader {
    private static final String PATCH = "Patch";
    private static final String OBSOLETES = "Obsoletes";
    private static final String REQUIRES = "Requires";
    private static final String INCOMPATIBLES = "Incompatibles";
    private static final String PACKAGES = "Packages";
    private static final int START_STATE = 0;
    private static final int PATCH_STATE = 1;
    private static final int OBSOLETES_STATE = 2;
    private static final int REQUIRES_STATE = 3;
    private static final int INCOMPATIBLES_STATE = 4;
    private static final int PACKAGES_STATE = 5;
    private static final String TOKEN_SEPARATORS = ": ,";

    private OipchSolarisPatchReader() {
    }

    static Collection readPatchDetails(String sFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        ArrayList<OipchSolarisPatch> oPatches = new ArrayList<OipchSolarisPatch>();
        HashMap<String, Object> oPatchesEncountered = new HashMap<String, Object>();
        HashMap oPackagesPatched = new HashMap();
        OipchSolarisPatch oPatch = null;
        block15: while (true) {
            boolean patchNameStartsWithAlphabet = false;
            String currentLine = reader.readLine();
            if (currentLine == null) break;
            StringTokenizer st = new StringTokenizer(currentLine, TOKEN_SEPARATORS, false);
            int state = 0;
            while (true) {
                if (!st.hasMoreTokens()) continue block15;
                String str = st.nextToken().trim();
                if (str.equals(PATCH)) {
                    state = 1;
                    continue;
                }
                if (str.equals(OBSOLETES)) {
                    state = 2;
                    continue;
                }
                if (str.equals(REQUIRES)) {
                    state = 3;
                    continue;
                }
                if (str.equals(INCOMPATIBLES)) {
                    state = 4;
                    continue;
                }
                if (str.equals(PACKAGES)) {
                    state = 5;
                    continue;
                }
                switch (state) {
                    case 1: {
                        if (!Character.isDigit(str.charAt(0))) {
                            patchNameStartsWithAlphabet = true;
                            break;
                        }
                        oPatch = (OipchSolarisPatch)oPatchesEncountered.get(str);
                        if (oPatch == null) {
                            try {
                                oPatch = new OipchSolarisPatch(str);
                            }
                            catch (OipchIncorrectPatchFormatException e) {
                                OiixAssert.assertion((boolean)true, (String)e.getMessage());
                            }
                            oPatchesEncountered.put(str, oPatch);
                        }
                        oPatches.add(oPatch);
                        break;
                    }
                    case 2: {
                        OipchSolarisPatch patch = (OipchSolarisPatch)oPatchesEncountered.get(str);
                        if (patch == null) {
                            try {
                                patch = new OipchSolarisPatch(str);
                            }
                            catch (OipchIncorrectPatchFormatException e) {
                                OiixAssert.assertion((boolean)true, (String)e.getMessage());
                            }
                            oPatchesEncountered.put(str, patch);
                        }
                        oPatch.addObsoletePatch(patch);
                        break;
                    }
                    case 3: {
                        OipchSolarisPatch patch = (OipchSolarisPatch)oPatchesEncountered.get(str);
                        if (patch == null) {
                            try {
                                patch = new OipchSolarisPatch(str);
                            }
                            catch (OipchIncorrectPatchFormatException e) {
                                OiixAssert.assertion((boolean)true, (String)e.getMessage());
                            }
                            oPatchesEncountered.put(str, patch);
                        }
                        oPatch.addRequiredPatch(patch);
                        break;
                    }
                    case 4: {
                        OipchSolarisPatch patch = (OipchSolarisPatch)oPatchesEncountered.get(str);
                        if (patch == null) {
                            try {
                                patch = new OipchSolarisPatch(str);
                            }
                            catch (OipchIncorrectPatchFormatException e) {
                                OiixAssert.assertion((boolean)true, (String)e.getMessage());
                            }
                            oPatchesEncountered.put(str, patch);
                        }
                        oPatch.addIncompatiblePatch(patch);
                        break;
                    }
                    case 5: {
                        String sPkg = (String)oPackagesPatched.get(str);
                        if (sPkg == null) {
                            oPatchesEncountered.put(str, str);
                            sPkg = str;
                        }
                        oPatch.addPackage(sPkg);
                        break;
                    }
                }
                if (patchNameStartsWithAlphabet) break;
            }
            patchNameStartsWithAlphabet = false;
        }
        reader.close();
        return oPatches;
    }
}

