/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchLinuxPackage;

public class OipchLinuxPackageReader {
    private OipchLinuxPackageReader() {
    }

    static Collection readPackageDetails(String sFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        ArrayList<OipchLinuxPackage> oPackages = new ArrayList<OipchLinuxPackage>();
        OipchLinuxPackage oPackage = null;
        while ((currentLine = reader.readLine()) != null) {
            currentLine.trim();
            oPackage = new OipchLinuxPackage();
            String sPkgVersion = currentLine;
            StringTokenizer st = new StringTokenizer(currentLine, " ");
            String sPkg = "";
            String sVersion = null;
            String sArch = null;
            if (st.hasMoreTokens()) {
                sPkg = st.nextToken();
                oPackage.setName(sPkg);
            }
            if (st.hasMoreTokens()) {
                sVersion = st.nextToken();
                try {
                    oPackage.setVersion(sVersion);
                }
                catch (OipchIncorrectVersionFormatException e) {
                    e.printStackTrace();
                }
            }
            if (st.hasMoreTokens()) {
                sArch = st.nextToken();
                oPackage.setArch(sArch);
            }
            oPackages.add(oPackage);
        }
        reader.close();
        return oPackages;
    }
}

