/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilDescQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class RemoveClusterPreinstService
implements OiilDescQuery {
    private static final String TEMP_SERVICE_DIR = "\\clusterpreinst";
    private static final String TEMP_SERVICE_EXECUTABLE = "clusterpreinstsrv.exe";
    private static final String TEMP_SERVICE_NAME = "OracleClusterPreinstService";

    public String getDescription(Vector inputs) {
        String descStr = "";
        return descStr;
    }

    public Object performQuery(Vector inputs) throws OiilQueryException {
        int i;
        String[] nodeList = (String[])this.retItem(inputs, "nodeList");
        String dest = (String)this.retItem(inputs, "dest");
        File f = new File(dest);
        if (nodeList.length < 1) {
            return null;
        }
        if (!f.isDirectory()) {
            String exName = "DirNotFoundException";
            String exString = OiQueryFileRes.getString("DirNotFoundException_desc");
            Object[] objs = new String[]{dest};
            exString = MessageFormat.format(exString, objs);
            throw new OiilQueryException(exName, exString);
        }
        ClusterPreinstClassW32 qc = new ClusterPreinstClassW32();
        ClusterWindows clusterWindows = null;
        try {
            clusterWindows = new ClusterWindows(4);
        }
        catch (ClusterException e) {
            Trace.out((Exception)((Object)e));
            String exName = "HardwareVerificationException";
            String exString = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(exName, exString);
        }
        Trace.out((String)"Stopping and deleting temporary clusterpreinstall service");
        try {
            for (i = 0; i < nodeList.length; ++i) {
                clusterWindows.stopServiceOnNode(TEMP_SERVICE_NAME, nodeList[i]);
                Thread.sleep(3L);
            }
        }
        catch (Exception e) {
            Trace.out((Exception)e);
            String exName = "HardwareVerificationException";
            String exString = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(exName, exString);
        }
        try {
            for (i = 0; i < nodeList.length; ++i) {
                clusterWindows.deleteServiceOnNode(TEMP_SERVICE_NAME, nodeList[i]);
                Thread.sleep(3L);
            }
            Trace.out((String)"\n Removed Temporary Services");
        }
        catch (Exception e) {
            Trace.out((Exception)e);
            String exName = "HardwareVerificationException";
            String exString = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(exName, exString);
        }
        boolean retVal = true;
        Trace.out((String)"Removing temporary drive letter service file");
        for (int i2 = 0; i2 < nodeList.length; ++i2) {
            String dirName = "\\\\" + nodeList[i2] + "\\" + dest.replace(':', '$');
            retVal = qc.removeDirectory(dirName);
            if (retVal) {
                Trace.out((String)"Successfully cleanup the temporary directory");
                continue;
            }
            Trace.out((String)"Unable to fully cleanup the temporary directory");
        }
        return new Boolean(retVal);
    }

    public Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public static void main(String[] args) {
        RemoveClusterPreinstService gsy = new RemoveClusterPreinstService();
        Vector<OiilActionInputElement> inp = new Vector<OiilActionInputElement>();
        System.out.println("Length of args = " + args.length);
        if (args.length != 2) {
            System.out.println("Usage: java RemoveClusterPreinstService \"node1,node2,\"  Exe_dest_directory");
            return;
        }
        System.out.println("Arg[0] = " + args[0]);
        System.out.println("Arg[1] = " + args[1]);
        StringTokenizer st = new StringTokenizer(args[0], ",");
        String[] nodelist = new String[st.countTokens()];
        System.out.println("Number of nodes = " + nodelist.length);
        int i = 0;
        while (st.hasMoreTokens()) {
            nodelist[i] = new String(st.nextToken());
            System.out.println("Node " + i + " = " + nodelist[i]);
            ++i;
        }
        inp.addElement(new OiilActionInputElement("nodeList", (Object)nodelist));
        String dest = args[1];
        inp.addElement(new OiilActionInputElement("dest", (Object)dest));
        try {
            Boolean retVal = (Boolean)gsy.performQuery(inp);
            System.out.println("retVal = " + retVal);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

