/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiip.oiipg.OiipgReadRGS;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

class ssReadRGSw32 {
    private boolean m_bDebug = true;
    String m_sFileName;
    BufferedInputStream m_bis;
    Vector m_vRgsTable = new Vector();
    private static final int m_numOfFields = 11;

    ssReadRGSw32() {
    }

    void init(String string) throws IOException {
        OiipgReadRGS oiipgReadRGS = new OiipgReadRGS();
        this.m_sFileName = oiipgReadRGS.getRgsFileName(string);
        this.debug("****Rgs file " + this.m_sFileName);
        FileInputStream fileInputStream = new FileInputStream(this.m_sFileName);
        this.m_bis = new BufferedInputStream(fileInputStream, 1024);
    }

    public Vector getRgsTable() {
        return this.m_vRgsTable;
    }

    private boolean searchForDuplicate(String string, String string2) {
        for (int i = 0; i < this.m_vRgsTable.size(); ++i) {
            RgsEntry rgsEntry = (RgsEntry)this.m_vRgsTable.elementAt(i);
            if (!rgsEntry.getName().equals(string) || !rgsEntry.getVersion().equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void addRgsEntry(Vector vector) {
        RgsEntry rgsEntry = new RgsEntry();
        String string = (String)vector.elementAt(0);
        rgsEntry.setID(new Integer(string));
        rgsEntry.setName((String)vector.elementAt(1));
        rgsEntry.setParentRegistry((String)vector.elementAt(2));
        rgsEntry.setFileName((String)vector.elementAt(3));
        rgsEntry.setVersion((String)vector.elementAt(4));
        rgsEntry.setInterfaceLabel((String)vector.elementAt(5));
        rgsEntry.setSize(new Long((String)vector.elementAt(6)));
        rgsEntry.setRegDate((String)vector.elementAt(7));
        rgsEntry.setReferences((String)vector.elementAt(8));
        rgsEntry.setComponentDesc((String)vector.elementAt(9));
        rgsEntry.setOption1((String)vector.elementAt(10));
        this.m_vRgsTable.addElement(rgsEntry);
    }

    private void deleteRgsEntry(String string) {
        int n;
        for (n = 0; n < this.m_vRgsTable.size(); ++n) {
            RgsEntry rgsEntry = (RgsEntry)this.m_vRgsTable.elementAt(n);
            if (!rgsEntry.getName().equals(string)) continue;
            this.debug("i : " + n);
            this.m_vRgsTable.removeElementAt(n);
            break;
        }
        this.debug("reached here i is " + n);
        if (n > this.m_vRgsTable.size()) {
            this.debug("Not found");
        }
    }

    public void doWriteRgs(String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            OiipgReadRGS oiipgReadRGS = new OiipgReadRGS();
            fileOutputStream = new FileOutputStream(oiipgReadRGS.getRgsFileName(string));
            printWriter = new PrintWriter(fileOutputStream);
            for (int i = 0; i < this.m_vRgsTable.size(); ++i) {
                RgsEntry rgsEntry = (RgsEntry)this.m_vRgsTable.elementAt(i);
                int n = rgsEntry.getID();
                printWriter.print(n + " ");
                String string2 = rgsEntry.getName();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getParentRegistry();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getFileName();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getVersion();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getInterfaceLabel();
                printWriter.print(string2 + " ");
                n = rgsEntry.getSize().intValue();
                printWriter.print(n + " ");
                string2 = rgsEntry.getRegDate();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getReferences();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getComponentDesc();
                printWriter.print(string2 + " ");
                string2 = rgsEntry.getOption1();
                printWriter.println(string2 + " ");
            }
            printWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw iOException;
        }
    }

    public void doReadRgs() throws IOException {
        String string;
        while ((string = this.readNextLine()) != null) {
            this.debug(string);
            Vector vector = this.splitRgsLine(string);
            this.addRgsEntry(vector);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.debug("\nEntry #" + i + " : " + (String)vector.elementAt(i));
            }
            this.debug("\nNextLine================");
        }
        this.m_bis.close();
    }

    String readNextLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (!bl && (n = this.m_bis.read()) != -1) {
            if (n == 10) {
                bl = true;
                continue;
            }
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    Vector splitRgsLine(String string) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = null;
        string = string.trim();
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (!bl) continue block4;
                    if (bl2) {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    bl = false;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = null;
                    continue block4;
                }
                case '\"': {
                    if (!bl) {
                        bl2 = true;
                        bl = true;
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(c);
                        continue block4;
                    }
                    stringBuffer.append(c);
                    bl2 = false;
                    bl = false;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = null;
                    continue block4;
                }
                default: {
                    if (!bl) {
                        bl = true;
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(c);
                        continue block4;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer != null) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    public Vector formVectorForRgsEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        vector.addElement(string);
        vector.addElement(string3);
        vector.addElement(string4);
        vector.addElement(string5);
        vector.addElement(string6);
        vector.addElement(string7);
        vector.addElement(string8);
        vector.addElement(string9);
        vector.addElement(string10);
        vector.addElement(string11);
        return vector;
    }

    public void doAddRgsEntryAction(String string, String string2, Integer n, String string3, String string4, String string5, String string6, Long l, String string7, String string8, String string9, String string10) throws IOException {
        Serializable serializable;
        OiipgReadRGS oiipgReadRGS = new OiipgReadRGS();
        String string11 = oiipgReadRGS.getRgsFileName(string);
        File file = new File(OiixPathOps.getNativeForm((String)string11));
        if (!file.exists()) {
            this.debug("RGS FILE/DIR DOES NOT EXIST");
            serializable = new File(file.getParent());
            OiixFileOps.mkdirs((File)serializable);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.close();
            if (file.exists()) {
                this.debug("CREATED NEW w32 RGS FILE");
            }
        } else {
            this.debug("RGS FILE/DIR EXISTS");
        }
        this.init(string);
        this.debug("FFFFF");
        this.doReadRgs();
        this.debug("done 1");
        serializable = this.formVectorForRgsEntry(string2, n.toString(), string3, string4, string5, string6, l.toString(), string7, string8, string9, string10);
        this.debug("done 2");
        boolean bl = this.searchForDuplicate(string2, string5);
        if (!bl) {
            this.addRgsEntry((Vector)serializable);
        } else {
            this.debug("Duplicate exists so not adding the new Rgs entry");
        }
        this.debug("done 3");
        this.doWriteRgs(string);
    }

    public void doDeleteRgsEntryAction(String string, String string2) throws IOException {
        this.init(string);
        this.debug("FFFFF");
        this.doReadRgs();
        this.deleteRgsEntry(string2);
        this.doWriteRgs(string);
    }

    private boolean searchAndAddToTable(String string, String string2, Vector vector) throws OiilActionException {
        boolean bl = false;
        for (int i = 0; i < this.m_vRgsTable.size(); ++i) {
            RgsEntry rgsEntry = (RgsEntry)this.m_vRgsTable.elementAt(i);
            if (!rgsEntry.getName().equals(string) || !rgsEntry.getVersion().equals(string2)) continue;
            bl = true;
            Vector vector2 = this.getRefListAsVector(rgsEntry.getReferences());
            vector2 = OiixVectorOps.union((Vector)vector2, (Vector)vector);
            rgsEntry.setReferences(this.getRefListAsString(vector2));
            break;
        }
        return bl;
    }

    private String getRefListAsString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < vector.size(); ++i) {
            if (i != 0) {
                stringBuffer = stringBuffer.append(",");
            }
            stringBuffer = stringBuffer.append((String)vector.elementAt(i));
        }
        stringBuffer = stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private Vector getRefListAsVector(String string) throws OiilActionException {
        if (!(string = string.trim()).startsWith("[") || !string.endsWith("]")) {
            int n = 2;
            String string2 = "InputBadFormatException";
            String string3 = OiActionRgsRes.getString("InputBadFormatException_desc");
            throw new OiilActionException(string2, string3, n);
        }
        string = string.substring(1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            vector.addElement(string4);
        }
        return vector;
    }

    public void doAddRgsRefListAction(String string, String string2, String string3, String string4) throws IOException, OiilActionException {
        OiipgReadRGS oiipgReadRGS = new OiipgReadRGS();
        String string5 = oiipgReadRGS.getRgsFileName(string);
        File file = new File(OiixPathOps.getNativeForm((String)string5));
        int n = 2;
        if (!file.exists()) {
            String string6 = "RgsFileFoundException";
            String string7 = OiActionRgsRes.getString("RgsFileFoundException_desc");
            throw new OiilActionException(string6, string7, n);
        }
        this.debug("RGS FILE/DIR EXISTS");
        this.init(string);
        this.debug("After initializing Oracle home etc");
        this.doReadRgs();
        this.debug("done reading Rgs RGS table size is " + this.m_vRgsTable.size());
        Vector vector = this.getRefListAsVector(string4);
        if (!this.searchAndAddToTable(string2, string3, vector)) {
            String string8 = "ProductVersionNotFoundException";
            String string9 = OiActionRgsRes.getString("ProductVersionNotFoundException_desc");
            throw new OiilActionException(string8, string9, n);
        }
        this.debug("done adding to the ref list Rgs table size is " + this.m_vRgsTable.size());
        this.doWriteRgs(string);
    }

    private void debug(String string) {
        if (this.m_bDebug) {
            System.err.println("ReadRgs : " + string);
        }
    }

    public static void main(String[] stringArray) {
        String string = "c:\\orant";
        String string2 = "check";
        Integer n = new Integer(1);
        String string3 = "checkparent";
        String string4 = "\"checkfile\"";
        String string5 = "\"1.0.0.0\"";
        String string6 = "\"checklabel\"";
        Long l = new Long(2L);
        String string7 = "\"checkDate\"";
        String string8 = "[check]";
        String string9 = "\"G\"";
        String string10 = "G";
        try {
            ssReadRGSw32 ssReadRGSw322 = new ssReadRGSw32();
            string8 = "[check, checkToAdd, checkToAdd2]";
            ssReadRGSw322.doAddRgsRefListAction(string, string2, string5, string8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

