/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.PhaseOneExecutor;
import oracle.opatch.twophase.PhaseTwoExecutor;
import oracle.sysman.oii.oiic.OiicInventoryOperationHelper;
import oracle.sysman.oii.oiix.OiixFunctionOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoPhasePatching {
    private boolean init = false;
    private String oh = OPatchEnv.getOracleHome();
    private OPatchCASOracleHome coh;

    private void initialize() {
        if (this.init) {
            return;
        }
        this.coh = new OPatchCASOracleHome(this.oh, ".cas");
        this.init = true;
    }

    public void prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch) {
        String sohPath = "";
        OLogger.printlnOnLog("TwoPhasePatching::Start OPatch/CAS for oneoff phase1/prepare");
        try {
            sohPath = this.casPrepare(this.oh, rollbackPatch, applyPatch);
            this.attachHome(sohPath);
            PhaseOneExecutor exe = new PhaseOneExecutor();
            exe.execute(sohPath, applyPatch, rollbackPatch);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public void commit() throws ClassNotFoundException, IOException {
        PhaseTwoExecutor exec = new PhaseTwoExecutor(this.oh);
        exec.execute();
    }

    private String casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches) {
        CASFileServices cas = new CASFileServices();
        String branchKey = "";
        String sohPath = "";
        try {
            this.initialize();
            branchKey = OPatchEnv.getBranchKey();
            OLogger.printlnOnLog("casPrepare::enable CAS/buildCasStore.");
            cas.build();
            String soh = this.coh.getCASStoragePath() + File.separator + branchKey;
            sohPath = oh + File.separator + soh;
            OLogger.printlnOnLog("casPrepare::destroy previous branch.");
            try {
                cas.destroy(soh);
            }
            catch (Throwable t) {
                OLogger.printlnOnLog("casPrepare::destroy previous branch - error: " + t.getMessage());
            }
            HashMap<Path, String> copy = new HashMap<Path, String>();
            HashMap<Path, String> hardlink = new HashMap<Path, String>();
            Path inv = Paths.get("inventory", new String[0]);
            copy.put(inv, "inventory");
            Map<Path, String> rCopies = this.getCopiedFiles(oh, rollbackPatches);
            Map<Path, String> aCopies = this.getCopiedFiles(oh, applyPatches);
            for (Map.Entry<Path, String> entry : rCopies.entrySet()) {
                copy.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Path, String> entry : aCopies.entrySet()) {
                copy.put(entry.getKey(), entry.getValue());
            }
            Path ps = Paths.get(OPatchEnv.getPatchStorageName(), new String[0]);
            copy.put(ps, OPatchEnv.getPatchStorageName());
            OLogger.printlnOnLog("Copy list to shadow home is: " + copy);
            OLogger.printlnOnLog("Hardlink list to shadow home is: " + hardlink);
            OLogger.printlnOnLog("casPrepare::create Shadow OH/createBranchOH, soh path is " + sohPath);
            cas.create(sohPath, copy, hardlink);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return sohPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void attachHome(String sohPath) {
        Properties props;
        block7: {
            OLogger.printlnOnLog("Enter attachHome for Shadow OH");
            props = System.getProperties();
            props.setProperty("oracle.installer.scratchPath", "/tmp");
            boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
            if (!isConsoleOutputDisabled) {
                OLogger.disableConsoleOutput(true);
            }
            try {
                try {
                    String strArgs = "";
                    strArgs = strArgs.concat(" -force ");
                    strArgs = strArgs.concat(" -nogenerateGUID ");
                    String[] params = OiixFunctionOps.explodeString((String)strArgs, (String)" ");
                    OiicInventoryOperationHelper.attachHome((String)sohPath, (String)"soh", (String[])params);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    Object var7_8 = null;
                    if (!isConsoleOutputDisabled) {
                        OLogger.enableConsoleOutput(true);
                    }
                    break block7;
                }
                Object var7_7 = null;
                if (isConsoleOutputDisabled) break block7;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!isConsoleOutputDisabled) {
                    OLogger.enableConsoleOutput(true);
                }
                throw throwable;
            }
            OLogger.enableConsoleOutput(true);
        }
        props.setProperty("oracle.installer.attachHome", "false");
        OLogger.printlnOnLog("attachHome::copy over comps.xml from origianl OH to Shadow OH after attachhome");
        File oComps = new File(IPMUtil.getCompsXMLLocation(this.oh));
        File sComps = new File(IPMUtil.getCompsXMLLocation(sohPath));
        SystemCall.copyFile(oComps, sComps);
    }

    private Map<Path, String> getCopiedFiles(String oh, PatchObject[] patches) {
        MakeAction[] makes;
        OLogger.printlnOnLog("Get a list of other files to be copied to shadow home.");
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> copy = new HashMap<Path, String>();
        HashSet<String> patchfiles = new HashSet<String>();
        OneOffEntry[] oneoffs = new OneOffEntry[patches.length];
        for (int i2 = 0; i2 < patches.length; ++i2) {
            oneoffs[i2] = patches[i2].toOneOffEntry(oh);
            String[][] filesTouched = oneoffs[i2].getFilesTouched(oh);
            for (int x = 0; x < filesTouched.length; ++x) {
                String touchfile = filesTouched[x][1];
                patchfiles.add(touchfile);
                OLogger.printlnOnLog(MessageFormat.format("Copy files touched by the patch, adding \"{0}\" to copy list. \n", touchfile));
            }
            ListIterator iter = patches[i2].getAllIncludedJarActions();
            while (iter.hasNext()) {
                String[] jarfiles;
                JarAction a2 = (JarAction)iter.next();
                for (String jarfile : jarfiles = a2.filesTouched(oh)) {
                    patchfiles.add(jarfile);
                    OLogger.printlnOnLog(MessageFormat.format("Copy multi-layer container files, adding \"{0}\" to copy list. \n", jarfile));
                }
            }
            for (String patchfile : patchfiles) {
                File file = new File(patchfile);
                if (!file.exists()) continue;
                patchfile = patchfile.substring(oh.length() + 1, patchfile.length());
                Path p1 = Paths.get(patchfile, new String[0]);
                copy.put(p1, patchfile);
            }
        }
        for (MakeAction m2 : makes = OPatchSessionHelper.getIncludedMakeActions(oh, patches)) {
            String makefile = m2.getMakeFile();
            String changedir = m2.getChangeDirectory();
            makefile = changedir + File.separator + makefile;
            Path p2 = Paths.get(makefile, new String[0]);
            copy.put(p2, makefile);
            OLogger.printlnOnLog(MessageFormat.format("Copy MakeFile needed for relink, adding \"{0}\" to copy list. \n", makefile));
        }
        return copy;
    }
}

