/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.opatch.OPatchEnv;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.InitReadMePatchActions;
import oracle.opatch.twophase.InitScriptPatchActions;
import oracle.opatch.twophase.MakePatchActions;
import oracle.opatch.twophase.PostReadMePatchActions;
import oracle.opatch.twophase.PostScriptPatchActions;
import oracle.opatch.twophase.PreReadMePatchActions;
import oracle.opatch.twophase.PreScriptPatchActions;

public class PhaseTwoExecutor {
    private boolean copyOh = false;
    private String oh;
    private CASFileServices cas;

    public PhaseTwoExecutor(String oracleHome) {
        this.oh = oracleHome;
        this.cas = new CASFileServices();
    }

    public void execute() throws ClassNotFoundException, IOException {
        this.runPhaseTwoNRollback();
        this.runPhaseTwoNApply();
        this.runFinalProcessingSteps();
    }

    private void runPhaseTwo(String prefix) throws ClassNotFoundException, IOException {
        OLogger.printlnOnLog(MessageFormat.format("Start to run phaseTwo with key {0}", prefix));
        InitReadMePatchActions initrms = new InitReadMePatchActions();
        InitScriptPatchActions inits = new InitScriptPatchActions();
        MakePatchActions makes = new MakePatchActions();
        PreReadMePatchActions prerms = new PreReadMePatchActions();
        PreScriptPatchActions pres = new PreScriptPatchActions();
        PostReadMePatchActions postrms = new PostReadMePatchActions();
        PostScriptPatchActions posts = new PostScriptPatchActions();
        this.load(prefix, initrms, inits, makes, prerms, pres, postrms, posts);
        try {
            if (this.shouldRunCopyOh(inits, makes, pres, posts)) {
                this.runCopyOh();
            }
            for (OPatchPatchKey key : inits.keySet()) {
                initrms.run(key);
                inits.run(key);
            }
            for (OPatchPatchKey key : pres.keySet()) {
                prerms.run(key);
                pres.run(key);
                this.commit(key);
                postrms.run(key);
                posts.run(key);
            }
            makes.runAll();
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("run Phase Two error");
            t.printStackTrace();
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        OLogger.printlnOnLog("Finished running phaseTwo.");
    }

    private void commit(OPatchPatchKey key) {
        this.cas.commit(key, new HashMap<Path, String>());
        OLogger.printlnOnLog(MessageFormat.format("Commited bit update for the key \"{0}\".\n", key.toString()));
    }

    private void load(String prefix, InitReadMePatchActions initrms, InitScriptPatchActions inits, MakePatchActions makes, PreReadMePatchActions prerms, PreScriptPatchActions pres, PostReadMePatchActions postrms, PostScriptPatchActions posts) throws ClassNotFoundException, IOException {
        OLogger.printlnOnLog("Loading patch custom scripts..");
        initrms.load(prefix);
        inits.load(prefix);
        makes.load(prefix);
        prerms.load(prefix);
        pres.load(prefix);
        postrms.load(prefix);
        posts.load(prefix);
        OLogger.printlnOnLog("Finished loading patch custom scripts.");
    }

    private boolean shouldRunCopyOh(InitScriptPatchActions inits, MakePatchActions makes, PreScriptPatchActions pres, PostScriptPatchActions posts) {
        if (inits.hasAnyActions()) {
            return true;
        }
        if (makes.hasAnyActions()) {
            return true;
        }
        if (pres.hasAnyActions()) {
            return true;
        }
        return posts.hasAnyActions();
    }

    private void runPhaseTwoNRollback() throws ClassNotFoundException, IOException {
        this.runPhaseTwo(this.getRollbackPrefixFileName());
    }

    private void runPhaseTwoNApply() throws ClassNotFoundException, IOException {
        this.runPhaseTwo(this.getApplyPrefixFileName());
    }

    private void runCopyOh() {
        if (!this.copyOh) {
            OLogger.printlnOnLog("Converting OH from hardlink to real copy..");
            this.cas.copyOh();
            this.copyOh = true;
            OLogger.printlnOnLog("Finished converting OH from hardlink to real copy.");
        }
    }

    private void runFinalProcessingSteps() {
        this.cas.normalizeOH();
        OLogger.printlnOnLog("Normalized OH.");
    }

    private String getRollbackPrefixFileName() {
        return OPatchEnv.getPrereqResultFileLoc(this.oh) + File.separator + "nrollback.key";
    }

    private String getApplyPrefixFileName() {
        return OPatchEnv.getPrereqResultFileLoc(this.oh) + File.separator + "napply.key";
    }
}

