/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.opatch.PatchObject;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.InitReadMePatchActions;
import oracle.opatch.twophase.InitScriptPatchActions;
import oracle.opatch.twophase.MakePatchActions;
import oracle.opatch.twophase.PostReadMePatchActions;
import oracle.opatch.twophase.PostScriptPatchActions;
import oracle.opatch.twophase.PreReadMePatchActions;
import oracle.opatch.twophase.PreScriptPatchActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OPatchOperator {
    public void run(String sohPath, PatchObject[] patchList) throws Exception {
        CASFileServices cas = new CASFileServices();
        if (patchList == null) {
            return;
        }
        LinkedHashMap<OPatchPatchKey, PatchObject[]> patchMap = new LinkedHashMap<OPatchPatchKey, PatchObject[]>();
        for (PatchObject p2 : patchList) {
            PatchObject[] piList = new PatchObject[]{p2};
            OPatchPatchKey opKey = new OPatchPatchKey(p2, this.getKeyPostfix());
            OLogger.printlnOnLog(MessageFormat.format("CAS beginPatchBranch with patchkey \"{0}\". \n", opKey.toString()));
            cas.begin(opKey);
            OLogger.printlnOnLog(MessageFormat.format("Modifying system on \"{0}\"... \n", sohPath));
            Map<Path, String> remove = this.modify(sohPath, piList);
            OLogger.printlnOnLog(MessageFormat.format("CAS endPatchBranch with patchkey \"{0}\". \n", opKey.toString()));
            cas.end(opKey, remove);
            OLogger.printlnOnLog(MessageFormat.format("Save key \"{0}\" and corresponding patch \"{1}\" to the map. \n", opKey.toString(), p2.getPatchID()));
            patchMap.put(opKey, piList);
        }
        OLogger.printlnOnLog(MessageFormat.format("Save the map to \"{0}\" \n", this.getPrefix()));
        this.save(this.getPrefix(), patchMap);
    }

    public abstract Map<Path, String> modify(String var1, PatchObject[] var2);

    public abstract String getPrefix();

    public abstract String getKeyPostfix();

    private void save(String prefix, Map<OPatchPatchKey, PatchObject[]> patchMap) throws IOException {
        InitScriptPatchActions inits = new InitScriptPatchActions();
        InitReadMePatchActions initrms = new InitReadMePatchActions();
        MakePatchActions makes = new MakePatchActions();
        PreScriptPatchActions pres = new PreScriptPatchActions();
        PreReadMePatchActions prerms = new PreReadMePatchActions();
        PostScriptPatchActions posts = new PostScriptPatchActions();
        PostReadMePatchActions postrms = new PostReadMePatchActions();
        inits.save(prefix, patchMap);
        initrms.save(prefix, patchMap);
        pres.save(prefix, patchMap);
        prerms.save(prefix, patchMap);
        posts.save(prefix, patchMap);
        postrms.save(prefix, patchMap);
        makes.save(prefix, patchMap);
    }
}

