/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import oracle.opatch.CopyAction;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.NRollback;
import oracle.opatch.twophase.OPatchOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchNRollback
extends OPatchOperator {
    @Override
    public Map<Path, String> modify(String soh, PatchObject[] rollbackPatch) {
        String[] patchesToRollback = new String[rollbackPatch.length];
        for (int i2 = 0; i2 < rollbackPatch.length; ++i2) {
            patchesToRollback[i2] = rollbackPatch[i2].getPatchID();
        }
        OLogger.printlnOnLog(MessageFormat.format("Start running NRollback Phase1 on OH {0}:", soh));
        NRollback.legacy_process(soh, patchesToRollback);
        this.setPatchActions(OPatchEnv.getOracleHome(), rollbackPatch);
        HashMap<Path, String> remove = new HashMap();
        remove = this.getRemovedFiles(OPatchEnv.getOracleHome(), rollbackPatch);
        OLogger.printlnOnLog(MessageFormat.format("Finish running NRollback Phase1 on OH {0}:", soh));
        return remove;
    }

    @Override
    public String getPrefix() {
        return OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "nrollback.key";
    }

    @Override
    public String getKeyPostfix() {
        return "nrollback";
    }

    private void setPatchActions(String oracleHomePath, PatchObject[] patches) {
        for (PatchObject po : patches) {
            String cookedPatchID = po.getCookedPatchID();
            String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            OLogger.printlnOnLog(MessageFormat.format("Start to set scripts actions for patch {0}.", po.getPatchID()));
            String preReadMeLoc = PatchObject.getPreReadMeFilePath(prevAppliedPatchLocation);
            String postReadMeLoc = PatchObject.getPostReadMeFilePath(prevAppliedPatchLocation);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
            String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
            String preScriptLoc = PatchObject.getPreScriptFilePath(prevAppliedPatchLocation);
            String postScriptLoc = PatchObject.getPostScriptFilePath(prevAppliedPatchLocation);
            po.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
            po.setInitScriptAction(new InitScriptAction(initScriptLoc));
            po.setPreReadMeAction(new PreReadMeAction(preReadMeLoc));
            po.setPreScriptAction(new PreScriptAction(preScriptLoc));
            String c1 = this.readScriptContent(postReadMeLoc);
            String newPostReadMeLoc = this.writeScriptContent(c1, po, ".newpost.readme");
            String c2 = this.readScriptContent(postScriptLoc);
            String newPostScriptLoc = this.writeScriptContent(c2, po, ".newpost");
            po.setPostReadMeAction(new PostReadMeAction(newPostReadMeLoc));
            po.setPostScriptAction(new PostScriptAction(newPostScriptLoc));
        }
        OLogger.printlnOnLog("Finished setting scripts actions for patches.");
    }

    private String readScriptContent(String scriptLoc) {
        StringBuffer sb = new StringBuffer();
        File scriptFile = new File(scriptLoc);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find scripts content under {0}:", scriptLoc));
            return null;
        }
        catch (Exception e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to read scripts content from {0}:", scriptLoc));
            return null;
        }
        return sb.toString();
    }

    private String writeScriptContent(String content, PatchObject po, String postfix) {
        String newLoc = "";
        if (content == null) {
            return "";
        }
        try {
            newLoc = this.getNewScriptLoc(po, postfix);
            OLogger.printlnOnLog(MessageFormat.format("OPatch is re-writing scripts to {0}:", newLoc));
            File file = new File(newLoc);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to write scripts content under {0}:", newLoc));
            return "";
        }
        return newLoc;
    }

    public String getNewScriptLoc(PatchObject po, String postfix) {
        StringBuffer buff = new StringBuffer(this.getPrefix());
        buff.append(".");
        buff.append(po.getPatchID());
        buff.append(postfix);
        return buff.toString();
    }

    private Map<Path, String> getRemovedFiles(String oh, PatchObject[] patches) {
        OLogger.printlnOnLog("Get a list of files to be removed in original home.");
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> remove = new HashMap<Path, String>();
        for (PatchObject po : patches) {
            String loc = OPatchEnv.getPatchFilemapInfoLoc(oh, po.getPatchID());
            loc = loc.substring(oh.length() + 1, loc.length());
            Path pLoc = Paths.get(loc, new String[0]);
            remove.put(pLoc, loc);
            OLogger.printlnOnLog(MessageFormat.format("Removing installed oneoff entry: adding \"{0}\" to remove list. \n", loc));
            String cookedPatchID = po.getCookedPatchID();
            String ps = OPatchEnv.getPatchStorageName() + File.separator + cookedPatchID;
            Path pPs = Paths.get(ps, new String[0]);
            remove.put(pPs, ps);
            OLogger.printlnOnLog(MessageFormat.format("Removing backup area, adding \"{0}\" to remove list. \n", ps));
            ListIterator cIter = po.getAllIncludedCopyActions();
            while (cIter.hasNext()) {
                CopyAction a2 = (CopyAction)cIter.next();
                String f2 = a2.getFilename();
                String src = this.getRollbackFile(oh, f2, cookedPatchID);
                String dst = a2.getParentFilePath(oh);
                File srcFile = new File(src);
                if (srcFile.exists() && srcFile.canRead()) {
                    OLogger.printlnOnLog(MessageFormat.format("The copy file \"{0}\" exists in .patch_storage, do not remove. \n", src));
                    continue;
                }
                if (srcFile.exists() && !srcFile.canRead()) {
                    String notReadableMsg = MessageFormat.format("The copy file \"{0}\" exists in .patch_storage, but it's not readable. \n", src);
                    OLogger.printlnOnLog(notReadableMsg);
                    throw new RuntimeException(notReadableMsg);
                }
                OLogger.printlnOnLog(MessageFormat.format("The copy file \"{0}\" doesn't exist in .patch_storage, to be removed. \n", src));
                StringBuffer srcFileName = new StringBuffer(src);
                dst = dst.substring(oh.length() + 1, dst.length());
                Path pd = Paths.get(dst, new String[0]);
                remove.put(pd, dst);
                OLogger.printlnOnLog(MessageFormat.format("Removing newly created file, adding \"{0}\" to remove list. \n", dst));
            }
        }
        return remove;
    }

    private String getRollbackFile(String oh, String copyFile, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oh, cookedPatchID));
        buff.append(File.separator);
        buff.append(copyFile);
        String file = buff.toString();
        return file;
    }
}

