/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdkv2impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchingModel;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdkv2.IPatch;
import oracle.opatch.opatchsdkv2.IReadWriteSession;
import oracle.opatch.opatchsdkv2.ce.OperationConfiguration;
import oracle.opatch.opatchsdkv2impl.ReadSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.TwoPhaseOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteSession
extends ReadSession
implements IReadWriteSession {
    private String oracleHomePath = this.opCfg.getOracleHomePath().toString();

    public ReadWriteSession(OperationConfiguration cfg) {
        super(cfg);
    }

    public void nRollbackPhaseOne(List<IPatch> poh) throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nRollbackPhaseOne");
        String workSheetLoc = this.getWorkSheetPath();
        this.updateHistoryFile("OPatchSDKV2::nRollbackPhaseOne -phBaseFile" + workSheetLoc);
        if (poh == null || poh.isEmpty()) {
            throw new RuntimeException("OPatchSDKV2:: Input IPatch list cannot be null. ");
        }
        try {
            try {
                OLogger.printlnOnLog("OPatchSDKV2::nRollbackPhaseOne:: with CAS two phase for oneoff.");
                String[] pIDs = new String[poh.size()];
                for (int i2 = 0; i2 < poh.size(); ++i2) {
                    IPatch pi = poh.get(i2);
                    pIDs[i2] = new String(pi.getPatchId().replaceAll("/", "_"));
                }
                OPatchEnv.setUserSuppliedPatchIDs(pIDs);
                OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nRollbackPhaseOne:: Get worksheetloc for incoming patches from " + workSheetLoc);
                this.writeToWorkSheet(poh, workSheetLoc);
                OPatchEnv.setCASPhase1();
                OPatchOverCAS.INSTANCE.prepareOneoffPatching(TwoPhaseOperations.NROLLBACK);
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            OPatchEnv.unsetCASPhase1();
            throw throwable;
        }
        OPatchEnv.unsetCASPhase1();
    }

    public void nRollbackPhaseTwo() throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nRollbackPhaseTwo");
        this.updateHistoryFile("OPatchSDKV2::nRollbackPhaseTwo");
        try {
            block4: {
                try {
                    OLogger.printlnOnLog("OPatchSDKV2::nRollbackPhaseTwo:: with CAS two phase for oneoff.");
                    OPatchEnv.setCASPhase2();
                    if (OPatchEnv.isReport()) break block4;
                    OPatchOverCAS.INSTANCE.commitOneoffPatching();
                }
                catch (Throwable t) {
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            OPatchEnv.unsetCASPhase2();
            throw throwable;
        }
        OPatchEnv.unsetCASPhase2();
    }

    public void nApplyPhaseOne(List<IPatch> piList) throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nApplyPhaseOne(List<IPatch> piList)");
        String workSheetLoc = this.getWorkSheetPath();
        this.updateHistoryFile("OPatchSDKV2::nApplyPhaseOne -phBaseFile" + workSheetLoc);
        if (piList == null || piList.isEmpty()) {
            throw new RuntimeException("OPatchSDKV2:: Input IPatch list cannot be null. ");
        }
        try {
            try {
                OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nApplyPhaseOne:: OPatch SDK calls CAS NApply phase1");
                OPatchPatch[] patches = new OPatchPatch[piList.size()];
                for (int i2 = 0; i2 < piList.size(); ++i2) {
                    IPatch pi = piList.get(i2);
                    patches[i2] = new OPatchPatch(pi.getLocation().toString());
                }
                if (!this.canSkipCasPhase1()) {
                    OLogger.printlnOnLogAndVerbose("OPatchSDKV2::SDK NApply::CAS Phase1 is not executed, re-run phase1.");
                    OPatchEnv.setCASPhase1();
                    OPatchOverCAS.INSTANCE.serializeData(this.oracleHomePath, patches);
                }
                OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nApplyPhaseOne:: Get worksheetloc for incoming patches from " + workSheetLoc);
                this.writeToWorkSheet(piList, workSheetLoc);
                try {
                    OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nApplyPhaseOne:: serialize current OH and pi status, and run napply phase1");
                    if (PatchingModel.returnModelCode(this.oracleHomePath) == 2) {
                        OLogger.printlnOnLog("OPatchSDKV2::CAS prepare snowball.");
                        OPatchOverCAS.INSTANCE.prepareSnowballPatching();
                    } else {
                        OLogger.printlnOnLog("OPatchSDKV2::CAS prepare oneoff.");
                        OPatchOverCAS.INSTANCE.prepareOneoffPatching(TwoPhaseOperations.NAPPLY);
                    }
                }
                catch (Throwable e2) {
                    OLogger.printlnOnLog("OPatchSDKV2::napply phase1 in validation fails");
                    e2.printStackTrace();
                    throw e2;
                }
                Object var7_9 = null;
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            OPatchEnv.unsetCASPhase1();
            throw throwable;
        }
        OPatchEnv.unsetCASPhase1();
    }

    private synchronized boolean canSkipCasPhase1() {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        OPatchEnv.setPrereqResult(OPatchTarget.getPrereqResultFileLoc((String)this.getOracleHomePath().toString()));
        boolean done = false;
        try {
            done = serializer.deserializeCASNapplyStatus(OPatchEnv.getPrereqResult() + File.separator + "cas_napply.txt");
        }
        catch (IOException e2) {
            OLogger.printlnOnLog("OPatchSDKV2::OPatch failed to parse cas_napply.txt");
            done = false;
        }
        return done;
    }

    public void nApplyPhaseTwo() throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nApplyPhaseTwo");
        this.updateHistoryFile("OPatchSDKV2::nApplyPhaseTwo");
        try {
            block6: {
                try {
                    OPatchEnv.setCASPhase2();
                    if (OPatchEnv.isReport()) break block6;
                    if (PatchingModel.returnModelCode(this.oracleHomePath) == 2) {
                        OLogger.printlnOnLog("OPatchSDKV2::CAS commit for snowball.");
                        OPatchOverCAS.INSTANCE.commitSnowballPatching();
                        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.FA_TWO_PHASE)) {
                            OLogger.printlnOnLog("OPatchSDKV2::nApplyPhaseTwo::clean and update cached files(2-phase) after napply completes.");
                            OPatchEnv.setPrereqResult(OPatchEnv.getPrereqResultFileLoc(this.oracleHomePath));
                            ProcessFileVersions proc = new ProcessFileVersions();
                            proc.cleanCachedFiles();
                            OPatchEnv.unsetHashMatch();
                            OPatchEnv.unsetFATwoPhase();
                        }
                        break block6;
                    }
                    OLogger.printlnOnLog("OPatchSDKV2::CAS commit for oneoff.");
                    OPatchOverCAS.INSTANCE.commitOneoffPatching();
                }
                catch (Throwable t) {
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OPatchEnv.unsetCASPhase2();
            throw throwable;
        }
        OPatchEnv.unsetCASPhase2();
    }

    private void updateHistoryFile(String arg) {
        StringBuffer buff = new StringBuffer("Log File    : ");
        try {
            String logfile = OPatchACL.getLogFileNameAndLocation(this, this.oracleHomePath);
            buff.append(logfile);
            buff.append("\n\n");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        OPatchSessionHelper.updateHistoryFile(this.oracleHomePath, new String[]{arg + "\n" + buff.toString()});
    }

    private void writeToWorkSheet(List<IPatch> patchList, String workSheetLoc) throws IOException {
        File wsObj = new File(workSheetLoc);
        FileWriter fw = new FileWriter(wsObj);
        PrintWriter pw = new PrintWriter(fw);
        for (IPatch pi : patchList) {
            pw.println(pi.getLocation().toString());
        }
        pw.flush();
        fw.close();
        pw.close();
    }
}

