/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.TwoPhaseMatchType;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFileVersions {
    public void computeFV(PatchObject[] patchObjects, String oracleHomePath, Map<String, String> m2, boolean fvExist) {
        IndexPair hash;
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        OneOffEntry[] pi = new OneOffEntry[patchObjects.length];
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            pi[i2] = patchObjects[i2].toOneOffEntry(oracleHomePath);
        }
        HashMap mpi = new HashMap();
        mpi = OPatchSessionHelper.getCopyFileVer(pi);
        try {
            OLogger.printlnOnLogAndVerbose("Stored cached object fv_pi_merge.txt");
            serializer.serializeFileVersion(OPatchEnv.getPrereqResult() + File.separator + "fv_pi_merge.txt", mpi);
        }
        catch (IOException e2) {
            OLogger.println("OPatch failed to store fv_pi_merge.txt");
        }
        if (!fvExist) {
            try {
                OLogger.printlnOnLogAndVerbose("Stored cached object fv_oh.txt");
                serializer.serializeFileVersion(OPatchEnv.getPrereqResult() + File.separator + "fv_oh.txt", m2);
            }
            catch (IOException e3) {
                OLogger.println("OPatch failed to store fv_oh.txt");
            }
        }
        try {
            hash = OPatchSessionHelper.getHashCodes(oracleHomePath, pi);
        }
        catch (IOException e4) {
            throw new RuntimeException(e4.getMessage());
        }
        try {
            OLogger.printlnOnLogAndVerbose("Stored cached object fv_hash.txt");
            serializer.serializeHashValue(OPatchEnv.getPrereqResult() + File.separator + "fv_hash.txt", hash);
        }
        catch (IOException e5) {
            OLogger.println("OPatch failed to store fv_hash.txt");
        }
        Set keys = mpi.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String ohVer;
            int retVal;
            String filename = (String)itr.next();
            String ver = (String)mpi.get(filename);
            if (!m2.containsKey(filename) || (retVal = OPatchSessionHelper.isGreaterDecimal(ohVer = m2.get(filename), ver)) != 0 && retVal != 1) continue;
            itr.remove();
        }
        try {
            OLogger.printlnOnLogAndVerbose("Stored cached object fv_delta.txt");
            serializer.serializeFileVersion(OPatchEnv.getPrereqResult() + File.separator + "fv_delta.txt", mpi);
        }
        catch (IOException e6) {
            OLogger.println("OPatch failed to store fv_delta.txt");
        }
        Set<String> keys2 = m2.keySet();
        for (String filename2 : keys2) {
            String ver2 = m2.get(filename2);
            if (mpi.containsKey(filename2)) continue;
            mpi.put(filename2, ver2);
        }
        try {
            OLogger.printlnOnLogAndVerbose("Stored cached object fv_next_oh.txt");
            serializer.serializeFileVersion(OPatchEnv.getPrereqResult() + File.separator + "fv_next_oh.txt", mpi);
        }
        catch (IOException e7) {
            OLogger.println("OPatch failed to store fv_next_oh.txt");
        }
    }

    public void computeNoOp(Vector noOps) {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            OLogger.printlnOnLogAndVerbose("Stored cached object pi_noOps.txt");
            serializer.serializeNoOpCheckResult(OPatchEnv.getPrereqResult() + File.separator + "pi_noOps.txt", noOps);
        }
        catch (IOException e2) {
            OLogger.println("OPatch failed to store pi_no_ops.txt");
        }
    }

    public void computeComps(PatchObject[] pis) {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        HashSet<IndexPair> comps = this.getPiComponents(pis);
        try {
            OLogger.printlnOnLogAndVerbose("Stored cached object pi_comps.txt and start_time.txt");
            serializer.serializePiComponents(OPatchEnv.getPrereqResult() + File.separator + "pi_comps.txt", comps);
            serializer.serializeTime(OPatchEnv.getPrereqResult() + File.separator + "start_time.txt");
        }
        catch (IOException e2) {
            OLogger.println("OPatch failed to store pi_comps.txt");
        }
    }

    public static boolean existFvOh(String oracleHomePath) {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        StringBuffer buff = new StringBuffer(OPatchEnv.getPrereqResult());
        buff.append(File.separator);
        buff.append("fv_oh.txt");
        File fvOhFile = new File(buff.toString());
        if (!fvOhFile.exists()) {
            return false;
        }
        String curHash = "";
        String storedHash = "";
        try {
            curHash = OPatchSessionHelper.getOhHash(oracleHomePath);
            storedHash = serializer.deserializeOhHashValue(OPatchEnv.getPrereqResult() + File.separator + "oh_hash.txt");
        }
        catch (IOException e2) {
            OLogger.println("OPatch failed to parse oh_hash.txt");
            return false;
        }
        boolean hash = curHash.equals(storedHash);
        return hash;
    }

    public boolean validateResult(String oracleHomePath, OneOffEntry[] pohs, OneOffEntry[] pis) {
        IndexPair storedHash;
        IndexPair currentHash;
        OLogger.printlnOnLogAndVerbose("Verify if the cache is valid.");
        OLogger.printlnOnLogAndVerbose("Poh number = " + pohs.length + ", Pi number = " + pis.length + "\n");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            currentHash = OPatchSessionHelper.getHashCodes(oracleHomePath, pis);
            storedHash = serializer.deserializeHashValue(OPatchEnv.getPrereqResult() + File.separator + "fv_hash.txt");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2.getMessage());
        }
        if (storedHash == null) {
            OLogger.printlnOnLogAndVerbose("Stored hash value is null, fvs are not valid.");
            return false;
        }
        if (currentHash.getSecondKey().equals(storedHash.getSecondKey())) {
            if (currentHash.getFirstKey().equals(storedHash.getFirstKey())) {
                OLogger.printlnOnLogAndVerbose("Both Pi and Poh are unchanged.");
                return true;
            }
            if (this.checkCompsUntouched(pohs)) {
                OLogger.printlnOnLogAndVerbose("Changed Pohs touch different components with those for incoming patches, fvs are still valid.");
                return true;
            }
            OLogger.printlnOnLogAndVerbose("Changed Pohs touch same components with those for incoming patches, fvs are not valid.");
            return false;
        }
        OLogger.printlnOnLogAndVerbose("Incoming patches changed, fvs become invalid.");
        OLogger.printlnOnLogAndVerbose("Stored Pi hash = " + storedHash.getSecondKey());
        OLogger.printlnOnLogAndVerbose("Current Pi hash = " + currentHash.getSecondKey());
        return false;
    }

    public TwoPhaseMatchType checkMatchType(String oracleHomePath, OneOffEntry[] pohs, OneOffEntry[] pis) {
        IndexPair currentHash;
        IndexPair storedHash;
        OLogger.printlnOnLogAndVerbose("Check hash match type: same, no collision, different");
        OLogger.printlnOnLogAndVerbose("Poh number = " + pohs.length + ", Pi number = " + pis.length + "\n");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            storedHash = OPatchOverCAS.INSTANCE.deserializeData(oracleHomePath);
            currentHash = OPatchSessionHelper.getHashCodes(oracleHomePath, pis);
        }
        catch (Exception e2) {
            OLogger.printlnOnLogAndVerbose("Parse hash error.");
            return TwoPhaseMatchType.DIFFERENT;
        }
        if (storedHash == null) {
            OLogger.printlnOnLogAndVerbose("Stored hash value is null, fvs are not valid.");
            return TwoPhaseMatchType.DIFFERENT;
        }
        if (currentHash.getSecondKey().equals(storedHash.getSecondKey())) {
            if (currentHash.getFirstKey().equals(storedHash.getFirstKey())) {
                OLogger.printlnOnLogAndVerbose("Both Pi and Poh are unchanged.");
                return TwoPhaseMatchType.SAME;
            }
            if (this.checkCompsUntouched(pohs)) {
                OLogger.printlnOnLogAndVerbose("Changed Pohs touch different components with those for incoming patches, fvs are still valid.");
                return TwoPhaseMatchType.NOCOLLISION;
            }
            OLogger.printlnOnLogAndVerbose("Changed Pohs touch same components with those for incoming patches, fvs are not valid.");
            return TwoPhaseMatchType.DIFFERENT;
        }
        OLogger.printlnOnLogAndVerbose("Incoming patches changed, fvs become invalid.");
        OLogger.printlnOnLogAndVerbose("Stored Pi hash = " + storedHash.getSecondKey());
        OLogger.printlnOnLogAndVerbose("Current Pi hash = " + currentHash.getSecondKey());
        return TwoPhaseMatchType.DIFFERENT;
    }

    private boolean checkCompsUntouched(OneOffEntry[] pohs) {
        Date startDate;
        OLogger.printlnOnLogAndVerbose("Veirfy if Poh changed (sandwich case)");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        HashSet<Object> oldComps = new HashSet();
        try {
            startDate = serializer.deserializeTime(OPatchEnv.getPrereqResult() + File.separator + "start_time.txt");
            oldComps = serializer.deserializePiComponents(OPatchEnv.getPrereqResult() + File.separator + "pi_comps.txt");
        }
        catch (IOException e2) {
            OLogger.println("OPatch failed to parse pi_comps.txt");
            return false;
        }
        if (startDate == null) {
            return false;
        }
        HashSet<IndexPair> newComps = new HashSet<IndexPair>();
        for (int i2 = 0; i2 < pohs.length; ++i2) {
            OneOffEntry poh = pohs[i2];
            if (!poh.getAppliedDate().after(startDate)) continue;
            for (PatchComponent comp : poh.getAllComponents()) {
                IndexPair nameVer = new IndexPair(comp.getName(), comp.getVersion());
                newComps.add(nameVer);
            }
        }
        newComps.retainAll(oldComps);
        return newComps.size() == 0;
    }

    private HashSet<IndexPair> getPiComponents(PatchObject[] pis) {
        HashSet<IndexPair> comps = new HashSet<IndexPair>();
        for (PatchObject pi : pis) {
            for (PatchComponent comp : pi.getPatchComponents()) {
                IndexPair nameVer = new IndexPair(comp.getName(), comp.getVersion());
                comps.add(nameVer);
            }
        }
        return comps;
    }

    public void updateCachedFiles(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("fv_oh");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
            buff.append(dateFormatter.format(new Date()));
        }
        catch (Throwable t) {
            buff.append("");
            OLogger.println("Failed to get timestamp");
        }
        buff.append(".txt");
        String cacheLoc = OPatchEnv.getPrereqResult();
        String oldOhPath = cacheLoc + File.separator + "fv_oh.txt";
        String newOhPath = cacheLoc + File.separator + buff.toString();
        String nextOhPath = cacheLoc + File.separator + "fv_next_oh.txt";
        serializer.renameCachedFiles(oldOhPath, newOhPath);
        serializer.renameCachedFiles(nextOhPath, oldOhPath);
        try {
            String hash = OPatchSessionHelper.getOhHash(oracleHomePath);
            serializer.serializeOhHashValue(cacheLoc + File.separator + "oh_hash.txt", hash);
            OLogger.printlnOnLogAndVerbose("Generated oh_hash.txt for current OH.");
        }
        catch (IOException e2) {
            OLogger.println("OPatch failed to store oh_hash.txt");
        }
        OLogger.printlnOnLogAndVerbose("Updated fv_oh.txt and fv_oh<timestamp>.txt after NApply completes.");
    }

    public void cleanCachedFiles() {
        String cacheLoc = OPatchEnv.getPrereqResult();
        File cacheLocFile = new File(cacheLoc);
        File[] listOfFiles = cacheLocFile.listFiles();
        for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
            File fv = listOfFiles[i2];
            if (!this.shouldBeRemoved(fv)) continue;
            fv.delete();
        }
        StringBuffer buff = new StringBuffer("Removed cached files under ");
        buff.append(cacheLoc);
        buff.append(" after napply completes.");
        OLogger.printlnOnLogAndVerbose(buff.toString());
    }

    private boolean shouldBeRemoved(File f2) {
        if (!f2.isFile()) {
            return false;
        }
        if (!f2.getName().endsWith(".txt")) {
            return false;
        }
        if (f2.getName().startsWith("fv_oh")) {
            return false;
        }
        return !f2.getName().equals("oh_hash.txt");
    }
}

