/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import oracle.opatch.OPatchACL;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;

public class checkApplicable {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkApplicable(String srcHome, String[] oracleHomes, String patchLocation, String mwHome, boolean isAll) throws RuntimeException {
        boolean failFlag;
        int i2;
        StringBuffer buff = new StringBuffer("oracle.opatch.opatchfafmw::checkApplicable()");
        OLogger.debug(buff);
        PatchObject po = null;
        try {
            po = new PatchObject(patchLocation);
        }
        catch (Exception e2) {
            RuntimeException t = new RuntimeException(e2.getMessage());
            t.setStackTrace(e2.getStackTrace());
            throw t;
        }
        buff = new StringBuffer();
        ArrayList<String> passedHomes = new ArrayList<String>();
        ArrayList<String> failedHomes = new ArrayList<String>();
        try {
            OPatchACL.releaseLock(new checkApplicable());
        }
        catch (Throwable t) {
            RuntimeException e3 = new RuntimeException(t.getMessage());
            e3.setStackTrace(t.getStackTrace());
            throw e3;
        }
        for (i2 = 0; i2 < oracleHomes.length; ++i2) {
            String homePath = oracleHomes[i2];
            StringBuffer debugBuff = new StringBuffer("Testing applicability of Patch \"" + po.getPatchID() + "\" on Oracle Home \"" + homePath + "\"...");
            OLogger.debug(debugBuff);
            PrereqResult applicableRes = PrereqAPI.checkApplicable(homePath, new PatchObject[]{po});
            OneOffEntry oneOff = po.toOneOffEntry(homePath);
            OneOffEntry[] oneOffEntries = new OneOffEntry[]{oneOff};
            PrereqResult spaceAvail = PrereqAPI.checkSystemSpace(homePath, oneOffEntries, new String[]{patchLocation});
            if (applicableRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || spaceAvail.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || applicableRes.getResult() == PrereqResult.ExecuteStatus.FAILED || spaceAvail.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff.append("\n\"checkApplicable\" failed for Patch \"");
                buff.append(po.getPatchID());
                buff.append("\" and Oracle Home \"");
                buff.append(homePath);
                buff.append("\".");
                buff.append(applicableRes.toString());
                failedHomes.add(homePath);
            } else {
                buff.append("\n\"checkApplicable\" passed for Patch \"");
                buff.append(po.getPatchID());
                buff.append("\" and Oracle Home \"");
                buff.append(homePath);
                buff.append("\".");
                buff.append(applicableRes.toString());
                passedHomes.add(homePath);
            }
            try {
                OPatchACL.releaseLock(new checkApplicable());
                continue;
            }
            catch (Throwable t) {
                RuntimeException e4 = new RuntimeException(t.getMessage());
                e4.setStackTrace(t.getStackTrace());
                throw e4;
            }
        }
        OLogger.printlnOnLog(buff.toString());
        buff = new StringBuffer();
        if (passedHomes.size() > 0) {
            buff.append("\n\nThe patch " + po.getPatchID() + " can be applied to the following homes (" + passedHomes.size() + "):");
            for (i2 = 0; i2 < passedHomes.size(); ++i2) {
                buff.append("\n" + passedHomes.get(i2));
            }
        }
        if (failedHomes.size() > 0) {
            buff.append("\n\nThe patch " + po.getPatchID() + " cannot be applied to any of following homes.");
            for (i2 = 0; i2 < failedHomes.size(); ++i2) {
                buff.append("\n" + failedHomes.get(i2));
            }
        }
        boolean bl = failFlag = failedHomes.size() > 0;
        if (failFlag) {
            if (mwHome == null || mwHome.equals("")) throw new RuntimeException(buff.toString());
            OLogger.println(buff.toString() + "\n");
            OLogger.warn("OUI-67124", new Object[]{"Some of the Oracle Homes under the Middleware Home \"" + mwHome + "\" have failed this check."});
            return;
        } else {
            OLogger.println(buff.toString());
        }
    }
}

