/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchSOAStep;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.SOATimeoutException;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class DeployBaseSOAComposite
implements Operation {
    DeployBaseSOAComposite() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(FMWContext c2) {
        OPatchSOAStep enableEdnStep2;
        SOACompositeManager scm = null;
        Object prereqAdapter = null;
        boolean report = OPatchEnv.isReport();
        scm = c2.getDomain().getSOACompositeManager();
        SOAComposite composite = c2.getSOAComposite();
        if (composite == null) {
            return;
        }
        String name = composite.getName();
        String revision = composite.getRevision();
        String path = composite.getPath();
        String newCompositeDN = "default/" + name + "!" + revision;
        String errorMsg = "";
        boolean enableEDN = false;
        try {
            try {
                if (!Util.existFile(path)) {
                    errorMsg = Logger.getString(RB.Entry.SOA_COMPOSITE_NOT_EXIST, path, name);
                    RuntimeException re = new RuntimeException(errorMsg);
                    OPatchStepAdapter existFileStep = new OPatchStepAdapter(OPatchFAStep.CHECK_PATH_EXISTS);
                    existFileStep.setStepDescription("Check SOA Composite exists");
                    existFileStep.setErrorMessage(errorMsg);
                    existFileStep.setExceptionObject(re);
                    existFileStep.setSuccess(false);
                    c2.getContextBuilder().addExecutionStep(existFileStep);
                    Logger.loge(errorMsg);
                    throw re;
                }
                Logger.logi("Path where the jar is taken is -> " + path);
                String tempLocation = Util.getTempLocation(c2.getTempLocation(), name);
                String jarName = new File(path).getName();
                String deployJar = tempLocation + System.getProperty("file.separator") + jarName;
                Util.deleteFile(deployJar);
                if (!Util.copyFile(path, deployJar)) {
                    errorMsg = "OPatch was not able to copy composite jar to the temporary location";
                    Logger.loge(errorMsg);
                    RuntimeException re1 = new RuntimeException(errorMsg);
                    OPatchStepAdapter copyFileStep = new OPatchStepAdapter(OPatchFAStep.COPY_JAR_TO_TEMP_LOCATION);
                    copyFileStep.setStepDescription("Copy composite Jar to temporary location");
                    copyFileStep.setSuccess(false);
                    copyFileStep.setErrorMessage(errorMsg);
                    copyFileStep.setExceptionObject(re1);
                    c2.getContextBuilder().addExecutionStep(copyFileStep);
                    throw re1;
                }
                if (report) {
                    OPatchSOAStep connectPromptStep = new OPatchSOAStep(OPatchFAStep.SOA_WLST_SERVER_CONNECT);
                    connectPromptStep.setStepDescription("[Connects WLST to a WebLogic Server instance as online model, this step is need by following WLST commands but not done here]");
                    connectPromptStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(connectPromptStep);
                }
                Logger.logi("[SOA COMPOSITE] Disable EDN Events Delivery");
                OPatchSOAStep disableEdnEventsStep = new OPatchSOAStep(OPatchFAStep.SOA_DISABLE_EDN_EVENTS);
                disableEdnEventsStep.setStepDescription("Disable EDN Events Delivery");
                try {
                    if (!report) {
                        scm.disableEDNEvents();
                        enableEDN = true;
                    } else {
                        disableEdnEventsStep.setStepDescription("[Skip] Disable EDN Events Delivery");
                    }
                    disableEdnEventsStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(disableEdnEventsStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in Disable EDN Events Delivery.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    disableEdnEventsStep.setSuccess(false);
                    disableEdnEventsStep.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    disableEdnEventsStep.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(disableEdnEventsStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    enableEDN = true;
                    throw re;
                }
                Logger.logi("[SOA COMPOSITE] Deploying Base SOA Composite [" + newCompositeDN + "]");
                OPatchSOAStep deployStep = new OPatchSOAStep(OPatchFAStep.SOA_DEPLOY_COMPOSITE);
                deployStep.setStepDescription("Deploy Composite");
                deployStep.setSarFile(deployJar);
                try {
                    if (!report && !scm.deployComposite(deployJar, null)) {
                        errorMsg = "OPatch was not able to deploy the composite [" + newCompositeDN + "]";
                        throw new Exception(errorMsg);
                    }
                    deployStep.setSuccess(true);
                    if (!report) {
                        OPatchStepAdapter timeoutStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_REQUEST_RESPONSE);
                        timeoutStep.setStepDescription("Check for timeout related issues in SOA deployment requests");
                        timeoutStep.setSuccess(true);
                        c2.getContextBuilder().addExecutionStep(timeoutStep);
                    } else {
                        deployStep.setStepDescription("[Skip] Deploy Composite");
                    }
                    c2.getContextBuilder().addExecutionStep(deployStep);
                }
                catch (SOATimeoutException t) {
                    errorMsg = "Timeout occurred when deploying SOA composite [" + newCompositeDN + "]. No SOA artifact recovery will be initiated.";
                    OPatchStepAdapter deployTimeOutStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_REQUEST_RESPONSE);
                    deployTimeOutStep.setStepDescription("Check for timeout related issues in SOA deployment requests");
                    deployTimeOutStep.setSuccess(false);
                    RuntimeException re = new RuntimeException(t);
                    deployTimeOutStep.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(deployTimeOutStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    enableEDN = true;
                    throw re;
                }
                catch (Throwable t) {
                    errorMsg = "Error in deploying SOA composite [" + newCompositeDN + "].";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    deployStep.setErrorMessage(errorMsg);
                    deployStep.setSuccess(false);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    deployStep.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(deployStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    enableEDN = true;
                    throw re;
                }
                Object var21_31 = null;
                enableEdnStep2 = new OPatchSOAStep(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
            }
            catch (Throwable t1) {
                RuntimeException re = new RuntimeException(t1.getMessage());
                re.setStackTrace(t1.getStackTrace());
                throw re;
            }
        }
        catch (Throwable throwable) {
            Object var21_32 = null;
            OPatchSOAStep enableEdnStep2 = new OPatchSOAStep(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
            enableEdnStep2.setStepDescription("Enable EDN Events Delivery");
            try {
                Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery");
                if (!report) {
                    scm.enableEDNEvents();
                } else {
                    enableEdnStep2.setStepDescription("[Skip] Enable EDN Events Delivery");
                }
                enableEdnStep2.setSuccess(true);
                enableEDN = false;
                c2.getContextBuilder().addExecutionStep(enableEdnStep2);
                throw throwable;
            }
            catch (Throwable t) {
                errorMsg = "Error in Enable EDN Events Delivery API.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                enableEdnStep2.setSuccess(false);
                enableEdnStep2.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                enableEdnStep2.setExceptionObject(re);
                c2.getContextBuilder().addRecoveryStep(enableEdnStep2);
                enableEDN = false;
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
        }
        enableEdnStep2.setStepDescription("Enable EDN Events Delivery");
        try {}
        catch (Throwable t) {
            errorMsg = "Error in Enable EDN Events Delivery API.";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            enableEdnStep2.setSuccess(false);
            enableEdnStep2.setErrorMessage(errorMsg);
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            enableEdnStep2.setExceptionObject(re);
            c2.getContextBuilder().addRecoveryStep(enableEdnStep2);
            enableEDN = false;
            Logger.loge(errorMsg);
            Logger.loge(re);
            throw re;
        }
        Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery");
        if (!report) {
            scm.enableEDNEvents();
        } else {
            enableEdnStep2.setStepDescription("[Skip] Enable EDN Events Delivery");
        }
        enableEdnStep2.setSuccess(true);
        enableEDN = false;
        c2.getContextBuilder().addExecutionStep(enableEdnStep2);
    }
}

