/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.util.ArrayList;
import oracle.opatch.Applicable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

public class sqlAction
extends PatchAction
implements Applicable,
Rollbackable,
RemoteShellPropagate {
    private String sqlName;
    private String filePath;
    private boolean runForApply;
    private boolean runForRollback;
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    public int APPLY_MODE = 0;
    public int ROLLBACK_MODE = 1;

    public sqlAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception, RuntimeException {
        super(pc, lineNumber);
        String sqlName = null;
        String filePath = null;
        boolean apply = true;
        boolean rollback = true;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for sqlAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals("name")) {
                sqlName = val;
            }
            if (arg.equals("file_path")) {
                filePath = val;
            }
            if (arg.equals("apply")) {
                boolean bl = apply = val.equals("true");
            }
            if (!arg.equals("rollback")) continue;
            rollback = val.equals("true");
        }
        if (sqlName == null || filePath == null) {
            String errMsg = "The sql action is null";
            if (sqlName == null) {
                errMsg = errMsg + "The sql file name is null";
            }
            if (filePath == null) {
                errMsg = errMsg + "The file path is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        if (!apply && !rollback) {
            StringBuffer buff = new StringBuffer("sqlAction should have atleast");
            buff.append("\"apply\" or \"rollback\" set to \"true\"");
            RuntimeException re = new RuntimeException(buff.toString());
            throw re;
        }
        this.sqlName = sqlName;
        this.filePath = PatchObjectUtil.getPlatformDependentPath(filePath);
        this.runForApply = apply;
        this.runForRollback = rollback;
        this.setDelayExecution(true);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("   Run Sql file ");
        buff.append("\"" + this.getSourceFile(OPatchEnv.getPatchloc()) + "\" for ");
        if (this.isApply()) {
            buff.append("'apply'");
        }
        if (this.isRollback()) {
            if (this.isApply()) {
                buff.append(",");
            }
            buff.append("'rollback'");
        }
        return buff.toString();
    }

    public boolean isApply() {
        return this.runForApply;
    }

    public boolean isRollback() {
        return this.runForRollback;
    }

    public boolean equals(Object o2) {
        StringBuffer buff = new StringBuffer("sqlAction::equals()");
        OLogger.debug(buff);
        if (o2 instanceof sqlAction) {
            String sqlName = this.sqlName;
            String filePath = this.filePath;
            sqlAction sqlObj = (sqlAction)o2;
            String inputSqlName = sqlObj.sqlName;
            String inputFilePath = sqlObj.filePath;
            return sqlName.equals(inputSqlName) && filePath.equals(inputFilePath);
        }
        buff = new StringBuffer("ERROR::Tried to find equality in sqlAction with an object of different type.");
        buff.append("\nCurrent object's sql file name is : " + this.sqlName);
        buff.append("\nCurrent object's sql file path is : " + this.filePath);
        OLogger.debug(buff);
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.sqlName.length();
        result = 37 * result + this.filePath.length();
        return result;
    }

    public String getChildPath() {
        return "";
    }

    public String getParentDirPath(String path) {
        if (path == null) {
            path = File.separator;
        }
        StringBuffer buff = new StringBuffer(path);
        buff.append(File.separator);
        buff.append(this.filePath);
        return buff.toString();
    }

    public String getParentFilePath(String path) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(path));
        buff.append(File.separator);
        buff.append(this.sqlName);
        return buff.toString();
    }

    public String getSourceFileName() {
        return this.sqlName;
    }

    public String getActionName() {
        return "sqlAction";
    }

    public String getActionDesc() {
        return "Run the sql sripts and patch the database instance.";
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        StringBuffer buff = null;
        if (beforeApply) {
            File sqlFile = new File(this.getParentFilePath(oracleHomePath));
            if (sqlFile.exists()) {
                buff = new StringBuffer("File \"");
                buff.append(sqlFile.toString());
                buff.append("\" is not a new file.\n");
                OLogger.debug(buff);
                return false;
            }
            buff = new StringBuffer("File \"");
            buff.append(sqlFile.toString());
            buff.append("\" is a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer tmpFile = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        tmpFile.append(File.separator);
        tmpFile.append(this.filePath);
        tmpFile.append(File.separator);
        tmpFile.append(this.sqlName);
        tmpFile.append("_opatch_");
        tmpFile.append(cookedPatchID);
        File sqlFile = new File(tmpFile.toString());
        if (sqlFile.exists()) {
            buff = new StringBuffer("File \"");
            buff.append(sqlFile.toString());
            buff.append("\" is present, so its a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer("File \"");
        buff.append(sqlFile.toString());
        buff.append("\" is not present, so its not a new file.\n");
        OLogger.debug(buff);
        return false;
    }

    public String getSourceFile(String patchLocation) {
        if (patchLocation == null) {
            patchLocation = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.filePath);
        buff.append(File.separator);
        buff.append(this.sqlName);
        return buff.toString();
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("sqlAction::applicable()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("Sql Action: Source File \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (parentFile.exists() && !parentFile.canRead()) {
            buff = new StringBuffer("Sql Action: Directory is not readable: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (dstFile.exists() && !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer("Sql Action: Desctination File \"");
            buff.append(dst);
            buff.append("\" is not writeable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!dstFile.exists() && parentFile.exists() && !parentFile.canWrite()) {
            buff = new StringBuffer("Sql Action: Directory is not writeable: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("sqlAction::apply()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(" SqlAction: src=\"");
        buff.append(src);
        buff.append("\", dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        File parentFile = dstFile.getParentFile();
        boolean cont = Rules.SystemWrite_continue();
        if (!parentFile.exists()) {
            if (cont) {
                parentFile.mkdirs();
            } else {
                OLogger.debug("Directory " + parentFile + " no exist. Ignored since we are in analyze mode.");
            }
        }
        if (!parentFile.exists() && cont) {
            buff = new StringBuffer("sqlAction::apply(): cannot mkdirs on parent directory ");
            try {
                buff.append(parentFile.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (!srcFile.exists()) {
            buff = new StringBuffer("sqlAction::apply()");
            buff.append(": the src file is not there.  This should not happen because ");
            buff.append("caller has certified that this sqlAction is applicable. src = ");
            buff.append(src);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            if (cont) {
                StringBuffer ts = new StringBuffer("Start sqlAction at ");
                OLogger.logTime(ts);
                SystemCall.copyFile(srcFile, dstFile);
                ts = new StringBuffer("Finish sqlAction at ");
                OLogger.logTime(ts);
            } else {
                buff = new StringBuffer("sqlAction::apply() skips copying the file from ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
            }
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
            buff = new StringBuffer("sqlAction::apply() failed: \"");
            buff.append(e2.getMessage());
            buff.append("\"");
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(warnMsg);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (!this.runForApply) {
            buff = new StringBuffer("SqlAction \"");
            buff.append(this.getSourceFile(patchLocation));
            buff.append("\" is not marked for apply. Hence not run here.");
            OLogger.debug(buff);
            return;
        }
        if (!OPatchEnv.isRunSql()) {
            OLogger.info("OUI-67519", new Object[]{this.getSourceFileName()});
            return;
        }
        if (Rules.SystemWrite_continue()) {
            this.updateDBInstances(oracleHomePath, this.APPLY_MODE);
        } else {
            buff = new StringBuffer("Skipping invocation of sql script \"");
            buff.append(this.getSourceFileName());
            buff.append("\"...");
            OLogger.println(buff.toString());
        }
        buff = new StringBuffer("sqlAction apply done");
        OLogger.verbose(this, buff);
    }

    public boolean updateDBInstances(String oracleHomePath, int mode) throws RuntimeException {
        StringBuffer buff = new StringBuffer("sqlAction::updateDBInstances()");
        buff.append("\nNow, lets connect to DB and run the sql.");
        OLogger.debug(buff);
        String sqlFilePath = this.getParentFilePath(oracleHomePath);
        String localNode = OPatchEnv.getLocalNode();
        StringBuffer oraWarnMsg = new StringBuffer("");
        OPatchProperty opp = new OPatchProperty();
        boolean allSIDsPassed = true;
        if (Rules.SystemWrite_continue()) {
            String[] dbSids = OPatchEnv.getDBSIDs();
            String[] dbUsers = OPatchEnv.getDBUsers();
            String[] dbPasswds = OPatchEnv.getDBPasswds();
            String[] dbNodes = OPatchEnv.getDBNodes();
            if (dbSids == null || dbSids.length < 1) {
                RuntimeException re = new RuntimeException("SqlAction : Database SIDs are not provided.");
                throw re;
            }
            for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
                if (dbNodes[sidIter] != null && !dbNodes[sidIter].equals("") && !dbNodes[sidIter].equals(localNode)) continue;
                if (mode == this.APPLY_MODE) {
                    OLogger.printlnOnLog(OLogger.INFO, OLogger.getString("OUI-67516", new Object[]{this.getSourceFileName(), dbSids[sidIter]}));
                } else if (mode == this.ROLLBACK_MODE) {
                    OLogger.printlnOnLog(OLogger.INFO, OLogger.getString("OUI-67517", new Object[]{this.getSourceFileName(), dbSids[sidIter]}));
                }
                SystemCall.ExecReturn ret = null;
                try {
                    if (!SQLUtilities.startupDB(oracleHomePath, OPatchEnv.isSqlMigrate(), dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter])) {
                        RuntimeException re = new RuntimeException("Unable to startup the DB \"" + dbSids[sidIter] + "\"");
                        throw re;
                    }
                    ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFilePath, dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter]);
                }
                catch (Exception e2) {
                    buff = new StringBuffer("sqlAction::updateDBInstances()\n");
                    buff.append("    " + e2.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException("SQL Script failed.", e2);
                    throw re;
                }
                boolean ok = ret.isOK();
                buff = new StringBuffer(ret.toString());
                OLogger.debug(buff);
                String oraString = SQLUtilities.detectOraError(ret.getNormalMessage());
                if (!oraString.equals("")) {
                    String resourceStr = OLogger.getString("OUI-67261", new Object[]{sqlFilePath, dbSids[sidIter]});
                    oraWarnMsg.append(resourceStr);
                    oraWarnMsg.append("\n");
                    oraWarnMsg.append("Error Information : ");
                    oraWarnMsg.append("\n");
                    oraWarnMsg.append(oraString);
                }
                if (!ok) {
                    OLogger.warn("OUI-67518", new Object[]{this.getSourceFileName(), dbSids[sidIter], ret.getErrorMessage()});
                    allSIDsPassed = false;
                    continue;
                }
                buff = new StringBuffer("Sql script \"\n");
                buff.append(this.getParentFilePath(oracleHomePath));
                buff.append("\" ran fine.");
                OLogger.debug(buff);
            }
        }
        if (!oraWarnMsg.toString().equals("")) {
            OLogger.debug(oraWarnMsg);
            throw new RuntimeException(oraWarnMsg.toString());
        }
        return allSIDsPassed;
    }

    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        String src = this.sqlName;
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67515", new Object[]{owningComponent, src});
        return desc;
    }

    public String getApplyDescription(String oracleHomePath) {
        if (this.runForApply) {
            return "Copying and Running the apply sql script '" + this.getSourceFileName() + "'";
        }
        return "Sql script not marked for apply : '" + this.getSourceFileName() + "'";
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("sqlAction::rollbackable()");
        OLogger.debug(buff);
        return true;
    }

    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("sqlAction::rollback()");
        OLogger.debug(buff);
        if (!this.runForRollback) {
            buff = new StringBuffer("SqlAction \"");
            buff.append(this.getParentFilePath(oracleHomePath));
            buff.append("\" is not marked for rollback. Hence not run here.");
            OLogger.debug(buff);
            return;
        }
        if (!OPatchEnv.isRunSql()) {
            OLogger.info("OUI-67519", new Object[]{this.getSourceFileName()});
            return;
        }
        if (Rules.SystemWrite_continue()) {
            this.updateDBInstances(oracleHomePath, this.ROLLBACK_MODE);
        } else {
            buff = new StringBuffer("Skipping invocation of sql script \"");
            buff.append(this.getSourceFileName());
            buff.append("\"...");
            OLogger.println(buff.toString());
        }
        buff = new StringBuffer("sqlAction rollback done");
        OLogger.verbose(this, buff);
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return "";
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("sqlAction::backupForRollback()");
        OLogger.debug(buff);
        String patchLocation = OPatchEnv.getPatchloc();
        String srcFile = this.getSourceFile(patchLocation);
        File f1 = new File(srcFile);
        StringBuffer dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        dstPath.append(File.separator);
        dstPath.append(this.filePath);
        dstPath.append(File.separator);
        dstPath.append(this.sqlName);
        String dstFile = dstPath.toString();
        File f2 = new File(dstFile);
        if (!srcFile.equals(dstFile)) {
            try {
                buff = new StringBuffer("sqlAction::backupForRollback(): back up ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
                SystemCall.backupFile(f1, f2);
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                String backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{srcFile, dstFile, e2.getMessage()});
                OLogger.println(backupForRollbackFailureDesc);
                throw e2;
            }
        }
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        String src = this.sqlName;
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67515", new Object[]{owningComponent, src});
        return desc;
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return "";
    }

    public String getRollbackDescription(String oracleHomePath) {
        if (this.runForRollback) {
            return "Running the rollback sql script '" + this.getSourceFileName() + "'";
        }
        return "Sql script not marked for rollback : '" + this.getSourceFileName() + "'";
    }

    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        int fileNumber = 0;
        String patchLocation = OPatchEnv.getPatchloc();
        String srcFile = this.getSourceFile(patchLocation);
        File f1 = new File(srcFile);
        StringBuffer dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        dstPath.append(File.separator);
        dstPath.append(this.filePath);
        dstPath.append(File.separator);
        dstPath.append(this.sqlName);
        String dstFile = dstPath.toString();
        File f2 = new File(dstFile);
        if (!srcFile.equals(dstFile)) {
            fileNumber = 1;
        }
        return fileNumber;
    }
}

