/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import oracle.opatch.OneOffEntry;
import oracle.opatch.Rules;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchprereq.PrereqSet;

public class SkipSubset {
    private NApplyData data;

    public SkipSubset(NApplyData data) {
        this.data = data;
    }

    public boolean skip(String oracleHomePath, NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: Step 3, process ");
        dBuff.append("skip_duplicate").append(" and ");
        dBuff.append("skip_subset");
        OneOffEntry[] patchesToApply = data.getPatchesToApply();
        PrereqSet patchesSkipped = data.getSkippedPatches();
        PrereqSet patchesDuplicate = data.getDuplicatePatches();
        OneOffEntry[] patchesCanGo = new OneOffEntry[]{};
        boolean len = false;
        if (Rules.shouldSkipSubset()) {
            dBuff = new StringBuffer("N-Apply: user specified");
            dBuff.append("skip_subset");
            OLogger.debug(dBuff);
            OLogger.println("Checking skip_subset");
            patchesCanGo = ConflictHandler.skipSubset(oracleHomePath, patchesToApply);
            if (patchesCanGo != null && patchesCanGo.length != patchesToApply.length) {
                dBuff = new StringBuffer("N-Apply: patchesCanGo's size != ");
                dBuff.append("patchesToApply's size. Some patches have been skipped.");
                dBuff.append("Update patchesToApply");
                OLogger.debug(dBuff);
                PrereqSet patchesApplyVector = new PrereqSet(patchesToApply);
                PrereqSet patchesCanGoVector = new PrereqSet(patchesCanGo);
                patchesSkipped = patchesSkipped.add(patchesApplyVector.delete(patchesCanGoVector));
                data.setSkippedPatches(patchesSkipped);
                patchesToApply = patchesCanGo;
                data.setPatchesToApply(patchesToApply);
                try {
                    NapplyProcessHelper.checkEmptyPatchList(patchesToApply);
                }
                catch (RuntimeException e2) {
                    int i2;
                    StringBuffer buff = new StringBuffer("");
                    for (i2 = 0; i2 < patchesSkipped.size(); ++i2) {
                        buff.append("   ");
                        buff.append(patchesSkipped.getElement(i2).getID());
                    }
                    for (i2 = 0; i2 < patchesDuplicate.size(); ++i2) {
                        buff.append("   ");
                        buff.append(patchesDuplicate.getElement(i2).getID());
                    }
                    buff.append("\nThere are no patches to apply.");
                    OLogger.warn("OUI-67302", new Object[]{buff.toString()});
                    return true;
                }
            }
        } else {
            dBuff = new StringBuffer("N-Apply: user did not specify");
            dBuff.append("skip_subset");
            OLogger.debug(dBuff);
        }
        return false;
    }
}

